#include "stdafx.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

#include "jp/ggaf/core/util/GgafStatus.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxChecker.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoB.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxGeometricActor::GgafDxGeometricActor(const char* prm_name,
                                           GgafStatus* prm_pStat,
                                           GgafDxChecker* prm_pChecker) : GgafDxBaseActor(prm_name, prm_pStat),
_pKurokoA(new GgafDxKurokoA(this)),
_pKurokoB(new GgafDxKurokoB(this)),
_pSeTx(new GgafDxSeTransmitterForActor(this)) {

    _obj_class |= Obj_GgafDxGeometricActor;
    _class_name = "GgafDxGeometricActor";
    _is_2D = false;
    _X = _Y = _Z = 0;
    _RX = _RY = _RZ = 0;
    _SX = _SY = _SZ = R_SC(1.0);
    _fX = C_DX(_X);
    _fY = C_DX(_Y);
    _fZ = C_DX(_Z);
    _bounding_sphere_radius = 0;
    _rate_of_bounding_sphere_radius = 1.0f;
    _pChecker = prm_pChecker;

    _offscreen_kind = -1;
    _pFunc_calcRotMvWorldMatrix = nullptr;
    _pActor_Base = nullptr;
    _dest_from_vppln_top = 0;
    _dest_from_vppln_bottom = 0;
    _dest_from_vppln_left = 0;
    _dest_from_vppln_right = 0;
    _dest_from_vppln_front = 0;
    _dest_from_vppln_back = 0;
    _X_local  = _X;
    _Y_local  = _Y;
    _Z_local  = _Z;
    _RX_local = _RX;
    _RY_local = _RY;
    _RZ_local = _RZ;
    _X_final  = _X;
    _Y_final  = _Y;
    _Z_final  = _Z;
    _RX_final = _RX;
    _RY_final = _RY;
    _RZ_final = _RZ;
    _pFormation = nullptr;

    _is_local = false;
    _was_calculated_matInvWorldRotMv = false;
}


void GgafDxGeometricActor::processSettlementBehavior() {
    if (_is_2D) {
        return;
    }

    _was_calculated_matInvWorldRotMv = false; //ts񖢌vZɃZbg

    if (_pActor_Base) {
        //y䂠莞[JWɈU߂
        changeGeoLocal();
    }

    //DirectX̒PʂɍWϊĂiWorldϊs쐬ɂgp܂j
    _fX = C_DX(_X);
    _fY = C_DX(_Y);
    _fZ = C_DX(_Z);
    //Worldϊsi_matWorldjXV
    if (_pFunc_calcRotMvWorldMatrix) {
        //]~ړ̂݌vZ _matWorldRotMv ɕێ
        (*_pFunc_calcRotMvWorldMatrix)(this, _matWorldRotMv);
        //]~ړ ̑O XP[lāA
        //ŏII _matWorld  s(g~]~ړ)ێ
        if (_SX != LEN_UNIT) {
            float Sx = SC_R(_SX);
            _matWorld._11 = Sx * _matWorldRotMv._11;
            _matWorld._12 = Sx * _matWorldRotMv._12;
            _matWorld._13 = Sx * _matWorldRotMv._13;
        } else {
            _matWorld._11 = _matWorldRotMv._11;
            _matWorld._12 = _matWorldRotMv._12;
            _matWorld._13 = _matWorldRotMv._13;
        }
        _matWorld._14 = _matWorldRotMv._14;

        if (_SY != LEN_UNIT) {
            float Sy = SC_R(_SY);
            _matWorld._21 = Sy * _matWorldRotMv._21;
            _matWorld._22 = Sy * _matWorldRotMv._22;
            _matWorld._23 = Sy * _matWorldRotMv._23;
        } else {
            _matWorld._21 = _matWorldRotMv._21;
            _matWorld._22 = _matWorldRotMv._22;
            _matWorld._23 = _matWorldRotMv._23;
        }
        _matWorld._24 = _matWorldRotMv._24;

        if (_SZ != LEN_UNIT) {
            float Sz = SC_R(_SZ);
            _matWorld._31 = Sz * _matWorldRotMv._31;
            _matWorld._32 = Sz * _matWorldRotMv._32;
            _matWorld._33 = Sz * _matWorldRotMv._33;
        } else {
            _matWorld._31 = _matWorldRotMv._31;
            _matWorld._32 = _matWorldRotMv._32;
            _matWorld._33 = _matWorldRotMv._33;
        }
        _matWorld._34 = _matWorldRotMv._34;

        _matWorld._41 = _matWorldRotMv._41;
        _matWorld._42 = _matWorldRotMv._42;
        _matWorld._43 = _matWorldRotMv._43;
        _matWorld._44 = _matWorldRotMv._44;
    }

    //ftHgł́A_matWorldRotMv = ]ϊs ~ sړϊs
    //                _matWorld      = XP[ϊs ~ _matWorldRotMv ƂȂ悤ɂĂB
    //܂ _matWorld = gk]sړ
    //_matWorldRotMv  addSubGroupAsFk() sɎgp邽߂ɍ쐬ĂB
    //] addSubGroupAsFk() gpȂȂ΁AprocessSettlementBehavior() I[o[ChA
    //ϊs쐬ƒP邱ƂŁAœK\B

    if (_pActor_Base) {
        //΍Wɕϊ
        D3DXMatrixMultiply(&_matWorld, &_matWorld, &(_pActor_Base->_matWorldRotMv)); //
        D3DXMatrixMultiply(&_matWorldRotMv, &_matWorldRotMv, &(_pActor_Base->_matWorldRotMv)); //
        changeGeoFinal();
        //[hϊs񂩂sړoŏIIȍWƂ
        _fX = _matWorld._41;
        _fY = _matWorld._42;
        _fZ = _matWorld._43;
        _X = DX_C(_fX);
        _Y = DX_C(_fY);
        _Z = DX_C(_fZ);

        //UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13, _RZ, _RY);

        //TODO:΍Wn_RX, _RY, _RZ ɕϊ͕ۗ
        //     ݂̍ŏIIȌARzRyŎ擾߂@͈ȉ̒ʂA
        //     t[[Nł _RX, _RY, _RZ ͂ǂł悭ϊs񂪂ΗǂB
        //     ČvZXLbvłB
        //     UTIL::convVectorToRzRy() ̌vZׂłȂƍl߁AŌvZȂB
        //     vZŋ߂ȂΈȉ̕@ōs
        //
        //
        //xNg̓[hϊs̐ρi_matWorldRotMv)ŕϊA݂̍ŏIIȌɌB
        //匳̕xNg(Xorg_,Yorg_,Zorg_)A
        //[hϊs̉]̐ρi_matWorldRotMv)̐ mat_xxA
        //ŏIIȕxNg(vX, vY, vZ) Ƃ
        //
        //                      | mat_11 mat_12 mat_13 |
        //| Xorg_ Yorg_ Zorg_ | | mat_21 mat_22 mat_23 | = | vX vY vZ |
        //                      | mat_31 mat_32 mat_33 |
        //ƂȂB
        //
        //vX = Xorg_*mat_11 + Yorg_*mat_21 + Zorg_*mat_31
        //vY = Xorg_*mat_12 + Yorg_*mat_22 + Zorg_*mat_32
        //vZ = Xorg_*mat_13 + Yorg_*mat_23 + Zorg_*mat_33
        //
        //ĂŁA匳O̒PʕxNg(1,0,0)̏ꍇ͂ǂȂ邩Hl
        //
        //vX = Xorg_*mat_11
        //vY = Xorg_*mat_12
        //vZ = Xorg_*mat_13
        //
        //ƂȂB{Avł́Af͑S(1,0,0)OƂĂ邽
        //ŏIIȕxNǵiXorg_*mat_11, Xorg_*mat_12, Xorg_*mat_13) ƂȂB
        //̕xNg _RZ _RY \ΗǂB
        //vZ₷悤Xorg_1ƒu
        //
        //UTIL::convVectorToRzRy(_matWorldRotMv._11, _matWorldRotMv._12, _matWorldRotMv._13, _RZ, _RY);
        //ƂȂ
    }

    //XV
    GgafDxCamera* pCam = P_CAM;
    _dest_from_vppln_top    = pCam->_plnTop.a * _fX +
                              pCam->_plnTop.b * _fY +
                              pCam->_plnTop.c * _fZ +
                              pCam->_plnTop.d;

    _dest_from_vppln_bottom = pCam->_plnBottom.a * _fX +
                              pCam->_plnBottom.b * _fY +
                              pCam->_plnBottom.c * _fZ +
                              pCam->_plnBottom.d;

    _dest_from_vppln_left   = pCam->_plnLeft.a * _fX +
                              pCam->_plnLeft.b * _fY +
                              pCam->_plnLeft.c * _fZ +
                              pCam->_plnLeft.d;

    _dest_from_vppln_right  = pCam->_plnRight.a * _fX +
                              pCam->_plnRight.b * _fY +
                              pCam->_plnRight.c * _fZ +
                              pCam->_plnRight.d;

    _dest_from_vppln_front  = pCam->_plnFront.a * _fX +
                              pCam->_plnFront.b * _fY +
                              pCam->_plnFront.c * _fZ +
                              pCam->_plnFront.d;

    _dest_from_vppln_back   = pCam->_plnBack.a * _fX +
                              pCam->_plnBack.b * _fY +
                              pCam->_plnBack.c * _fZ +
                              pCam->_plnBack.d;
    _offscreen_kind = -1;

    //Wؓo^
    if (_pChecker) {
        if (_can_hit_flg) {
            if (_can_hit_out_of_view == false && isOutOfView()) {
                //O蔻薳̏ꍇ͓o^Ȃ
            } else  {
                _pChecker->updateHitArea();
            }
        }
    }
}


GgafGroupHead* GgafDxGeometricActor::addSubGroupAsFk(actorkind prm_kind,
                                                     GgafDxGeometricActor* prm_pGeoActor,
                                                     coord prm_X_init_local,
                                                     coord prm_Y_init_local,
                                                     coord prm_Z_init_local,
                                                     coord prm_RX_init_local,
                                                     coord prm_RY_init_local,
                                                     coord prm_RZ_init_local) {
#ifdef MY_DEBUG
    if (_pFunc_calcRotMvWorldMatrix) {
        //OK
    } else {
        throwGgafCriticalException("GgafDxGeometricActor::addSubGroupAsFk() : "<<
                                   "this=("<<this<<")["<<getName()<<"] ́A_pFunc_calcRotMvWorldMatrix  nullptrׁ̈AFKx[XƂȂ鎑i܂");
    }
#endif
    GgafGroupHead* pGroupHead = addSubGroup(prm_kind, prm_pGeoActor);
    prm_pGeoActor->_pActor_Base = this;
    prm_pGeoActor->changeGeoLocal();
    prm_pGeoActor->_X = prm_X_init_local;
    prm_pGeoActor->_Y = prm_Y_init_local;
    prm_pGeoActor->_Z = prm_Z_init_local;
    prm_pGeoActor->_pKurokoA->_angFace[AXIS_X]  = prm_RX_init_local;
    prm_pGeoActor->_pKurokoA->_angFace[AXIS_Y]  = prm_RY_init_local;
    prm_pGeoActor->_pKurokoA->_angFace[AXIS_Z]  = prm_RZ_init_local;
    prm_pGeoActor->_pKurokoA->_angRzMv = prm_RZ_init_local;
    prm_pGeoActor->_pKurokoA->_angRyMv = prm_RY_init_local;
    prm_pGeoActor->_RX = prm_RX_init_local;
    prm_pGeoActor->_RY = prm_RY_init_local;
    prm_pGeoActor->_RZ = prm_RZ_init_local;
    prm_pGeoActor->changeGeoFinal();
    return pGroupHead;
}

GgafGroupHead* GgafDxGeometricActor::addSubGroupAsFk(GgafDxGeometricActor* prm_pGeoActor,
                                                     coord prm_X_init_local,
                                                     coord prm_Y_init_local,
                                                     coord prm_Z_init_local,
                                                     coord prm_RX_init_local,
                                                     coord prm_RY_init_local,
                                                     coord prm_RZ_init_local) {
    return addSubGroupAsFk(prm_pGeoActor->_pStatus->getUint(STAT_DEFAULT_ACTOR_KIND),
                           prm_pGeoActor,
                           prm_X_init_local,
                           prm_Y_init_local,
                           prm_Z_init_local,
                           prm_RX_init_local,
                           prm_RY_init_local,
                           prm_RZ_init_local);
}

bool GgafDxGeometricActor::processHitChkLogic(GgafActor* prm_pOtherActor) {
    if (_can_hit_flg && prm_pOtherActor->_can_hit_flg) {
        //&& prm_pOtherActor->instanceOf(Obj_GgafDxGeometricActor)) { 蔻肪̂GgafDxGeometricActorȏƔf
        //_can_hit_flg && prm_pOtherActor->_can_hit_flg ̃`FbN͂Wؓo^Oɂ`FbNĂ邪
        //łx`FbNقǂB
        //ȂȂ΁Aʂȃqbg`FbNsȂ߁AonHit(GgafActor*)  setHitAble(false) sA
        //Qdqbg`FbNh~sĂ邩ȂB
        if (_pChecker) {
            return _pChecker->isHit(((GgafDxGeometricActor*)prm_pOtherActor)->_pChecker);
        }
    }
    return false;
}

int GgafDxGeometricActor::isOutOfView() {
    //_TRACE_("name="<<getName()<<" _bounding_sphere_radius="<<_bounding_sphere_radius);
    if (_offscreen_kind == -1) {
        dxcoord bound = _bounding_sphere_radius * _rate_of_bounding_sphere_radius*2;//|2͋E傫āAʋẼ`cL}
        if (_dest_from_vppln_top < bound) {
            if (_dest_from_vppln_bottom < bound) {
                if (_dest_from_vppln_left < bound) {
                    if (_dest_from_vppln_right < bound) {
                        if (_dest_from_vppln_front < bound) {
                            if (_dest_from_vppln_back < bound) {
                                //Viewport͈͓
                                _offscreen_kind = 0;
                            } else {
                                //ʂ艜Ŕ͈͊O
                                _offscreen_kind = 6;
                            }
                        } else {
                            //OʂOŔ͈͊O
                            _offscreen_kind = 5;
                        }
                    } else {
                        //EʂEŔ͈͊O
                        _offscreen_kind = 4;
                    }
                } else {
                    //ʂ荶Ŕ͈͊O
                    _offscreen_kind = 3;
                }
            } else {
                //ʂ艺Ŕ͈͊O
                _offscreen_kind = 2;
            }
        } else {
            //㕽ʂŔ͈͊O
            _offscreen_kind = 1;
        }
    }
    return _offscreen_kind;
}

bool GgafDxGeometricActor::isOutOfUniverse() {
    if (GgafDxUniverse::_X_gone_left < _X) {
        if (_X < GgafDxUniverse::_X_gone_right) {
            if (GgafDxUniverse::_Y_gone_bottom < _Y) {
                if (_Y < GgafDxUniverse::_Y_gone_top) {
                    if (GgafDxUniverse::_Z_gone_near < _Z) {
                        if (_Z < GgafDxUniverse::_Z_gone_far) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}

void GgafDxGeometricActor::defineRotMvWorldMatrix(void (*prm_pFunc)(GgafDxGeometricActor*, D3DXMATRIX&)) {
    _pFunc_calcRotMvWorldMatrix = prm_pFunc;
    (*_pFunc_calcRotMvWorldMatrix)(this, _matWorldRotMv);
}

void GgafDxGeometricActor::positionAs(GgafDxGeoElem* prm_pGeoElem) {
    _X = prm_pGeoElem->_X;
    _Y = prm_pGeoElem->_Y;
    _Z = prm_pGeoElem->_Z;
}

void GgafDxGeometricActor::rotateAs(GgafDxGeometricActor* prm_pActor) {
    _RX = prm_pActor->_RX;
    _RY = prm_pActor->_RY;
    _RZ = prm_pActor->_RZ;
}
void GgafDxGeometricActor::rotateAs(GgafDxGeoElem* prm_pGeoElem) {
    _RX = prm_pGeoElem->_RX;
    _RY = prm_pGeoElem->_RY;
    _RZ = prm_pGeoElem->_RZ;
}

void GgafDxGeometricActor::scaleAs(GgafDxGeometricActor* prm_pActor) {
    _SX = prm_pActor->_SX;
    _SY = prm_pActor->_SY;
    _SZ = prm_pActor->_SZ;
}

void GgafDxGeometricActor::onEnd() {
    GgafDxBaseActor::onEnd();
    _pFormation = nullptr;
}

GgafDxGeometricActor::~GgafDxGeometricActor() {
    delete _pKurokoA;
    delete _pKurokoB;
    delete _pSeTx;
}

void GgafDxGeometricActor::dump() {
    _TRACE_("\t\t\t\t\t\t\t\t"<<_class_name<<"("<<this<<")["<<getName()<<"]("<<_X<<","<<_Y<<","<<_Z<<")"<<DUMP_FLGS);
    GgafActor* pActor_tmp = _pSubFirst;
    if (_pSubFirst) {
        while (true) {
            pActor_tmp->dump("\t\t\t\t\t\t\t\tb");
            if (pActor_tmp->getNext()) {
                pActor_tmp = pActor_tmp->getNext();
            } else {
                _TRACE_("yxz"<<_class_name<<"("<<this<<")["<<getName()<<"]nextnullptrĂ܂");
                break;
            }
            if (pActor_tmp->isFirst()) {
                _TRACE_("\t\t\t\t\t\t\t\t");
                break;
            }
        }
    }
}

void GgafDxGeometricActor::dump(std::string prm_parent) {
    _TRACE_(prm_parent << _class_name<<"("<<this<<")["<<getName()<<"]("<<_X<<","<<_Y<<","<<_Z<<")"<<DUMP_FLGS);
    GgafActor* pActor_tmp = _pSubFirst;
    if (_pSubFirst) {
        while (true) {
            pActor_tmp->dump(prm_parent + "b");
            if (pActor_tmp->getNext()) {
                pActor_tmp = pActor_tmp->getNext();
            } else {
                _TRACE_("yxz"<<_class_name<<"("<<this<<")["<<getName()<<"]nextnullptrĂ܂");
                break;
            }
            if (pActor_tmp->isFirst()) {
                _TRACE_(prm_parent+"");
                break;
            }
        }
    }
}

