#include "stdafx.h"
#include "jp/ggaf/dxcore/GgafDxGod.h"

#include "jp/ggaf/core/GgafFactory.h"
#include "jp/ggaf/dxcore/actor/GgafDxCamera.h"
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"
#include "jp/ggaf/dxcore/exception/GgafDxCriticalException.h"
#include "jp/ggaf/dxcore/GgafDxProperties.h"
#include "jp/ggaf/dxcore/manager/GgafDxEffectManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxModelManager.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureManager.h"
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"
#include "jp/ggaf/dxcore/sound/GgafDxSound.h"
#include "jp/ggaf/dxcore/util/GgafDxInput.h"

using namespace GgafCore;
using namespace GgafDxCore;

#define returnWhenFailed(HR, OKVAL, X) { \
    if (HR != OKVAL) { \
        std::stringstream ss; \
        ss << X; \
        MessageBox(GgafDxGod::_pHWndPrimary, TEXT(ss.str().c_str()), TEXT("ERROR"), MB_OK | MB_ICONSTOP | MB_SETFOREGROUND); \
        return E_FAIL; \
    } \
}

//TODO:RgƂBB



HWND GgafDxGod::_pHWndPrimary = nullptr;
HWND GgafDxGod::_pHWndSecondary = nullptr;
HINSTANCE GgafDxGod::_hInstance = nullptr;
IDirect3D9* GgafDxGod::_pID3D9 = nullptr;
IDirect3DDevice9* GgafDxGod::_pID3DDevice9 = nullptr;
D3DLIGHT9 GgafDxGod::_d3dlight9_default;
DWORD GgafDxGod::_dwAmbientBrightness_default = 0xff404040;


D3DFILLMODE GgafDxGod::_d3dfillmode = D3DFILL_SOLID;//D3DFILL_WIREFRAME;//D3DFILL_SOLID;

GgafDxModelManager* GgafDxGod::_pModelManager = nullptr;
GgafDxEffectManager* GgafDxGod::_pEffectManager = nullptr;
GgafDxTextureManager* GgafDxGod::_pCubeMapTextureManager = nullptr;
GgafDxTextureManager* GgafDxGod::_pBumpMapTextureManager = nullptr;
bool GgafDxGod::_is_device_lost_flg = false;
bool GgafDxGod::_adjustGameScreen = false;
HWND GgafDxGod::_pHWnd_adjustScreen = nullptr;

uint32_t GgafDxGod::_vs_v = 0;
uint32_t GgafDxGod::_ps_v = 0;

GgafDxGod::GgafDxGod() : GgafGod() {
    _is_device_lost_flg = false;
    _adjustGameScreen = false;
    _pHWnd_adjustScreen = nullptr;

    GgafDxGod::_hInstance = GetModuleHandle(0);


    CmRandomNumberGenerator::getInstance()->changeSeed(19740722UL); //19740722 Seed
    GgafRgb rgb_border = GgafRgb(PROPERTY::BORDER_COLOR);
    _color_border = D3DCOLOR_RGBA(rgb_border._R, rgb_border._G, rgb_border._B, 0);
    GgafRgb rgb_bg = GgafRgb(PROPERTY::BG_COLOR);
    _color_clear = D3DCOLOR_RGBA(rgb_bg._R, rgb_bg._G, rgb_bg._B, 0);
    _pRenderTexture = nullptr;
    _pRenderTextureSurface = nullptr;
    _pRenderTextureZ = nullptr;
    _num_adapter = 1;
    _apSwapChain[0] = nullptr;
    _apBackBuffer[0] = nullptr;
    _apSwapChain[1] = nullptr;
    _apBackBuffer[1] = nullptr;

    _secondary_screen_x = 0;
    _secondary_screen_y = 0;

    _can_wddm = true;//Ƃ肠
}


/**
 * EBhẼTCYĐݒ .
 * @param hWnd Đݒ肷EBhEHWND
 * @param client_width NCAg̈扡isNZj
 * @param client_height NCAg̈cisNZj
 */
void GgafDxGod::resetWindowsize(HWND hWnd, pixcoord client_width, pixcoord client_height) {
    RECT wRect1, cRect1; // EBhEŜ̋`ANCAg̈̋`
    pixcoord ww1, wh1; // EBhEŜ̕A
    pixcoord cw1, ch1; // NCAg̈̕A
    pixcoord fw1, fh1; // t[̕A
    // EBhEŜ̕EvZ
    GetWindowRect(hWnd, &wRect1);
    ww1 = wRect1.right - wRect1.left;
    wh1 = wRect1.bottom - wRect1.top;
    // NCAg̈̕EvZ
    GetClientRect(hWnd, &cRect1);
    cw1 = cRect1.right - cRect1.left;
    ch1 = cRect1.bottom - cRect1.top;
    // NCAg̈ȊOɕKvȃTCYvZ
    fw1 = ww1 - cw1;
    fh1 = wh1 - ch1;
    // vZƍEBhEɐݒ
    SetWindowPos(
            hWnd,
            HWND_TOP,
            0,
            0,
            client_width + fw1,
            client_height + fh1,
            SWP_NOMOVE
    );
}

void GgafDxGod::chengeViewPos(HWND prm_pHWnd, int pos) {
    if (PROPERTY::DUAL_VIEW) {
        if (prm_pHWnd ==  GgafDxGod::_pHWndPrimary) {
            PROPERTY::DUAL_VIEW_DRAW_POSITION1 = pos;
        } else if (prm_pHWnd ==  GgafDxGod::_pHWndSecondary) {
            PROPERTY::DUAL_VIEW_DRAW_POSITION2 = pos;
        }
    } else {
        if (prm_pHWnd ==  GgafDxGod::_pHWndPrimary) {
            PROPERTY::SINGLE_VIEW_DRAW_POSITION = pos;
        }
    }
    if (GgafDxCore::GgafDxGod::_can_be) {
        if (!PROPERTY::FULL_SCREEN && prm_pHWnd) {
            GgafDxCore::GgafDxGod::_adjustGameScreen = true;
            GgafDxCore::GgafDxGod::_pHWnd_adjustScreen = prm_pHWnd;
        }
    }
}
void GgafDxGod::chengeViewAspect(bool prm_b) {
    PROPERTY::FIXED_GAME_VIEW_ASPECT = prm_b;
    if (GgafDxCore::GgafDxGod::_can_be) {
        if (!PROPERTY::FULL_SCREEN) {
            GgafDxCore::GgafDxGod::_adjustGameScreen = true;
            GgafDxCore::GgafDxGod::_pHWnd_adjustScreen = GgafDxGod::_pHWndPrimary;
        }
    }
}
int GgafDxGod::checkAppropriateDisplaySize(D3DDISPLAYMODE* prm_paMode, int prm_mode_num,
                                           UINT prm_width, UINT prm_height) {
    _TRACE_("checkAppropriateDisplaySize() ]A"<<prm_width<<"x"<<prm_height);

    for (int n = 0; n < prm_mode_num; n++) {
        if (prm_width == prm_paMode[n].Width && prm_height == prm_paMode[n].Height) {
            _TRACE_("["<<n<<"] BINGO!");
            return n; //҂
        }
    }
    _TRACE_("BINGOȂA߂𑜓xT܂B");
    int cfg_width  = (int)(prm_width * 1.1);  //𑜓x̍I₷邽
    int cfg_height = (int)(prm_height * 1.1); //10%
    double cfg_aspect = 1.0 * cfg_width / cfg_height;

    int eval_top = INT_MAX; //](قǗǂ)
    int resut_index = 0;
    for (int n = 0; n < prm_mode_num; n++) {
        int disp_width  = (int)(prm_paMode[n].Width);
        int disp_height = (int)(prm_paMode[n].Height);
        int eval_level = ABS(disp_width-cfg_width) + (int)(ABS(disp_height-cfg_height) * cfg_aspect * 1.5); //AXyNgd̂1.5{
        _TRACE_("["<<n<<"] "<<disp_width<<"x"<<disp_height<<" EEE ]F"<<eval_level);
        if (eval_level < eval_top) {
            eval_top = eval_level;
            resut_index = n;
        }
    }
    _TRACE_("checkAppropriateDisplaySize() _A["<<resut_index<<"]  "<<
            prm_paMode[resut_index].Width<<"x"<<prm_paMode[resut_index].Height<<" ǂȂI");
    return resut_index;
}


void GgafDxGod::createWindow(WNDCLASSEX& prm_wndclass1, WNDCLASSEX& prm_wndclass2,
                         const char* prm_title1   , const char* prm_title2,
                         DWORD       prm_dwStyle1 , DWORD       prm_dwStyle2,
                         HWND&       out_hWnd1    , HWND&       out_hWnd2) {

    //2011/09/18 WDDM gpłȂgp悤ɕύXB
    // }`j^tXN[̃foCXXg̕A
    // XPł͂܂̂Vistał͂܂Ȃ邱ƂoB
    // IDirect3D9Ex ݂̑CɂȂAɎB
    // WDDM܂ IDirect3D9Ex or IDirect3D9 ̑IsB
    // IDirect3D9Ex 擾 Direct3DCreate9Ex() gpA
    // ߂ľʂŔ肷ΗǂƈՂɍlĂA
    // IDirect3D9Ex ̎ԂAVista ȍ~  d3d9.dll ɂ̂ݑ݂炵A
    // Direct3DCreate9Ex() ֐̃R[h_ŁAXP̏ꍇ d3d9.dll [h
    // uGg|Cg܂vƂG[ɂȂĂ܂słȂB
    // R[h𗼑Ήɂ́ADirect3DCreate9Ex() ͎gȂƎvB
    // ňȉ̂悤 d3d9.dll ADirect3DCreate9Ex 𒼐ڒTāA|C^
    // 擾@MSDNɂ̂ŁAQlɂĎB
    // __uuid Zq GCC ɂ͖̂ŁAIDD_IDirect3D9 ɕύXB
    // TODO::ŐȂ̂낤cB

    HRESULT hr;
    typedef HRESULT (WINAPI *DIRECT3DCREATE9EXFUNCTION)(UINT SDKVersion, IDirect3D9Ex**);
    IDirect3D9* pID3D9 = nullptr;
    IDirect3D9Ex* pID3D9Ex = nullptr;
    HMODULE hD3D = LoadLibrary(TEXT("d3d9.dll"));

    DIRECT3DCREATE9EXFUNCTION pFunc_Direct3DCreate9Ex = (DIRECT3DCREATE9EXFUNCTION)GetProcAddress(hD3D, "Direct3DCreate9Ex");
    if (pFunc_Direct3DCreate9Ex) {
        _TRACE_("GgafDxGod::createWindow() d3d9.dllɁADirect3DCreate9Ex݂͑܂B");
        //d3d9.dll  Direct3DCreate9Ex ݂͑B
        hr = ((*pFunc_Direct3DCreate9Ex)(D3D_SDK_VERSION, &pID3D9Ex)); //Direct3DCreate9Ex s
        if (FAILED(hr)) {
            FreeLibrary(hD3D);
            throwGgafCriticalException("IDirect3D9Ex R|[lg擾Ɏs܂B(1)"); //s
        }
//        hr = pID3D9Ex->QueryInterface(IID_IDirect3D9, reinterpret_cast<void **>(&pID3D9)); //COMƂĎgp
//        if (FAILED(hr)) {
//            MessageBox(GgafDxGod::_pHWndPrimary, TEXT("IDirect3D9Ex R|[lg擾Ɏs܂B(2)"), TEXT("ERROR"), MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
//            FreeLibrary(hD3D);
//            return E_FAIL; //s
//        }
        GgafDxGod::_pID3D9 = (IDirect3D9*)pID3D9Ex;
        _can_wddm = true;
        _TRACE_("GgafDxGod::createWindow() WDDM [h");
    } else {
        _TRACE_("GgafDxGod::createWindow() d3d9.dllɁADirect3DCreate9Ex݂͑܂łB");
        //d3d9.dll  Direct3DCreate9Ex ݂͑ȂB
        pID3D9 = Direct3DCreate9(D3D_SDK_VERSION);
        if (!pID3D9) {
            FreeLibrary(hD3D);
            throwGgafCriticalException("IDirect3D9 R|[lg擾Ɏs܂B");
        }
        GgafDxGod::_pID3D9 = pID3D9;
        _can_wddm = false;
        _TRACE_("GgafDxGod::createWindow() XPDM [h");
    }
    FreeLibrary(hD3D);

    //foCXp[^쐬
    D3DCAPS9 caps;
    GgafDxGod::_pID3D9->GetDeviceCaps(D3DADAPTER_DEFAULT, // [in] fBXvC A_v^B
                                       D3DDEVTYPE_HAL,     // [in] foCX̎ށB D3DDEVTYPE񋓌^̃o
                                       &caps);             // [out] foCX̔\͂i[

    _num_adapter = caps.NumberOfAdaptersInGroup;   //gA_v^̐擾
    _paPresetPrm = NEW D3DPRESENT_PARAMETERS[_num_adapter > 2 ? _num_adapter : 2];
    ZeroMemory(&_paPresetPrm[0], sizeof(D3DPRESENT_PARAMETERS));

    //EBhEEtXN[
    _paPresetPrm[0].BackBufferCount        = 1;            //obNobt@̐
    _paPresetPrm[0].EnableAutoDepthStencil = TRUE;         //obNobt@ Zobt@̎쐬
    _paPresetPrm[0].AutoDepthStencilFormat = D3DFMT_D24S8; //[xXeVobt@ //D3DFMT_D16;
    _paPresetPrm[0].Flags                  = 0;            //0ɂĂ

    if (PROPERTY::FULL_SCREEN) {

        //tXN[
        _paPresetPrm[0].BackBufferFormat           = D3DFMT_X8R8G8B8; //D3DFMT_A8R8G8B8; //D3DFMT_X8R8G8B8; //D3DFMT_R5G6B5;
        _paPresetPrm[0].Windowed                   = false; //tXN[[h
        _paPresetPrm[0].FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT; //tbV[g
        _paPresetPrm[0].PresentationInterval       = D3DPRESENT_INTERVAL_DEFAULT; //Xbṽ^C~O
        _paPresetPrm[0].SwapEffect                 = D3DSWAPEFFECT_DISCARD;

        if(PROPERTY::DUAL_VIEW) {
            _paPresetPrm[1] = _paPresetPrm[0]; //RR܂ł𕡐

            _paPresetPrm[0].EnableAutoDepthStencil = FALSE;   //Zobt@̎쐬
            _paPresetPrm[1].EnableAutoDepthStencil = FALSE;
            //yz
            //EnableAutoDepthStencil = FALSE;
            //ƂƁA_OXe[g D3DRS_ZENABLE  FALSE ɂȂ邾̂悤ɌB
            //]āuvɂłAugpsvł͂Ȃ̂낤EEEB
        } else {
            _paPresetPrm[0].EnableAutoDepthStencil = FALSE; //Z obt@̎쐬L
        }
    } else {
        //EBhE
        _paPresetPrm[0].BackBufferFormat           = D3DFMT_UNKNOWN; //݂̕\[htH[}bg
        _paPresetPrm[0].Windowed                   = true; //EBhE[h
        _paPresetPrm[0].FullScreen_RefreshRateInHz = 0; //tbV[g
        _paPresetPrm[0].PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE; //
        _paPresetPrm[0].SwapEffect                 = D3DSWAPEFFECT_COPY; //TODO:Window[h͂Ȃ̂HAD3DPRESENT_INTERVAL_ONE Ƃ߂H

        if(PROPERTY::DUAL_VIEW) {
            _paPresetPrm[1] = _paPresetPrm[0]; //RR܂ł𕡐
            _paPresetPrm[0].EnableAutoDepthStencil = TRUE; //Z obt@̎쐬
            _paPresetPrm[1].EnableAutoDepthStencil = TRUE;
        } else {

            _paPresetPrm[0].EnableAutoDepthStencil = TRUE; //Z obt@̎쐬
        }


//        //fXvC[h̎擾
//        D3DDISPLAYMODE structD3DDisplayMode0; //ʂi[\
//        hr = GgafDxGod::_pID3D9->GetAdapterDisplayMode(0, &structD3DDisplayMode0);
//        returnWhenFailed(hr, D3D_OK, "GetAdapterDisplayMode Ɏs܂B");
//        if(PROPERTY::DUAL_VIEW) {
//            D3DDISPLAYMODE structD3DDisplayMode1;
//            hr = GgafDxGod::_pID3D9->GetAdapterDisplayMode(1, &structD3DDisplayMode1);
//            returnWhenFailed(hr, D3D_OK, "2ʖ GetAdapterDisplayMode Ɏs܂");
//            _paPresetPrm[0].BackBufferFormat = structD3DDisplayMode0.Format; //݂̉ʃ[h𗘗p
//            _paPresetPrm[1].BackBufferFormat = structD3DDisplayMode1.Format; //݂̉ʃ[h𗘗p
//        } else {
//            _paPresetPrm[0].BackBufferFormat = structD3DDisplayMode0.Format; //݂̉ʃ[h𗘗p
//            _paPresetPrm[1].BackBufferFormat = D3DFMT_UNKNOWN; //݂̉ʃ[h𗘗p
//        }
    }

    //A`ACAXɂł邩`FbN
    DWORD qualityLevels = D3DMULTISAMPLE_NONE;
    D3DMULTISAMPLE_TYPE multiSampleType = D3DMULTISAMPLE_NONE;
//    if( SUCCEEDED(GgafDxGod::_pID3D9->CheckDeviceMultiSampleType(
//        D3DADAPTER_DEFAULT,
//        D3DDEVTYPE_HAL,
//        _paPresetPrm[0].BackBufferFormat,  //TODO:EBhE[h
//        PROPERTY::FULL_SCREEN ? FALSE : TRUE,
//        D3DMULTISAMPLE_2_SAMPLES,
//        &qualityLevels) ) )
//    {
//        if( SUCCEEDED(GgafDxGod::_pID3D9->CheckDeviceMultiSampleType(
//            D3DADAPTER_DEFAULT,
//            D3DDEVTYPE_HAL,
//            _paPresetPrm[0].AutoDepthStencilFormat,
//            PROPERTY::FULL_SCREEN ? FALSE : TRUE,
//            D3DMULTISAMPLE_2_SAMPLES,
//            nullptr) ) )
//        {
//            multiSampleType = D3DMULTISAMPLE_2_SAMPLES;
//            _TRACE_("n[hEFA MultiSampleType = D3DMULTISAMPLE_2_SAMPLES LII");
//        } else {
//            multiSampleType = D3DMULTISAMPLE_NONE;
//            qualityLevels = D3DMULTISAMPLE_NONE;
//        }
//    } else {
//        multiSampleType = D3DMULTISAMPLE_NONE;
//        qualityLevels = D3DMULTISAMPLE_NONE;
//    }


    if(PROPERTY::DUAL_VIEW) {
        //}`Tv̐
        //}`Tv̕ix
        _paPresetPrm[0].MultiSampleQuality = qualityLevels - (qualityLevels > 0 ? 1 : 0);
        //}`Tv̐
        _paPresetPrm[1].MultiSampleType = multiSampleType;//D3DMULTISAMPLE_NONE;
        //}`Tv̕ix
        _paPresetPrm[1].MultiSampleQuality = qualityLevels - (qualityLevels > 0 ? 1 : 0);
    } else {
        //}`Tv̐
        _paPresetPrm[0].MultiSampleType = multiSampleType;//D3DMULTISAMPLE_NONE;
        //}`Tv̕ix
        _paPresetPrm[0].MultiSampleQuality = qualityLevels - (qualityLevels > 0 ? 1 : 0);
    }

    //}`Tv̐
    //_paPresetPrm[0].MultiSampleType = D3DMULTISAMPLE_NONMASKABLE;//D3DMULTISAMPLE_NONE;
    //}`Tv̕ix
    //_paPresetPrm[0].MultiSampleQuality = 0;//qualityLevels - (qualityLevels > 0 ? 1 : 0);


    //obNobt@TCY
    if (PROPERTY::FULL_SCREEN) {
        if(PROPERTY::DUAL_VIEW) {
            //tXN[[hEQʎgp (tXN[`FbNŏ㏑邩Ȃ)
            _paPresetPrm[0].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
            _paPresetPrm[0].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
            _paPresetPrm[1].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
            _paPresetPrm[1].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;
        } else {
            //tXN[[hEPʎgp (tXN[`FbNŏ㏑邩Ȃ)
            _paPresetPrm[0].BackBufferWidth  = PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
            _paPresetPrm[0].BackBufferHeight = PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
            _paPresetPrm[1].BackBufferWidth  = 0;
            _paPresetPrm[1].BackBufferHeight = 0;
        }
    } else {
        if(PROPERTY::DUAL_VIEW) {
            //EBhE[hEQʎgp
            _paPresetPrm[0].BackBufferWidth  = PROPERTY::RENDER_TARGET_BUFFER_WIDTH;
            _paPresetPrm[0].BackBufferHeight = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT;
            _paPresetPrm[1].BackBufferWidth  = 0;
            _paPresetPrm[1].BackBufferHeight = 0;
        } else {
            //EBhE[hEPʎgp
            _paPresetPrm[0].BackBufferWidth  = PROPERTY::RENDER_TARGET_BUFFER_WIDTH;
            _paPresetPrm[0].BackBufferHeight = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT;
            _paPresetPrm[1].BackBufferWidth  = 0;
            _paPresetPrm[1].BackBufferHeight = 0;
        }
    }

    _paDisplayMode = NEW D3DDISPLAYMODEEX[_num_adapter > 2 ? _num_adapter : 2];
    _paDisplayMode[0].Size = sizeof(_paDisplayMode[0]);
    _paDisplayMode[0].Width = _paPresetPrm[0].BackBufferWidth;
    _paDisplayMode[0].Height = _paPresetPrm[0].BackBufferHeight;
    _paDisplayMode[0].Format = _paPresetPrm[0].BackBufferFormat;
    _paDisplayMode[0].RefreshRate = _paPresetPrm[0].FullScreen_RefreshRateInHz;
    _paDisplayMode[0].ScanLineOrdering = D3DSCANLINEORDERING_PROGRESSIVE;

    _paDisplayMode[1].Size = sizeof(_paDisplayMode[1]);
    _paDisplayMode[1].Width = _paPresetPrm[1].BackBufferWidth;
    _paDisplayMode[1].Height = _paPresetPrm[1].BackBufferHeight;
    _paDisplayMode[1].Format = _paPresetPrm[1].BackBufferFormat;
    _paDisplayMode[1].RefreshRate = _paPresetPrm[1].FullScreen_RefreshRateInHz;
    _paDisplayMode[1].ScanLineOrdering = D3DSCANLINEORDERING_PROGRESSIVE;

    //tXN[Rʖڈȍ~̃p[^Qʂ̃p[^̃Rs[ō쐬
    for (int i = 2; i < _num_adapter; i++) {
        _paPresetPrm[i] = _paPresetPrm[1];
        _paDisplayMode[i] = _paDisplayMode[1];
    }

    //tXN[vAw𑜓xɏo邩ׁA
    //oȂꍇ́A߂𑜓xTA
    //_paPresetPrm[] ƁA_paDisplayMode[] ㏑B
    _TRACE_("_num_adapter = "<< _num_adapter);
    if (PROPERTY::FULL_SCREEN) {
        for (int disp_no = 0; disp_no < _num_adapter; disp_no++) {
            _TRACE_("--- " << disp_no+1 << "ʖ ̉𑜓xݒ --->");
            int mode_num = GgafDxGod::_pID3D9->GetAdapterModeCount(disp_no, _paPresetPrm[0].BackBufferFormat);
            D3DDISPLAYMODE* paMode = NEW D3DDISPLAYMODE[mode_num];
            for (int n = 0; n < mode_num; n++) {
                GgafDxGod::_pID3D9->EnumAdapterModes(disp_no, _paPresetPrm[0].BackBufferFormat, n, &(paMode[n]));
            }
            if (PROPERTY::DUAL_VIEW) {
                //QʃtXN[
                if (disp_no == 0) {
                    //Pʖ
                    int n = checkAppropriateDisplaySize(
                                    paMode, mode_num,
                                    (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH,
                                    (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT
                                );
                    PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH  = (pixcoord)(paMode[n].Width);
                    PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT = (pixcoord)(paMode[n].Height);
                    _paPresetPrm[disp_no].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
                    _paPresetPrm[disp_no].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
                } else if (disp_no == 1) {
                    //Qʖ
                    int n = checkAppropriateDisplaySize(
                                    paMode, mode_num,
                                    (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH,
                                    (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT
                                );
                    PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH  = (pixcoord)(paMode[n].Width);
                    PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT = (pixcoord)(paMode[n].Height);
                    _paPresetPrm[disp_no].BackBufferWidth  = PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
                    _paPresetPrm[disp_no].BackBufferHeight = PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;
                } else if (disp_no >= 2) {
                    //FRʖڈȍ~PʖځEQʖڂ̉𑜓xȊO̖ȉ𑜓xTĂɐݒB
                    // getSecondaryMoniterPixcoordCallback() ɂ
                    //Qʖڂ̍W擾ifoCXXgKvj邽߂ɁA
                    //vC}łȂARʖڈȍ~łȂQʖڂB
                    //Ƃ肷邽߂ɉ𑜓xŔ肵Ăӏ邽߁B
                    //TODO:XN[ԍ𐳊mɎ擾@AFXׂĔY񂾂ǂ킩ȂB̂ŋ̍EEEB
                    for (int n = 0; n < mode_num; n++) {
                        if ((paMode[n].Width == (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH && paMode[n].Height == (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT) ||
                            (paMode[n].Width == (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH && paMode[n].Height == (UINT)PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT)    ) {
                            //PʖڂQʖڂƓȂ̂Ŕ
                        } else {
                            _TRACE_(disp_no+1 << "ʖڂ́AK "<<paMode[n].Width<<"x"<<paMode[n].Height<<" ɐݒ");
                            _paPresetPrm[disp_no].BackBufferWidth  = paMode[n].Width;
                            _paPresetPrm[disp_no].BackBufferHeight = paMode[n].Height;
                            break;
                        }
                    }
                }


            } else {
                //PʃtXN[
                if (disp_no == 0) {
                    int n = checkAppropriateDisplaySize(
                                    paMode, mode_num,
                                    (UINT)PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH,
                                    (UINT)PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT
                                );
                    PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH = (pixcoord)(paMode[n].Width);
                    PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT = (pixcoord)(paMode[n].Height);
                    _paPresetPrm[disp_no].BackBufferWidth  = PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
                    _paPresetPrm[disp_no].BackBufferHeight = PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
                } else if (disp_no >= 1) {
                    _paPresetPrm[disp_no].BackBufferWidth  = 0;
                    _paPresetPrm[disp_no].BackBufferHeight = 0;
                }

            }
            //㏑XV
            _paDisplayMode[disp_no].Width  = _paPresetPrm[disp_no].BackBufferWidth;
            _paDisplayMode[disp_no].Height = _paPresetPrm[disp_no].BackBufferHeight;


            GGAF_DELETEARR(paMode);
            _TRACE_("<---" << disp_no+1 << "ʖڂ̉𑜓x́A"<<_paDisplayMode[disp_no].Width<<"x"<<_paDisplayMode[disp_no].Height<<"Ɋm肵܂B");
        }
    }

    //sNZVF[_[A_VF[_[o[W`FbN
    _vs_v = caps.VertexShaderVersion;
    _ps_v = caps.PixelShaderVersion;
    _TRACE_("Hardware Vertex Shader Version = "<<D3DSHADER_VERSION_MAJOR(_vs_v)<<"_"<<D3DSHADER_VERSION_MINOR(_vs_v));
    _TRACE_("Hardware Pixel Shader Version  = "<<D3DSHADER_VERSION_MAJOR(_ps_v)<<"_"<<D3DSHADER_VERSION_MINOR(_ps_v));
    if (_vs_v < D3DVS_VERSION(2, 0) || _ps_v < D3DPS_VERSION(2, 0)) {
        _TRACE_("rfIJ[hn[h̒_VF[_[ƃsNZVF[_[́AɃo[W 2_0 ȏオłB");
        _TRACE_("gp̃rfIJ[hł́A삵Ȃꂪ܂B");
    }

    //[FRECT\]
    //ɎgpRECT\̂̃o right, bottom ́uEWvƂȂĂ邪\mł͂ȂB
    //ۂ̒`
    //rect.right = rect.left + `;
    //rect.bottom = rect.top + `;
    //܂ (10,10)-(17,17) ̈́ARECT(10,10,18,18) Ǝw肷̂Ӑ}gp@炵B
    //₱AAӂ̒߂ꍇ͕֗łB
    //i{̉EẂAright, bottom  -1 ̒lɂȂj
    _rectGameBuffer.left   = 0;
    _rectGameBuffer.top    = 0;
    _rectGameBuffer.right  = _rectGameBuffer.left + PROPERTY::GAME_BUFFER_WIDTH;
    _rectGameBuffer.bottom = _rectGameBuffer.top  + PROPERTY::GAME_BUFFER_HEIGHT;

    _rectRenderTargetBuffer.left   = 0;
    _rectRenderTargetBuffer.top    = 0;
    _rectRenderTargetBuffer.right  = _rectRenderTargetBuffer.left + PROPERTY::RENDER_TARGET_BUFFER_WIDTH;
    _rectRenderTargetBuffer.bottom = _rectRenderTargetBuffer.top  + PROPERTY::RENDER_TARGET_BUFFER_HEIGHT;

    if (PROPERTY::SWAP_GAME_VIEW) {
        _primary = 1;
        _secondary = 0;
    } else {
        _primary = 0;
        _secondary = 1;
    }
    _aRect_HarfGameBuffer[_primary].left   = 0;
    _aRect_HarfGameBuffer[_primary].top    = 0;
    _aRect_HarfGameBuffer[_primary].right  = _aRect_HarfGameBuffer[_primary].left  + PROPERTY::GAME_BUFFER_WIDTH/2;
    _aRect_HarfGameBuffer[_primary].bottom = _aRect_HarfGameBuffer[_primary].top + PROPERTY::GAME_BUFFER_HEIGHT;

    _aRect_HarfGameBuffer[_secondary].left   = PROPERTY::GAME_BUFFER_WIDTH/2;
    _aRect_HarfGameBuffer[_secondary].top    = 0;
    _aRect_HarfGameBuffer[_secondary].right  = _aRect_HarfGameBuffer[_secondary].left + PROPERTY::GAME_BUFFER_WIDTH/2;
    _aRect_HarfGameBuffer[_secondary].bottom = _aRect_HarfGameBuffer[_secondary].top  + PROPERTY::GAME_BUFFER_HEIGHT;

    _aRect_HarfRenderTargetBuffer[_primary].left   = 0;
    _aRect_HarfRenderTargetBuffer[_primary].top    = 0;
    _aRect_HarfRenderTargetBuffer[_primary].right  = _aRect_HarfRenderTargetBuffer[_primary].left  + PROPERTY::RENDER_TARGET_BUFFER_WIDTH/2;
    _aRect_HarfRenderTargetBuffer[_primary].bottom = _aRect_HarfRenderTargetBuffer[_primary].top + PROPERTY::RENDER_TARGET_BUFFER_HEIGHT;

    _aRect_HarfRenderTargetBuffer[_secondary].left   = PROPERTY::RENDER_TARGET_BUFFER_WIDTH/2;
    _aRect_HarfRenderTargetBuffer[_secondary].top    = 0;
    _aRect_HarfRenderTargetBuffer[_secondary].right  = _aRect_HarfRenderTargetBuffer[_secondary].left + PROPERTY::RENDER_TARGET_BUFFER_WIDTH/2;
    _aRect_HarfRenderTargetBuffer[_secondary].bottom = _aRect_HarfRenderTargetBuffer[_secondary].top  + PROPERTY::RENDER_TARGET_BUFFER_HEIGHT;

    //\̈ݒ
    if (PROPERTY::FULL_SCREEN) {
        //tXN[[h
        if (PROPERTY::DUAL_VIEW) {
            _aRect_ViewScreen[0].top    = 0;
            _aRect_ViewScreen[0].left   = 0;
            _aRect_ViewScreen[0].right  = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
            _aRect_ViewScreen[0].bottom = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
            _aRect_ViewScreen[1].top    = 0;
            _aRect_ViewScreen[1].left   = 0;
            _aRect_ViewScreen[1].right  = PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
            _aRect_ViewScreen[1].bottom = PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;

            //tXN[[hEQʎgp
            if (PROPERTY::VIEW_AS_RENDER_TARGET_BUFFER_SIZE) {
                //utXN[[hEQʎgpERENDER_TARGET_BUFFERTCY\v
                LONG fix_width = PROPERTY::RENDER_TARGET_BUFFER_WIDTH * (1.0*PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH_BK) * PROPERTY::VIEW1_WIDTH_RATIO / 2;
                LONG fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT * (1.0*PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT / PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT_BK) * PROPERTY::VIEW1_HEIGHT_RATIO;
                _aRect_Present[0].left   = (PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / 2.0) - (fix_width / 2.0);
                _aRect_Present[0].top    = (PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT / 2.0) - (fix_height / 2.0);
                _aRect_Present[0].right  = _aRect_Present[0].left + fix_width ;
                _aRect_Present[0].bottom = _aRect_Present[0].top  + fix_height;


                //͂ݏoꍇ_aRect_HarfRenderTargetBuffer ߂
                if (_aRect_Present[0].left < 0 || _aRect_Present[0].right > PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH) {
                    LONG width_Present = _aRect_Present[0].right - _aRect_Present[0].left; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / width_Present;
                    LONG width_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*r;
                    _aRect_HarfRenderTargetBuffer[0].left = _aRect_HarfRenderTargetBuffer[0].right - (width_RenderTargetBuffer/2);
                    if (_aRect_Present[0].left < 0) {
                        _aRect_Present[0].left = 0;
                    }
                    if ( _aRect_Present[0].right > PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH) {
                        _aRect_Present[0].right = PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
                    }
                }
                if (_aRect_Present[0].top < 0 || _aRect_Present[0].bottom > PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT) {
                    LONG height_Present = _aRect_Present[0].bottom - _aRect_Present[0].top; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT / height_Present;
                    LONG height_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*r;
                    _aRect_HarfRenderTargetBuffer[0].top = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT - height_RenderTargetBuffer)/2;
                    _aRect_HarfRenderTargetBuffer[0].bottom = _aRect_HarfRenderTargetBuffer[0].top + height_RenderTargetBuffer;
                    if (_aRect_Present[0].top < 0) {
                        _aRect_Present[0].top = 0;
                    }
                    if (_aRect_Present[0].bottom > PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT) {
                        _aRect_Present[0].bottom = PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
                    }
                }




                fix_width = PROPERTY::RENDER_TARGET_BUFFER_WIDTH * (1.0*PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH_BK) * PROPERTY::VIEW2_WIDTH_RATIO / 2;
                fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT * (1.0*PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT / PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT_BK) * PROPERTY::VIEW2_HEIGHT_RATIO;
                _aRect_Present[1].left   = (PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / 2.0) - (fix_width / 2.0);
                _aRect_Present[1].top    = (PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT / 2.0) - (fix_height / 2.0);
                _aRect_Present[1].right  = _aRect_Present[1].left + fix_width;
                _aRect_Present[1].bottom = _aRect_Present[1].top  + fix_height;

                //͂ݏoꍇ_aRect_HarfRenderTargetBuffer ߂
                if (_aRect_Present[1].left < 0 || _aRect_Present[1].right > PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH) {
                    LONG width_Present = _aRect_Present[1].right - _aRect_Present[1].left; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / width_Present;
                    LONG width_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*r;
                    _aRect_HarfRenderTargetBuffer[1].right = _aRect_HarfRenderTargetBuffer[1].left + (width_RenderTargetBuffer/2);
                    if (_aRect_Present[1].left < 0) {
                        _aRect_Present[1].left = 0;
                    }
                    if ( _aRect_Present[1].right > PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH) {
                        _aRect_Present[1].right = PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
                    }
                }
                if (_aRect_Present[1].top < 0 || _aRect_Present[1].bottom > PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT) {
                    LONG height_Present = _aRect_Present[1].bottom - _aRect_Present[1].top; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT / height_Present;
                    LONG height_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*r;
                    _aRect_HarfRenderTargetBuffer[1].top = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT - height_RenderTargetBuffer)/2;
                    _aRect_HarfRenderTargetBuffer[1].bottom = _aRect_HarfRenderTargetBuffer[1].top + height_RenderTargetBuffer;
                    if (_aRect_Present[1].top < 0) {
                        _aRect_Present[1].top = 0;
                    }
                    if (_aRect_Present[1].bottom > PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT) {
                        _aRect_Present[1].bottom = PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;
                    }
                }

                positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION1, _aRect_Present[0],
                                    PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH, PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT);
                positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION2, _aRect_Present[1],
                                    PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH, PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT);
            } else {
                //utXN[[hEQʎgpERENDER_TARGET_BUFFERTCY
                if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                    //utXN[[hEQʎgpEcFIXv̂Pʖڃtgobt@`̈
                    LONG fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO/2;
                    LONG fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                    if (1.0f * PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT > 1.0f * fix_width / fix_height) {
                        //艡ɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT / fix_height; //k=c̔䗦
                        _aRect_Present[0].left   = (PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[0].top    = 0;
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    } else {
                        //cɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH / fix_width; //k=̔䗦
                        _aRect_Present[0].left   = 0;
                        _aRect_Present[0].top    = (PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    }
                    //utXN[[hEQʎgpEcFIXv̂Qʖڃtgobt@`̈
                    fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO/2;
                    fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                    if (1.0f * PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT > 1.0f * fix_width / fix_height) {
                        //艡ɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT / fix_height; //k=c̔䗦
                        _aRect_Present[1].left   = (PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[1].top    = 0;
                        _aRect_Present[1].right  = _aRect_Present[1].left + (fix_width * rate);
                        _aRect_Present[1].bottom = _aRect_Present[1].top  + (fix_height * rate);
                    } else {
                        //cɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH / fix_width; //k=̔䗦
                        _aRect_Present[1].left   = 0;
                        _aRect_Present[1].top    = (PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[1].right  = _aRect_Present[1].left + (fix_width * rate);
                        _aRect_Present[1].bottom = _aRect_Present[1].top  + (fix_height * rate);
                    }
                    positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION1, _aRect_Present[0],
                                        PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH, PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT);
                    positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION2, _aRect_Present[1],
                                        PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH, PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT);
                } else {
                    //utXN[[hEQʎgpEcXgb`v̂Pʖڃtgobt@`̈
                    _aRect_Present[0].left   = 0;
                    _aRect_Present[0].top    = 0;
                    _aRect_Present[0].right  = _aRect_Present[0].left + PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH;
                    _aRect_Present[0].bottom = _aRect_Present[0].top  + PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT;
                    //utXN[[hEQʎgpEcXgb`v̂Qʖڃtgobt@`̈
                    _aRect_Present[1].left   = 0;
                    _aRect_Present[1].top    = 0;
                    _aRect_Present[1].right  = _aRect_Present[1].left + PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH;
                    _aRect_Present[1].bottom = _aRect_Present[1].top  + PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT;
                }
            }
        } else {
            //tXN[[hEPʎgp
            _aRect_ViewScreen[0].top    = 0;
            _aRect_ViewScreen[0].left   = 0;
            _aRect_ViewScreen[0].right  = PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
            _aRect_ViewScreen[0].bottom = PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
            _aRect_ViewScreen[1] = _aRect_ViewScreen[0];

            if (PROPERTY::VIEW_AS_RENDER_TARGET_BUFFER_SIZE) {
                //utXN[[hEPʎgpERENDER_TARGET_BUFFERTCY\ṽtgobt@`̈
                LONG fix_width = PROPERTY::RENDER_TARGET_BUFFER_WIDTH * (1.0*PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH_BK) * PROPERTY::VIEW1_WIDTH_RATIO;
                LONG fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT * (1.0*PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT / PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT_BK) * PROPERTY::VIEW1_HEIGHT_RATIO;
                _aRect_Present[0].left   = (PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / 2.0) - (fix_width / 2.0);
                _aRect_Present[0].top    = (PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT / 2.0) - (fix_height / 2.0);
                _aRect_Present[0].right  = _aRect_Present[0].left + fix_width ;
                _aRect_Present[0].bottom = _aRect_Present[0].top  + fix_height;
                //left top ̏ꍇ _rectRenderTargetBuffer ߂B
                if (_aRect_Present[0].left < 0 || _aRect_Present[0].right > PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH) {
                    LONG width_Present = _aRect_Present[0].right - _aRect_Present[0].left; //_aRect_
                    double r = 1.0* PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / width_Present;
                    LONG width_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*r;
                    _rectRenderTargetBuffer.left = (PROPERTY::RENDER_TARGET_BUFFER_WIDTH - width_RenderTargetBuffer)/2;
                    _rectRenderTargetBuffer.right = _rectRenderTargetBuffer.left + width_RenderTargetBuffer;
                    if (_aRect_Present[0].left < 0) {
                        _aRect_Present[0].left = 0;
                    }
                    if (_aRect_Present[0].right > PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH) {
                        _aRect_Present[0].right = PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
                    }
                }
                if (_aRect_Present[0].top < 0 || _aRect_Present[0].bottom > PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT) {
                    LONG height_Present = _aRect_Present[0].bottom - _aRect_Present[0].top; //_aRect_
                    double r = 1.0* PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT / height_Present;
                    LONG bottom_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*r;
                    _rectRenderTargetBuffer.top = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT - bottom_RenderTargetBuffer)/2;
                    _rectRenderTargetBuffer.bottom = _rectRenderTargetBuffer.top + bottom_RenderTargetBuffer;
                    if (_aRect_Present[0].top < 0) {
                        _aRect_Present[0].top = 0;
                    }
                    if (_aRect_Present[0].bottom > PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT) {
                        _aRect_Present[0].bottom = PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
                    }
                }
                _aRect_Present[1] = _aRect_Present[0];
                positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[0],
                                    PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH, PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT);
                positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[1],
                                    PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH, PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT);
            } else {
                //utXN[[hEPʎgpERENDER_TARGET_BUFFERTCYv
                if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                    //utXN[[hEPʎgpEcFIXṽtgobt@`̈
                    LONG fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO;
                    LONG fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                    if (1.0f * PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT > 1.0f * fix_width / fix_height) {
                        //艡ɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT / fix_height; //k=c̔䗦
                        _aRect_Present[0].left   = (PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[0].top    = 0;
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    } else {
                        //cɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH / fix_width; //k=̔䗦
                        _aRect_Present[0].left   = 0;
                        _aRect_Present[0].top    = (PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    }
                    _aRect_Present[1] = _aRect_Present[0];
                    positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[0],
                                        PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH, PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT);
                    positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[1],
                                        PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH, PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT);
                } else {
                    //utXN[[hEPʎgpEcXgb`ṽtgobt@`̈
                    _aRect_Present[0].left   = 0;
                    _aRect_Present[0].top    = 0;
                    _aRect_Present[0].right  = _aRect_Present[0].left + PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH;
                    _aRect_Present[0].bottom = _aRect_Present[0].top  + PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT;
                    _aRect_Present[1] = _aRect_Present[0];
                }

            }
        }
    } else {
        //EBhE[h
        if (PROPERTY::DUAL_VIEW) {
            //EBhE[hEQgp
            if (PROPERTY::VIEW_AS_RENDER_TARGET_BUFFER_SIZE) {
                //uEBhE[hEQgpERENDER_TARGET_BUFFERTCY\v̂Pڃtgobt@`̈
                LONG fix_width = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO/2;
                LONG fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                _aRect_Present[0].left   = (PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / 2.0) - (fix_width  / 2.0);
                _aRect_Present[0].top    = (PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT / 2.0) - (fix_height / 2.0);
                _aRect_Present[0].right  = _aRect_Present[0].left + fix_width ;
                _aRect_Present[0].bottom = _aRect_Present[0].top  + fix_height;

                //͂ݏoꍇ_aRect_HarfRenderTargetBuffer ߂
                if (_aRect_Present[0].left < 0 || _aRect_Present[0].right > PROPERTY::DUAL_VIEW_WINDOW1_WIDTH) {
                    LONG width_Present = _aRect_Present[0].right - _aRect_Present[0].left; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / width_Present;
                    LONG width_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*r;
                    _aRect_HarfRenderTargetBuffer[0].left = _aRect_HarfRenderTargetBuffer[0].right - (width_RenderTargetBuffer/2);
                    if (_aRect_Present[0].left < 0) {
                        _aRect_Present[0].left = 0;
                    }
                    if ( _aRect_Present[0].right > PROPERTY::DUAL_VIEW_WINDOW1_WIDTH) {
                        _aRect_Present[0].right = PROPERTY::DUAL_VIEW_WINDOW1_WIDTH;
                    }
                }
                if (_aRect_Present[0].top < 0 || _aRect_Present[0].bottom > PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT) {
                    LONG height_Present = _aRect_Present[0].bottom - _aRect_Present[0].top; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT / height_Present;
                    LONG height_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*r;
                    _aRect_HarfRenderTargetBuffer[0].top = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT - height_RenderTargetBuffer)/2;
                    _aRect_HarfRenderTargetBuffer[0].bottom = _aRect_HarfRenderTargetBuffer[0].top + height_RenderTargetBuffer;
                    if (_aRect_Present[0].top < 0) {
                        _aRect_Present[0].top = 0;
                    }
                    if (_aRect_Present[0].bottom > PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT) {
                        _aRect_Present[0].bottom = PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT;
                    }
                }

                fix_width = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO/2;
                fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                _aRect_Present[1].left   = (PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / 2.0) - (fix_width / 2.0);
                _aRect_Present[1].top    = (PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT / 2.0) - (fix_height / 2.0);
                _aRect_Present[1].right  = _aRect_Present[1].left + fix_width ;
                _aRect_Present[1].bottom = _aRect_Present[1].top  + fix_height;

                //͂ݏoꍇ_aRect_HarfRenderTargetBuffer ߂
                if (_aRect_Present[1].left < 0 || _aRect_Present[1].right > PROPERTY::DUAL_VIEW_WINDOW2_WIDTH) {
                    LONG width_Present = _aRect_Present[1].right - _aRect_Present[1].left; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / width_Present;
                    LONG width_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*r;
                    _aRect_HarfRenderTargetBuffer[1].right = _aRect_HarfRenderTargetBuffer[1].left + (width_RenderTargetBuffer/2);
                    if (_aRect_Present[1].left < 0) {
                        _aRect_Present[1].left = 0;
                    }
                    if ( _aRect_Present[1].right > PROPERTY::DUAL_VIEW_WINDOW2_WIDTH) {
                        _aRect_Present[1].right = PROPERTY::DUAL_VIEW_WINDOW2_WIDTH;
                    }
                }
                if (_aRect_Present[1].top < 0 || _aRect_Present[1].bottom > PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT) {
                    LONG height_Present = _aRect_Present[1].bottom - _aRect_Present[1].top; //_aRect_
                    double r = 1.0* PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT / height_Present;
                    LONG height_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*r;
                    _aRect_HarfRenderTargetBuffer[1].top = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT - height_RenderTargetBuffer)/2;
                    _aRect_HarfRenderTargetBuffer[1].bottom = _aRect_HarfRenderTargetBuffer[1].top + height_RenderTargetBuffer;
                    if (_aRect_Present[1].top < 0) {
                        _aRect_Present[1].top = 0;
                    }
                    if (_aRect_Present[1].bottom > PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT) {
                        _aRect_Present[1].bottom = PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT;
                    }
                }

                positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION1, _aRect_Present[0],
                                    PROPERTY::DUAL_VIEW_WINDOW1_WIDTH, PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT);
                positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION2, _aRect_Present[1],
                                    PROPERTY::DUAL_VIEW_WINDOW2_WIDTH, PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT);
            } else {
                //uEBhE[hEQgpERENDER_TARGET_BUFFERTCYv
                if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                    LONG fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO/2;
                    LONG fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                    //uEBhE[hEQgpEcFIXEsNZXgb`v̂Pڃtgobt@`̈
                    if (1.0f * PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT > 1.0f * fix_width / fix_height) {
                        //艡ɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT / fix_height; //k=c̔䗦
                        _aRect_Present[0].left   = (PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[0].top    = 0;
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    } else {
                        //cɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW1_WIDTH / fix_width; //k=̔䗦
                        _aRect_Present[0].left   = 0;
                        _aRect_Present[0].top    = (PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    }

                    fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO/2;
                    fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                    //uEBhE[hEQgpEcFIXv̂Qڃtgobt@`̈
                    if (1.0f * PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT > 1.0f * fix_width / fix_height) {
                        //艡ɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT / fix_height; //k=c̔䗦
                        _aRect_Present[1].left   = (PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[1].top    = 0;
                        _aRect_Present[1].right  = _aRect_Present[1].left + (fix_width * rate);
                        _aRect_Present[1].bottom = _aRect_Present[1].top  + (fix_height * rate);
                    } else {
                        //cɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::DUAL_VIEW_WINDOW2_WIDTH / fix_width; //k=̔䗦
                        _aRect_Present[1].left   = 0;
                        _aRect_Present[1].top    = (PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[1].right  = _aRect_Present[1].left + (fix_width * rate);
                        _aRect_Present[1].bottom = _aRect_Present[1].top  + (fix_height * rate);
                    }

                    positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION1, _aRect_Present[0],
                                        PROPERTY::DUAL_VIEW_WINDOW1_WIDTH, PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT);
                    positionPresentRect(PROPERTY::DUAL_VIEW_DRAW_POSITION2, _aRect_Present[1],
                                        PROPERTY::DUAL_VIEW_WINDOW2_WIDTH, PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT);
                } else {
                    //uEBhE[hEQgpEcXgb`v̂Pڃtgobt@`̈
                    _aRect_Present[0].left   = 0;
                    _aRect_Present[0].top    = 0;
                    _aRect_Present[0].right  = _aRect_Present[0].left + PROPERTY::DUAL_VIEW_WINDOW1_WIDTH;
                    _aRect_Present[0].bottom = _aRect_Present[0].top  + PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT;
                    //uEBhE[hEQgpEcXgb`v̂Qڃtgobt@`̈
                    _aRect_Present[1].left   = 0;
                    _aRect_Present[1].top    = 0;
                    _aRect_Present[1].right  = _aRect_Present[1].left + PROPERTY::DUAL_VIEW_WINDOW2_WIDTH;
                    _aRect_Present[1].bottom = _aRect_Present[1].top  + PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT;
                }
            }
        } else {
            //EBhE[hEPgp
            if (PROPERTY::VIEW_AS_RENDER_TARGET_BUFFER_SIZE) {
                //uEBhE[hEPgpERENDER_TARGET_BUFFERTCY\ṽtgobt@`̈
                LONG fix_width = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO;
                LONG fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                _aRect_Present[0].left   = (PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / 2.0) - (fix_width / 2.0);
                _aRect_Present[0].top    = (PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT / 2.0) - (fix_height / 2.0);
                _aRect_Present[0].right  = _aRect_Present[0].left + fix_width;
                _aRect_Present[0].bottom = _aRect_Present[0].top  + fix_height;
                //left top ̏ꍇ _rectRenderTargetBuffer ߂B
                if (_aRect_Present[0].left < 0 || _aRect_Present[0].right > PROPERTY::SINGLE_VIEW_WINDOW_WIDTH) {
                    LONG width_Present = _aRect_Present[0].right - _aRect_Present[0].left; //_aRect_
                    double r = 1.0* PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / width_Present;
                    LONG width_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_WIDTH*r;
                    _rectRenderTargetBuffer.left = (PROPERTY::RENDER_TARGET_BUFFER_WIDTH - width_RenderTargetBuffer)/2;
                    _rectRenderTargetBuffer.right = _rectRenderTargetBuffer.left + width_RenderTargetBuffer;
                    if (_aRect_Present[0].left < 0) {
                        _aRect_Present[0].left = 0;
                    }
                    if (_aRect_Present[0].right > PROPERTY::SINGLE_VIEW_WINDOW_WIDTH) {
                        _aRect_Present[0].right = PROPERTY::SINGLE_VIEW_WINDOW_WIDTH;
                    }
                }
                if (_aRect_Present[0].top < 0 || _aRect_Present[0].bottom > PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT) {
                    LONG height_Present = _aRect_Present[0].bottom - _aRect_Present[0].top; //_aRect_
                    double r = 1.0* PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT / height_Present;
                    LONG bottom_RenderTargetBuffer = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT*r;
                    _rectRenderTargetBuffer.top = (PROPERTY::RENDER_TARGET_BUFFER_HEIGHT - bottom_RenderTargetBuffer)/2;
                    _rectRenderTargetBuffer.bottom = _rectRenderTargetBuffer.top + bottom_RenderTargetBuffer;
                    if (_aRect_Present[0].top < 0) {
                        _aRect_Present[0].top = 0;
                    }
                    if (_aRect_Present[0].bottom > PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT) {
                        _aRect_Present[0].bottom = PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT;
                    }
                }
                _aRect_Present[1] = _aRect_Present[0];
                positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[0],
                                    PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
                positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[1],
                                    PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
            } else {
                //uEBhE[hEPgpERENDER_TARGET_BUFFERTCYv
                if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                    LONG fix_width = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW2_WIDTH_RATIO;
                    LONG fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW2_HEIGHT_RATIO;
                    //uEBhE[hEPgpEcFIXṽtgobt@`̈
                    if (1.0f * PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT > 1.0f * fix_width / fix_height) {
                        //艡ɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT / fix_height; //k=c̔䗦
                        _aRect_Present[0].left   = (PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / 2.0) - (fix_width * rate / 2.0);
                        _aRect_Present[0].top    = 0;
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    } else {
                        //cɂȂĂ܂Ă
                        double rate = 1.0 * PROPERTY::SINGLE_VIEW_WINDOW_WIDTH / fix_width; //k=̔䗦
                        _aRect_Present[0].left   = 0;
                        _aRect_Present[0].top    = (PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT / 2.0) - (fix_height * rate / 2.0);
                        _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                    }
                    _aRect_Present[1] = _aRect_Present[0];
                    positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[0],
                                        PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
                    positionPresentRect(PROPERTY::SINGLE_VIEW_DRAW_POSITION, _aRect_Present[1],
                                        PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
                } else {
                    //uEBhE[hEPgpEcXgb`ṽtgobt@`̈
                    _aRect_Present[0].left   = 0;
                    _aRect_Present[0].top    = 0;
                    _aRect_Present[0].right  = _aRect_Present[0].left + PROPERTY::SINGLE_VIEW_WINDOW_WIDTH;
                    _aRect_Present[0].bottom = _aRect_Present[0].top  + PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT;
                    _aRect_Present[1] = _aRect_Present[0];
                }
            }
        }
    }

#ifdef MY_DEBUG
    _TRACE_("ݒ");
    if (PROPERTY::DUAL_VIEW) {
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].left   = "<<_aRect_HarfRenderTargetBuffer[0].left  );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].top    = "<<_aRect_HarfRenderTargetBuffer[0].top   );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].right  = "<<_aRect_HarfRenderTargetBuffer[0].right );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].bottom = "<<_aRect_HarfRenderTargetBuffer[0].bottom);
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].left   = "<<_aRect_HarfRenderTargetBuffer[1].left  );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].top    = "<<_aRect_HarfRenderTargetBuffer[1].top   );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].right  = "<<_aRect_HarfRenderTargetBuffer[1].right );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].bottom = "<<_aRect_HarfRenderTargetBuffer[1].bottom);
        _TRACE_(" _aRect_Present[0].left   = "<<_aRect_Present[0].left  );
        _TRACE_(" _aRect_Present[0].top    = "<<_aRect_Present[0].top   );
        _TRACE_(" _aRect_Present[0].right  = "<<_aRect_Present[0].right );
        _TRACE_(" _aRect_Present[0].bottom = "<<_aRect_Present[0].bottom);
        _TRACE_(" _aRect_Present[1].left   = "<<_aRect_Present[1].left  );
        _TRACE_(" _aRect_Present[1].top    = "<<_aRect_Present[1].top   );
        _TRACE_(" _aRect_Present[1].right  = "<<_aRect_Present[1].right );
        _TRACE_(" _aRect_Present[1].bottom = "<<_aRect_Present[1].bottom);
    } else {
        _TRACE_(" _rectRenderTargetBuffer.left   = "<<_rectRenderTargetBuffer.left  );
        _TRACE_(" _rectRenderTargetBuffer.top    = "<<_rectRenderTargetBuffer.top   );
        _TRACE_(" _rectRenderTargetBuffer.right  = "<<_rectRenderTargetBuffer.right );
        _TRACE_(" _rectRenderTargetBuffer.bottom = "<<_rectRenderTargetBuffer.bottom);
        _TRACE_(" _aRect_Present[0].left   = "<<_aRect_Present[0].left  );
        _TRACE_(" _aRect_Present[0].top    = "<<_aRect_Present[0].top   );
        _TRACE_(" _aRect_Present[0].right  = "<<_aRect_Present[0].right );
        _TRACE_(" _aRect_Present[0].bottom = "<<_aRect_Present[0].bottom);
    }
#endif

    GgafCore::GgafRgb rgb = GgafCore::GgafRgb(PROPERTY::BORDER_COLOR);
    prm_wndclass1.hbrBackground = CreateSolidBrush(RGB(rgb._R, rgb._G, rgb._B));
    prm_wndclass2.hbrBackground = CreateSolidBrush(RGB(rgb._R, rgb._G, rgb._B));
    // EChE̐
    if (PROPERTY::FULL_SCREEN) {
        if (PROPERTY::DUAL_VIEW) {
            //tXN[[hEQʎgp
            RegisterClassEx(&prm_wndclass1);
            GgafDxGod::_pHWndPrimary   = CreateWindowEx(
                                           WS_EX_APPWINDOW,
                                           prm_wndclass1.lpszClassName,
                                           prm_title1,
                                           WS_POPUP | WS_VISIBLE,
                                           CW_USEDEFAULT,
                                           CW_USEDEFAULT,
                                           PROPERTY::DUAL_VIEW_FULL_SCREEN1_WIDTH,
                                           PROPERTY::DUAL_VIEW_FULL_SCREEN1_HEIGHT,
                                           HWND_DESKTOP,
                                           nullptr,
                                           prm_wndclass1.hInstance,
                                           nullptr
                                        );

            RegisterClassEx(&prm_wndclass2);
            GgafDxGod::_pHWndSecondary = CreateWindowEx(
                                           WS_EX_APPWINDOW,
                                           prm_wndclass2.lpszClassName,
                                           prm_title2,
                                           WS_POPUP | WS_VISIBLE,
                                           CW_USEDEFAULT,
                                           CW_USEDEFAULT,
                                           PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH,
                                           PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT,
                                           HWND_DESKTOP,
                                           nullptr,
                                           prm_wndclass2.hInstance,
                                           nullptr
                                         );

        } else {
            //tXN[[hEPʎgp
            RegisterClassEx(&prm_wndclass1);
            GgafDxGod::_pHWndPrimary   = CreateWindowEx(
                                           WS_EX_APPWINDOW,
                                           prm_wndclass1.lpszClassName,
                                           prm_title1,
                                           WS_POPUP | WS_VISIBLE,
                                           CW_USEDEFAULT,
                                           CW_USEDEFAULT,
                                           PROPERTY::SINGLE_VIEW_FULL_SCREEN_WIDTH,
                                           PROPERTY::SINGLE_VIEW_FULL_SCREEN_HEIGHT,
                                           HWND_DESKTOP,
                                           nullptr,
                                           prm_wndclass1.hInstance,
                                           nullptr
                                         );

        }
    } else {
        if (PROPERTY::DUAL_VIEW) {
            //ECh[hEQgp
            RegisterClassEx(&prm_wndclass1);
            GgafDxGod::_pHWndPrimary   = CreateWindow(
                                           prm_wndclass1.lpszClassName,
                                           prm_title1,
                                           prm_dwStyle1,
                                           CW_USEDEFAULT,
                                           CW_USEDEFAULT,
                                           PROPERTY::DUAL_VIEW_WINDOW1_WIDTH,
                                           PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT,
                                           HWND_DESKTOP,
                                           nullptr,
                                           prm_wndclass1.hInstance,
                                           nullptr
                                         );

            RegisterClassEx(&prm_wndclass2);
            GgafDxGod::_pHWndSecondary = CreateWindow(
                                           prm_wndclass2.lpszClassName,
                                           prm_title2,
                                           prm_dwStyle2,
                                           CW_USEDEFAULT,
                                           CW_USEDEFAULT,
                                           PROPERTY::DUAL_VIEW_WINDOW2_WIDTH,
                                           PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT,
                                           HWND_DESKTOP,
                                           nullptr,
                                           prm_wndclass2.hInstance,
                                           nullptr
                                         );
        } else {
            //ECh[hEPgp
            RegisterClassEx(&prm_wndclass1);
            GgafDxGod::_pHWndPrimary  = CreateWindow(
                                          prm_wndclass1.lpszClassName,
                                          prm_title1,
                                          prm_dwStyle1,
                                          CW_USEDEFAULT,
                                          CW_USEDEFAULT,
                                          PROPERTY::SINGLE_VIEW_WINDOW_WIDTH,
                                          PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT,
                                          HWND_DESKTOP,
                                          nullptr,
                                          prm_wndclass1.hInstance,
                                          nullptr
                                        );
        }
    }

    out_hWnd1 = GgafDxGod::_pHWndPrimary;
    out_hWnd2 = GgafDxGod::_pHWndSecondary;

    if (!GgafDxGod::_pHWndPrimary) {
        std::cout << "can't CreateWindow " << std::endl;
    }
    //Windownhʎw
    _paPresetPrm[0].hDeviceWindow = _pHWndPrimary;
    _paPresetPrm[1].hDeviceWindow = _pHWndSecondary;
    for (int disp_no = 2; disp_no < _num_adapter; disp_no++) {
        _paPresetPrm[disp_no].hDeviceWindow = _pHWndSecondary;
    }
    //EBhE[hANCAg̈]̑傫ɂ邽߁A
    //^Cgo[ATCY{[_[̌lĐݒB
    if (!PROPERTY::FULL_SCREEN) {
        if (PROPERTY::DUAL_VIEW) {
            resetWindowsize(GgafDxGod::_pHWndPrimary, PROPERTY::DUAL_VIEW_WINDOW1_WIDTH, PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT);
            resetWindowsize(GgafDxGod::_pHWndSecondary, PROPERTY::DUAL_VIEW_WINDOW2_WIDTH, PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT);
        } else {
            resetWindowsize(GgafDxGod::_pHWndPrimary, PROPERTY::SINGLE_VIEW_WINDOW_WIDTH, PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT);
        }
    }

    //ANeBu
    ShowWindow(GgafDxGod::_pHWndPrimary, SW_SHOWNORMAL);
    UpdateWindow(GgafDxGod::_pHWndPrimary);
    if (PROPERTY::DUAL_VIEW) {
        ShowWindow(GgafDxGod::_pHWndSecondary, SW_SHOWNORMAL);
        UpdateWindow(GgafDxGod::_pHWndSecondary);
    }

    //foCX쐬
    if (FAILED(initDevice())) {
        throwGgafCriticalException("Ɏs܂BAvP[VNo܂B");
    }

}

void GgafDxGod::createWindow(WNDCLASSEX& prm_wndclass1, WNDCLASSEX& prm_wndclass2,
                             const char* prm_title1   , const char* prm_title2,
                             HWND&       out_hWnd1    , HWND&       out_hWnd2) {

    createWindow( prm_wndclass1, prm_wndclass2,
                  prm_title1, prm_title2,
                  WS_OVERLAPPEDWINDOW, WS_OVERLAPPEDWINDOW,
                  out_hWnd1, out_hWnd2   );
}

void GgafDxGod::createWindow(WNDPROC prm_WndProc,
                             const char* prm_title1, const char* prm_title2,
                             HWND&       out_hWnd1 , HWND&       out_hWnd2  ) {
    //EBhE`쐬
    WNDCLASSEX wcex1;
    ZeroMemory(&wcex1, sizeof(WNDCLASSEX));
    wcex1.cbSize = sizeof(WNDCLASSEX);
    wcex1.style = CS_HREDRAW | CS_VREDRAW | CS_CLASSDC;
    wcex1.lpfnWndProc = (WNDPROC)prm_WndProc;
    wcex1.hInstance = GgafDxGod::_hInstance;
    wcex1.hCursor = LoadCursor(nullptr, IDC_ARROW);
    wcex1.lpszClassName = "Gecchi Game App Framework (window[0])";
    WNDCLASSEX wcex2 = wcex1;
    wcex2.lpszClassName = "Gecchi Game App Framework (window[1])";

    createWindow( wcex1, wcex2,
                  prm_title1, prm_title2,
                  WS_OVERLAPPEDWINDOW, WS_OVERLAPPEDWINDOW,
                  out_hWnd1, out_hWnd2   );
}


HRESULT GgafDxGod::initDevice() {


//    //default
//    UINT AdapterToUse = D3DADAPTER_DEFAULT;
//    D3DDEVTYPE DeviceType = D3DDEVTYPE_HAL;
//    // NVIDIA PerfHUD p begin --------------------------------------------->

//#ifdef MY_DEBUG
//
//#if SHIPPING_VERSION
//    // When building a shipping version, disable PerfHUD (opt-out)
//#else
//    _TRACE_("Look for 'NVIDIA PerfHUD' adapter...");
//    // If it is present, override default settings
//    for (UINT Adapter = 0; Adapter < GgafDxGod::_pID3D9->GetAdapterCount(); Adapter++) {
//        D3DADAPTER_IDENTIFIER9 Identifier;
//        HRESULT Res;
//        Res = GgafDxGod::_pID3D9->GetAdapterIdentifier(Adapter, 0, &Identifier);
//        if (strstr(Identifier.Description, "PerfHUD") != 0) {
//            _TRACE_("found NVIDIA PerfHUD!");
//            AdapterToUse = Adapter;
//            DeviceType = D3DDEVTYPE_REF;
//            break;
//        }
//    }
//#endif
//
//#endif
    // <------------------------------------------------ NVIDIA PerfHUD p end
    HRESULT hr;
    if (PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
        //tXN[  fAr[ ̏ꍇ
        //foCX쐬 GgafDxGod::_pID3DDevice9 ֐ݒ肷B
        //n[hEFAɂ钸_AX^CYsfoCX쐬݂BHAL(pure vp)
        hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, GgafDxGod::_pHWndPrimary,
                             D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE | D3DCREATE_ADAPTERGROUP_DEVICE,
                             _paPresetPrm, _paDisplayMode);
        if (hr != D3D_OK) {
            _TRACE_("}`wbhD3DCREATE_HARDWARE_VERTEXPROCESSING : "<<GgafDxCriticalException::getHresultMsg(hr));

            //\tgEFAɂ钸_An[hEFAɂ郉X^CYsfoCX쐬݂BHAL(soft vp)
            hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, GgafDxGod::_pHWndPrimary,
                                 D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE | D3DCREATE_ADAPTERGROUP_DEVICE,
                                 _paPresetPrm, _paDisplayMode);
            if (hr != D3D_OK) {
                _TRACE_("}`wbhD3DCREATE_HARDWARE_VERTEXPROCESSING : "<<GgafDxCriticalException::getHresultMsg(hr));

                //\tgEFAɂ钸_AX^CYsfoCX쐬݂BREF
                hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, GgafDxGod::_pHWndPrimary,
                                     D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE | D3DCREATE_ADAPTERGROUP_DEVICE,
                                     _paPresetPrm, _paDisplayMode);
                if (hr != D3D_OK) {
                    //ǂ̃foCX̍쐬sꍇ
                    _TRACE_("GgafDxGod::init DirectX̏Ɏs܂B}`wbhD3DCREATE_SOFTWARE_VERTEXPROCESSING : "<<GgafDxCriticalException::getHresultMsg(hr));
                    MessageBox(GgafDxGod::_pHWndPrimary, TEXT("DirectX̏Ɏs܂B\n}`wbhfBXvC݂Ă܂B"), TEXT("ERROR"), MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
                    return E_FAIL;
                } else {
                    _TRACE_("GgafDxGod::init foCX MULTI FULLSCRREEN REF ŏł܂B");
                }

            } else {
                _TRACE_("GgafDxGod::init foCX MULTI FULLSCRREEN HAL(soft vp) ŏł܂B");
            }

        } else {
            _TRACE_("GgafDxGod::init foCX MULTI FULLSCRREEN HAL(pure vp) ŏł܂B");
        }

    } else {
        //(tXN[  fAr[) ȊȌꍇ
        //foCX쐬 GgafDxGod::_pID3DDevice9 ֐ݒ肷B
        //n[hEFAɂ钸_AX^CYsfoCX쐬݂BHAL(pure vp)
        hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, GgafDxGod::_pHWndPrimary,
                             D3DCREATE_PUREDEVICE | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
                             &_paPresetPrm[0], &_paDisplayMode[0]);
//                                           D3DCREATE_MIXED_VERTEXPROCESSING|D3DCREATE_MULTITHREADED,
//                                           D3DCREATE_HARDWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED,
        if (hr != D3D_OK) {
            //\tgEFAɂ钸_An[hEFAɂ郉X^CYsfoCX쐬݂BHAL(soft vp)
            hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, GgafDxGod::_pHWndPrimary,
                                 D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
                                 &_paPresetPrm[0], &_paDisplayMode[0]);
            if (hr != D3D_OK) {
                //\tgEFAɂ钸_AX^CYsfoCX쐬݂BREF
                hr = createDx9Device(D3DADAPTER_DEFAULT, D3DDEVTYPE_REF, GgafDxGod::_pHWndPrimary,
                                     D3DCREATE_SOFTWARE_VERTEXPROCESSING | D3DCREATE_MULTITHREADED | D3DCREATE_FPU_PRESERVE,
                                     &_paPresetPrm[0], &_paDisplayMode[0]);
                if (hr != D3D_OK) {
                    //ǂ̃foCX̍쐬sꍇ
                    _TRACE_("GgafDxGod::init DirectX̏Ɏs܂B "<<GgafDxCriticalException::getHresultMsg(hr));
                    MessageBox(GgafDxGod::_pHWndPrimary, TEXT("DirectX̏Ɏs܂B"), TEXT("ERROR"), MB_OK | MB_ICONSTOP | MB_SETFOREGROUND);
                    return E_FAIL;
                } else {
                    _TRACE_("GgafDxGod::init foCX REF ŏł܂B");
                }

            } else {
                _TRACE_("GgafDxGod::init foCX HAL(soft vp) ŏł܂B");
            }

        } else {
            _TRACE_("GgafDxGod::init foCX HAL(pure vp) ŏł܂B");
        }
    }

    //eXg
    if (_can_wddm) {
        hr = ((IDirect3DDevice9Ex*)GgafDxGod::_pID3DDevice9)->SetMaximumFrameLatency(0);
        checkDxException(hr, D3D_OK, "SetMaximumFrameLatency(0) Ɏs܂B");
    }

    //̑Kvȏ
    _pCubeMapTextureManager = NEW GgafDxTextureManager("CubeMapTexManager");
    _pBumpMapTextureManager = NEW GgafDxTextureManager("BumpMapTexManager");
    _pModelManager = NEW GgafDxModelManager("ModelManager");
    _pEffectManager = NEW GgafDxEffectManager("EffectManager");
    GgafDxUtil::init();  //[eBeB
    GgafDxInput::init(); //DirectInput
    GgafDxSound::init(); //DirectSound

    //foCX
    hr = initDx9Device();
    if (hr == E_FAIL) {
        return E_FAIL;
    }
    Sleep(1000);
    //tXN[A_O^[QbgeNX`[쐬
    if (PROPERTY::FULL_SCREEN) {
        hr = restoreFullScreenRenderTarget();
        if (hr == E_FAIL) {
            return E_FAIL;
        }
    }

    //2011/09/28
    //TODO:VISTAłQʃtXN[ANbNŃtXN[̑΍
    //WDDMŃfoCX쐬AQʃtXN[ŋNAQʖڂ̗̈̂A
    //ƂƂ̂Pʖڂ̈(𑜓xύXɂQʖڂւ͂ݏoojNbNƁA
    //tXN[Ă܂ƂCɂȂBȂ̎Ԃ₵A@͌ȂB
    //AŃEBhEč\z邱ƂŁAȂ͉łB
    //ԂAK̕@ȂB̍EEEB
    if (_can_wddm && PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
        hr = releaseFullScreenRenderTarget();
        hr = restoreFullScreenRenderTarget();
    }
    return D3D_OK;
}


//Qʖڂ̍W𒲂ׂ
BOOL CALLBACK GgafDxGod::getSecondaryMoniterPixcoordCallback(HMONITOR hMonitor,
                                                             HDC hdcMonitor,
                                                             LPRECT lprcMonitor,
                                                             LPARAM dwData) {
    //Rʖڈȍ~̉𑜓x́APʖځEQʖڂ̉𑜓xȊO̖ȉ𑜓xɐݒ肳Ă邱ƂO
    GgafDxGod* pGod = (GgafDxGod*)dwData;
    MONITORINFOEX moniter_info;
    moniter_info.cbSize = sizeof(MONITORINFOEX);
    GetMonitorInfo(hMonitor, &moniter_info);
    if (moniter_info.dwFlags != MONITORINFOF_PRIMARY) {
        //vC}j^ł͖
        if (moniter_info.rcMonitor.right - moniter_info.rcMonitor.left == PROPERTY::DUAL_VIEW_FULL_SCREEN2_WIDTH &&
            moniter_info.rcMonitor.bottom - moniter_info.rcMonitor.top == PROPERTY::DUAL_VIEW_FULL_SCREEN2_HEIGHT
        ) {
            //vC}j^ł͖AQʖڂ̉𑜓xɈvB
            //ĂQʖڂƌȂ(U@łȂȂEEE)

            //Qʖڂ̍W㏑ۑ
            pGod->_secondary_screen_x = moniter_info.rcMonitor.left;
            pGod->_secondary_screen_y = moniter_info.rcMonitor.top;
            return FALSE; //񋓂𒆎~
        } else {
            //vC}j^ł͖AQʖڂ̉𑜓xɕsvB
            //ɂ͗Ȃ
            return TRUE; //񋓂𑱍s
        }
    } else {
        //vC}j^
        return TRUE; //񋓂𑱍s
    }
}

HRESULT GgafDxGod::createDx9Device(UINT Adapter,
                                   D3DDEVTYPE DeviceType,
                                   HWND hFocusWindow,
                                   DWORD BehaviorFlags,
                                   D3DPRESENT_PARAMETERS* pPresentationParameters,
                                   D3DDISPLAYMODEEX* pFullscreenDisplayMode
                                  ) {
    HRESULT hr;
    if (_can_wddm) {
        if (!PROPERTY::FULL_SCREEN) {
            pFullscreenDisplayMode = nullptr;
        }
        IDirect3D9Ex* pID3D9Ex = (IDirect3D9Ex*)GgafDxGod::_pID3D9;
        IDirect3DDevice9Ex* pID3DDevice9Ex;
        hr = pID3D9Ex->CreateDeviceEx(Adapter,
                                      DeviceType,
                                      hFocusWindow,
                                      BehaviorFlags,
                                      pPresentationParameters,
                                      pFullscreenDisplayMode,
                                      &pID3DDevice9Ex
                                      );
        GgafDxGod::_pID3DDevice9 = (IDirect3DDevice9Ex*)pID3DDevice9Ex;
    } else {
        hr = GgafDxGod::_pID3D9->CreateDevice(Adapter,
                                              DeviceType,
                                              hFocusWindow,
                                              BehaviorFlags,
                                              pPresentationParameters,
                                              &GgafDxGod::_pID3DDevice9
                                              );
    }
    return hr;
 }

HRESULT GgafDxGod::initDx9Device() {
    //Cg\̂́AVF[_[̃p[^ɂȂ鎞邽ߕKvB
    D3DXVECTOR3 vecDirection(-1.0f, -1.0f, 1.0f);
    D3DXVec3Normalize(&vecDirection, &vecDirection); //K
    ZeroMemory(&_d3dlight9_default, sizeof(D3DLIGHT9));
    GgafDxGod::_d3dlight9_default.Direction = vecDirection;
    GgafDxGod::_d3dlight9_default.Type = D3DLIGHT_DIRECTIONAL;
    GgafDxGod::_d3dlight9_default.Diffuse.a = 1.0f;
    GgafDxGod::_d3dlight9_default.Diffuse.r = 1.0f;
    GgafDxGod::_d3dlight9_default.Diffuse.g = 1.0f;
    GgafDxGod::_d3dlight9_default.Diffuse.b = 1.0f;

    GgafDxGod::_d3dlight9_default.Ambient.a = 1.0f;
    GgafDxGod::_d3dlight9_default.Ambient.r = 0.3f; //ArGgCgSetRenderState(D3DRS_AMBIENT, 0x00303030)Őݒ
    GgafDxGod::_d3dlight9_default.Ambient.g = 0.3f;
    GgafDxGod::_d3dlight9_default.Ambient.b = 0.3f;

    //GgafDxGod::_d3dlight9_default.Range = 1000.0f;

    //CgZbg
    //    GgafDxGod::_pID3DDevice9->SetLight(0, &GgafDxGod::_d3dlight9_default);
    //CgXCb`ON
    //    GgafDxGod::_pID3DDevice9->LightEnable(0, TRUE);
    //GgafDxGod::_pID3DDevice9->LightEnable(0, FALSE);
    //_ɃCg̉eiAejL
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_LIGHTING, TRUE);
    //_ɃCg̉eiAej𖳌 (sNZVF[_[ōsȂ߁j
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_LIGHTING, FALSE);
    //_AEɋʂ̃ArGgCgLɂ悤ɕ`
    //   GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_AMBIENT, _dwAmbientBrightness_default);

    // Zobt@L
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
    // Zobt@𖳌
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);
    //Zobt@݉
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZWRITEENABLE, TRUE);
    //Zobt@ݕs
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ZWRITEENABLE, FALSE );

    //D3DRENDERSTATE_ZFUNC

    //XeVeXg̕@
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_STENCILFUNC, D3DCMP_ALWAYS); //ɃeXgpX
    //ɎsɃXeV̒lǂω邩
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_STENCILFAIL, D3DSTENCILOP_KEEP); //ωȂ
    //ZeXgŎsꍇ̃XeVl̕ω
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_STENCILZFAIL, D3DSTENCILOP_KEEP); //ωȂ


    //ivjɃJO 捶Wn
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);
    //JOȂ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

    // fBUO
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DITHERENABLE, TRUE );
    // }`TvOA`GCAX(ƂĂtXN[H)TODO:܂
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS, TRUE);
//    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEMASK, 0x00ffffff);

    //sNZPʂ̃At@eXgL
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ALPHATESTENABLE, TRUE);

    //ݒ̓VF[_[ɏɂ̂ŃRg
    // At@uhnm
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    //2iKځAeNX`\t|SƃobNobt@i_[^[QbgjƂ̍
    //F̎Zo@̐ݒ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_BLENDOPALPHA, D3DBLENDOP_ADD); //D3DBLENDOP_ADD=]ɓ]悪Z
    //W
    //    //ɏ摜̍@(VF[_[ɉe)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA); //SRC,D3DBLEND_SRCALPHA=ʂɕ`B|S̃At@l̔Zŕ`BAt@l̒l΍قǁAZ`B
    //    //n̉摜̍@(VF[_[ɉe)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA); //DIST,D3DBLEND_INVSRCALPHA=ɕ`|S̃At@l̔ZɂāAn̕`𔖂B



    //_J[𖳌ɂ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_COLORVERTEX, FALSE );
    // GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_COLORVERTEX, TRUE );
    //    //ʂ̃ArGg˂́A}eAQƂ悤ɐݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_AMBIENTMATERIALSOURCE, D3DMCS_MATERIAL);
    //    //ʂ̃ft[Y˂́A}eAQƂ悤ɐݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE, D3DMCS_MATERIAL);
    //    //ʂ̃G~bVu˂́A}eAQƂݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_EMISSIVEMATERIALSOURCE, D3DMCS_MATERIAL);
    //    //ʂ̃XyL˂́A}eAQƂݒ肷Bi_J[QƂꍇ D3DMCS_COLOR1)
    //    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_SPECULARMATERIALSOURCE, D3DMCS_MATERIAL);

    //_gpƂ
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_DIFFUSEMATERIALSOURCE , D3DMCS_COLOR1);

    //
    //
    // A`GCAX̎w
    //GgafDxGod::_pID3DDevice9->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
    //GgafDxGod::_pID3DDevice9->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
    //  TypeD3DSAMP_MINFILTER/D3DSAMP_MAGFILTERig/kj ??D3DTSS_MAGFILTER
    //  ValueD3DTEXTUREFILTERTYPE񋓌^w肷
    //  D3DTEXF_POINT@@@@FtB^ȂB`ł
    //  D3DTEXF_LINEAR@@@FjAtB^i`⊮j
    //  D3DTEXF_ANISOTROPIC@FٕtB^Bn\ʂȂǂ́AgkOƉňقȂꍇɎg
    //  D3DTEXF_PYRAMIDALQUADFegtB^BjAtB^Ƃ܂ςȂ炵
    //  D3DTEXF_GAUSSIANQUAD FKEVAtB^B܂̖ڂtB^
    //  w肷B

    //2009/3/4 SetSamplerStatëӖ뗝B
    //SetSamplerState̓eNX`ǂTvOiǂݎ邩j邩̐ݒB
    //A`GCAXĂĂAeNX`A`GCAX܂B
    //sNZVF[_[őŜŁÂ̐ݒ́ASȂȂ͂B


    //A`GCAXɂ郌_OXe[g
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS,TRUE);
    //GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_MULTISAMPLEMASK,0x7fffffff);

    //FSăVF[_[ŏɂȂ̂ŃRg
    //SetTextureStageState͔p~H
    //  1iKڃ|SƃeNX`̍@ݒ
    //    //eNX`[̐FƁA_J[DIFFUSEFZ悤ɐݒ
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
    //    //eNX`[̃ƁA_J[̃Z悤ɐݒ
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_MODULATE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);
    //    GgafDxGod::_pID3DDevice9->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE);


    //GgafDxCameraֈړ
    // VIEWϊiJʒujݒ
    //D3DXMATRIX _matView; // r[ϊs
    //    GGAF_DELETE_NULLABLE(_pVecCamFromPoint);
    //    GGAF_DELETE_NULLABLE(_pVecCamLookatPoint);
    //    GGAF_DELETE_NULLABLE(_pVecCamUp);

    //GgafDxCameraֈړ
    // ˉeϊiRcʁj
    //D3DXMATRIX _matProj; // ˉeϊs
    //GgafDxGod::_pID3DDevice9->SetTransform(D3DTS_PROJECTION, &_matProj);
    HRESULT hr;
    //obNobt@EBhEBGFŃNA
    //łRenderTarget͂܂Aʏ̃obNobt@ł
    hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
    returnWhenFailed(hr, D3D_OK, "wiF(_color_border)̓hԂAʃNAɎs܂B");
    return D3D_OK;
}


HRESULT GgafDxGod::restoreFullScreenRenderTarget() {
    if (!PROPERTY::FULL_SCREEN) {
        _TRACE_("GgafDxGod::restoreFullScreenRenderTarget() xtXN[ӊOAĂяosvłB");
        return D3D_OK;
    }
    HRESULT hr;
    //`ƂȂeNX`ʓr쐬iobNobt@IȎgpsj
    hr = GgafDxGod::_pID3DDevice9->CreateTexture(
                                        PROPERTY::RENDER_TARGET_BUFFER_WIDTH,
                                        PROPERTY::RENDER_TARGET_BUFFER_HEIGHT,
                                        1, //MipLevel Mip
                                        D3DUSAGE_RENDERTARGET,
                                        _paPresetPrm[0].BackBufferFormat,
                                        D3DPOOL_DEFAULT,
                                        &_pRenderTexture,
                                        nullptr);

//    LPDIRECT3DTEXTURE9 pIDirect3DTexture9;
//    HRESULT hr = D3DXCreateTextureFromFileEx(
//                     GgafDxGod::_pID3DDevice9,  // [in] LPDIRECT3DDEVICE9 pDevice,
//                     texture_file_name.c_str(), // [in] LPCTSTR pSrcFile,
//                     D3DX_DEFAULT,              // [in] UINT Widths,
//                     D3DX_DEFAULT,              // [in] UINT Height,
//                     D3DX_DEFAULT,              // [in] UINT MipLevels,  //D3DX_DEFAULT,
//                     0,                         // [in] DWORD Usage,
//                     D3DFMT_UNKNOWN,            // [in] D3DFORMAT Format,
//                     D3DPOOL_DEFAULT,           // [in] D3DPOOL Pool, //D3DPOOL_DEFAULT
//                     D3DX_FILTER_POINT,         // [in] DWORD Filter, D3DX_FILTER_POINTŃ{PiC. D3DX_FILTER_LINEAR
//                     D3DX_DEFAULT,              // [in] DWORD MipFilter,
//                     0,                         // [in] D3DCOLOR ColorKey,
//                     _pD3DXIMAGE_INFO,          // [out] D3DXIMAGE_INFO *pSrcInfo,
//                     nullptr,                      // [in] PALETTEENTRY *pPalette,
//                     &pIDirect3DTexture9        // [out] LPDIRECT3DTEXTURE9* ppTexture
//                );

    //TODO:A`GCAX̎̂
    //     eNX`[̑ɃT[tFCXB
    //    HRESULT CreateRenderTarget(
    //        UINT Width,
    //        UINT Height,
    //        D3DFORMAT Format,
    //        D3DMULTISAMPLE_TYPE MultiSample,
    //        DWORD MultisampleQuality,
    //        BOOL Lockable,
    //        IDirect3DSurface9** ppSurface,
    //        HANDLE* pHandle
    //    );


    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX`("<<PROPERTY::RENDER_TARGET_BUFFER_WIDTH<<"x"<<PROPERTY::RENDER_TARGET_BUFFER_HEIGHT<<")̍쐬ɎsB\nTCYmFĉB");
    //RenderTarget(`)eNX`֐؂ւ
    hr = _pRenderTexture->GetSurfaceLevel(0, &_pRenderTextureSurface);
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX`̃T[tFCX擾Ɏs܂B");
    hr = GgafDxGod::_pID3DDevice9->SetRenderTarget(0, _pRenderTextureSurface);
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX` SetRenderTarget o܂łB");


    //eNX`ɕ`悷ۂ̐[xobt@pT[tFCXʓr쐬
    hr = GgafDxGod::_pID3DDevice9->CreateDepthStencilSurface(
            PROPERTY::RENDER_TARGET_BUFFER_WIDTH,
            PROPERTY::RENDER_TARGET_BUFFER_HEIGHT,
            _paPresetPrm[0].AutoDepthStencilFormat, //D3DFORMAT           Format,
            _paPresetPrm[0].MultiSampleType,        //D3DMULTISAMPLE_TYPE MultiSample,
            _paPresetPrm[0].MultiSampleQuality,     //DWORD               MultisampleQuality,
            TRUE,                                   //BOOL                Discard, SetDepthStencileSurface֐Ő[xobt@ύXɃobt@j邩ǂ
            &_pRenderTextureZ,                      //IDirect3DSurface9** ppSurface,
            nullptr                                    //HANDLE*             pHandle ݖgp
    );
    //[xobt@쐬́A[xobt@pT[tFCXLɕύX
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX`Zobt@쐬Ɏs܂B");
    hr =  GgafDxGod::_pID3DDevice9->SetDepthStencilSurface(_pRenderTextureZ);
    returnWhenFailed(hr, D3D_OK, "_O^[QbgeNX` SetDepthStencilSurface o܂łB");
    //wiFŃNA
    hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
    hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
    hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
    returnWhenFailed(hr, D3D_OK,  "NAF(_color_border)̓hԂAʃNAɎs܂B");

    //A_v^Ɋ֘AtꂽXbv`F[擾ăobNobt@擾
    hr = GgafDxGod::_pID3DDevice9->GetSwapChain( 0, &_apSwapChain[0] );
    returnWhenFailed(hr, D3D_OK, "Xbv`FC擾Ɏs܂B");
    hr = _apSwapChain[0]->GetBackBuffer( 0, D3DBACKBUFFER_TYPE_MONO, &_apBackBuffer[0] );
    returnWhenFailed(hr, D3D_OK, "Xbv`FCA^[Qbg̃obNobt@擾Ɏs܂B");
    if (PROPERTY::DUAL_VIEW) {
        hr = GgafDxGod::_pID3DDevice9->GetSwapChain( 1, &_apSwapChain[1] );
        returnWhenFailed(hr, D3D_OK, "Qʖڂ̃Xbv`FC擾Ɏs܂B\n}`fBXvCɖ蔭܂B");
        hr = _apSwapChain[1]->GetBackBuffer( 0, D3DBACKBUFFER_TYPE_MONO, &_apBackBuffer[1] );
        returnWhenFailed(hr, D3D_OK, "Qʖڂ̃Xbv`FCA^[Qbg̃obNobt@擾Ɏs܂B");
    }

    //tXN[AobNobt@ƃtgobt@wiFœh
    if (PROPERTY::DUAL_VIEW) {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[0],
                _apBackBuffer[0]      , &_aRect_ViewScreen[0],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 1ʖځAwiFhɎs܂B(1)\n"<<
                                     "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[0]="<<_apBackBuffer[0]);

        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[1],
                _apBackBuffer[1]      , &_aRect_ViewScreen[1],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 2ʖځAwiFhɎs܂B(1)\n"<<
                                      "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[0]="<<_apBackBuffer[0]);
    } else {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_rectRenderTargetBuffer,
                _apBackBuffer[0]      , &_aRect_ViewScreen[0],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN wiFhɎs܂B(1)");
    }

    hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
    returnWhenFailed(hr, D3D_OK, "Present(nullptr, nullptr, nullptr, nullptr)Ɏs܂B");
    //tbvĂxwiFœh
    if (PROPERTY::DUAL_VIEW) {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[0],
                _apBackBuffer[0]      , &_aRect_ViewScreen[0],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 1ʖځAwiFhɎs܂B(2)\n"<<
                                     "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[0]="<<_apBackBuffer[0]);

        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[1],
                _apBackBuffer[1]      , &_aRect_ViewScreen[1],
                D3DTEXF_NONE);
        checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 2ʖځAwiFhɎs܂B(2)\n"<<
                                      "_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[0]="<<_apBackBuffer[0]);
    } else {
        hr = GgafDxGod::_pID3DDevice9->StretchRect(
                _pRenderTextureSurface, &_rectRenderTargetBuffer,
                _apBackBuffer[0]      , &_aRect_ViewScreen[0],
                D3DTEXF_NONE
                );
        checkDxException(hr, D3D_OK, "FULL_SCREEN wiFhɎs܂B(2)");
    }
    //ʂȊAVISTAXP̂QʖڃtXN[[h
    //  Ή̂͂̂悤ȃR[hȂƂ_B


    if (PROPERTY::DUAL_VIEW) {
        //Qʖڂ̃EBhEʒu␳
        EnumDisplayMonitors(nullptr, nullptr, GgafDxGod::getSecondaryMoniterPixcoordCallback, (LPARAM)this);
        _TRACE_("Qʖڂ̍W("<<_secondary_screen_x<<","<<_secondary_screen_y<<")");
        ShowWindow(_pHWndSecondary, SW_SHOWNORMAL);
        UpdateWindow(_pHWndSecondary);
        SetWindowPos(_pHWndSecondary,
                     HWND_TOPMOST,
                     _secondary_screen_x, _secondary_screen_y, 0, 0,
                     SWP_SHOWWINDOW | SWP_NOSIZE );
        //sȂĂȂƁANAQʖڂ̗̈NbNہA
        //ĂуtXN[Ă܂B
        //Pʖڂ̓tXN[ɂȂĂAWindow̍オ(0,0)̂߃YȂ̂ŁA
        //SetWindowPos͂ԂsvBÔ߂ɓl̏sB
        ShowWindow(_pHWndPrimary, SW_SHOWNORMAL);
        UpdateWindow(_pHWndPrimary);
        SetWindowPos(_pHWndPrimary,
                     HWND_TOPMOST,
                     0, 0, 0, 0,
                     SWP_SHOWWINDOW | SWP_NOSIZE);
    } else {
        ShowWindow(_pHWndPrimary, SW_SHOWNORMAL);
        UpdateWindow(_pHWndPrimary);
        SetWindowPos(_pHWndPrimary,
                     HWND_TOPMOST,
                     0, 0, 0, 0,
                     SWP_SHOWWINDOW | SWP_NOSIZE);
    }

    return D3D_OK;
}



HRESULT GgafDxGod::releaseFullScreenRenderTarget() {
    GGAF_RELEASE_BY_FROCE(_pRenderTextureSurface);
    GGAF_RELEASE_BY_FROCE(_pRenderTexture);
    GGAF_RELEASE_BY_FROCE(_pRenderTextureZ);
    GGAF_RELEASE_BY_FROCE(_apBackBuffer[0]);
    GGAF_RELEASE_BY_FROCE(_apSwapChain[0]);
    if (PROPERTY::DUAL_VIEW) {
        GGAF_RELEASE_BY_FROCE(_apBackBuffer[1]);
        GGAF_RELEASE_BY_FROCE(_apSwapChain[1]);
    }
    return D3D_OK;
}

void GgafDxGod::presentUniversalMoment() {
    if (_is_device_lost_flg) {
        return;
    } else {
        GgafGod::presentUniversalMoment();
    }
}

void GgafDxGod::executeUniversalJudge() {
    if (_is_device_lost_flg) {
        return;
    } else {
        GgafGod::executeUniversalJudge();
    }
}
void GgafDxGod::makeUniversalMaterialize() {
    if (_is_device_lost_flg) {
        return;
    }
    HRESULT hr;
    //ʏ펞
    //obt@NA
    hr = GgafDxGod::_pID3DDevice9->Clear(0, // NA`̈̐
                                         nullptr, // `̈
                                         D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, // _O^[QbgƐ[xobt@NA
                                         _color_clear, //NAFinot wiFj
                                         1.0f,         // Zobt@̃NAl
                                         0             // XeVobt@̃NAl
                                        );
    checkDxException(hr, D3D_OK, "GgafDxGod::_pID3DDevice9->Clear() Ɏs܂B");

    //`掖O
    hr = GgafDxGod::_pID3DDevice9->BeginScene();
    checkDxException(hr, D3D_OK, "GgafDxGod::_pID3DDevice9->BeginScene() Ɏs܂B");
    //SċIi`j
#ifdef MY_DEBUG
    GgafDxGod::_pID3DDevice9->SetRenderState(D3DRS_FILLMODE, GgafDxGod::_d3dfillmode);
#endif
    GgafGod::makeUniversalMaterialize(); //X[p[materializes
    //`掖㏈
    hr = GgafDxGod::_pID3DDevice9->EndScene();
    checkDxException(hr, D3D_OK, "GgafDxGod::_pID3DDevice9->EndScene() Ɏs܂B");

}

void GgafDxGod::presentUniversalVisualize() {
    //A
    //if (GgafDxGod::_pID3DDevice9->Present(nullptr,&_aRect_Present[0],nullptr,nullptr) == D3DERR_DEVICELOST) {
    //        static D3DRASTER_STATUS rs;
    //        while (SUCCEEDED(GgafDxGod::_pID3DDevice9->GetRasterStatus(0, &rs)) ) {
    //            if(rs.InVBlank) {
    //                break; //AԂł͂Ȃ
    //            } else {
    //                Sleep(1);
    //            }
    //        }
    HRESULT hr;
    if (_is_device_lost_flg == false) {
        if (_adjustGameScreen && _pHWnd_adjustScreen) {
            adjustGameScreen(_pHWndPrimary);
            adjustGameScreen(_pHWndSecondary);
        }

        //Present
        if (PROPERTY::FULL_SCREEN) {
            if (PROPERTY::DUAL_VIEW) {
                //QʎgpEtXN[
                //ʂOobNobt@ʂPobNobt@փRs[
                hr = GgafDxGod::_pID3DDevice9->StretchRect(
                        _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[0],
                        _apBackBuffer[0]      , &_aRect_Present[0],
                        D3DTEXF_LINEAR); //TODO:D3DTEXF_LINEARIvVwɂ邩H
                checkDxException(hr, D3D_OK, "FULL_SCREEN DUAL_VIEW 1ʖ StretchRect() Ɏs܂B\n_pRenderTextureSurface="<<_pRenderTextureSurface<<"/_apBackBuffer[0]="<<_apBackBuffer[0]);

                hr = GgafDxGod::_pID3DDevice9->StretchRect(
                        _pRenderTextureSurface, &_aRect_HarfRenderTargetBuffer[1],
                        _apBackBuffer[1]      , &_aRect_Present[1],
                        D3DTEXF_LINEAR);
                checkDxException(hr, D3D_OK, "StretchRect() Ɏs܂B");

                hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
            } else {
                //PʎgpEtXN[
                hr = GgafDxGod::_pID3DDevice9->StretchRect(
                        _pRenderTextureSurface,
                        &_rectRenderTargetBuffer,
                        _apBackBuffer[0],
                        &_aRect_Present[0],
                        D3DTEXF_LINEAR);
                checkDxException(hr, D3D_OK, "FULL 1gamen StretchRect() Ɏs܂B");

                hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
            }
        } else {
            if (PROPERTY::DUAL_VIEW) {
                //QʎgpEEBhE[h
                if (PROPERTY::VIEW_AS_RENDER_TARGET_BUFFER_SIZE) {
                    hr = GgafDxGod::_pID3DDevice9->Present(&_aRect_HarfRenderTargetBuffer[0], &_aRect_Present[0], nullptr, nullptr);
                    if (hr == D3D_OK) {
                        hr = GgafDxGod::_pID3DDevice9->Present(&_aRect_HarfRenderTargetBuffer[1], &_aRect_Present[1], _pHWndSecondary, nullptr);
                    }
                } else {
                    if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                        //cŒ胂[h
                        hr = GgafDxGod::_pID3DDevice9->Present(&_aRect_HarfRenderTargetBuffer[0], &_aRect_Present[0], nullptr, nullptr);
                        if (hr == D3D_OK) {
                            hr = GgafDxGod::_pID3DDevice9->Present(&_aRect_HarfRenderTargetBuffer[1], &_aRect_Present[1], _pHWndSecondary, nullptr);
                        }
                    } else {
                        //cXgb`[h
                        hr = GgafDxGod::_pID3DDevice9->Present(&_aRect_HarfRenderTargetBuffer[0], nullptr, nullptr, nullptr);
                        if (hr == D3D_OK) {
                            hr = GgafDxGod::_pID3DDevice9->Present(&_aRect_HarfRenderTargetBuffer[1], nullptr, _pHWndSecondary, nullptr);
                        }
                    }
                }
            } else {
                if (PROPERTY::VIEW_AS_RENDER_TARGET_BUFFER_SIZE) {
                    hr = GgafDxGod::_pID3DDevice9->Present(&_rectRenderTargetBuffer, &_aRect_Present[0], nullptr, nullptr);
                } else {
                    //PʎgpEEBhE[h
                    if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                        //cŒ胂[h
                        hr = GgafDxGod::_pID3DDevice9->Present(nullptr, &_aRect_Present[0], nullptr, nullptr);
                    } else {
                        //cXgb`[h
                        hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
                    }
                }
            }
        }

        if (hr != D3D_OK) { //hr  Present ̖߂l
             //onّfIlH
//            _TRACE_("xfoCXُ픭!!" <<DXGetErrorString(hr) << " "<< DXGetErrorDescription(hr));
            _TRACE_("xfoCXُ픭!! HRESULT="<<hr);
            if (hr == D3DERR_DEVICELOST) {
                _TRACE_("ʏ̐foCXXgI");
            }

            Sleep(100); // 1b҂
            _TRACE_("yfoCXXgzBEGIN ------>");

            //Hx~
            _TRACE_("yfoCXXgzH~ BEGIN ------>");
            GgafFactory::beginRest();
         ___EndSynchronized1; // <----- rI
            for (int i = 0; GgafFactory::isResting() == false; i++) {
                Sleep(10); //Hꂪ܂ő҂
                if (i > 10*60*100) {
                    _TRACE_("yfoCXXg/H~z 10ҋ@܂AHꂩ甽܂Bbreak܂Bv");
                    break;
                }
            }
         ___BeginSynchronized1; // ----->rJn
            _TRACE_("yfoCXXgzH~ <-------- END");

            _TRACE_("yfoCXXgz\[X BEGIN ------>");

            //_O^[QbgAfoCXXg
            if (PROPERTY::FULL_SCREEN) {
                releaseFullScreenRenderTarget();
            }
            //}bveNX`AfoCXXg
            GgafDxGod::_pCubeMapTextureManager->releaseAll();
            GgafDxGod::_pBumpMapTextureManager->releaseAll();
            //GtFNgAfoCXXg
            GgafDxGod::_pEffectManager->onDeviceLostAll();
            //f
            GgafDxGod::_pModelManager->onDeviceLostAll();
            //Sm[hɉȂCxg
            getUniverse()->throwEventLowerTree(GGAF_EVENT_ON_DEVICE_LOST);
            _TRACE_("yfoCXXgz\[X <-------- END");
            _is_device_lost_flg = true;
        }
    }

    if (_is_device_lost_flg) {
        _TRACE_("yfoCXXg/\[Xzx`FbN BEGIN ------>");
        //for(int i = 0; i < 300; i++) {
        while(true) {
            if (_can_wddm) {
                hr = ((IDirect3DDevice9Ex*)GgafDxGod::_pID3DDevice9)->CheckDeviceState(_pHWndPrimary);
                if (hr == D3DERR_DEVICELOST || hr == S_PRESENT_OCCLUDED) {
                    return;
                } else {
                    break;
                }
            } else {
                hr = GgafDxGod::_pID3DDevice9->TestCooperativeLevel();
                if (hr == D3DERR_DEVICELOST) {
                    return;
                } else {
                    break;
                }
            }
        }
        _TRACE_("yfoCXXg/\[Xzx`FbN <-------- END");

        //foCXZbg݂
        _TRACE_("yfoCXXgzfoCXZbg BEGIN ------>");
        for(int i = 0; i < 100*60*10; i++) {
            if (PROPERTY::FULL_SCREEN && PROPERTY::DUAL_VIEW) {
                hr = GgafDxGod::_pID3DDevice9->Reset(_paPresetPrm);
            } else {
                hr = GgafDxGod::_pID3DDevice9->Reset(&(_paPresetPrm[0]));
            }
            if (hr != D3D_OK) {
                if (hr == D3DERR_DRIVERINTERNALERROR) {
                    Sleep(10);
                    return;
                } else if (hr == D3DERR_DRIVERINTERNALERROR) {
                    throwGgafDxCriticalException(hr, "yfoCXXg/foCXZbgzD3DERR_DRIVERINTERNALERRORBI܂B");
                } else if (hr == D3DERR_OUTOFVIDEOMEMORY) {
                    throwGgafDxCriticalException(hr, "yfoCXXg/foCXZbgzD3DERR_OUTOFVIDEOMEMORYB܂BI܂B");
                } else {
                    Sleep(10);
                    return;
                }
            } else {
                break;
            }
        }
        _TRACE_("yfoCXXgzfoCXZbg <-------- END");


        //foCXĐݒ
        _TRACE_("yfoCXXgzfoCXč\z BEGIN ------>");
        initDx9Device();
        _TRACE_("yfoCXXgzfoCXč\z <-------- END");

        if (PROPERTY::FULL_SCREEN) {
            _TRACE_("yfoCXXgztXN[_O^[QbgeNX`č\z BEGIN ------>");
            restoreFullScreenRenderTarget();
            _TRACE_("yfoCXXgztXN[_O^[QbgeNX`č\z <-------- END");
        }

        //\[Xč\z
        _TRACE_("yfoCXXgz\[Xč\z BEGIN ------>");
        //}bveNX`AA
        GgafDxGod::_pCubeMapTextureManager->restoreAll();
        GgafDxGod::_pBumpMapTextureManager->restoreAll();
        //GtFNgZbg
        GgafDxGod::_pEffectManager->restoreAll();
        //fĐݒ
        GgafDxGod::_pModelManager->restoreAll();
        //Sm[hɍĐݒ肵ȂCxg
        getUniverse()->throwEventLowerTree(GGAF_EVENT_ON_DEVICE_LOST, this);
        //O`惂f𖳌ɂ
        GgafDxModelManager::_pModelLastDraw = nullptr;
        _is_device_lost_flg = false;
        _TRACE_("yfoCXXgz\[Xč\z <-------- END");

        //HĊJ
        _TRACE_("yfoCXXgzHċN BEGIN ------>");
        GgafFactory::finishRest();
        _TRACE_("yfoCXXgzHċN <-------- END");

        _TRACE_("yfoCXXgz<-------- END");

        Sleep(500);
        hr = GgafDxGod::_pID3DDevice9->Clear(0,    // NA`̈̐
                                             nullptr, // `̈
                                             D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, // _O^[QbgƐ[xobt@NA
                                             _color_border, //wiF      //D3DCOLOR_XRGB( 0, 0, 0 )
                                             1.0f, // Zobt@̃NAl
                                             0     // XeVobt@̃NAl
                                            );
    }
}

void GgafDxGod::finalizeUniverse() {
    if (_is_device_lost_flg) {
        return;
    } else {
        GgafGod::finalizeUniverse();
    }
}

void GgafDxGod::clean() {
    if (!_was_cleaned) {
        _TRACE_("GgafDxGod::clean() begin");
        for(int i = 0; i < 8; ++i) { GgafDxGod::_pID3DDevice9->SetTexture( i, nullptr ); }
        for(int i = 0; i < 8; ++i) { GgafDxGod::_pID3DDevice9->SetStreamSource( i, nullptr, 0, 0 ); }
        GgafDxGod::_pID3DDevice9->SetIndices( nullptr );
        GgafDxGod::_pID3DDevice9->SetPixelShader( nullptr );
        GgafDxGod::_pID3DDevice9->SetVertexShader( nullptr );
        GgafDxGod::_pID3DDevice9->SetVertexDeclaration( nullptr );

        GgafGod::clean();

        CmRandomNumberGenerator::getInstance()->release();
        //ێf
        GGAF_DELETE(_pCubeMapTextureManager);
        GGAF_DELETE(_pBumpMapTextureManager);
        GGAF_DELETE(_pModelManager);
        GGAF_DELETE(_pEffectManager);
        _TRACE_("GgafDxGod::clean() end");
    }
}

void GgafDxGod::adjustGameScreen(HWND prm_pHWnd) {
    RECT rect;
    if (prm_pHWnd && !PROPERTY::FULL_SCREEN ) {
        //EBhE[h
        HRESULT hr;
        hr = GgafDxGod::_pID3DDevice9->Clear(0, nullptr, D3DCLEAR_TARGET, _color_border, 1.0f, 0);
        hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, nullptr, nullptr);
        if (PROPERTY::DUAL_VIEW) {
            hr = GgafDxGod::_pID3DDevice9->Present(nullptr, nullptr, _pHWndSecondary, nullptr);
        }
        if (::GetClientRect(prm_pHWnd, &rect)) {
            LONG c_width= rect.right;
            LONG c_height = rect.bottom;

            LONG fix_width, fix_height;
            int pos1, pos2;
            if (PROPERTY::DUAL_VIEW) {
                pos1 = PROPERTY::DUAL_VIEW_DRAW_POSITION1;
                pos2 = PROPERTY::DUAL_VIEW_DRAW_POSITION2;
            } else {
                pos1 = PROPERTY::SINGLE_VIEW_DRAW_POSITION;
                pos2 = PROPERTY::DUAL_VIEW_DRAW_POSITION2; //Ƃ肠
            }

            if (PROPERTY::VIEW_AS_RENDER_TARGET_BUFFER_SIZE) {
                //EBhE[hERENDER_TARGET_BUFFERTCY\
                if (PROPERTY::DUAL_VIEW) {
                    if (prm_pHWnd == _pHWndPrimary) {
                        fix_width  = PROPERTY::RENDER_TARGET_BUFFER_WIDTH  * (1.0*c_width / PROPERTY::DUAL_VIEW_WINDOW1_WIDTH) * PROPERTY::VIEW1_WIDTH_RATIO / 2.0;
                        fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT * (1.0*c_height / PROPERTY::DUAL_VIEW_WINDOW1_HEIGHT) * PROPERTY::VIEW1_HEIGHT_RATIO;
                        _aRect_Present[0].left   = (c_width / 2.0) - (fix_width / 2.0);
                        _aRect_Present[0].top    = (c_height / 2.0) - (fix_height / 2.0);
                        _aRect_Present[0].right  = _aRect_Present[0].left + fix_width ;
                        _aRect_Present[0].bottom = _aRect_Present[0].top  + fix_height;
                        if (_aRect_Present[0].left < 0) {
                            _aRect_Present[0].left = 0;
                        }
                        if (_aRect_Present[0].right > c_width) {
                            _aRect_Present[0].right = c_width;
                        }
                        if (_aRect_Present[0].top < 0) {
                            _aRect_Present[0].top = 0;
                        }
                        if (_aRect_Present[0].bottom > c_height) {
                            _aRect_Present[0].bottom = c_height;
                        }
                        positionPresentRect(pos1, _aRect_Present[0], c_width, c_height);

                    } else {
                        fix_width  = PROPERTY::RENDER_TARGET_BUFFER_WIDTH  * (1.0*c_width / PROPERTY::DUAL_VIEW_WINDOW2_WIDTH) * PROPERTY::VIEW2_WIDTH_RATIO / 2.0;
                        fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT * (1.0*c_height / PROPERTY::DUAL_VIEW_WINDOW2_HEIGHT) * PROPERTY::VIEW2_HEIGHT_RATIO;
                        _aRect_Present[1].left   = (c_width / 2.0) - (fix_width / 2.0);
                        _aRect_Present[1].top    = (c_height / 2.0) - (fix_height / 2.0);
                        _aRect_Present[1].right  = _aRect_Present[1].left + fix_width;
                        _aRect_Present[1].bottom = _aRect_Present[1].top  + fix_height;
                        if (_aRect_Present[1].left < 0) {
                            _aRect_Present[1].left = 0;
                        }
                        if (_aRect_Present[1].right > c_width) {
                            _aRect_Present[1].right = c_width;
                        }
                        if (_aRect_Present[1].top < 0) {
                            _aRect_Present[1].top = 0;
                        }
                        if (_aRect_Present[1].bottom > c_height) {
                            _aRect_Present[1].bottom = c_height;
                        }
                        positionPresentRect(pos2, _aRect_Present[1], c_width, c_height);

                    }
                } else {
                    //1ʎ
                    fix_width  = PROPERTY::RENDER_TARGET_BUFFER_WIDTH  * (1.0*c_width / PROPERTY::SINGLE_VIEW_WINDOW_WIDTH) * PROPERTY::VIEW1_WIDTH_RATIO;
                    fix_height = PROPERTY::RENDER_TARGET_BUFFER_HEIGHT * (1.0*c_height / PROPERTY::SINGLE_VIEW_WINDOW_HEIGHT) * PROPERTY::VIEW1_HEIGHT_RATIO;
                    _aRect_Present[0].left   = (c_width / 2.0) - (fix_width / 2.0);
                    _aRect_Present[0].top    = (c_height / 2.0) - (fix_height / 2.0);
                    _aRect_Present[0].right  = _aRect_Present[0].left + fix_width ;
                    _aRect_Present[0].bottom = _aRect_Present[0].top  + fix_height;
                    if (_aRect_Present[0].left < 0) {
                        _aRect_Present[0].left = 0;
                    }
                    if (_aRect_Present[0].right > c_width) {
                        _aRect_Present[0].right = c_width;
                    }
                    if (_aRect_Present[0].top < 0) {
                        _aRect_Present[0].top = 0;
                    }
                    if (_aRect_Present[0].bottom > c_height) {
                        _aRect_Present[0].bottom = c_height;
                    }
                    positionPresentRect(pos1, _aRect_Present[0], c_width, c_height);
                }

            } else {
                //EBhE[hERENDER_TARGET_BUFFERTCY
                if (PROPERTY::FIXED_GAME_VIEW_ASPECT) {
                    //EBhE[hEAXyNgŒ
                    if (PROPERTY::DUAL_VIEW) {
                        if (prm_pHWnd == _pHWndPrimary) {
                            fix_width  = PROPERTY::GAME_BUFFER_WIDTH * PROPERTY::VIEW1_WIDTH_RATIO / 2.0;
                            fix_height = PROPERTY::GAME_BUFFER_HEIGHT * PROPERTY::VIEW1_HEIGHT_RATIO;
                        } else {
                            fix_width  = PROPERTY::GAME_BUFFER_WIDTH * PROPERTY::VIEW2_WIDTH_RATIO / 2.0;
                            fix_height = PROPERTY::GAME_BUFFER_HEIGHT * PROPERTY::VIEW2_HEIGHT_RATIO;
                        }
                    } else {
                        fix_width  = PROPERTY::GAME_BUFFER_WIDTH*PROPERTY::VIEW1_WIDTH_RATIO;
                        fix_height = PROPERTY::GAME_BUFFER_HEIGHT*PROPERTY::VIEW1_HEIGHT_RATIO;
                    }

                    if (1.0f * c_width / c_height > 1.0f * fix_width / fix_height) {
                        //艡ɂȂĂ܂Ă
                        double rate = 1.0 * c_height / fix_height; //k=c̔䗦
                        if (prm_pHWnd == _pHWndPrimary) {
                            _aRect_Present[0].left   = (c_width / 2.0) - (fix_width * rate / 2.0);
                            _aRect_Present[0].top    = 0;
                            _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                            _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                            positionPresentRect(pos1, _aRect_Present[0], c_width, c_height);
                        } else {
                            _aRect_Present[1].left   = (c_width / 2.0) - (fix_width * rate / 2.0);
                            _aRect_Present[1].top    = 0;
                            _aRect_Present[1].right  = _aRect_Present[1].left + (fix_width * rate);
                            _aRect_Present[1].bottom = _aRect_Present[1].top  + (fix_height * rate);
                            positionPresentRect(pos2, _aRect_Present[1], c_width, c_height);
                        }

                    } else {
                        //cɂȂĂ܂Ă
                        double rate = 1.0 * c_width / fix_width; //k=̔䗦
                        if (prm_pHWnd == _pHWndPrimary) {
                            _aRect_Present[0].left   = 0;
                            _aRect_Present[0].top    = (c_height / 2.0) - (fix_height * rate / 2.0);
                            _aRect_Present[0].right  = _aRect_Present[0].left + (fix_width * rate);
                            _aRect_Present[0].bottom = _aRect_Present[0].top  + (fix_height * rate);
                            positionPresentRect(pos1, _aRect_Present[0], c_width, c_height);
                        } else {
                            _aRect_Present[1].left   = 0;
                            _aRect_Present[1].top    = (c_height / 2.0) - (fix_height * rate / 2.0);
                            _aRect_Present[1].right  = _aRect_Present[1].left + (fix_width * rate);
                            _aRect_Present[1].bottom = _aRect_Present[1].top  + (fix_height * rate);
                            positionPresentRect(pos2, _aRect_Present[1], c_width, c_height);
                        }
                    }
                } else {
                    //EBhE[hEcXgb`
                    if (::GetClientRect(prm_pHWnd, &rect)) {
                        if (prm_pHWnd == _pHWndPrimary) {
                            _aRect_Present[0] = rect;
                        } else {
                            _aRect_Present[1] = rect;
                        }

                    }
                }
            }
        }
    } else {
        //tXN[

    }



#ifdef MY_DEBUG
    _TRACE_("GgafDxGod::adjustGameScreen(" << (prm_pHWnd == _pHWndPrimary ? "Primary" : "Secondary") <<") R[");
    if (PROPERTY::DUAL_VIEW) {
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].left   = "<<_aRect_HarfRenderTargetBuffer[0].left  );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].top    = "<<_aRect_HarfRenderTargetBuffer[0].top   );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].right  = "<<_aRect_HarfRenderTargetBuffer[0].right );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[0].bottom = "<<_aRect_HarfRenderTargetBuffer[0].bottom);
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].left   = "<<_aRect_HarfRenderTargetBuffer[1].left  );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].top    = "<<_aRect_HarfRenderTargetBuffer[1].top   );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].right  = "<<_aRect_HarfRenderTargetBuffer[1].right );
        _TRACE_(" _aRect_HarfRenderTargetBuffer[1].bottom = "<<_aRect_HarfRenderTargetBuffer[1].bottom);
        _TRACE_(" _aRect_Present[0].left   = "<<_aRect_Present[0].left  );
        _TRACE_(" _aRect_Present[0].top    = "<<_aRect_Present[0].top   );
        _TRACE_(" _aRect_Present[0].right  = "<<_aRect_Present[0].right );
        _TRACE_(" _aRect_Present[0].bottom = "<<_aRect_Present[0].bottom);
        _TRACE_(" _aRect_Present[1].left   = "<<_aRect_Present[1].left  );
        _TRACE_(" _aRect_Present[1].top    = "<<_aRect_Present[1].top   );
        _TRACE_(" _aRect_Present[1].right  = "<<_aRect_Present[1].right );
        _TRACE_(" _aRect_Present[1].bottom = "<<_aRect_Present[1].bottom);
    } else {
        _TRACE_(" _rectRenderTargetBuffer.left   = "<<_rectRenderTargetBuffer.left  );
        _TRACE_(" _rectRenderTargetBuffer.top    = "<<_rectRenderTargetBuffer.top   );
        _TRACE_(" _rectRenderTargetBuffer.right  = "<<_rectRenderTargetBuffer.right );
        _TRACE_(" _rectRenderTargetBuffer.bottom = "<<_rectRenderTargetBuffer.bottom);
        _TRACE_(" _aRect_Present[0].left   = "<<_aRect_Present[0].left  );
        _TRACE_(" _aRect_Present[0].top    = "<<_aRect_Present[0].top   );
        _TRACE_(" _aRect_Present[0].right  = "<<_aRect_Present[0].right );
        _TRACE_(" _aRect_Present[0].bottom = "<<_aRect_Present[0].bottom);
    }
#endif



    GgafDxGod::_pID3DDevice9->GetViewport(&(P_CAM->_viewport));
    _adjustGameScreen = false;
    _pHWnd_adjustScreen = nullptr;
}

void GgafDxGod::positionPresentRect(int prm_pos, RECT& inout_rectPresent, pixcoord prm_screen_width, pixcoord prm_screen_height) {
    // V@W@X
    // @_b^
    // S\T\U
    // @^b_
    // P@Q@R
    //1:A2:A3:EA4:A5:^񒆁A6:EA7:A8:A9:E
    if (prm_pos == 5) {
        return;
    }
    if (prm_pos == 7 || prm_pos == 8 || prm_pos == 9) {
        inout_rectPresent.bottom = inout_rectPresent.bottom - inout_rectPresent.top;
        inout_rectPresent.top = 0;
    } else if (prm_pos == 1 || prm_pos == 2 || prm_pos == 3) {
        inout_rectPresent.top = prm_screen_height - (inout_rectPresent.bottom - inout_rectPresent.top);
        inout_rectPresent.bottom = prm_screen_height;
    }

    if (prm_pos == 7 || prm_pos == 4 || prm_pos == 1) {
        inout_rectPresent.right = inout_rectPresent.right - inout_rectPresent.left;
        inout_rectPresent.left = 0;
    } else if (prm_pos == 9 || prm_pos == 6 || prm_pos == 3) {
        inout_rectPresent.left = prm_screen_width - (inout_rectPresent.right - inout_rectPresent.left);
        inout_rectPresent.right = prm_screen_width;
    }
}

GgafDxGod::~GgafDxGod() {

    clean();
    _was_cleaned = true;
    //DirectSound
    GgafDxSound::release();
    //DirectInput
    GgafDxInput::release();

    if(PROPERTY::FULL_SCREEN) {
        releaseFullScreenRenderTarget();
    }

    _TRACE_("_pID3DDevice9 [");
    Sleep(60);
    GGAF_DELETEARR(_paPresetPrm);
    GGAF_DELETEARR(_paDisplayMode);
    GGAF_RELEASE(_pID3DDevice9);
    GGAF_RELEASE(_pID3D9);

}




// 2011/07/26
//
//yPʃEBhE[hz
//                                 QQQQQQQQQQQQQQQQQQQQQ
//                               ^                                        ^
//    tgobt@         ^                                        ^
//    (EChE)           ^                                        ^
//                           PPPPPPPPPPPPPPPPPPPPP
//                           SINGLE_VIEW_WINDOW_WIDTH x SINGLE_VIEW_WINDOW_HEIGHT
//
//                                               
//                                               b Present
//                                               b(D3DSWAPEFFECT_COPY)
//                                               b
//                                  QQQQQQQQQQQQQQQQQQQQQ
//    obNobt@              ^                                        ^
//                              ^                                        ^ Draw   QQQ
//                            ^                                        ^      ^    ^Q[obt@
//                            PPPPPPPPPPPPPPPPPPPPP          PPP
//                       RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT
//
//
//---------------------------------------------------------------------------------------------
//
//
//yQʃEBhE[hz
//                            QQQQQQQQQQQ             QQQQQQQQQQQ
//                          ^                    ^           ^                    ^
//    tgobt@    ^                    ^           ^                    ^
//    (EChE)      ^                    ^           ^                    ^
//                      PPPPPPPPPPP             PPPPPPPPPPP
//                     DUAL_VIEW_WINDOW1_WIDTH x            DUAL_VIEW_WINDOW2_WIDTH x
//                       DUAL_VIEW_WINDOW1_HEIGHT             DUAL_VIEW_WINDOW2_HEIGHT
//
//                                                                
//                                 b Present                       b Present
//                                 b(D3DSWAPEFFECT_COPY)           b (D3DSWAPEFFECT_COPY)
//
//                                  QQQQQQQQQQQQQQQQQQQQQ
//    obNobt@              ^                                        ^
//                              ^                                        ^ Draw   QQQ
//                            ^                                        ^      ^    ^Q[obt@
//                            PPPPPPPPPPPPPPPPPPPPP          PPP
//                    RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT
//
//
//---------------------------------------------------------------------------------------------
//
//
//yPʃtXN[[hz
//                                         QQQQQQQQQQQQQQQQ
//                                       ^                              ^
//                                     ^                              ^
//    tgobt@               ^                              ^
//    (fBXvC)               ^                              ^
//                               ^                              ^
//                               PPPPPPPPPPPPPPPP
//                                SINGLE_VIEW_FULL_SCREEN_WIDTH x
//                                  SINGLE_VIEW_FULL_SCREEN_HEIGHT
//
//                                                 
//                                                 b Present
//                                                 b(D3DSWAPEFFECT_DISCARD)
//                                        QQQQQQQQQQQQQQQQ
//                                      ^                              ^
//                                    ^                              ^
//    obNobt@                ^      _apBackBuffer[0]        ^
//                                ^                              ^
//                              ^                              ^
//                              PPPPPPPPPPPPPPPP
//                               SINGLE_VIEW_FULL_SCREEN_WIDTH x
//                                 SINGLE_VIEW_FULL_SCREEN_HEIGHT
//
//                                                 
//                                                 b StretchRect
//                                                 b
//                                 QQQQQQQQQQQQQQQQQQQQQ
//    _[^[Qbg         ^                                        ^
//    eNX`[             ^       _pRenderTextureSurface           ^ Draw   QQQ
//                           ^                                        ^      ^    ^Q[obt@
//                           PPPPPPPPPPPPPPPPPPPPP          PPP
//                     RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT
//
//
//---------------------------------------------------------------------------------------------
//
//
//yQʃtXN[[hz
//                            QQQQQQQQQQQ     |        QQQQQQQQQQQ
//                          ^                    ^     |      ^                    ^
//    tgobt@    ^                    ^       |    ^                    ^
//    (fBXvC)    ^                    ^         |  ^                    ^
//                      PPPPPPPPPPP           |  PPPPPPPPPPP
//                     DUAL_VIEW_FULL_SCREEN1_WIDTH x    |   DUAL_VIEW_FULL_SCREEN2_WIDTH x
//                       DUAL_VIEW_FULL_SCREEN1_HEIGHT   |     DUAL_VIEW_FULL_SCREEN2_HEIGHT
//
//                                                                
//                               b Present                         b Present
//                               b(D3DSWAPEFFECT_DISCARD)          b (D3DSWAPEFFECT_DISCARD)
//
//                            QQQQQQQQQQQ             QQQQQQQQQQQ
//                          ^                    ^           ^                    ^
//    obNobt@      ^  _apBackBuffer[0]  ^           ^  _apBackBuffer[1]  ^
//                      ^                    ^           ^                    ^
//                      PPPPPPPPPPP             PPPPPPPPPPP
//                     DUAL_VIEW_FULL_SCREEN1_WIDTH x        DUAL_VIEW_FULL_SCREEN2_WIDTH x
//                       DUAL_VIEW_FULL_SCREEN1_HEIGHT         DUAL_VIEW_FULL_SCREEN2_HEIGHT
//
//                                                                
//                                    b StretchRect                b StretchRect
//                                    b                            b
//                                  QQQQQQQQQQQQQQQQQQQQQ
//    _[^[Qbg          ^                                        ^
//    eNX`[              ^       _pRenderTextureSurface           ^ Draw   QQQ
//                            ^                                        ^      ^    ^Q[obt@
//                            PPPPPPPPPPPPPPPPPPPPP          PPP
//                       RENDER_TARGET_BUFFER_WIDTH x RENDER_TARGET_BUFFER_HEIGHT




//ĂP
//                 <-------------------------------------------- 2048 --------------------------------------------->
//                 <--------- 512 --------->
//                 <------------------------- 1600 ------------------------------------------><------ 448 --------->
//
//         ^       +-----------------------+-----------------------+-----------------------+-+---------------------+
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//        512      |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         |       |                       |                       |                       | |                     |
//         v       +-----------------------+-----------------------+-----------------------+-+---------------------+
//                                                                                         >-<-- 64


//ĂQ
//                 <-------------------------------------------- 2048 --------------------------------------------->
//                 <--------- 512 --------->
//                 <------------------------- 1280 ----------------------------><-------------- 768 --------------->
//
//         ^   ^   +-----------------------+-----------------------+-----------+-----------+-----------------------+
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//        512 480  |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   |   |                       |                       |           |           |                       |
//         |   v   +-----------------------+-----------------------+-----------+           |                       |
//         v  32   +-----------------------+-----------------------+-----------------------+-----------------------+
//
//                                                                 <----256----><---256---->


