#ifndef GGAFDXCORE_GGAFDXMODEL_H_
#define GGAFDXCORE_GGAFDXMODEL_H_
#include "jp/ggaf/core/GgafObject.h"

#include <d3d9.h>

namespace GgafDxCore {

/**
 * fNX.
 * L(AN^[)̌`FȂǂێNXłB<BR>
 * @version 1.00
 * @since 2008/02/21
 * @author Masatoshi Tsuge
 */
class GgafDxModel : public GgafCore::GgafObject {
    friend class GgafDxModelManager;

public:
    class VERTEX_3D_BASE {
    public:
        float x, y, z;    // _W
        float nx, ny, nz; // @
    };


    /** [r]ID */
    int _id;
    /** [r]ő\`ZbgiLN^j*/
    int _set_num;
    /** [r]f`̎ʖB(50܂) */
    char* _model_name;
    /** [r]fCX^X */
    uint32_t _obj_model;
    /** [r]}eAz */
    D3DMATERIAL9* _paMaterial_default;
    /** [r]}eA */
    DWORD _num_materials;

    /** [rw]f̋EaBʊOɗp */
    FLOAT _bounding_sphere_radius;
    /** [r]_ŋx (0.0 <= _fblink <= 1.0)BGgafDxTextureBlinkerɂ葀삷邱 */
    FLOAT _power_blink;
    /** [r]_őΏRGBl(0.0 <= tex2D()rgb̉ꂩ <= 1.0)BGgafDxTextureBlinkerɂ葀삷邱 */
    FLOAT _blink_threshold;
    //_blink_threshold = 1.0 Ǝw肵ꍇAPStex2D()̃TvOJ[
    //r,g,b ꂩ >= 1.0  ̏ꍇA_power_blink{̐F(rgb)Z
    //[rEX̃L̐Ԃ_ł̂悤ȂƂߍ쐬B

    /** [r]eNX`RlNVz */
    GgafDxTextureConnection** _papTextureConnection;
    /** [r]_őxIuWFNg */
    GgafDxTextureBlinker* const _pTexBlinker;
    /** [r]GgafDxTextureBlinkerpJE^[ */
    frame _blinker_frames;

    /** [r/w]f̃XyL[͈̔́in[txNgE@ςg_specularj */
    float _specular;
    /** [r/w]f̃XyL[̋xiŜ̔{A0.0ȊOݒ肷ƃXyLLɂȂj */
    float _specular_power;

    /** [r]fPʂ̏sς݂ǂ(draw`FbNύX) */
    bool _is_init_model;

    UINT _numPass;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name f`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    GgafDxModel(char* prm_model_name);

    char* getName(){
        return _model_name;
    }

    /**
     * f̃XyL[xݒ .
     * ̈ 0 ȊO̐lݒ肷ƁAXyL[LɂȂ܂B
     * ̂悤ɐݒ肷ƃXyL[𖳌ɏo܂BiftHg̓XyL[𖳌j
     * setSpecular(0, 0)
     * @param prm_specular f̃XyL[͈̔́in[txNgE@ςg_specularj
     * @param prm_specular_power f̃XyL[̋xiŜ̔{A0.0ȊOݒ肷ƃXyLLɂȂj
     */
    virtual void setSpecular(float prm_specular, float prm_specular_power) {
        _specular = prm_specular;
        _specular_power = prm_specular_power;
    }

    /**
     * f` .
     * ʃNXŃf`惍WbNĉB
     * @param prm_pActor_Target `悷郂f̃AN^[
     * @param prm_draw_set_num `悷郂f̃Zbg
     * @return
     */
    virtual HRESULT draw(GgafDxDrawableActor* prm_pActor_Target, int prm_draw_set_num = 1) = 0;


    /**
     * }eÃeNX`Iɏ㏑ݒ .
     * Y}eAԍ̊̃eNX` close() B
     * @param prm_material_no }eAԍ
     * @param prm_texture eNX`
     */
//    virtual void setMaterialTexture(int prm_material_no, const char* prm_texture);

//    virtual GgafDxTextureConnection* setMaterialTextureCon(int prm_material_no, GgafDxTextureConnection* prm_pTexCon);

    virtual void swapTopTextureOrder(const char* prm_texture0);

    /**
     * fč\z܂.
     */
    virtual void restore() = 0;

    /**
     * f܂.
     */
    virtual void release() = 0;

    /**
     * foCXXgR[obN
     */
    virtual void onDeviceLost() = 0;

    /**
     * fXgN^<BR>
     * deletêGgafDxModelManagerł<BR>
     */
    virtual ~GgafDxModel(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXMODEL_H_*/
