#ifndef GGAFDXCORE_GGAFDXMORPHER_H_
#define GGAFDXCORE_GGAFDXMORPHER_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * [tBOxNX .
 * GgafDxMorphMeshActor ̃o<BR>
 * d _weight[] <BR>
 * ȒPɑ삷邽߂ɐ݌vB<BR>
 *  _weight[] ́A[0]͖gpA[1]`[n][t^[Qbg1`n̏d <BR>
 * TODO:GgafDxScaler,GgafDxMorpher,GgafDxTextureBlinker ʉB
 * @version 1.00
 * @since 2009/05/11
 * @author Masatoshi Tsuge
 */
class GgafDxMorpher : public GgafCore::GgafObject {

public:
    /** [r]ΏۃAN^[ */
    GgafDxMorphMeshActor* const _pActor;
    /** [r/w]e[t^[Qbg̏d(0.0 ` 1.0) */
    float _weight[MAX_MORPH_TARGET+1];
    /** [r/w]e[t^[Qbg֐ݒ肳ꂽڕW̏d(0.0 ` 1.0) */
    float _target_weight[MAX_MORPH_TARGET+1];
    /** [r/w]e[t^[Qbg֏dݏ(0.0 ` 1.0) */
    float _top_weight[MAX_MORPH_TARGET+1];
    /** [r/w]e[t^[Qbg֏d݉(0.0 ` 1.0) */
    float _bottom_weight[MAX_MORPH_TARGET+1];
    /** [r/w]e[t^[Qbgւ̖t[dݑx */
    float _velo_weight[MAX_MORPH_TARGET+1];
    /** [r/w]e[t^[Qbgւ̖t[d݉x */
    float _acce_weight[MAX_MORPH_TARGET+1];
    int _halfloop_cnt[MAX_MORPH_TARGET+1];
    /** [r]~\̕Г[v */
    int _stop_halfloop_num[MAX_MORPH_TARGET+1];
    /** [r][v̐U镑 */
    GgafDxMorphingMethod _method[MAX_MORPH_TARGET+1];

    /** [r][vd݂̂P[vt[ */
    frame _beat_target_frames[MAX_MORPH_TARGET+1];
    /** [r][vd݂̊Jn΃t[ */
    frame _frame_of_beat_begin[MAX_MORPH_TARGET+1];
    /** [r]Opg[vd݂̃A^bN܂ł̃t[ */
    frame _beat_attack_frames[MAX_MORPH_TARGET+1];
    /** [r]Opg[vd݂̋xt[ */
    frame _beat_rest_frames[MAX_MORPH_TARGET+1];
    /** [r]r[gAẽA^bN牺܂ł̃t[ */
    frame _beat_down_frames[MAX_MORPH_TARGET+1];
    /** [r]r[gAJE^[ */
    frame _beat_frame_count[MAX_MORPH_TARGET+1];
    /** [r]r[gAiԍ */
    int _beat_progres[MAX_MORPH_TARGET+1];

public:
    /**
     * RXgN^<BR>
     * @param	prm_pActor	KpActor
     */
    GgafDxMorpher(GgafDxMorphMeshActor* prm_pActor);

    /**
     * Zbg
     */
    void reset();

    /**
     * [t^[Qbg̏d݂̏Ɖݒ肵d݂̒l𐧌 .
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_weight1 d݂P( or )
     * @param prm_weight2 d݂Q( or )
     */
    void forceWeightRange(int prm_target_mesh_no, float prm_weight1, float prm_weight2) {
        if (prm_weight1 < prm_weight2) {
            _top_weight[prm_target_mesh_no] = prm_weight2;
            _bottom_weight[prm_target_mesh_no] = prm_weight1;
        } else {
            _top_weight[prm_target_mesh_no] = prm_weight1;
            _bottom_weight[prm_target_mesh_no] = prm_weight2;
        }
    }

    /**
     * [t^[Qbg̏d݂𒼐ڎw .
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_weight d d0.0`1.0Bȏ\
     */
    inline void setWeight(int prm_target_mesh_no, float prm_weight) {
        if (_top_weight[prm_target_mesh_no] < prm_weight) {
            _weight[prm_target_mesh_no] = _top_weight[prm_target_mesh_no];
        } else if (_bottom_weight[prm_target_mesh_no] > prm_weight) {
            _weight[prm_target_mesh_no] = _bottom_weight[prm_target_mesh_no];
        } else {
            _weight[prm_target_mesh_no] = prm_weight;
        }
    }

    /**
     * S[t^[Qbg̏d݂𒼐ڎw
     * @param prm_target_mesh_no d0.0`1.0Bȏ\
     */
    void setWeight(float prm_weight);

    /**
     * [t^[Qbg̏d݂Z(ŌZ) .
     * ͕ۏ؂B
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_weight
     */
    void addWeight(int prm_target_mesh_no, float prm_weight_offset) {
        setWeight(prm_target_mesh_no, _weight[prm_target_mesh_no] + prm_weight_offset);
    }

    /**
     * [t^[Qbg̏d݂lɐݒ .
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     */
    void setWeightToBottom(int prm_target_mesh_no) {
        _weight[prm_target_mesh_no] = _bottom_weight[prm_target_mesh_no];
    }

    /**
     * [t^[Qbg̏d݂lɐݒ .
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     */
    void setWeightToTop(int prm_target_mesh_no) {
        _weight[prm_target_mesh_no] = _top_weight[prm_target_mesh_no];
    }

    /**
     * [tBO~ .
     * @param prm_target_mesh_no [tBÕ[t^[QbgbVNO(1`)
     */
    void stopImmed(int prm_target_mesh_no);

    /**
     * SẴ[tBO~ .
     */
    void stopImmed();

    /**
     * [tĂ邩ׂ .
     * e[t^[Qbgւ̏d݂A1ł0傫 true
     * @return true:[tĂ/false:[tȂ
     */
    bool isMorphing();

    /**
     * [t^[Qbgֈ葬xŃ[tBOit[wj .
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_target_weight ^[QbgbV̖ڕWd(0.0`1.0)
     * @param prm_spend_frame ₷t[
     */
    void morphLinerUntil(int prm_target_mesh_no, float prm_target_weight, frame prm_spend_frame);

    /**
     * [t^[Qbgֈ葬xŃ[tBOidݍwj .
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_target_weight ^[QbgbV̖ڕWd(0.0`1.0)
     * @param prm_velo_weight t[Zdݍ(>0.0)B̏d݂w肷鎖BZZ͎fB
     */
    void morphLinerStep(int prm_target_mesh_no, float prm_target_weight, float prm_velo_weight);

    /**
     * [t^[Qbg։wŃ[tBOidݑxAd݉xwj .
     * d݉x0Ɏw肷 morphLinerStep ƂقړӖɂȂB
     * morphLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂixłȂjB
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_target_weight ^[QbgbV̖ڕWd(0.0`1.0)
     * @param prm_velo_weight dݑxiӎĂj
     * @param prm_acce_weight d݉xiӎĂj
     */
    void morphAcceStep(int prm_target_mesh_no, float prm_target_weight, float prm_velo_weight, float prm_acce_weight);

    /**
     * [t^[Qbgֈ葬xŃ[tBOA葬xŌɖ߂B[vw肷BiP[ṽt[wj .
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_beat_target_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(0.5 PʂŎw\)
     */
    void loopLiner(int prm_target_mesh_no, frame prm_beat_target_frames, float prm_beat_num = -1);

    /**
     * Opg̔g`d݂Ƃă[tBOB .
     * <PRE>
     * C  _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
     *            /_                     /_
     *           /   _                  /   _
     *          /      _               /      _
     *         /         _            /         _
     *        /            _         /            _
     * D  Q/               _QQQ/               _Q
     *
     *       A            B
     *        @ 
     * </PRE>
     * KvȐݒl<BR>
     * @ P[ṽt[<BR>
     * A A^bN܂ł̃t[<BR>
     * B xet[<BR>
     * C dݏ(_top_weight[prm_target_mesh_no] ێ)<BR>
     * D d݉(_bottom_weight[prm_target_mesh_no] ێ)<BR>
     * <BR>
     * @param prm_target_mesh_no [t^[QbgbVNO(1`)
     * @param prm_beat_target_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_rest_frames }ŇB̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    void beat(int prm_target_mesh_no,
              frame prm_beat_target_frames,
              frame prm_attack_frames,
              frame prm_rest_frames,
              float prm_beat_num = -1);

    /**
     * t[̐U镑\bhB<BR>
     * {NX̃[tBO@\𗘗pꍇ́A<BR>
     * ̃\bh𖈃t[s邱ƂKvłB <BR>
     */
    virtual void behave();

    virtual ~GgafDxMorpher();
};

}
#endif /*GGAFDXCORE_GGAFDXMORPHER_H_*/

