#ifndef GGAFDXCORE_GGAFDXKUROKOB_H_
#define GGAFDXCORE_GGAFDXKUROKOB_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * B .
 * B͉X̖ڂɂ͐G܂񂪁A(AN^[)グAusړvs킹鐢blłB<BR>
 * usړvɓĂAÁuړvủ]vƂ͐啪삪Ⴂ܂B<BR>
 * AƍB͂΁AȂ蕡Gȓ҂ɍs킹邱Ƃł܂B
 * ҈lɂABWňltĂ܂B<BR>
 * <BR>
 * ͂ĒuA܂WvZxiʉjNX̂QłB<BR>
 * GgafDxGeometricActor ̃o<BR>
 *  _X, _Y, _Z  EEE AN^[̍W<BR>
 * AeɊȒPɑ삷邽߂ɍ쐬B<BR>
 * @version 1.00
 * @since 2008/08/20
 * @author Masatoshi Tsuge
 */
class GgafDxKurokoB : public GgafCore::GgafObject {

public:
    /** [r]ΏۃAN^[ */
    GgafDxGeometricActor* const _pActor;
    /** [r/w]Xړx */
    velo _veloVxMv;
    /** [r/w]Xړx */
    velo _veloTopVxMv;
    /** [r/w]Xړx */
    velo _veloBottomVxMv;
    /** [r/w]Xړx */
    acce _acceVxMv;
    /** [r/w]Xړx*/
    acce _acceTopVxMv;
    /** [r/w]Xړx*/
    acce _acceBottomVxMv;
    /** [r/w]Yړx */
    velo _veloVyMv;
    /** [r/w]Yړx */
    velo _veloTopVyMv;
    /** [r/w]Yړx */
    velo _veloBottomVyMv;
    /** [r/w]Yړx */
    acce _acceVyMv;
    /** [r/w]Yړx*/
    acce _acceTopVyMv;
    /** [r/w]Yړx*/
    acce _acceBottomVyMv;
    /** [r/w]Zړx */
    velo _veloVzMv;
    /** [r/w]Zړx */
    velo _veloTopVzMv;
    /** [r/w]Zړx */
    velo _veloBottomVzMv;
    /** [r/w]Zړx */
    acce _acceVzMv;
    /** [r/w]Zړx*/
    acce _acceTopVzMv;
    /** [r/w]Zړx*/
    acce _acceBottomVzMv;

    coord _gravitation_mv_seq_target_X;
    coord _gravitation_mv_seq_target_Y;
    coord _gravitation_mv_seq_target_Z;
    GgafDxGeometricActor* _gravitation_mv_seq_pActor_target;
    velo _gravitation_mv_seq_max_velo;
    acce _gravitation_mv_seq_acce;
    coord _gravitation_mv_seq_stop_renge;
    bool _gravitation_mv_seq_flg;

public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  KpActor
     */
    GgafDxKurokoB(GgafDxGeometricActor* prm_pActor);

    int dot(int prm_vX, int prm_vY, int prm_vZ);
    /**
     * Xړxݒ .
     * @param prm_veloVxMv Xړx
     */
    void setVxMvVelo(velo prm_veloVxMv);

    /**
     * XړxZ .
     * @param prm_veloVxMv Xړx
     */
    void addVxMvVelo(velo prm_veloVxMv);

    /**
     * Xړx̏ .
     * @param prm_veloVxMv01 xP
     * @param prm_veloVxMv02 xQ
     */
    void forceVxMvVeloRange(velo prm_veloVxMv01, velo prm_veloVxMv02);

    /**
     * Xړxݒ .
     * @param prm_acceVxMv Xړx
     */
    void setVxMvAcce(acce prm_acceVxMv);

    /**
     * XړxZ .
     * @param prm_acceVxMv Xړx
     */
    void addVxMvAcce(acce prm_acceVxMv);

    /**
     * Xړx̏ .
     * @param prm_acceVxMv01 xP
     * @param prm_acceVxMv02 xQ
     */
    void forceVxMvAcceRange(acce prm_acceVxMv01, acce prm_acceVxMv02);

    /**
     * Yړxݒ .
     * @param prm_veloVyMv Yړx
     */
    void setVyMvVelo(velo prm_veloVyMv);

    /**
     * YړxZ .
     * @param prm_veloVyMv Yړx
     */
    void addVyMvVelo(velo prm_veloVyMv);

    /**
     * Yړx̏ .
     * @param prm_veloVyMv01 xP
     * @param prm_veloVyMv02 xQ
     */
    void forceVyMvVeloRange(velo prm_veloVyMv01, velo prm_veloVyMv02);

    /**
     * Yړxݒ .
     * @param prm_acceVyMv Yړx
     */
    void setVyMvAcce(acce prm_acceVyMv);

    /**
     * YړxZ .
     * @param prm_acceVyMv Yړx
     */
    void addVyMvAcce(acce prm_acceVyMv);

    /**
     * Yړx̏ .
     * @param prm_acceVyMv01 xP
     * @param prm_acceVyMv02 xQ
     */
    void forceVyMvAcceRange(acce prm_acceVyMv01, acce prm_acceVyMv02);

    /**
     * Zړxݒ .
     * @param prm_veloVzMv Zړx
     */
    void setVzMvVelo(velo prm_veloVzMv);

    /**
     * ZړxZ .
     * @param prm_veloVzMv Zړx
     */
    void addVzMvVelo(velo prm_veloVzMv);

    /**
     * Zړx̏ .
     * @param prm_veloVzMv01 xP
     * @param prm_veloVzMv02 xQ
     */
    void forceVzMvVeloRange(velo prm_veloVzMv01, velo prm_veloVzMv02);

    /**
     * Zړxݒ .
     * @param prm_acceVzMv Zړx
     */
    void setVzMvAcce(acce prm_acceVzMv);

    /**
     * ZړxZ .
     * @param prm_acceVzMv Zړx
     */
    void addVzMvAcce(acce prm_acceVzMv);

    /**
     * Zړx̏ .
     * @param prm_acceVzMv01 xP
     * @param prm_acceVzMv02 xQ
     */
    void forceVzMvAcceRange(acce prm_acceVzMv01, acce prm_acceVzMv02);

    /**
     * XYZ̈ړx̏ .
     * @param prm_veloVxyzMv01 x1
     * @param prm_veloVxyzMv02 x2
     */
    void forceVxyzMvVeloRange(velo prm_veloVxyzMv01, velo prm_veloVxyzMv02);

    /**
     * XYZ̈ړx̏ .
     * @param prm_acceVxyzMv01 xP
     * @param prm_acceVxyzMv02 xQ
     */
    void forceVxyzMvAcceRange(acce prm_acceVxyzMv01, acce prm_acceVxyzMv02);

    /**
     * XYZ̈ړxݒ肷B
     * @param prm_veloVxMv Xړx
     * @param prm_veloVyMv Yړx
     * @param prm_veloVzMv Zړx
     */
    void setVxyzMvVelo(velo prm_veloVxMv, velo prm_veloVyMv, velo prm_veloVzMv);

    /**
     * XYZ̈ړxݒ肷B
     * @param prm_acceVxMv Xړx
     * @param prm_acceVyMv Yړx
     * @param prm_acceVzMv Zړx
     */
    void setVxyzMvAcce(acce prm_acceVxMv, acce prm_acceVyMv, acce prm_acceVzMv);

    /**
     * XYZ̈ړx 0 ɐݒ肷B
     */
    void setZeroVxyzMvVelo() {
        _veloVxMv = _veloVyMv = _veloVzMv = 0;
    }

    /**
     * XYZ̈ړx 0 ɐݒ肷B
     */
    void setZeroVxyzMvAcce() {
        _acceVxMv = _acceVyMv = _acceVzMv = 0;
    }

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̂߂ .
     */
    void stopGravitationMvSequence() {
        _gravitation_mv_seq_flg = false;
    }

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̍Œǂ
     * @return true:Œ/false:łȂ
     */
    bool isGravitationMvSequence() {
        return _gravitation_mv_seq_flg;
    }

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̂s .
     * yASYTvz<BR>
     * X,Y,Z̊e̍WꂼɁAڕW̍WƃAN^[̍WA<BR>
     * ̐ɂAxZZĖڕWɋ߂ÂƂ܂B<BR>
     * AÂ܂܂łƁAq񂷂邪@AiɖڕW̍WɓB܂B<BR>
     * ŁAڕW̍WX,Y,Z̊eƁAAN^[̍W<BR>
     * -1*prm_stop_renge ` prm_stop_renge<BR>
     * ͈͓̔ɂȂꍇAxɘa()AڕW̍WɍXɋ߂Â܂B<BR>
     * eꂼAڕWɋ߂ÂƎx0ɋ߂ÂAƂŏd͂Ƃ͕IɓقȂ܂B<BR>
     * łAd͂ňt邩̂悤Ȍʂҏo܂B<BR>
     * wIɂ́AڕW̍WɌȂ߂ÂŁAڕWWƈv邱Ƃ͂܂B<BR>
     * @param prm_tX 񂹂ēBڕWXW
     * @param prm_tY 񂹂ēBڕWYW
     * @param prm_tZ 񂹂ēBڕWZW
     * @param prm_max_velo 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_acce 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_stop_renge x}ڕWW̊e̋
     */
    void execGravitationMvSequenceTwd(coord prm_tX, coord prm_tY, coord prm_tZ,
                                      velo prm_max_velo,
                                      acce prm_acce,
                                      coord prm_stop_renge);

    /**
     * d͂ɂ蕨̂񂹂邩悤Ȋ݂̓Ȋۂ̂s .
     * ́A
     * execGravitationMvSequenceTwd(coord,coord,coord,velo,acce,int)
     * QƁB
     * @param prm_pActor_target 񂹂ēBڕWWƂȂAN^[
     * @param prm_max_velo 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_acce 񂹂ĂŒ̊e(XYZ)̎ړxl
     * @param prm_stop_renge x}ڕWW̊e̋
     */
    void execGravitationMvSequenceTwd(GgafDxGeometricActor* prm_pActor_target,
                                      velo prm_max_velo,
                                      acce prm_acce,
                                      coord prm_stop_renge);

    /**
     * B̎dp .
     *  GgafDxKurokoB IuWFNgԂgɈp .
     * @param prm_pKurokoB p
     */
    void takeoverMvFrom(GgafDxKurokoB* const prm_pKurokoB);

    void resetMv();

    /**
     * BU镑 .
     * B@\𗘗pꍇ́Ã\bh𖈃t[ĂяosĂB<BR>
     * tɍBKvƂȂꍇ́Ã\bhĂяoȂƂŁAptH[}Xɉe^܂B<BR>
     */
    virtual void behave();

    virtual ~GgafDxKurokoB();
};

}
#endif /*GGAFDXCORE_GGAFDXKUROKOB_H_*/

