#ifndef GGAFDXCORE_GGAFDXSTRINGBOARDACTOR_H_
#define GGAFDXCORE_GGAFDXSTRINGBOARDACTOR_H_
#include "jp/ggaf/dxcore/actor/GgafDxBoardSetActor.h"

namespace GgafDxCore {

/**
 * \NX .
 * GgafDxBoardActor pAZbgeNX`[
 * \@\ǉAN^[łB<BR>
 * ̂悤ȃeNX`ł邱ƂOBiۂ̉摜͌rłj<BR>
 * <code><pre>
 * 
 * @Ihf
 * 
 * ij{C|D^
 * 
 * OPQRSTUV
 * 
 * WXFGH
 * 
 * `abcdef
 * 
 * ghijklmn
 * 
 * opqrstuv
 * 
 * wxym_nOQ
 * 
 * </pre></code>
 * \ƌĂUV؂ւĘA\邾B
 * @version 1.00
 * @since 2009/04/09
 * @author Masatoshi Tsuge
 */
class GgafDxStringBoardActor : public GgafDxBoardSetActor {

    /**
     * I[o[Chs .
     */
    virtual void processSettlementBehavior() override;

public:
    /** [r/w]p^[ԍ0Ƃ镶 */
    int _chr_ptn_zero;
    /** [r]`敶 */
    char* _draw_string;
    /** [r]obt@(1024 char ܂ŁAs256܂) */
    char* _buf;
    /** [r] */
    int _len;
    /** [r/w]x[X̂P(px) */
    pixcoord _chr_width_px;
    /** [r/w]x[X̂P(px) */
    pixcoord _chr_height_px;
    /** [r/w]eԊu(px) */
    pixcoord _aWidthPx[256];
    /** [r]obt@̍sPʂ̕(px) */
    pixcoord _aWidth_line_px[256];
    /** [r]obt@s */
    int _nn;

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_model ZbgeNX`̃f`ID
     * @return
     */
    GgafDxStringBoardActor(const char* prm_name, const char* prm_model);

    virtual void onCreateModel() override;

    virtual void processDraw() override;

    virtual void processAfterDraw() override {
    }

    virtual bool processHitChkLogic(GgafCore::GgafActor* prm_pOtherActor) {
        return false;
    }

    virtual void onHit(GgafCore::GgafActor* prm_pOtherActor) {
    }
    /**
     * `敶XVݒ .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, const char* prm_str);
    /**
     * `敶XVݒ  .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, char* prm_str);

    /**
     * `敶XVݒ  .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param Z vCIeB(lO)
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, coord Z, const char* prm_str);
    /**
     * `敶XVݒ  .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param Z vCIeB(lO)
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, coord Z, char* prm_str);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     */
    virtual void update(const char* prm_str);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     */
    virtual void update(char* prm_str);

    /**
     * `敶XVݒ .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͍[Ӗ^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[Ӗ
     * @param prm_valign VALIGN_TOP:YW͕̍̏ӂӖ^VALIGN_MIDDLE:YW͕̍̐^񒆂Ӗ^VALIGN_BOTTOM:YW͕̍̒ӂӖ
     */
    virtual void update(coord X, coord Y, const char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͍[Ӗ^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[Ӗ
     * @param prm_valign VALIGN_TOP:YW͕̍̏ӂӖ^VALIGN_MIDDLE:YW͕̍̐^񒆂Ӗ^VALIGN_BOTTOM:YW͕̍̒ӂӖ
     */
    virtual void update(coord X, coord Y, char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);

    /**
     * `敶XVݒ  .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param Z vCIeB(lO)
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͍[Ӗ^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[Ӗ
     * @param prm_valign VALIGN_TOP:YW͕̍̏ӂӖ^VALIGN_MIDDLE:YW͕̍̐^񒆂Ӗ^VALIGN_BOTTOM:YW͕̍̒ӂӖ
     */
    virtual void update(coord X, coord Y, coord Z, const char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param X (ftHg)XW(sNZ : W  1 : LEN_UNIT)
     * @param Y (ftHg)YW(sNZ : W  1 : LEN_UNIT)
     * @param Z vCIeB(lO)
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͍[Ӗ^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[Ӗ
     * @param prm_valign VALIGN_TOP:YW͕̍̏ӂӖ^VALIGN_MIDDLE:YW͕̍̐^񒆂Ӗ^VALIGN_BOTTOM:YW͕̍̒ӂӖ
     */
    virtual void update(coord X, coord Y, coord Z, char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͍[Ӗ^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[Ӗ
     * @param prm_valign VALIGN_TOP:YW͕̍̏ӂӖ^VALIGN_MIDDLE:YW͕̍̐^񒆂Ӗ^VALIGN_BOTTOM:YW͕̍̒ӂӖ
     */
    virtual void update(const char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͍[Ӗ^ALIGN_CENTER:XW͕̐^񒆁^ALIGN_RIGHT:XW͉E[Ӗ
     * @param prm_valign VALIGN_TOP:YW͕̍̏ӂӖ^VALIGN_MIDDLE:YW͕̍̐^񒆂Ӗ^VALIGN_BOTTOM:YW͕̍̒ӂӖ
     */
    virtual void update(char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);


    virtual ~GgafDxStringBoardActor();

};

}
#endif /*GGAFDXCORE_GGAFDXSTRINGBOARDACTOR_H_*/
