#ifndef GGAFDXCORE_GGAFDXDRAWABLEACTOR_H_
#define GGAFDXCORE_GGAFDXDRAWABLEACTOR_H_
#include "jp/ggaf/dxcore/actor/GgafDxGeometricActor.h"

namespace GgafDxCore {

/**
 * ʂɕ`sAN^[̒ۃNX .
 * GgafDxGeometricActor  fAGtFNgA}eAȂǂێA<BR>
 * `֘A\bh`<BR>
 * @version 1.00
 * @since 2009/06/10
 * @author Masatoshi Tsuge
 */
class GgafDxDrawableActor : public GgafDxGeometricActor {
private:
    /** [r]ꎞeNjbN */
    char* _temp_technique;
    /** [r]ꎞeNjbNnbVl */
    hashval _hash_temp_technique;
    /** [r]ꎞeNjbNIt[ */
    frame _frame_of_behaving_temp_technique_end;


    /**
     * draw()̎gp֎~ .
     * E(GgafDxUniverse)SĂ̕`sdg݂ɂȂ܂B
     * GgafDxUniverse::draw() QƂB
     * m[hc[p draw \bhʂŎgȂ悤ɂ邽privateŎB
     */
    void draw() override {}

public:
    /** [r/w]`掞AZobt@lĕ`sۂBtrue:l^false:Zobt@𖳎ĕ`  */
    bool _zenable;
    /** [r/w]`掞AZobt@֏݂sۂBtrue:Zobt@֐[xށ^false:Zobt@ւ͉܂Ȃ */
    bool _zwriteenable;

    /** [r]߂̕`掞ɎgpꂽeNjbÑnbVR[h */
    static hashval _hash_technique_last_draw;

    /** [r]`惌x̎̃AN^[ */
    GgafDxDrawableActor* _pNext_TheSameDrawDepthLevel;
    /** [r/w]݂̃}eÃl (0.0 <= _alpha <= 1.0) */
    float _alpha;
    /** [r]ݕ`ɎgpĂVF[_[eNjbN */
    char* _technique;
    /** [r]ݕ`ɎgpẴVF[_[eNjbÑnbVR[h */
    hashval _hash_technique;
    /** [r/w]݂̃}eAʃJ[ */
    D3DMATERIAL9* _paMaterial;

    /** [r/w]݂̕`[x */
    int _now_drawdepth;
    /** [r/w]ʂȌŒ`[xA-1łȂ _now_drawdepth Dł̐[xKp */
    int _specal_drawdepth;
    /** [r]ꎞeNjbNKp̏ꍇ true */
    bool _is_temp_technique;
    /** [r]tB[hCtF[hAEgx */
    GgafDxAlphaFader* const _pAFader;
    /** [r]fڑ */
    GgafDxModelConnection* const _pModelCon;
    /** [r]f */
    GgafDxModel* const _pModel;
    /** [r]GtFNgڑ */
    GgafDxEffectConnection* const _pEffectCon;
    /** [r]GtFNg */
    GgafDxEffect* const _pEffect;

public:
    /**
     * RXgN^ .
     * @param prm_name f́iCӁj
     * @param prm_model fʃL[
     * @param prm_effect GtFNgʃL[
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     */
    GgafDxDrawableActor(const char* prm_name,
                        const char* prm_model,
                        const char* prm_effect,
                        const char* prm_technique,
                        GgafCore::GgafStatus* prm_pStat,
                        GgafDxChecker* prm_pChecker);

    /**
     * RXgN^ .
     * GgafDxModelManager::processCreateResource() y
     * GgafDxEffectManager::processCreateResource()
     * ̐QƂׂB
     * @param prm_name AN^[́iCӁj
     * @param prm_model_id f`
     * @param prm_model_type f^Cv
     * @param prm_effect_id GtFNg`
     * @param prm_effect_type GtFNg^Cv
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     */
    GgafDxDrawableActor(const char* prm_name,
                        const char* prm_model_id,
                        const char* prm_model_type,
                        const char* prm_effect_id,
                        const char* prm_effect_type,
                        const char* prm_technique,
                        GgafCore::GgafStatus* prm_pStat,
                        GgafDxChecker* prm_pChecker);

    virtual GgafDxDrawableActor* getPrev() override {
        return (GgafDxDrawableActor*)GgafActor::getPrev();
    }

    virtual GgafDxDrawableActor* getNext() override {
        return (GgafDxDrawableActor*)GgafActor::getNext();
    }

    /**
     * VF[_[̃eNjbNύX .
     * \B
     * @param prm_technique eNjbN
     */
    void changeEffectTechnique(const char* prm_technique);

    /**
     * VF[_[̃eNjbNꎞIɕύX .
     * ɈꎞeNjbNgp͖BAA
     * ɈꎞeNjbNgpɋIɈꎞeNjbNύXꍇ̂悤ɂłB
     * <code>
     * if (_is_temp_technique == false) {
     *     changeEffectTechnique("ύXeNjbN");
     * }
     * </code>
     * @param prm_technique eNjbN
     * @param prm_frame ύXeNjbŇpt[
     */
    void changeEffectTechniqueInterim(const char* prm_technique, frame prm_frame);

    /**
     * sJƌB
     * @param prm_frame 鎞
     */
    virtual void effectFlush(frame prm_frame = MAX_FRAME);

    /**
     * ZGtFNg .
     * @param prm_frame
     */
    virtual void effectBlendOne(frame prm_frame = MAX_FRAME);

    /**
     * WGtFNgɖ߂ .
     */
    virtual void effectDefault();

    /**
     * ʂȕ`[xB .
     * 0ȏwꍇA`[xwɂ̒lgpB
     * ̐̎wꍇAݒɖ߂i_specal_drawdepth̃ftHg-1)
     * @param prm_drawdepth
     */
    void setSpecialDrawDepth(int prm_drawdepth);

    /**
     * ʂ̕`掖O .
     * `sɂĂ̏dvȎOsȂ܂B
     * EonCreateModel() ̌Ăяo
     * EiK_O̐[xvZ
     * EꎞeNjbNl
     * I[o[Ch񐄏B
     * I[o[Chꍇ́A
     * GgafDxDrawableActor::processPreDraw() \bhŌĂяoA
     * ͎Oœ̏邩AȂlĂB
     * TODO:private virtual ɂׂۂHBfainal ~
     */
    virtual void processPreDraw() override;

    /**
     * ʂ̕`掖㏈ .
     * fobO[h (MY_DEBUG  1)̏ꍇ
     * 蔻̈`悷B
     * (ƂĂ drawHitArea() R[邾)
     */
    virtual void processAfterDraw() override;

    /**
     * 蔻̈` .
     * ۂ͉̏ʃNXɔCB
     */
    virtual void drawHitArea() {};

    /**
     * {AN^[̕`掞̃}eAAt@lݒ .
     * 1.0 ȏ̏ꍇJOONA<br>
     * 1.0 菬ȏꍇAJOOFFA<br>
     * Ƃ@\킹B<br>
     * @param prm_alpha AN^[̃}eAAt@l
     */
    virtual void setAlpha(float prm_alpha) {
        _alpha = prm_alpha;
    }

    /**
     * {AN^[̕`掞̃}eAAt@lZ .
     * @param prm_alpha Z}eAAt@l
     */
    virtual void addAlpha(float prm_alpha) {
        _alpha += prm_alpha;
    }

    /**
     * {AN^[̕`掞̃}eAAt@l擾 .
     * @return AN^[݂̌̃At@l
     */
    virtual float getAlpha() {
        return _alpha;
    }

    /**
     * {AN^[̕`掞̃}eAJ[ݒB .
     * LN^ŜɐFd˂ʂ𓾂B<br>
     * @́AʂɈˑB<br>
     * Ė{\bhɂu}eAJ[v̈Ӗ́A<br>
     * uDirectX̃}eAv̈ӖƈvȂȂB<br>
     * @param r Redx(0.0 ` 1.0)
     * @param g Greenx(0.0 ` 1.0)
     * @param b Bluex(0.0 ` 1.0)
     */
    virtual void setMaterialColor(float r, float g, float b);

    /**
     * {AN^[̕`掞̃}eAJ[ݒB .
     * @param prm_rgb
     */
    virtual void setMaterialColor(GgafCore::GgafRgb* prm_rgb);

    /**
     * }eAJ[fǂݍݎ̏ԂɃZbgB
     */
    virtual void resetMaterialColor();

    virtual GgafDxModel* getModel() {
        return _pModel;
    }

    virtual GgafDxEffect* getEffect() {
        return _pEffect;
    }

    /**
     * `掞Zobt@l邩 .
     * @param prm_bool true:l(default) / false:
     */
    void setZEnable(bool prm_bool) {
        _zenable = prm_bool;
    }

    /**
     * `掞Zobt@ނ .
     * @param prm_bool true:(default) / false:܂Ȃ
     */
    void setZWriteEnable(bool prm_bool) {
        _zwriteenable = prm_bool;
    }

    /**
     * fꂽ̏ .
     * fIuWFNg new ꂽꍇɂP񂾂Ăяo܂B
     * fPʂŐݒ肵I[o[ChĉB
     */
    virtual void onCreateModel() = 0;

    virtual ~GgafDxDrawableActor(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXDRAWABLEACTOR_H_*/
