#ifndef GGAFCORE_GGAFREPEATSEQ_H_
#define GGAFCORE_GGAFREPEATSEQ_H_
#include <map>
#include <string>

namespace GgafCore {

/**
 * NX .
 * f[^x[X̃V[NGXiIuWFNgĵ悤ɁA̔Ԃ܂B
 * @version 1.00
 * @since 2007/12/11
 * @author Masatoshi Tsuge
 */
class GgafRepeatSeq {
public:
    static std::map<std::string, int> mapNowval;
    static std::map<std::string, int> mapMaxval;
    static std::map<std::string, int> mapMinval;

public:
    /**
     * IuWFNg쐬 .
     * @param ID R鏇IuWFNgIDiC)
     * @param min ŏl
     * @param max ől
     */
    static void create(std::string ID, int min, int max);

    static void set(std::string& ID, int val);
    static void set(const char* ID, int val);
    static void setMax(std::string& ID);
    static void setMax(const char* ID);
    static void setMin(std::string& ID);
    static void setMin(const char* ID);
    /**
     * ID̏IuWFNg쐬ςׂ݂ .
     * @param ID IuWFNgID
     * @return true:ς݁^false:
     */
    static bool isExist(std::string& ID);
    static bool isExist(const char* ID);
    /**
     * IuWFNg玟̒l̔Ԃ .
     * @param ID 쐬̏IuWFNgID
     * @return Oĺ{PꂽlB
     *         AA͍ŏlԂB
     *         ܂Aől̎̔ԂƍŏlԂi߂jB
     */
    static int nextVal(std::string& ID);
    static int nextVal(const char* ID);
};

}
#endif /*GGAFCORE_GGAFREPEATSEQ_H_*/
