#ifndef GGAFCORE_GGAFLINKEDLISTRING_H_
#define GGAFCORE_GGAFLINKEDLISTRING_H_
#include "jp/ggaf/core/GgafObject.h"

#include "GgafCommonHeader.h"
#include "jp/ggaf/core/exception/GgafCriticalException.h"

namespace GgafCore {

/**
 * oAXg(O[)\zB.
 * <B>yz</B><BR>
 * IuWFNgփ|C^̊oAXg쐬܂B<BR>
 * Ⴆ΁Â悤ȃR[h
 * <pre><code>
 * Object* A = new Object();
 * Object* B = new Object();
 * Object* C = new Object();
 * Object* D = new Object();
 * Object* E = new Object();
 * GgafLinkedListRing<Object> ring_list = GgafLinkedListRing<Object>();
 * ring_list.addLast(A);
 * ring_list.addLast(B);
 * ring_list.addLast(C);
 * ring_list.addLast(D);
 * ring_list.addLast(E);
 * </code></pre>
 *
 * T̗vfŉ}̂悤ȍ\̂鎖o܂B<BR>
 * <pre>
 * ---------------------------------------------
 * ([E])[A]![B][C][D][E]([A]!)
 * ---------------------------------------------
 *
 * ---------------------------------------------
 * C[W}   [`]!
 *             ^  _
 *          [d]    [a]
 *            \      /
 *           [c][[b]
 * ----------------------------------------------
 * 擪vf     :[A]     (=getFirst();)
 * ԗvf     :[B]`[D]
 * vf     :[E]     (=getLast(); =getFirst()->getPrev();)
 * Jgvf :[A]     (=getCurrent();)
 * </pre>
 * ev[g͓ێ|C^̌^w肵܂B<BR>
 * ܂AuGgafLinkedListRing<Object*>();vł͂ȂuGgafLinkedListRing<Object>();vƂ邱ƂƂ܂B<BR>
 * w[A]x́w [ ] x ́AwvfxƌĂ΂ꕨiReij\Aw[A]x́wAx͗vfێwlx\Ă܂B<BR>
 * }́ẃx́Avfm݂|C^wĂ鎖Ă܂B<BR>
 * "!" ̓Jgvf(J[\wĂ悤Ȃ)ŁA{ev[g\bhɂ@\̊ƂȂvfłB<BR>
 * [́w([E])xƁw([A]!)xƂ\ĹAvfXg̐擪ƖA݂AĂ鎖Ă܂B<BR>
 * ɂȂĂ邽ߏI[Ai next  prev \łB<BR>
 * next  prev ł̏I[͂܂񂪁AtOɂăXg̐擪vfAvf͊ǗĂ܂B<BR>
 * }ł́Aw[A]x 擪vfAw[E]x 𖖔vfAƂēǗĂAʏ̐`Xĝ悤Ȏg\łB<BR>
 * [ߑ]<BR>
 * {NX̐ŁAuvfvƂ\́A̓Ci[NX ElemIuWFNgւ̃|C^̎wA<BR>
 * uvf̒lvƂ\ Elem IuWFNg̃o _pValue w܂B<BR>
 * uvf̒lv̌^ T* łB̗ł Object* ^w܂BObject ̒l̂ł͂܂B
 * <BR>
 * @version 1.00
 * @since 2008/12/19
 * @author Masatoshi Tsuge
 */
template<class T>  //T:Ǘvf̃|C^̌^
class GgafLinkedListRing : public GgafObject {

public:
    /**
     * Rei .
     * lbvAO|C^ێB
     */
    class Elem {
    public:
        /** [r]ۂ̗vf̒l */
        T* _pValue;
        /** [r]vf */
        Elem* _pNext;
        /** [r]Ovf */
        Elem* _pPrev;
        /** [r]֘Avfz */
        Elem** _papRelation;
        /** [r]擪vftO (vf擪vf̏ꍇ true)*/
        bool _is_first_flg;
        /** [r]vftO (vfvf̏ꍇ true)*/
        bool _is_last_flg;
        /** [r/w]delete_pValuedelete邩ǂ̃tO */
        bool _is_delete_value;

        /**
         * RXgN^
         * @param prm_pValue li|C^j
         * @param prm_relation_num ǉmۂ֘Avf
         * @param prm_is_delete_value true  : GgafLinkedListRingCX^XdeleteɁAvf(_pValue)deleteB<BR>
         *                            false : vf(_pValue)deleteȂB
         */
        Elem(T* prm_pValue, int prm_relation_num, bool prm_is_delete_value = true) {
            _pValue = prm_pValue;
            _pNext = _pPrev = nullptr;
            if (prm_relation_num == 0) {
                _papRelation = nullptr;
            } else {
                _papRelation = NEW Elem*[prm_relation_num];
                for (int i = 0; i < prm_relation_num; i++) {
                    _papRelation[i] = nullptr;
                }
            }
            _is_first_flg = _is_last_flg = false;
            _is_delete_value = prm_is_delete_value;
        }

        /**
         * vf̒lԂB
         * @return l
         */
        inline T* getValue() {
            return _pValue;
        }
        /**
         * vf݂Ɋ֘At .
         * @param prm_connection_index vf֘Aڑԍ
         * @param prm_pOppElem ֘Avf
         */
        void connectEachOther(int prm_connection_index, Elem* prm_pOppElem) {
            _papRelation[prm_connection_index] = prm_pOppElem;
            prm_pOppElem[prm_connection_index] = this;
        }
        /**
         * vfIɊ֘At .
         * @param prm_connection_index vf֘Aڑԍ
         * @param prm_pOppElem ֘Avf
         */
        void connect(int prm_connection_index, Elem* prm_pOppElem) {
            _papRelation[prm_connection_index] = prm_pOppElem;
        }
        /**
         * vf玩ցAIɊ֘AtĂ炤 .
         * @param prm_pOppElem ̗vf
         * @param prm_opp_connection_index vf玩ւ̗vf֘Aڑԍ
         */
        void gotConnected(Elem* prm_pOppElem, int prm_opp_connection_index) {
            prm_pOppElem[prm_opp_connection_index] = this;
        }
        /**
         * fXgN^.
         * ێvf̒ldelete܂B<BR>
         */
        ~Elem() {
            if (_is_delete_value) {
                GGAF_DELETE(_pValue);
            }
            GGAF_DELETEARR_NULLABLE(_papRelation);
        }
    }; //class Elem

    /** [r]擪vf */
    Elem* _pElem_first;
    /** [r]Jgvf */
    Elem* _pElemActive;
    /** [r]vf */
    int _num_elem;
    /** [r]֘Avf */
    int _relation_num;

public:
    /**
     * RXgN^ .
     * g֘AvfƂ́Anext prev ȊOɃ[Vs}łB
     * @param prm_extend_relation_num g֘Avf
     */
    GgafLinkedListRing(int prm_extend_relation_num = 0);

    /**
     * fXgN^.
     * ێvf̒ĺAnullptrŖꍇAꂼ delete ɂ܂B<BR>
     * TODO:delete[] ₻̑̉@ɑΉ
     */
    virtual ~GgafLinkedListRing();

    /**
     * ̒lAJgvf́uvɒǉB
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                addNext(X) sBJgvf [C] ́uvɑ}B
     * ---usv--------------------------
     * ([E])[A][B][C]![X][D][E]([A])
     * ---------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addNext ́A<BR>
     * ̒l̗vf̓JgvfɂȂ܂B<BR>
     * Qڈȍ~ addNext() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv--------------------------
     * nullptr(vfȂ)
     * ---------------------------------------
     *                addNext(A)
     * ---------------------------------------
     * ([A]!)[A]!([A]!)
     * ---------------------------------------
     *                addNext(B)
     * ---------------------------------------
     * ([B])[A]![B]([A]!)
     * ---------------------------------------
     *                addNext(C)
     * ---------------------------------------
     * ([B])[A]![C][B]([A]!)
     * ---------------------------------------
     * </pre>
     * <BR>
     * Jgvf̏ԂŖ{\bhsÁuvɑ}sꍇA<BR>
     * ̒lA̗vflɂȂ܂Bi̒l̗vfA擪ɂ͂Ȃ܂j<BR>
     * <pre>
     * ---usOv--------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * ---------------------------------------
     *                addNext(X)
     * ---usv--------------------------
     * ([X])[A][B][C][D][E]![X]([A])
     * ---------------------------------------
     * </pre>
     * @param prm_pNew CX^Xςݗvf̃|C^
     * @param prm_is_delete_value true  : XgdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̒ǉvflɂĉsȂB
     */
    virtual void addNext(T* prm_pNew, bool prm_is_delete_value = true);


    /**
     * ̒lAJgvf́uOvɒǉBJgvf͕ωȂ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                addPrev(X)
     * ---usv--------------------------
     * ([E])[A][B][X][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addPrev() ́A
     * ̒l̓JgvflƂȂ܂B<BR>
     * Qڈȍ~ addPrev() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv--------------------------
     * nullptr(vfȂ)
     * ---------------------------------------
     *                addPrev(A)
     * ---------------------------------------
     * ([A]!)[A]!([A]!)
     * ---------------------------------------
     *                addPrev(B)
     * ---------------------------------------
     * ([A]!)[B][A]!([B])
     * ---------------------------------------
     *                addPrev(C)
     * ---------------------------------------
     * ([A]!)[B][C][A]!([B])
     * ---------------------------------------
     * </pre>
     * <BR>
     * Jgvf擪̏ԂŖ{\bhsA擪́uOvɑ}sꍇA<BR>
     * ̒l̗vf擪ɂȂ܂Bi̒l̗vfɂ͂Ȃ܂j<BR>
     * <pre>
     * ---usOv--------------------------
     * ([E])[A]![B][C][D][E]([A]!)
     * ---------------------------------------
     *                addPrev(X)
     * ---usv--------------------------
     * ([E])[X][A]![B][C][D][E]([X])
     * ---------------------------------------
     * </pre>
     * @param prm_pNew Vvf̒l
     * @param prm_is_delete_value true  : XgdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̒ǉvfɂĉsȂB
     */
    virtual void addPrev(T* prm_pNew, bool prm_is_delete_value = true);

    /**
     * ̒lA(_is_last_flg  true)ƂĒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                addLast(X)
     * ---usv--------------------------
     * ([X])[A][B][C]![D][E][X]([A])
     * ---------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addLast() ́A
     * ̒l̓JgvfɂȂ܂B<BR>
     * Qڈȍ~ addLast() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv--------------------------
     * nullptr(vfȂ)
     * ---------------------------------------
     *                addLast(A)
     * ---------------------------------------
     * ([A]!)[A]!([A]!)
     * ---------------------------------------
     *                addLast(B)
     * ---------------------------------------
     * ([B])[A]![B]([A]!)
     * ---------------------------------------
     *                addLast(C)
     * ---------------------------------------
     * ([C])[A]![B][C]([A]!)
     * ---------------------------------------
     * </pre>
     * @param prm_pNew Vvf̒l
     * @param prm_is_delete_value true  : Xg̃CX^XdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : Xg̃CX^XdeleteɁA̒ǉvflɂĉsȂB
     */
    virtual void addLast(T* prm_pNew, bool prm_is_delete_value = true);

    /**
     * ̒lA擪(_is_first_flg  true)ƂĒǉ .
     * ǉꏊ͈ȉ̐}̂悤ɂȂ܂B
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                addFirst(X)
     * ---usv--------------------------
     * ([E])[X][A][B][C]![D][E]([X])
     * ---------------------------------------
     * </pre>
     * <BR>
     * {IɃJgvf͕ω܂AA߂Ă addFirst() ́A
     * ̒l̓JgvfȂ܂B<BR>
     * Qڈȍ~ addFirst() ́AJgvfɉe^܂B<BR>
     * <pre>
     * ---usOv--------------------------
     * nullptr(vfȂ)
     * ---------------------------------------
     *                addFirst(A)
     * ---------------------------------------
     * ([A]!)[A]!([A]!)
     * ---------------------------------------
     *                addFirst(B)
     * ---------------------------------------
     * ([A]!)[B][A]!([B])
     * ---------------------------------------
     *                addFirst(C)
     * ---------------------------------------
     * ([A]!)[C][B][A]!([C])
     * ---------------------------------------
     * </pre>
     * @param prm_pNew Vvf̒l
     * @param prm_is_delete_value true  : XgdeleteɁA̒ǉvflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̒ǉvflɂĉsȂB
     */
    virtual void addFirst(T* prm_pNew, bool prm_is_delete_value = true);

    /**
     * Jgvfi߁A̗vf̒l𓾂 .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                next()sBJgvfuvɐi߁Al D Qbg
     * ---usv--------------------------
     * ([E])[A][B][C][D]![E]([A])
     * ---------------------------------------
     * </pre>
     * <BR>
     * Jgvf̏ԂŖ{\bhsƁA<BR>
     * 擪JgvfɂȂ܂B<BR>
     * <pre>
     * ---usOv--------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * ---------------------------------------
     *                 next()sBJgvfu(擪)vɐi߁Al A Qbg
     * ---usv--------------------------
     * ([E])[A]![B][C][D][E]([A]!)
     * ---------------------------------------
     * </pre>
     * @return Jgvfi߂A̗vf̒lԂ
     */
    virtual T* next();

    /**
     * Jgvf߂A̗vf̒l𓾂 .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                prev() sBl B Qbg
     * ---usv--------------------------
     * ([E])[A][B]![C][D][E]([A])
     * ---------------------------------------
     * </pre>
     * <BR>
     * Jgvf擪̏ԂŖ{\bhsƁA<BR>
     * JgvfɂȂ܂B<BR>
     * <pre>
     * ---usOv--------------------------
     * ([E])[A]![B][C][D][E]([A]!)
     * ---------------------------------------
     *                  prev() sBJgvfuO()vɈړAl E Qbg
     * ---usv--------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * ---------------------------------------
     * </pre>
     * @return JgvfOɖ߂A̗vf̒lԂ
     */
    virtual T* prev();

    /**
     * Jgvf擪ɖ߂A̗vf̒l𓾂 .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                Jg擪ɈړA̗vf̒l A Qbg
     * ---usv--------------------------
     * ([E])[A]![B][C][D][E]([A])
     * ---------------------------------------
     * </pre>
     * @return Jgvf擪ɖ߂A̗vf̒lԂ
     */
    virtual T* first();
    /**
     * Jgvf𖖔ֈړB .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                Jg𖖔ɈړA̗vf̒l E Qbg
     * ---usv--------------------------
     * ([E])[A][B][C][D][E]!([A])
     * ---------------------------------------
     * </pre>
     * @return Jgvf𖖔ֈړ́A̗vf̒l
     */
    virtual T* last();

    /**
     * Jgvfw̐擪vf̐΃CfbNXɈړA̗vf̒l𓾂 .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                current(1); JgړA̗vf̒l B Qbg
     * ---usv--------------------------
     * ([E])[A][B]![C][D][E]([A])
     *         0    1     2    3    4
     * ---------------------------------------
     * </pre>
     * @param n 擪vf̐΃CfbNX
     * @return Jgvfړ́A̗vf̒l
     */
    virtual T* current(int n);

    /**
     * Jgvf֘AvfֈړA̗vf̒l𓾂  .
     * ̊֘Avfڑԍ͈͊ȌꍇA͊֘Aݒ̏ꍇG[
     * @param prm_connection_index ֘Avfڑԍ
     * @return Jgvf֘Avfֈړ́A̗vf̒l
     */
    virtual T* gotoRelation(int prm_connection_index);

    /**
     * Jgvf̗̎vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                getNext() sBɕωɁAl D Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * Jgvf̏ԂŖ{\bhsƁA<BR>
     * 擪vf̒l擾邱ƂɂȂ܂B<BR>
     * <pre>
     * ---usOv--------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * ---------------------------------------
     *                 getNext() sBɕωɁAl A Qbg
     * ---usv--------------------------
     * (![E])[A][B][C][D][E]!([A])
     * ---------------------------------------
     * </pre>
     * @return ̗vf̒l
     */
    virtual T* getNext();

    /**
     * Jgvf̂Ԗڂ̗vf̒l擾BJgvf͕ωȂ .
     * getNext(1) ́AgetNext() ƓłBgetNext(0)  getCurrent()ƓłB
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     *                   0     1    2     3
     *   2     3    4    5
     * ---------------------------------------
     *                getNext(2) sBɕωɁAl E Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * @param n CfbNX
     * @return Jgvf炎Ԗڂ̗vf̒l
     */
    virtual T* getNext(int n);

    /**
     * Jgvf̂PO̗vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                getPrev() sBɕωɁAl B Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * @return O̗vf̒l
     */
    virtual T* getPrev();

    /**
     * Jgvf̂ԖڑO̗vf̒l擾BJgvf͕ωȂ .
     * getPrev(1) ́AgetPrev() ƓłBgetPrev(0)  get()ƓłB
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     *   3     2    1    0
     *                   5     4    3     2
     * ---------------------------------------
     *                getPrev(2) sBɕωɁAl A Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * @param n CfbNX
     * @return Jgvf炎ԖڑO̗vf̒l
     */
    virtual T* getPrev(int n);


    /**
     * 擪̗vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                ω[A]Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * @return 擪̗vf̒l
     */
    virtual T* getFirst();

    /**
     * 擪vf̂Ԗڂ̗vf̒l擾BJgvf͕ωȂ .
     * getFromFirst(0) ́AgetFirst() ƓłB
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     *         0    1    2     3    4     5
     *   4     5    6
     * ---------------------------------------
     *                getFromFirst(3) sBɕωɁAl D Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * @param n CfbNX
     * @return 擪vf炎Ԗڂ̗vf̒l
     */
    virtual T* getFromFirst(int n);

    /**
     * ̗vf̒l擾BJgvf͕ωȂ .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                getLast() sBɕωɁAl E Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * @return ̗vf̒l
     */
    virtual T* getLast();

    /**
     * Jgvf̒liێĂej擾 .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                sBɕωɁAl C Qbg
     * ---usv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * @return  Jgvf̒l
     */
    virtual T* getCurrent();

    /**
     * ֘Avf̒l擾BJgvf͕ωȂ .
     * @param prm_connection_index ֘Avfڑԍ
     * @return ֘Avf̒l^͈͊ȌꍇA͊֘Aݒ̏ꍇ nullptr
     */
    virtual T* getRelation(int prm_connection_index);

    /**
     * ݂̃Jgvf́A擪牽Ԗڂ(0`)ԂB
     * getCurrent() nullptr ̏ꍇ -1 ԂB
     * @return Jgvf̃CfbNX
     */
    virtual int getCurrentIndex();

    /**
     * JgvfXg̖ł邩ǂ肷 .
     * <pre>
     * ---------------------------------------
     * ([E])[A][B][C][D][E]!([A])
     * ---------------------------------------
     * }̏ꍇ true
     * </pre>
     * @return true:ł^false:ł͖
     */
    virtual bool isLast();

    /**
     * JgvfXg̐擪ł邩ǂ肷 .
     * <pre>
     * ---------------------------------------
     * ([E])[A]![B][C][D][E]([A])
     * ---------------------------------------
     * }̏ꍇ true
     * </pre>
     * @return true:ł^false:ł͖
     */
    virtual bool isFirst();

    /**
     * Jgvfɒl㏑ݒ肷B .
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                set(X) c l X ㏑āAX̒l C Qbg
     * ---usv--------------------------
     * ([E])[A][B][X]![D][E]([A])
     * ---------------------------------------
     *
     * AA㏑Ǒ̗vfݒ莞ɁA delete tOZbgɂĂꍇA
     * {\bhsɓ delete A߂lɂ nullptrԂ܂B
     * </pre>
     * @param prm_pVal Vvf̒l
     * @param prm_is_delete_value true  : XgdeleteɁA̗vflɂĂdelete𔭍sB(T̃wb_includeYꂸɁI)<BR>
     *                            false : XgdeleteɁA̗vflɂĉsȂB
     * @return ̐ݒvf delete ̏ꍇ nullptr ^ ̐ݒvf delete ł͂ȂꍇA㏑O̗vf(ɗp鎖zB)
     */
    virtual T* set(T* prm_pVal, bool prm_is_delete_value = true);

    /**
     * Jgvf𔲂 .
     * VȃJgvf next ̗vfɕςB
     * <pre>
     * ---usOv--------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     *                remove() c vf [C] BĒl C Qbg
     * ---usv--------------------------
     * ([E])[A][B][D]![E]([A])
     * ---------------------------------------
     * </pre>
     *
     * <BR>
     * Jgvfꍇ<BR>
     * VȃJgvf͐擪vfɕςB
     * <pre>
     * ---usOv--------------------------
     * ([E]!)[A][B][C][D][E]!([A])
     * ---------------------------------------
     *                remove() c vf [C] BĒl E Qbg
     * ---usv--------------------------
     * ([D])[A]![B][C][D]([A]!)
     * ---------------------------------------
     * </pre>
     *
     * l̉Kvȏꍇ́A߂lgpČĂьōsĉB
     * @return OɃJgvfvf̒l
     */
    virtual T* remove();

    /**
     * SĂ̗vf𔲂 .
     */
    virtual int removeAll();

    /**
     * 擪牽ԖڂԂB
     * ێĂvf̒l̓|C^̂߁Al̔rł͂Ȃ|C^(AhX)v
     * CfbNXԂ܂BCfbNX0̐lłB
     * <pre><code>
     * Object* A = new Object();
     * Object* B = new Object();
     * Object* C = new Object();
     * Object* D = new Object();
     * Object* E = new Object();
     * GgafLinkedListRing<Object> ring_list = GgafLinkedListRing<Object>();
     * ring_list.addLast(A);
     * ring_list.addLast(B);
     * ring_list.addLast(C);
     * ring_list.addLast(D);
     *
     * int a = ring_list.indexOf(A);   // a = 0 ƂȂ
     * int b = ring_list.indexOf(B);   // b = 1 ƂȂ
     * int c = ring_list.indexOf(C);   // c = 2 ƂȂ
     * int d = ring_list.indexOf(D);   // d = 3 ƂȂ
     * int e = ring_list.indexOf(E);   // e = -1 ƂȂ(݂Ȃꍇ̖߂l)
     * </code></pre>
     * @param prm_pVal CfbNX𒲂ׂvf
     * @return ݂ꍇÃCfbNX(0`)ԂA݂Ȃꍇ -1 ԂB
     */
    virtual int indexOf(T* prm_pVal);


    /**
     * vfԂ .
     * <pre>
     * ---------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * }̏ꍇAlength()  5 Ԃ
     * ܂Avfꍇ 0 Ԃ܂B
     * @return vf
     */
    virtual int length();

    /**
     * 擪vfԂ .
     * <pre>
     * ---------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * }̏ꍇAgetElemFirst() ͗vf [A] Ԃil A ł͖jB
     * @return
     */
    Elem* getElemFirst() {
        return _pElem_first;
    }

    /**
     * JgvfԂ .
     * <pre>
     * ---------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     * ---------------------------------------
     * </pre>
     * }̏ꍇAgetElemActive() ͗vf [C] Ԃil C ł͖jB
     * @return
     */
    Elem* getElemActive() {
        return _pElemActive;
    }

    /**
     * 擪炎Ԗڂ̗vfԂ .
     * <pre>
     * ---------------------------------------
     * ([E])[A][B][C]![D][E]([A])
     *         0    1    2     3    4     5
     *   4     5
     * ---------------------------------------
     * </pre>
     * }̏ꍇAgetElemFromFirst(3) ͗vf [D] Ԃil D ł͖jB
     * @param n 擪̃CfbNX
     * @return
     */
    Elem* getElemFromFirst(int n) {
        if (_pElem_first == nullptr) {
            return nullptr;
        }
        Elem* pElem_return = _pElem_first;
        for (int i = 0; i < n; i++) {
            pElem_return = pElem_return->_pNext;
        }
        return pElem_return;
    }

    /**
     * SĂ̗vflɑ΂Ďẘ֐s .
     * vfñ|C^A֐|C^ pFunc̑P T* ɓnĂ܂B
     * prm1, prm2 ́A֐|C^ void*, void* ɓnĂ܂B(Lv`IɎgāI)<BR>
     * <BR>
     * gp၄<BR>
     * tH[[V̕ґo[̃IuWFNg(GgafActor*)AGgafLinkedListRingXg(listFollowers_)
     * ǗĂƂB<BR>
     * ̕ґo[SɁA(order1)oB̑x int velo_mv_ ƂB
     * ƂꍇAȉ̂悤ȊɂȂB<BR>
     * <BR>
     * <code><pre>
     *
     * class FormationXXX : public DepositoryFormation {
     * public :
     *     int velo_mv_;
     *     GgafLinkedListRing<GgafActor> listFollowers_;
     *
     *     static void FormationXXX::order1(GgafCore::GgafActor* prm_pActor, void* p1, void* p2) {
     *         //X̃o[
     *         EnemyXXX* pEnemyXXX = (EnemyDelheid*)prm_pActor; //̌^ɃLXg
     *         int velo_mv = *((velo*)p1);                       //Lv`̌^ɖ߂
     *         pEnemyXXX->_pKurokoA->setMvVelo(velo_mv);         //ݒ
     *     }
     *
     *     void processBehavior() {
     *         //SĂ̕ґo[ɉxoB
     *         velo_mv_ = 3000; //x
     *         listFollowers_.executeFunc(FormationXXX::order1, &velo_mv_, nullptr);
     *     }
     * }
     *
     * </pre></code>
     * @param pFunc vflɎs֐Bp[^(T*, void*, void*) ŒB
     * @param prm1 n̂P
     * @param prm2 n̂Q
     */
    void executeFunc(void (*pFunc)(T*, void*, void*), void* prm1, void* prm2) {
        if (_pElemActive == nullptr) {
            return;
        } else {
            Elem* pElem = _pElem_first;
            for (int i = 0; i < _num_elem; i++) {
                pFunc(pElem->_pValue, prm1, prm2);
                pElem = pElem -> _pNext;
            }
            return;
        }
    }
};

//////////////////////////////////////////////////////////////////

/**
 * ͎
 */

template<class T>
GgafLinkedListRing<T>::GgafLinkedListRing(int prm_extend_relation_num) :
    GgafObject() {
    _num_elem = 0;
    _pElemActive = nullptr;
    _pElem_first = nullptr;
    _relation_num = prm_extend_relation_num;
}


//template<class T>
//T* GgafLinkedListRing<T>::getFromFirst(int n) {
//    if (_pElem_first == nullptr) {
//        return nullptr;
//    }
//    Elem* pElem_return = _pElem_first;
//    for (int i = 0; i < n; i++) {
//        pElem_return = pElem_return->_pNext;
//    }
//    return pElem_return->_pValue;
//}



template<class T>
void GgafLinkedListRing<T>::addNext(T* prm_pNew, bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwGgafCriticalException("[GgafLinkedListRing::addNext()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);
    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_last_flg = true;
        pElem->_is_first_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        Elem* pMy = _pElemActive;
        if (pMy->_is_last_flg) {
            pMy->_is_last_flg = false;
            pElem->_is_last_flg = true;
            pElem->_is_first_flg = false;
        }
        Elem* pMyNext = _pElemActive->_pNext;
        pMy->_pNext = pElem;
        pElem->_pPrev = pMy;
        pElem->_pNext = pMyNext;
        pMyNext->_pPrev = pElem;
    }
    _num_elem++;
}

template<class T>
void GgafLinkedListRing<T>::addPrev(T* prm_pNew, bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwGgafCriticalException("[GgafLinkedListRing::addPrev()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);
    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_last_flg = true;
        pElem->_is_first_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        Elem* pMy = _pElemActive;
        if (pMy->_is_first_flg) {
            pMy->_is_first_flg = false;
            pElem->_is_first_flg = true;
            pElem->_is_last_flg = false;
            _pElem_first = pElem;
        }
        Elem* pMyPrev = _pElemActive->_pPrev;
        pMyPrev->_pNext = pElem;
        pElem->_pPrev = pMyPrev;
        pElem->_pNext = pMy;
        pMy->_pPrev = pElem;
    }
    _num_elem++;
}

template<class T>
void GgafLinkedListRing<T>::addLast(T* prm_pNew, bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwGgafCriticalException("[GgafLinkedListRing::addLast()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);

    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_first_flg = true;
        pElem->_is_last_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        //Qڈȍ~
        pElem->_is_first_flg = false;
        pElem->_is_last_flg = true;
        Elem* pLastElem = _pElem_first->_pPrev;
        pLastElem->_is_last_flg = false;
        pLastElem->_pNext = pElem;
        pElem->_pPrev = pLastElem;
        pElem->_pNext = _pElem_first;
        _pElem_first->_pPrev = pElem;
    }
    _num_elem++;
}


template<class T>
void GgafLinkedListRing<T>::addFirst(T* prm_pNew, bool prm_is_delete_value) {
//#ifdef MY_DEBUG
//    if (prm_pNew == nullptr) {
//        throwGgafCriticalException("[GgafLinkedListRing::addFirst()] Error! nullptrł");
//    }
//#endif
    Elem* pElem = NEW Elem(prm_pNew, _relation_num, prm_is_delete_value);
    if (_pElem_first == nullptr) {
        //ŏ̂P
        pElem->_is_first_flg = true;
        pElem->_is_last_flg = true;
        pElem->_pNext = pElem;
        pElem->_pPrev = pElem;
        _pElemActive = pElem;
        _pElem_first = pElem;
    } else {
        Elem* pFirstElem = _pElem_first;
        Elem* pLastElem = _pElem_first->_pPrev;
        pLastElem->_pNext = pElem;
        pElem->_pPrev = pLastElem;
        pElem->_pNext = pFirstElem;
        pFirstElem->_pPrev = pElem;
        pFirstElem->_is_first_flg = false;

        pElem->_is_first_flg = true;
        pElem->_is_last_flg = false;
        _pElem_first = pElem;
    }
    _num_elem++;
}

template<class T>
T* GgafLinkedListRing<T>::next() {
    _pElemActive = _pElemActive->_pNext;
    return _pElemActive->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::prev() {
    _pElemActive = _pElemActive->_pPrev;
    return _pElemActive->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::first() {
    _pElemActive = _pElem_first;
    return _pElemActive->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::last() {
    _pElemActive = _pElem_first->_pPrev; //Ȃ̂ŁA擪̈O͖
    return _pElemActive->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::current(int n) {
    Elem* pElem = _pElem_first;
    for (int i = 0; i < n; i++) {
        pElem = pElem->_pNext;
    }
    _pElemActive = pElem;
    return _pElemActive->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::gotoRelation(int prm_connection_index) {
#ifdef MY_DEBUG
    if (_relation_num-1 < prm_connection_index) {
        throwGgafCriticalException("GgafLinkedListRing<T>::gotoRelation ڑvfԍ͈̔͊OłBprm_connection_index="<<prm_connection_index);
    }
#endif
    _pElemActive = _pElemActive->_papRelation[prm_connection_index];
#ifdef MY_DEBUG
    if (_pElemActive == nullptr) {
        throwGgafCriticalException("GgafLinkedListRing<T>::gotoRelation ڑvfԍ̗vfݒłBprm_connection_index="<<prm_connection_index);
    }
#endif
    return _pElemActive->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::getNext() {
    return _pElemActive->_pNext->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::getNext(int n) {
    Elem* pElem_return = _pElemActive;
    for (int i = 0; i < n; i++) {
        pElem_return = pElem_return->_pNext;
    }
    return pElem_return->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::getFromFirst(int n) {
    if (_pElem_first == nullptr) {
        return nullptr;
    }
    Elem* pElem_return = _pElem_first;
    for (int i = 0; i < n; i++) {
        pElem_return = pElem_return->_pNext;
    }
    return pElem_return->_pValue;
}


template<class T>
T* GgafLinkedListRing<T>::getPrev() {
    return _pElemActive->_pPrev->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::getPrev(int n) {
    Elem* pElem_return = _pElemActive;
    for (int i = 0; i < n; i++) {
        pElem_return = pElem_return->_pPrev;
    }
    return pElem_return->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::getFirst() {
    return _pElem_first->_pValue;
}

template<class T>
T* GgafLinkedListRing<T>::getLast() {
    return _pElem_first->_pPrev->_pValue; //Ȃ̂ŁA擪̈O͖
}


template<class T>
T* GgafLinkedListRing<T>::getCurrent() {
    if (_pElemActive == nullptr) {
        return nullptr;
    } else {
        return _pElemActive->_pValue;
    }
}

template<class T>
T* GgafLinkedListRing<T>::getRelation(int prm_connection_index) {
#ifdef MY_DEBUG
    if (_relation_num-1 < prm_connection_index) {
        throwGgafCriticalException("GgafLinkedListRing<T>::getRelation ڑvfԍ͈̔͊OłBprm_connection_index="<<prm_connection_index);
    }
#endif
    Elem* pE = _pElemActive->_papRelation[prm_connection_index];
    if (pE) {
        return pE->_pValue;
    } else {
        return nullptr;
    }
}


template<class T>
int GgafLinkedListRing<T>::getCurrentIndex() {
    if (_pElemActive == nullptr) {
        return -1;
    } else {
        Elem* pElem = _pElem_first;
        for (int i = 0; i < _num_elem; i++) {
            if (pElem == _pElemActive) {
                return i;
            } else {
                pElem = pElem -> _pNext;
            }
        }
        return -1;
    }
}


template<class T>
bool GgafLinkedListRing<T>::isLast() {
    return _pElemActive->_is_last_flg;
}

template<class T>
bool GgafLinkedListRing<T>::isFirst() {
    return _pElemActive->_is_first_flg;
}

template<class T>
T* GgafLinkedListRing<T>::set(T* prm_pVal, bool prm_is_delete_value) {
    T* pValue = _pElemActive->_pValue;
    bool is_delete_value = _pElemActive->_is_delete_value;
    _pElemActive->_pValue = prm_pVal;
    _pElemActive->_is_delete_value = prm_is_delete_value;
    if (is_delete_value) {
        GGAF_DELETE(pValue);
        return nullptr;
    } else {
        return pValue;
    }
}

template<class T>
T* GgafLinkedListRing<T>::remove() {
    Elem* pMy = _pElemActive;
    _num_elem--;
    if (pMy->_is_first_flg && pMy->_is_last_flg) {
        //vfP̏ꍇ
        _pElemActive = nullptr;
        _pElem_first = nullptr;
        T* r = pMy->_pValue;
        GGAF_DELETE(pMy);
        return r;
    } else {
        //AO
        Elem* pMyNext = _pElemActive->_pNext;
        Elem* pMyPrev = _pElemActive->_pPrev;
        //ׂ̃m[hmqAwȂB
        pMyPrev->_pNext = pMyNext;
        pMyNext->_pPrev = pMyPrev;
        if (pMy->_is_last_flg) { //vfȂ
            pMyPrev->_is_last_flg = true; //O̗vfVɂȂ
        }
        if (pMy->_is_first_flg) { //vf擪Ȃ
            _pElem_first = pMyNext;
            pMyNext->_is_first_flg = true; //̗vfV擪ɂȂ
        }
        _pElemActive = pMyNext; //Jgvf next ɍXVB
        T* r = pMy->_pValue;
        GGAF_DELETE(pMy);
        return r;
    }
}

template<class T>
int GgafLinkedListRing<T>::removeAll() {
    Elem* pElem = _pElem_first;
    int n = 0;
    while (pElem) {
        if (pElem->_is_last_flg) {
            GGAF_DELETE(pElem);
            break;
        } else {
            Elem* pTmp = pElem -> _pNext;
            GGAF_DELETE(pElem);
            pElem = pTmp;
        }
    }
    _num_elem = 0;
    _pElemActive = nullptr;
    _pElem_first = nullptr;
    return n;
}

template<class T>
int GgafLinkedListRing<T>::indexOf(T* prm_pVal) {
    if (_pElem_first == nullptr) {
        return -1;
    }
    int r = 0;
    Elem* pElem = _pElem_first;
    while (true) {
        if (pElem->_pValue == prm_pVal) {
            return r;
        } else {
            if (pElem->_is_last_flg) {
                break;
            } else {
                pElem = pElem -> _pNext;
                r++;
            }
        }
    }
    return -1;
}


template<class T>
int GgafLinkedListRing<T>::length() {
    return _num_elem;
}

template<class T>
GgafLinkedListRing<T>::~GgafLinkedListRing() {
    _TRACE_("GgafLinkedListRing<T>::~GgafLinkedListRing() _num_elem="<<_num_elem);
    //Ɏqꍇ
    if (_pElem_first) {
        //܂qdelete
        if (_num_elem == 1) {
            //qvf͂P̏ꍇ
            GGAF_DELETE(_pElem_first);
            _pElem_first = nullptr;
            _pElemActive = nullptr;
            _num_elem = 0;

        } else {
            //qvf͂Qȏ̏ꍇ
            Elem* pLast = _pElem_first->_pPrev;
            Elem* pLastPrev = pLast->_pPrev;
            while (true) {
                GGAF_DELETE(pLast); //delete
                if (pLastPrev->_is_first_flg) {
                    GGAF_DELETE(_pElem_first); //pSubLastPrev == _pSubFirst ł
                    _pElem_first = nullptr;
                    _pElemActive = nullptr;
                    _num_elem = 0;
                    break;
                }
                pLast = pLastPrev;
                pLastPrev = pLastPrev->_pPrev;
            }
        }
    }
}

}
#endif /*GGAFCORE_GGAFLINKEDLISTRING_H_*/
