#ifndef GGAFCORE_GGAFGACTORY_H_
#define GGAFCORE_GGAFGACTORY_H_
#include <limits.h>

namespace GgafCore {

/**
 * CX^XHNX .
 * CXbhA(GgafOrder)nƁAʃXbhɂ̃CX^X𐶐(new)܂B<BR>
 * oオCX^X(iƌĂ)̃|C^B͍HŃXgbNACKvɉďi
 * oƂo܂<BR>
 * y⑫z<BR>
 * ȂȂ₱̂B́AʃCX^X鎞_ŐȂ΂Ȃ悤ȌŁA
 * 炩ɏ߁B<BR>
 * Xe[W̃[fBOÂ悭̂łA{XOŁAQ[isuuEbvƎ~܂(킩邩Ȃ)
 * ̂𖳂߂łB<BR>
 * 𑁂߂ɂĂƁAX[YɃQ[is͂Ɩژ_ށB<BR>
 * @version 1.00
 * @since 2007/12/27
 * @author Masatoshi Tsuge
 */
class GgafFactory {
    friend class GgafGod;

private:
    /**
     * Hɒs .
     * @param prm_id	IDԍ
     * @param prm_pFunc	ۂɐs֐̃|C^
     * @param prm_pOrderer 
     * @param prm_pArg1	s֐ւ̈1
     * @param prm_pArg2	s֐ւ̈2
     * @param prm_pArg3	s֐ւ̈3
     *
     */
    static void order(uint32_t prm_id,
                      GgafObject* (*prm_pFunc)(void*, void*, void*),
                      GgafObject* prm_pOrderer,
                      void* prm_pArg1,
                      void* prm_pArg2,
                      void* prm_pArg3);

    /**
     * io .
     * ꍇA܂ő҂B<BR>
     * @param   prm_id	IDԍ
     * @param   prm_org ifobOpj
     * @return	ĩ|C^
     */
    static void* obtain(uint32_t prm_id, GgafObject* prm_org);

public:
    /** 擪̒ */
    static GgafOrder* ROOT_ORDER;
    /** ݐ̒ */
    static GgafOrder* CREATING_ORDER;
    //CREATING_ORDER ́ASĐς݂̏ꍇAŏIwÂ
    //SĐς݂AiSĎ擾Ă܂ꍇ nullptr ɂȂB
    //_is_last_order_flg == false ɔ肵AŏIłȂȂiVK΁jA
    //sĎɐi߂B _is_last_order_flg == false ɂȂ܂ŐÂ

    /** [r]tO(_삷) */
    static volatile bool _is_working_flg;
    /** [r]xރtO */
    static volatile bool _have_to_rest_flg;
    /** [r]xłtO */
    static volatile bool _is_resting_flg;
    /** [r]SXI */
    static volatile bool _was_finished_flg;

public:
    /**
     * HɃAN^[쐬̒siCXbhgpj .
     * CĂяo܂B<BR>
     * @param prm_id    IDԍ
     * @param prm_pFunc ۂɐs֐̃|C^
     * @param prm_pOrderer IuWFNg
     * @param prm_pArg1 s֐ւ̈1
     * @param prm_pArg2 s֐ւ̈2
     * @param prm_pArg3 s֐ւ̈3
     */
    template<class X>
    static void orderActor(uint32_t prm_id,
                           X* (*prm_pFunc)(void*, void*, void*),
                           GgafObject* prm_pOrderer,
                           void* prm_pArg1,
                           void* prm_pArg2,
                           void* prm_pArg3) {
        order(prm_id, (GgafObject* (*)(void*, void*, void*))prm_pFunc, prm_pOrderer, prm_pArg1, prm_pArg2, prm_pArg3);
    }

    /**
     * HɃV[쐬̒siCXbhgpj .
     * CĂяo܂B<BR>
     * @param prm_id	IDԍ
     * @param prm_pFunc	ۂɐs֐̃|C^
     * @param prm_pOrderer IuWFNg
     * @param prm_pArg1	s֐ւ̈1
     * @param prm_pArg2	s֐ւ̈2
     * @param prm_pArg3	s֐ւ̈3
     */
    template<class X>
    static void orderScene(uint32_t prm_id,
                           X* (*prm_pFunc)(void*, void*, void*),
                           GgafObject* prm_pOrderer,
                           void* prm_pArg1,
                           void* prm_pArg2,
                           void* prm_pArg3) {
        order(prm_id, (GgafObject* (*)(void*, void*, void*))prm_pFunc, prm_pOrderer, prm_pArg1, prm_pArg2, prm_pArg3);
    }

    /**
     * AN^[oBiCXbhgpj .
     * CĂяo܂B<BR>
     * ꍇA܂ő҂B<BR>
     * @param   prm_id	ID
     * @param   prm_org ifobOpj
     * @return	ꂽAN^[̃|C^
     */
    static GgafMainActor* obtainActor(uint32_t prm_id, GgafObject* prm_org);

    /**
     * V[oBiCXbhgpj .
     * CĂяo܂B<BR>
     * ꍇA܂ő҂B<BR>
     * @param   prm_id	ID
     * @param   prm_org ifobOpj
     * @return	ꂽV[̃|C^
     */
    static GgafMainScene* obtainScene(uint32_t prm_id, GgafObject* prm_org);


    template<class X>
    static X* makeObject(X* (*prm_pFunc)(void*, void*, void*),
                         GgafObject* prm_pOrderer,
                         void* prm_pArg1,
                         void* prm_pArg2,
                         void* prm_pArg3,
                         GgafObject* prm_org) {
        order(UINT_MAX, (GgafObject* (*)(void*, void*, void*))prm_pFunc, prm_pOrderer, prm_pArg1, prm_pArg2, prm_pArg3);
        return (X*)(obtain(UINT_MAX, prm_org));
    }


    /**
     * ioオĂ邩ׂBiCXbhgpj .
     * @param   prm_id   ID
     * @return   ID̏i̐i(-2:Hꎩ̂ĂȂ/-1:炵ĂȂ/0:ς݂ōHꖢ/1:/2:ς݁j
     */
    static int chkProgress(uint32_t prm_id);

    /**
     * H|iCXbhgpj .
     * C̐_Ăяo܂B<BR>
     * ROOT_ORDER wĂ鐻i̘AXgSĉ<BR>
     * ӁFKȉ̂悤ɃNeBJZNVň͂ŌĂяoĂIB<BR>
     * R[h၄ <BR>
     *  ___BeginSynchronized1; // ----->rJn<BR>
     * GgafFactory::clean();<BR>
     *  ___EndSynchronized1; // <----- rI<BR>
     */
    static void clean();

    /**
     * ғBiHXbhC[vj.
     * _iGgafGodjݒ莞ɕʃXbhňxsA\bhŖ[vĂ܂B<BR>
     * ΍쐬AXgbN܂B<BR>
     * _ʂ܂ŁiAvI܂ŁjiɉғłB<BR>
     */
    static unsigned __stdcall work(void* prm_arg);

    /**
     * Hꎞx~w iCXbhgpj .
     * ĂяoĂɋx~ԂɂȂƂ͌܂B<BR>
     * isResting() ŊSx~܂Œׂ鑱Kv܂B<BR>
     */
    static void beginRest();
    /**
     * H̏Ԃ擾iCXbhgpj .
     * @return true=x~/false=ғ
     */
    static bool isResting();

    /**
     * Hx~̉w iCXbhgpj .
     */
    static void finishRest();

    template<class X>
    static X* create(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((char*)p1);
        return p;
    }
    template<class X>
    static X* create2(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((char*)p1, (char*)p2);
        return p;
    }

    template<class X>
    static X* createActor(void* p1, void* p2, void* p3) {
        //p1 : 
        X* p = NEW X((char*)p1);
        return p;
    }

    template<class X>
    static X* createScene(void* p1, void* p2, void* p3) {
        //Sceneňԑ`̈B
        //p1 : ʖ
        X* p = NEW X((char*)p1);
        return p;
    }


};
#define orderSceneToFactory(ID, CLASS, NAME) (GgafCore::GgafFactory::orderScene<CLASS>((ID),GgafCore::GgafFactory::createScene, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr)))
#define orderActorToFactory(ID, CLASS, NAME) (GgafCore::GgafFactory::orderActor<CLASS>((ID),GgafCore::GgafFactory::createActor, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr)))
#define obtainActorFromFactory(ID) (GgafCore::GgafFactory::obtainActor((ID),this))
#define obtainSceneFromFactory(ID) (GgafCore::GgafFactory::obtainScene((ID),this))
#define createInFactory(CLASS, NAME) (GgafCore::GgafFactory::makeObject<CLASS>(GgafCore::GgafFactory::create, this, (void*)(NAME),(void*)(nullptr),(void*)(nullptr),this))
#define createInFactory2(CLASS, NAME, MODEL) (GgafCore::GgafFactory::makeObject<CLASS>(GgafCore::GgafFactory::create2, this, (void*)(NAME),(void*)(MODEL),(void*)(nullptr),this))

}
#endif /*GGAFCORE_GGAFGACTORY_H_*/
