#ifndef GGAFCORE_GGAFELEMENT_H_
#define GGAFCORE_GGAFELEMENT_H_
#include "jp/ggaf/core/GgafNode.hpp"

#include "jp/ggaf/core/GgafProgress.h"
#include "jp/ggaf/core/GgafGarbageBox.h"
#include "jp/ggaf/core/exception/GgafCriticalException.h"

namespace GgafCore {

/**
 * m[h(GgafNode<T>)ɁAlXȏԊǗ@\ǉNX .
 * ^XNVXeɕKvȏԑJڋ@\ĂB<BR>
 * t[A_(GgafGod)́A̐(GgafUniverse)ɁÃ\bhɌĂяodg݂ɂȂĂB<BR>
 * nextFrame() > behave() > settleBehavior() > judge() > [preDraw() > draw() > afterDraw()] > doFinally() <BR>
 * AvP[Vɓoꂷm[h͑SāAu̐ṽc[ɏ邽߁ASm[hɑ΂ďL̏sB
 * L̓AnextFrame() ̂ݖt[KsB<BR>
 * behave(), settleBehavior(), judge(), doFinally() ́AԃtO(_is_active_in_the_tree_flg) trueAA
 * ꎞ~tO(_was_paused_flg) false ̏ꍇsB<BR>
 * preDraw(), draw(), afterDraw() ́At[܂ł̎cԂɗ]TꍇAsB<BR>
 * t[܂ł̎cԂɗ]TꍇA_͂3\bhXLbvB
 * AAXLbvƂĂAMAX_SKIP_FRAME t[ɂP͕KsB<BR>
 * L nextFrame() ` doFinally() ̏ʂŃI[o[Ch΁A^XNVXe̊łB<BR>
 * A\bh̒ڃI[o[Ch͔񐄏łBI[o[ChpɊe\bhŃR[obN<BR>
 * z֐(processXxxxxx()) pӂĂ̂ŁÃ\bhI[o[ChĉB<BR>
 * initialize() ́AL nextFrame() ` doFinally() ꂩĂяoOɃCX^XƂɂP񂾂Ă΂dg݂ɂȂĂB<BR>
 * tO(_can_live_flg)falsȅꍇ́AnextFrame() ` doFinally() ͑SĎsȂB<BR>
 * (NXGgafFactor)
 * @version 1.00
 * @since 2008/08/21
 * @author Masatoshi Tsuge
 */
template<class T>
class GgafElement : public GgafNode<T> {

private:

    /**
     * c[\ɂāAċAĂяosB
     * @param pFunc ċAĂяo郁\bh
     */
    inline void callRecursive(void (GgafElement<T>::*pFunc)()) {
        T* pElementTemp = GgafNode<T>::_pSubFirst;
        while (pElementTemp) {
            (pElementTemp->*pFunc)(); //s
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }

    /**
     * c[\ɂāAċAĂяosB
     * @param pFunc ċAĂяo郁\bh(frame L)
     * @param prm_frame pFunc̈łframe
     */
    inline void callRecursive(void (GgafElement<T>::*pFunc)(frame), frame prm_frame) {
        T* pElementTemp = GgafNode<T>::_pSubFirst;
        while (pElementTemp) {
            (pElementTemp->*pFunc)(prm_frame); //s
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }


public:
    /** [r]_ւ̋ߓ */
    GgafGod* _pGod;
    /** [r]initializesꂽǂ̃tO(true=sꂽ) */
    bool _was_initialize_flg;
    /** [r]m[ha(addSubꂽj̃t[v(AA_was_paused_flg = true ͉Zꖳ) */
    frame _frame_of_life;
    /** [r]m[ha(addSubꂽjAUt[v(AA_was_paused_flg = true  _is_active_flg = false ͉Zꖳ) */
    frame _frame_of_behaving;
    /** [r]m[hJn(onActive())̐Ut[v(AA_was_paused_flg = true  _is_active_flg = false ͉Zꖳ) */
    frame _frame_of_behaving_since_onActive;

    /** [r]m[htO */
    bool _is_active_flg;
    /** [r]m[htO(c[l) */
    bool _is_active_in_the_tree_flg;
    /** [r]ꎞ~tO */
    bool _was_paused_flg;
    /** [r]m[htO */
    bool _can_live_flg;

    /** [r]t[̈ꎞ~tOAt[̃t[Z _was_paused_flg ɔf */
    bool _was_paused_flg_in_next_frame;
    /** [r]ItO */
    bool _will_end_after_flg;
    /** [r]I\ _frame_of_life */
    frame _frame_of_life_when_end;


    /** [r]ƂŊ\tO */
    bool _will_activate_after_flg;
    /** [r]Jn\ _frame_of_life */
    frame _frame_of_life_when_activation;

    /** [r]ƂŔ񊈓\tO */
    bool _will_inactivate_after_flg;
    /** [r]I\ _frame_of_life */
    frame _frame_of_life_when_inactivation;

    /** [r]m[hɐ؂ւ(_is_active_flg  false  true)uԂɂPt[ZbgtO */
    bool _on_change_to_active_flg;
    /** [r]m[h~ɐ؂ւ(_is_active_flg  true  false)uԂɂPt[ZbgtO */
    bool _on_change_to_inactive_flg;

    /** [r]擪m[hɈړ\tOAt[̃t[ZɁAm[h擪m[hɈړ */
    bool _will_mv_first_in_next_frame_flg;
    /** [r]m[hɈړ\tOAt[̃t[ZɁAm[hm[hɈړ */
    bool _will_mv_last_in_next_frame_flg;
    /** [r]Jgt[ňxłZbgstrueBt[ false ɍXV */
    bool _is_already_reset;
    /** [r]ԐiǗIuWFNg */
    GgafProgress* _pProg;

public:
    /**
     * RXgN^
     * @param prm_name m[h́ij[Nɂĉj
     */
    GgafElement(const char* prm_name);

    /**
     * fXgN^Bc[m[hB .
     */
    virtual ~GgafElement();

    /**
     * |(sΏہFzm[hSāAgdelete܂) .
     * _Ԃɗ]TłƂɁA_ĂтB<BR>
     * zm[h̒Ƀm[htO(_can_live_flg) false ɂȂĂm[h
     * prm_num_cleaning  delete B<BR>
     * @param prm_num_cleaning IuWFNg
     */
    virtual void clean(int prm_num_cleaning);

    /**
     * m[h(sΏہFthiŝ) .
     * CX^XAꂩĂяoOɁAŏɕKP񂾂ĂяoB<BR>
     * ⑫Finitialize()ĂяoꂽAreset() ĂяoB
     */
    virtual void initialize() = 0;

    /**
     * m[h̃t[ZƁAt[JnɂĂ̂낢ȏ(sΏہFc[S) .
     * t[KsAɗlXȏԃtO̍XVsB <BR>
     * _is_active_flg_in_next_frame _was_paused_flg_in_next_frame _can_live_flg_in_next_frame <BR>
     * _is_active_flg _was_paused_flg _can_live_flg ɔfiRs[jB<BR>
     * ܂A_will_mv_first_in_next_frame_flg, _will_mv_last_in_next_frame_flg  true ̏ꍇ́A<BR>
     * ꂼAm[h̐擪m[hւ̈ړAm[hւ̈ړsB<BR>
     * ̌Azm[hSĂ nextFrame() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ nextFrame() sA behave() s邱ƂɂȂB<BR>
     * ̂悤ȍ\̏ꍇAs͇@`L̏ƂȂB<BR>
     * m[hԂŎQƊ֌Wꍇ́AӂKvB<BR>
     * <pre>
     * (o)̇@o(o)
     *         
     * (d)̇A`̇EȧJḃKċLd(`)
     *             
     *                                       
     * (g)̇BėCḟDg(e)    (k)̇FḣGi̇Hj̇Ik(h)
     *
     * {͐擪̏AATu݂ΐɎsA݂ȂΎ()sB
     * </pre>
     * \bhɁw(sΏہFc[S)xƋLqĂꍇ́ASďL̏ŎsB
     */
    virtual void nextFrame();

    /**
     * m[h̃t[̐U镑(sΏہFc[S) .
     * ̏ł́ASm[hWړsƂƂB<BR>
     * p processBehavior() R[obN邽߂̃tȌ́A<BR>
     * tOAtOZbgAꎞ~tOAZbg<BR>
     * i _is_active_in_the_tree_flg && !_was_paused_flg && _can_live_flg j̏ꍇłB <BR>
     * behave()  z֐ processBehavior() R[Az̃m[hSĂɂ behave() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNŖ{\bh𒼐ڌĂяosȂƂƂB<BR>
     * ʃNXł̓R[ processBehavior() I[o[Chċ̓IȍWړWbNB <BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ behave() sA settleBehavior() s邱ƂɂȂB<BR>
     */
    virtual void behave();

    /**
     * m[h̃t[̐U镑㏈(sΏہFc[S) .
     * ̏ł́ASm[hWړĂ邱Ƃۏ؂ꂽ̏sƂ݌vB<BR>
     * XVW񂩂Aɔ̗lXȃXe[^X̍XVōsړIƂ<BR>
     * p processSettlementBehavior() R[obN邽߂̃tȌ́A<BR>
     * behave()ƓtOAtOZbgAꎞ~tOAZbgB<BR>
     * ܂ ( _is_active_in_the_tree_flg && !_was_paused_flg && _can_live_flg )̏ꍇłB <BR>
     * settleBehavior()́Az֐ processSettlementBehavior() R[Az̃m[hSĂɂ settleBehavior() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNŖ{\bh𒼐ڌĂяosȂƂƂB<BR>
     * ʃNXł̓R[ processSettlementBehavior() I[o[ChăWbN邱ƂƂB <BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ settleBehavior() sA judge() s邱ƂɂȂB<BR>
     */
    virtual void settleBehavior();

    /**
     * m[h̃t[̔菈(sΏہFc[S) .
     * ̏ł́Am[hԂ̗lXȔ菈sƂ݌vB<BR>
     * Sm[hWړƔȂXe[^Xނ̍XVSɊĂOƂ鏈sB<BR>
     * p processJudgement() R[obN邽߂̃tȌ́Abehave()ƓA<BR>
     * tOAtOZbgAꎞ~tOAZbg<BR>
     * ܂ ( _is_active_in_the_tree_flg && !_was_paused_flg && _can_live_flg )̏ꍇ <BR>
     * judge()  z֐ processJudgement() R[Az̃m[hSĂɂ judge() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNŖ{\bh𒼐ڌĂяosȂƂƂB<BR>
     * ʃNXł̓R[ processJudgement() I[o[ChăWbN <BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ judge() sA<BR>
     * _(GgafGod)͂̌At[܂ł̎cԂɗ]T preDraw()  doFinally() s邱ƂɂȂB<BR>
     */
    virtual void judge();

    /**
     * m[h̃t[̕`掖O(sΏہFc[S)it[XLbvČĂяoȂꍇBj .
     * p processPreDraw() R[obŃAtOAtOZbg<BR>
     * (܂ _is_active_flg && _can_live_flg)̏ꍇłB <BR>
     * processPreDraw() R[Az̃m[hSĂɂ preDraw() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processPreDraw() I[o[ChăWbN <BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ preDraw() sA draw() s邱ƂɂȂB<BR>
     */
    virtual void preDraw();

    /**
     * m[h̃t[̕`{(sΏہFc[S)it[XLbvČĂяoȂꍇBj .
     * p processDraw() R[obŃAtOAtOZbg<BR>
     * (܂ _is_active_in_the_tree_flg && _can_live_flg)̏ꍇłB <BR>
     * processDraw() R[Az̃m[hSĂɂ draw() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processDraw() I[o[ChăWbN <BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ draw() sA afterDraw() s邱ƂɂȂB<BR>
     */
    virtual void draw();

    /**
     * m[h̃t[̕`掖㏈(sΏہFc[S)it[XLbvČĂяoȂꍇBj .
     * p processAfterDraw() R[obŃAtOAtOZbg<BR>
     * (܂ _is_active_in_the_tree_flg && _can_live_flg)̏ꍇłB <BR>
     * processAfterDraw() R[Az̃m[hSĂɂ afterDraw() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processAfterDraw() I[o[ChăWbN <BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ afterDraw() sA doFinally() s邱ƂɂȂB<BR>
     */
    virtual void afterDraw();

    /**
     * m[h̃t[̍ŏI(sΏہFc[S) .
     * WړA菈A`揈IɁAŌɍsnsƂ݌vB<BR>
     * p processFinal() R[obŃA
     * tOAtOZbgAꎞ~tOAZbg<BR>
     * i_is_active_in_the_tree_flg && !_was_paused_flg && _can_live_flgj̏ꍇłB <BR>
     * processFinal() R[Az̃m[hSĂɂ doFinally() ċAIɎsB<BR>
     * _(GgafGod)s郁\bhłAʏ͉ʃWbNł͎gpȂ͂łB<BR>
     * ʃNXł̓R[ processFinal() I[o[ChăWbN <BR>
     * _(GgafGod)́A̐(GgafUniverse)ɑ΂ doFinally() sA<BR>
     * t[܂ł̎cԂɗ]T clean() sB<BR>
     * ̌ nextFrame() s邱ƂɂȂB<BR>
     */
    virtual void doFinally();

    /**
     * 񊈓ɐ؂ւ̃R[obN .
     * 񊈓Ԃ犈ԂɕωƂɁA behave() OɂPR[obNB<BR>
     * KvɉăI[o[ChB<BR>
     * R[^C~Oڍׁ
     * @񊈓ɐ؂ւ
     * nextFrame() AOt[̏ԃtOu񊈓ԁvŁAt[̏ԃtOuԁvƂȂꍇA
     * nextFrame() ŁAt[̏ԃtOuԁvɂAt[Z R[obN
     * AAPt[ڂ̎
     * ۂɂ݂͑ȂOt[(0t[)̏ԃtOȀlŁu񊈓ԁvƂĂׁB
     * A߂ nextFrame() ꍇAnextFrame() ŃR[obN邱ƂɂȂB
     */
    virtual void onActive() {
    }

    /**
     * 񊈓ɐ؂ւ̃R[obN .
     * Ԃ񊈓ԂɕωƂɂPR[obNB<BR>
     * Ăяo^C~O̓t[ZłBʏ behave() OɎsB<BR>
     * KvɉăI[o[ChB<BR>
     */
    virtual void onInactive() {
    }

    /**
     * t[̌ʐU镑B([U[p) .
     * behave() ̏擪ŃR[obNB<BR>
     * ̃o֐ʃNXŃI[o[ChāAm[hʂ̐U镑B<BR>
     * z肵ĂU镑Ƃ́AɍWvZƈړłB<BR>
     * {o֐R[obNƌ́ASm[h΂āAnextFrame() sς݂ł邱Ƃۏ؂B<BR>
     */
    virtual void processBehavior() = 0;

    /**
     * t[̌ʐU镑㏈B(t[[Np) .
     */
    virtual void processSettlementBehavior() {}

    /**
     * t[̌ʔfB([U[p) .
     * judge() ̏擪ŃR[obNB<BR>
     * ̃o֐I[o[ChāAm[hʔfLqB<BR>
     * {o֐R[obNƌ́ASm[h΂ĂāAprocessBehavior() sς݂ł邱Ƃۏ؂B<BR>
     * {o֐݈̑Ӑ}ƂāAprocessBehavior() ōWړSĊA
     * {o֐œ蔻菈Ƃgz肵ĂB<BR>
     */
    virtual void processJudgement() = 0;

    /**
     * m[h̃t[̌ʕ`掖OB({t[[Np) .
     * preDraw() ̏擪ŃR[obNB AA_(GgafGod)`XLbvꍇAt[ŌĂяo܂B<BR>
     * ̃o֐I[o[ChāAm[hʕ`掖OB<BR>
     * ʕ`掖OƂ́Aɓwi`ȂǂłB<BR>
     * {o֐R[obNƌ́ASm[h΂āAprocessJudgement() sς݂ł邱Ƃۏ؂B<BR>
     * ɁA{o֐sAprocessDraw()AprocessAfterDraw() Ăяo邱Ƃۏ؂B
     */
    virtual void processPreDraw() {};

    /**
     * m[h̃t[̌ʕ`{B({t[[Np^[U[p) .
     * draw() ̏擪ŃR[obNB AApreDraw() Ɠlɐ_(GgafGod)`XLbvꂽꍇ́At[ŌĂяo܂B<BR>
     * ̃o֐I[o[ChāAm[hʕ`{B<BR>
     * ʕ`{Ƃ͎ɃLN^Awi̕`z肵ĂB
     * {o֐R[obNƌ́ASm[h΂āAprocessPreDraw() sς݂ł邱Ƃۏ؂B<BR>
     */
    virtual void processDraw() = 0;

    /**
     * m[h̃t[̌ʕ\㏈LqB({t[[Np) .
     * afterDraw() ̏擪ŃR[obNB AApreDraw() Ɠlɐ_(GgafGod)`XLbvꂽꍇ́At[ŌĂяo܂B<BR>
     * ̃o֐I[o[ChāAm[hʕ\㏈B<BR>
     * ʕ\㏈Ƃ́AőOʃC[ŎtF[hGtFNgAɍőOʂɕ\\ȂǂłB<BR>
     * {oR[obNƌ́ASm[h΂āAprocessDraw() sς݂ł邱Ƃۏ؂B<BR>
     */
    virtual void processAfterDraw() {};

    /**
     * m[h̃t[̌ʏI[B({t[[Np) .
     * doFinally() ̏擪ŃR[obNB<BR>
     * ̃o֐ʃNXŃI[o[ChāAm[hʂ̏I[B<BR>
     * I[Ƃ́AtOǗ̎sȂǂłB<BR>
     * z肵ĂU镑Ƃ́AɍWvZƈړłB̑ȂłǂłB<BR>
     * {o֐R[obNƌ́ASm[h΂āAprocessJudgement() sς݂ `揈͏IĂ邱Ƃۏ؂B<BR>
     */
    virtual void processFinal() {};

    /**
     * m[hƎm[heɂm[hSĂɃCxgbZ[Wʒm(ʒmΏہFc[S) .
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * @param prm_no CxgbZ[Wԍ
     * @param prm_pSource  Cxgpėp|C^
     */
    virtual void throwEventUpperTree(hashval prm_no, void* prm_pSource);

    /**
     * m[hƎm[heɂm[hSĂɃCxgbZ[Wʒm(ʒmΏہFc[S) .
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * ėp void* ɂ́Athis ݒ肳܂B<BR>
     * @param prm_no CxgbZ[Wԍ
     */
    virtual void throwEventUpperTree(hashval prm_no) {
        throwEventUpperTree(prm_no, this);
    }


    /**
     * m[hƂ̔zm[hSĂɃCxgbZ[Wʒm܂(ʒmΏہF̐eS) .
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * @param prm_no CxgbZ[Wԍ
     * @param prm_pSource  Cxgpėp|C^
     */
    virtual void throwEventLowerTree(hashval prm_no, void* prm_pSource);

    /**
     * m[hƂ̔zm[hSĂɃCxgbZ[Wʒm܂(ʒmΏہF̐eS) .
     * Cxg󂯎鑤́AonCatchEvent(hashval, void) KvłB<BR>
     * g onCatchEvent(hashval, void) ɂʒm̂ŒӂĉB<BR>
     * ėp void* ɂ́Athis ݒ肳܂B<BR>
     * @param prm_no CxgbZ[Wԍ
     */
    virtual void throwEventLowerTree(hashval prm_no) {
        throwEventLowerTree(prm_no, this);
    }

    /**
     * Cxg̃R[obN .
     * throwEventUpperTree() throwEventLowerTree() ŔꍇR[obN܂B<BR>
     * @param prm_no CxgbZ[Wԍ
     * @param prm_pSource  Cxgpėp|C^
     */
    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) = 0;


    virtual bool isDisappear();
    /**
     * _ɉy .
     * @return  Ă΂ďoĂ_
     */
    virtual GgafGod* askGod() = 0;

    //==================ԑJڃ\bhS==================>
    /**
     * Ԃɂ(sΏہFthis ̂) .
     * mɂ́Am[ht[犈Ԃɂ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA߂ł(_is_active_flg = true)ɂȂB<BR>
     * ȌԂ񊈓Ȃ΁A擪 onActive() ̃R[obNsB<BR>
     * āA{\bhsĂwt[x͊Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     *  inactivateDelay() sς݂̏ꍇ́Aactivate()LɂȂB<BR>
     *  activateDelay() sς݂̏ꍇ́AwZt[1(activate() = activateDelay(1))㏑B<BR>
     * <B>[⑫]</B><BR>
     * m[h̓ftHgŊԂƂȂĂ邽߁Aŏ activate() svB<BR>
     * <B>yӁz</B><BR>
     * processBehavior()  g activate() ĂяoR[h͒ʏӖB<BR>
     * ^XNVXe̎dgݏ processBehavior() ͊Ԃɂ̂ݎŝŁAiɎsȂɂȂB<BR>
     */
    virtual void activate();

    /**
     * Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI activate() sB<BR>
     */
    virtual void activateTree();

    /**
     * xĂ犈Ԃɂ(sΏہFthis ̂) .
     * ̃t[x activate() sB<BR>
     * activateDelay(1) ́Aactivate() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void activateDelay(frame prm_offset_frames = 1);

    /**
     * xĂ犈Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI activateDelay(frame) sB<BR>
     * activateTreeDelay(1) ́AactivateTree() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void activateTreeDelay(frame prm_offset_frames = 1);

    /**
     * 莞ԂԂɂ(sΏہFthis ̂) .
     * ԂɂÃt[o߂ƁA񊈓ԂɂȂB
     * activateWhile(10); 
     * activate(); inactivateDelay(10); ̎sƓ̌ʂłB
     * @param prm_frames t[
     */
    virtual void activateWhile(frame prm_frames = 1);

    /**
     * ɊԂɂ(sΏہFthis ̂) .
     * ɏԃtOXV(_is_active_flg = true)B<BR>
     * onActive() R[obN͎sȂBȊOŖ{\bh̎gp͔񐄏B<BR>
     * ȉ̓_𗯈ӂĎgpۂ͒ӂKvłB<BR>
     * wt[xłĂAɏꂽm[hƖ̃m[hŁAقȂԂɂȂĂ܂B<BR>
     * ŁAũm[hԂȂ΁EEEvȀԁitOjɂ蕪򂵂ĂꍇA<BR>
     * t[̏ʂ̐鋰ꂪB<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void activateImmed();

    /**
     * ɊԂɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI activateImmed() sB<BR>
     * activateImmed() ̐vQƁB<BR>
     * gpƂ́Am[h̉eǂlĒӂĎgp邱ƁB<BR>
     */
    virtual void activateTreeImmed();
    //===================

    /**
     * 񊈓Ԃɂ(sΏہFthis ̂) .
     * mɂ́Am[ht[񊈓Ԃɂ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA{̔񊈓(_is_active_flg = false)ɂȂB<BR>
     * ȌԂԂȂ΁A擪 onInactive() ̃R[obNsB<BR>
     * āA{\bhsĂwt[x͊Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     */
    virtual void inactivate();

    /**
     * 񊈓Ԃɂ
     * gƔzm[hSĂɂčċAI inactivate() sB<BR>
     */
    virtual void inactivateTree();

    /**
     * xĂ񊈓Ԃɂ(sΏہFthis ̂) .
     * ̃t[x inactivate() sB<BR>
     * inactivateDelay(1) ́Ainactivate() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void inactivateDelay(frame prm_offset_frames = 1);


    /**
     * xĂ犈Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI inactivateDelay(frame) sB<BR>
     * inactivateDelay(1) ́AinactivateTree() ƓӖɂȂB<BR>
     * @param prm_offset_frames xt[(1`)
     */
    virtual void inactivateTreeDelay(frame prm_offset_frames = 1);

    /**
     * ɔ񊈓Ԃɂ(sΏہFthis ̂) .
     * ɏԃtOXV(_is_active_flg = false)B<BR>
     * onInactive() R[obN͎sȂBȊOŖ{\bh̎gp͔񐄏B<BR>
     * ȉ̓_𗯈ӂĎgpۂ͒ӂKvłB<BR>
     * wt[xłĂAɏꂽm[hƖ̃m[hŁAقȂԂɂȂĂ܂B<BR>
     * ŁAũm[h񊈓ԂȂ΁EEEvȀԁitOjɂ蕪򂵂ĂꍇA<BR>
     * t[̏ʂ̐鋰ꂪB<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void inactivateImmed();

    /**
     * ɔ񊈓Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI inactivateImmed() sB<BR>
     * inactivateImmed() ̐vQƁB<BR>
     * gpƂ́Am[h̉eǂlĒӂĎgp邱ƁB<BR>
     */
    virtual void inactivateTreeImmed();

    //===================
    /**
     * ꎞ~Ԃɂ(sΏہFthis ̂) .
     * mɂ́Am[ht[ꎞ~ɂ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA߂łꎞ~(_was_paused_flg = true)ɂȂB<BR>
     * āA{\bhsĂwt[x͈ꎞ~Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     */
    virtual void pause();

    /**
     * ꎞ~Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI pause() sB<BR>
     */
    virtual void pauseTree();

    /**
     * Ɉꎞ~Ԃɂ(sΏہFthis ̂) .
     * Ɉꎞ~ԃtOXV(_was_paused_flg = true)B<BR>
     * wt[xłĂAɏꂽm[hƖ̃m[hŁAقȂԂɂȂĂ܂B<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void pauseImmed();

    /**
     * Ɉꎞ~Ԃɂ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI pauseImmed() sB<BR>
     * pauseImmed() ̐vQƁB<BR>
     * gpƂ́Am[h̉eǂlĒӂĎgp邱ƁB<BR>
     */
    virtual void pauseTreeImmed();

    //===================
    /**
     * ꎞ~Ԃ(sΏہFthis ̂) .
     * mɂ́Am[ht[ꎞ~Ԃ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁA߂łꎞ~ԉ(_was_paused_flg = false)ɂȂB<BR>
     * āA{\bhsĂwt[x͈ꎞ~Ԃ̕ω͖ѐ͕ۂB<BR>
     * zm[hɂ͉e܂B<BR>
     */
    virtual void unpause();

    /**
     * ꎞ~Ԃ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI unpause() sB<BR>
     */
    virtual void unpauseTree();

    /**
     * Ɉꎞ~Ԃ(sΏہFthis ̂) .
     * Ɉꎞ~ԃtOXV(_was_paused_flg = false)B<BR>
     * wt[xłĂAɏꂽm[hƖ̃m[hŁAقȂԂɂȂĂ܂B<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void unpauseImmed();

    /**
     * Ɉꎞ~Ԃ(sΏہFc[S) .
     * gƔzm[hSĂɂčċAI unpauseImmed() sB<BR>
     * unpauseImmed() ̐vQƁB<BR>
     * gpƂ́Am[h̉eǂlĒӂĎgp邱ƁB<BR>
     */
    virtual void unpauseTreeImmed();


    //===================
    /**
     * ԂZbg邽߂̏ł onReset() R[obNB(sΏہFthiŝ) .
     * ̂悤ȓwxɍs܂B<BR>
     * t[̐擪( nextFrame() )ł͂܂B<BR>
     * t[ŉx reset() ĂяoĂAPt[ onReset() ͂P񂵂Ă΂Ȃ
     * 悤ɂ邽߂̃\bhłB̂悤ɓ삷B<BR>
     * @ t[ŁA߂Ă̌Ăяoł邩`FbN<BR>
     *   E߂Ă̌ĂяołB   A<BR>
     *   EQȏĂяoĂB Ȃreturn<BR>
     * A ʎ onReset() R[obNB<BR>
     * ⑫: initialize() ĂяoɁAP񂾂 reset() ͎IɌĂяoB<BR>
     */
    virtual void reset();
    //  initialize(), onReset(), onActive() ̎gɂā
    // ԂZbǵAǂɎׂH
    // initialize() EEE Aŏ̂P񂾂OɃR[obNBɎgp邱ƂzB
    // onReset()    EEE Ainitialize() ̌AP񂾂ŃR[B
    //                     ̌ACӂ̃^C~O reset() sŃR[obNB
    // onActive()   EEE Ainitialize() ̌̊Ԏ Pt[ڂ behave() OɃR[B
    //                     ̌ 񊈓ԂɂȂAIɃR[obNB
    // m[h(AN^[V[)̏TCNɂĎgB
    // AN^[ÃRXgN^ŉȂꍇAŏ nextFrame() 
    // initialize()  onReset() onActive() ̏Ɏs邱ƂɂȂB
    //
    // EPTCNȃm[h(AN^[V[)̏ꍇ
    // A߂ẮuIvƂԂ}ۂɁÂ܂܉ƂȂꍇB܂ACX^Xg܂킳ȂꍇB
    // initialize(), onReset(), onActive() ͎OɊePŝŁAǂɏԂZbgĂق͖͂B
    // ̒ʏ̃AN^[AꎞIȒZV[͂ɊYƗ\zB
    // ǂɎĂǂAinitialize() Ŏ𓝈ꂵقÃIuWFNg瑀삵₷B
    //
    // EonActive() gpׂꍇ
    // ꂽm[hɁAu\vu\vƂԂ݂Ag܂킷ꍇB
    // \() ` \(񊈓) Am[ĥPTCN̂ƈvꍇB
    // initialize() EEE A
    // onActive()   EEE ԃZbg
    // ƎgċLqB inacivate()Aactive() ŏԃZbgsB
    // Ȃ onReset() ɏԃZbgLqAreset()R[ł͂Ȃ̂ƂƁA
    // ̒Sł processBehavior() \bh́A\(񊈓) ̓R[Ȃ߁A
    // g̃IuWFNg̏ reset() LqĂs邱ƂƂԂɊׂB
    // ÃIuWFNgA\(񊈓)\() `FbNAreset() sĂ
    // ȂAZbĝAǂȂƕȂ悤ɂȂƂfbĝł͂Ȃ낤B
    // onActive() R[ĂAgetBehaveingFrame() ́uZbgȂvA
    // getActiveFrame()́uZbgv鎖ɒӁB
    // ɓGeȂǔėpIȃAN^[́AɊYƗ\zB
    //
    // EonReset() gpׂꍇ
    // ꂽm[hɁAu\vu\vƂTOi͕\ςȂjŁA
    // ȂATCNiZbgj̊TOm[hꍇ
    // initialize() EEE A
    // onReset()    EEE ԃZbg
    // ƎgċLqB reset() ŏԃZbgsB
    // onReset() R[obŃAt[JE^́uZbgvɒӁB
    // ɃV[ƁAꕔ̃AN^[́AɊYƗ\zB
    //
    // EonActive() onReset() ĎgpׂꍇB
    // \() ` \(񊈓) Am[ĥPTCNƈvȂꍇA
    // initialize() EEE A
    // onActive()   EEE ʕ`掞
    // onReset()    EEE ԃZbg
    // ƎgċLqB inacivate()Aactivate()  reset() R[B
    // reset() ŏԃZbgsB
    // @͂ɊYƗ\zB
    //
    // Einitialize() onActive() onReset() ǂł悢ꍇB
    // \() ` \(񊈓) Am[h̐`ɈvꍇB
    // ܂胊ZbgƂg񂷊TOȂIuWFNǵAIuWFNg̏
    // initialize() onActive() onReset() ̉ɋLqĂقڈӖ͓łB
    // A\()܂łɃ^CO݂Ȃ΁AonActive() onReset() ̂ǂ炩
    // LqׂB


    /**
     * ԂZbg(sΏہFc[S) .
     * c[SẴIuWFNgɑ΂ reset() wxsB
     * reset() ̐vQƁB
     */
    virtual void resetTree();

    /**
     * ۂ̏ԂZbg鏈([U[p) .
     * reset() ́AresetTree() s邱ƂŃR[obNB
     * ʂ̂̏ԃZbgAʃNXŃI[o[ChĂB
     */
    virtual void onReset() {}


    /**
     * I錾B(sΏہFc[S) .
     * m[h̃t[ɁuIvԂɂ邱Ƃ錾BiI\tO𗧂Ăj <BR>
     * gƔzm[hSĂɂčċAI end(frame) sꐶI錾sB<br>
     * em[hI΁Aqm[hI𓾂ȂłB<BR>
     * ItO͈xĂƌɂǂ܂Bȍ~ end(frame) d˂ČĂяoĂA<BR>
     * ̗P\t[́Ãt[ɐIƂȂxt[łB<BR>
     * uIvƂ͋̓Iɂ́AU镑tO(_is_active_flg)AtO(_can_live_flg) A
     * AZbg\tO𗧂Ă邱ƎŁAP\t[̐擪( nextFrame() )ŎۂɃtOXV
     * {̏IԂɂȂB<BR>
     * _can_live_flg AZbg邱ƂɂAIɃc[؂藣S~(GgafGarbageBox) zɁA
     * 邱ƂɂȂB̌A_(GgafGod)]T̂鎞 (FPSƂ) v炢 clean() \bhɂA<BR>
     * GgafGarbageBox ɏzm[h delete 邵A[B<BR>
     * <b>yӁz</b><BR>
     * CÂƎvA{\bhsĈ̗P\t[ɂȂĂA
     * GgafGarbageBox zɈڂ邾ŁAɂ deleteƂ͌Ȃ߁A
     * s|C^ɂݓIoONBאS̒ӂ͂炨`iA߂j<BR>
     * @param prm_offset_frames IP\t[(1`)
     */
    virtual void end(frame prm_offset_frames = 1);

    /**
     * S~ɕ荞܂钼OɌĂяoR[obN .
     * end(frame) sAS~(GgafGarbageBox) Ɏ荞܂钼OɌĂяoB<BR>
     * őŁAend(frame) Ŏw肵t[ + GGAF_END_DELAY ɔB<BR>
     * ƁAȏ̐̃t[ŔB<BR>
     * OɏKvȏꍇ́AI[o[ChĎ\B<BR>
     */
    virtual void onEnd() {
    }

    /**
     * m[hŏIm[hɈړ .
     * mɂ́At[ŏIm[hɈړ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁAm[hŏIm[hɈړ鏈sB<BR>
     * m[h͐؂藣āÃׂm[h͐VɐڍA݂̍ŏIm[h̎̃m[hăCT[gB<BR>
     * {\bhsĂwt[x́Am[hړ͖߁Aѐ͕ۂB<BR>
     */
    virtual void moveLast() override {
        _will_mv_last_in_next_frame_flg = true;
    }

    /**
     * Ɏm[hŏIm[hɈړ .
     * Ɏm[hŏIm[hɈړi[e[Vj邱ƂɂA
     * t[ŁAm[ĥQdsAsȂm[h鋰ꂪB<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void moveLastImmed() {
        GgafNode<T>::moveLast();
    }

    /**
     * m[h擪m[hɈړ .
     * mɂ́At[ŏIm[hɈړ\tO𗧂ĂB<BR>
     * āAt[擪(nextFrame())ŁAm[h擪m[hɈړ鏈sB<BR>
     * m[h͐؂藣āÃׂm[h͐VɐڍA݂̐擪m[h̑Õm[hăCT[gB<BR>
     * {\bhsĂwt[x́Am[hړ͖߁Aѐ͕ۂB<BR>
     */
    virtual void moveFirst() override {
        _will_mv_first_in_next_frame_flg = true;
    }

    /**
     * Ɏm[h擪m[hɈړ .
     * Ɏm[h擪m[hɈړi[e[Vj邱ƂɂA
     * t[ŁAm[ĥQdsAsȂm[h鋰ꂪB<BR>
     * m[h̉eAc[\ǂlĎgp邱ƁB<BR>
     */
    virtual void moveFirstImmed() {
        GgafNode<T>::moveFirst();
    }

    /**
     * m[h񊈓犈Ԃɐ؂ւǂׂ .
     * onActive() Ă΂ꂽt[̂ true ɂȂB
     * onActive() I[o[ChŎꍇ́A̕Lqł͂B<BR>
     * ̃m[h̏ԕωm肽̂߂ɁA{\bh܂B<BR>
     * @return  bool true:񊈓犈Ԑ؂ւ^false:؂ւĂȂ
     */
    inline bool onChangeToActive();

    /**
     * m[hԂ񊈓ɐ؂ւǂׂ .
     * onInctive() Ă΂ꂽt[̂ true ɂȂB
     * onInctive() I[o[ChŎꍇ́A̕Lqł͂B<BR>
     * ̃m[h̏ԕωm肽̂߂ɁA{\bh܂B<BR>
     * @return  bool true:Ԃ񊈓ɐ؂ւ^false:؂ւĂȂ
     */
    inline bool onChangeToInactive();

    /**
     * \Ԃׂ
     * @return  bool true:\ԁ^false:s
     */
    inline bool canLive() {
        return _can_live_flg;
    }

    /**
     * ׂ .
     * gtȌԂŊǂf
     * @return  bool true:^false:񊈓
     */
    inline bool isActive();

    /**
     * c[Ŋǂf <BR>
     * Ƃ΁AgtȌԂŊłAełȂꍇA
     * g͊oȂBlŁA{ɊǂsB
     * @return true:c[Ŋ^false:c[Ŕ񊈓
     */
    inline bool isActiveInTheTree();

    /**
     * ꎞ~Ԃǂf
     * @return true:ꎞ~ԁ^false:ꎞ~Ԃł͖
     */
    inline bool wasPaused();

    /**
     * I錾ǂ .
     * end(frame) sς݂ǂׂ܂B
     * @return true:I錾ς݁^false:܂I錾ĂȂ
     */
    inline bool wasDeclaredEnd();

    /**
     * U镑ԎɉZt[擾 .
     * uU镑ԁvƂ́AcanBehave()  true ̏̎ӖB<BR>
     * 0 FrameԂ͊{݂A1 Frame ` ̒lɂȂBAOI<BR>
     * RXgN^AсAŏ initialize() ł 0 Frame ԂB<BR>
     * s onActive()AprocessBehavior()AprocessJudgement() ̒ 1 ɂȂĂB<BR>
     * ȍ~AU镑ԎɃt[ZB<BR>
     * @return U镑t[v
     */
    inline frame getBehaveingFrame() {
        return _frame_of_behaving;
    }

    /**
     * ߂ onActive() JnU镑Ԃ͉t[ڂԂB .
     * ėpIuWFNgȂǁAxĎg܂킷(deleteȂ)ꍇA<BR>
     *  inactivate() Ao activate() JԂƂz肳B<BR>
     * ̂悤ȏꍇɁAt[ڂ擾ۂɓsǂ\bhB<BR>
     * onActive() R[obNɃZbg(0)B<BR>
     * getBehaveingFrame() Ɠ^C~OŉZBprocessBehavior()ł́A1 ` ԂB
     * @return onActive() ̐U镑t[
     */
    inline frame getActiveFrame() {
        return _frame_of_behaving_since_onActive;
    }

    /**
     * gƔzSẴIuWFNgɑ΂Ďẘ֐s .
     * zIuWFNgiAN^[V[j̃|C^A֐|C^ pFunc̑PɓnĂB<BR>
     * ֐|C^ pFunc ̑Qɂ́AexecuteFuncLowerTree Ăяo prm1(P)̃|C^nĂB<BR>
     * ֐|C^ pFunc ̑Rɂ́AexecuteFuncLowerTree Ăяo prm2(Q)̃|C^nĂB<BR>
     * z̃IuWFNgł̂ĂŎgpȂƊ댯łB<BR>
     * ƁA_ƃLv`[g킹ĂB<BR>
     *
     * gp၄<BR>
     * XXXXActor z̃IuWFNgSẴAN^[(AGgafDxGeometricActor)̃oϐ _x ɁA
     * XXXXActoroϐ _velo ̒lZB<BR>
     * XXXXActor NX̎TvȉɋL<BR>
     * <code><pre>
     *
     * class XXXXActor : public GgafDxGeometricActor {
     * public :
     *     int velo_;
     *
     *     static void addX(GgafObject* pThat, void* p1, void* p2) {
     *         if (pThat->instanceOf(Obj_GgafDxGeometricActor)) { //GgafDxGeometricActorȂ
     *             GgafDxGeometricActor* pActor = (GgafDxGeometricActor*)pThat;
     *             pActor->_x += (*((int*)p1));  //_x ZBp1 ɂ velo_ ւ̃|C^nĂ
     *         }
     *     }
     *
     *     void processBehavior() {
     *         //zAN^[SĂaddXs
     *         velo_ = 1000;
     *         executeFuncLowerTree(XXXXActor::addX, &velo_, nullptr);
     *     }
     * }
     *
     * </pre></code>
     * @param pFunc IuWFNgɎs֐Bp[^(GgafObject*, void*, void*) ŒB
     * @param prm1 n̂P
     * @param prm2 n̂Q
     */
    virtual void executeFuncLowerTree(void (*pFunc)(GgafObject*, void*, void*), void* prm1, void* prm2);


    /**
     * iǗIuWFNg(GgafProgress) Ǘȉꍇݒ肷B
     * {\bhsA_pProg o[gp\ɂȂB
     * @param prm_num ȉꍇ̐
     */
    virtual void useProgress(int prm_num = 10) {
        if (_pProg == nullptr) {
            _pProg = NEW GgafProgress(&_frame_of_behaving, prm_num);
        } else {
            _TRACE_("xuseProgress() ["<<GgafNode<T>::getName()<<"] ͊ useProgress ĂBȑO̐ȉꍇ̐="<<_pProg->_num_progress<<"B prm_num="<<prm_num);
            if (_pProg->_num_progress != prm_num) {
                throwGgafCriticalException("useProgress() ["<<GgafNode<T>::getName()<<"] ͊ useProgress ĂB_Ȃ̂HIB\nȑO̐ȉꍇ̐="<<_pProg->_num_progress<<"B prm_num="<<prm_num);
            }
        }
    }

    virtual GgafProgress* createProgress(int prm_num = 10) {
        return NEW GgafProgress(&_frame_of_behaving, prm_num);
    }

    /**
     * c[lm[htO()
     */
    virtual void updateActiveInTheTree() = 0;

};

///////////////////////////////////////////////////////////////// ͎

template<class T>
GgafElement<T>::GgafElement(const char* prm_name) : GgafCore::GgafNode<T>(prm_name),
_pGod(nullptr),
_was_initialize_flg(false),
_frame_of_life(0),
_frame_of_behaving(0),
_frame_of_behaving_since_onActive(0),
_is_active_flg(false),
_is_active_in_the_tree_flg(false),
_was_paused_flg(false),
_can_live_flg(true),
_was_paused_flg_in_next_frame(false),
_will_end_after_flg(false),
_frame_of_life_when_end(MAX_FRAME),
_will_activate_after_flg(true),    //t[ɃANeBuɂȂ邽
_frame_of_life_when_activation(1), //t[ɃANeBuɂȂ邽߂1
_will_inactivate_after_flg(false),
_frame_of_life_when_inactivation(0),
_on_change_to_active_flg(false),
_on_change_to_inactive_flg(false),
_will_mv_first_in_next_frame_flg(false),
_will_mv_last_in_next_frame_flg(false),
_is_already_reset(false),
_pProg(nullptr)
{

}

template<class T>
void GgafElement<T>::nextFrame() {
    //moveLast\
    if (_will_mv_last_in_next_frame_flg) {
        _will_mv_last_in_next_frame_flg = false;
        moveLastImmed();
        return;
        //return鎖͏dvBnextFrame() ̂Qds邽߁B
        //̃m[h́Aɉ񂳂Ă邽߁AKx nextFrame() ̋@KB
    }
    _was_paused_flg = _was_paused_flg_in_next_frame;
    if (!_was_paused_flg) {
        _frame_of_life++;
        if (_will_end_after_flg && _frame_of_life_when_end == _frame_of_life) {
            _can_live_flg = false; //I̎
        }
        _on_change_to_active_flg = false;
        _on_change_to_inactive_flg = false;
        if (_can_live_flg) {
            if (_is_active_flg) {  //activate
                if (_will_inactivate_after_flg) {  //activate ŁAQt[ڈȍ~ŁA
                                                   // inactivate\
                    if (_frame_of_life == _frame_of_life_when_inactivation) { //activate ŁAQt[ڈȍ~ŁA
                                                                              //inactivate\ŁAinactivateɂȂ鎞
                        _is_active_flg = false; //tOOFF
                        _on_change_to_inactive_flg = true; //onInactivem
                    }
                }
            } else { //inactivate
                if (_will_activate_after_flg) { //inactivate Aactivate\B
                    if(_frame_of_life == _frame_of_life_when_activation) { //inactivate Aactivate\
                                                                           //āAactivateɂȂ鎞
                        _is_active_flg = true; //tOON
                        _on_change_to_active_flg = true;  //onActive
                    }
                }
            }
            _is_already_reset = false;

            updateActiveInTheTree();     //_is_active_in_the_tree_flg XV

            if (_is_active_in_the_tree_flg) {
                _frame_of_behaving++;
                // i𔽉f
                if (_pProg) {
                    _pProg->update();
                }
                _frame_of_behaving_since_onActive++;
            }
            //onActive
            if (_on_change_to_active_flg) {
                if (!_was_initialize_flg) {
                    initialize();       //
                    _was_initialize_flg = true;
                    reset(); //Zbg
                }
                _frame_of_behaving_since_onActive = 1; //Zbg
                onActive(); //R[obN
                _frame_of_life_when_activation = 0;
                _will_activate_after_flg = false;
            }
            //onInactive
            if (_on_change_to_inactive_flg) {
                onInactive(); //R[obN
                _frame_of_life_when_inactivation = 0;
                _will_inactivate_after_flg = false;
            }
        }
    }

    //z̑Sm[hɍċAInextFrame()s
    T* pElement = GgafNode<T>::_pSubFirst; //z̐擪m[h
    if (pElement) {
        while (!pElement->_is_last_flg) {
            //z̐擪`ԃm[h nextFrame()
            pElement->nextFrame();
            if (pElement->_can_live_flg) {
                pElement = pElement->_pNext;
            } else {
                pElement->onEnd();
                pElement = pElement->_pNext; //i܂đޔĂ
                GgafGarbageBox::_pGarbageBox->add(pElement->_pPrev); //OS~(A؂)
            }
        }
        //z̖m[h nextFrame()
        pElement->nextFrame();
        if (pElement->_can_live_flg) {
            //OKȂ
        } else {
            pElement->onEnd();
            GgafGarbageBox::_pGarbageBox->add(pElement); //S~
        }
    }

    if (_will_mv_first_in_next_frame_flg) {
        _will_mv_first_in_next_frame_flg = false;
        moveFirstImmed();
        //moveFirstԍŌɂ邱Ƃ͏dvB
        // nextFrame() ̂Qds邽߁B
    }
}

template<class T>
void GgafElement<T>::behave() {
    if (_is_active_in_the_tree_flg && !_was_paused_flg) {
        processBehavior();    //[U[p
        callRecursive(&GgafElement<T>::behave); //ċA
    }
}

template<class T>
void GgafElement<T>::settleBehavior() {
    if (_is_active_in_the_tree_flg) { //_was_paused_flg ͖YĂ܂
        processSettlementBehavior(); //t[[Np
        callRecursive(&GgafElement<T>::settleBehavior); //ċA
    }
}

template<class T>
void GgafElement<T>::judge() {
    if (_is_active_in_the_tree_flg && !_was_paused_flg) {
        processJudgement();    //[U[p
        callRecursive(&GgafElement<T>::judge); //ċA
    }
}

template<class T>
void GgafElement<T>::preDraw() {
    if (_is_active_in_the_tree_flg) {
        processPreDraw();
        callRecursive(&GgafElement<T>::preDraw); //ċA
    }
}

template<class T>
void GgafElement<T>::draw() {
    if (_is_active_in_the_tree_flg) {
        processDraw();
        callRecursive(&GgafElement<T>::draw); //ċA
    }
}

template<class T>
void GgafElement<T>::afterDraw() {
    if (_is_active_in_the_tree_flg) {
        processAfterDraw();
        callRecursive(&GgafElement<T>::afterDraw); //ċA
    }
}

template<class T>
void GgafElement<T>::doFinally() {
    if (_is_active_in_the_tree_flg && !_was_paused_flg) {
        processFinal();
        callRecursive(&GgafElement<T>::doFinally); //ċA
    }
}

template<class T>
void GgafElement<T>::reset() {
    if (_can_live_flg) {
        if(_was_initialize_flg == false) {
            initialize();       //
            _was_initialize_flg = true;
        }
        if (_is_already_reset == false) {
            onReset();
            _is_already_reset = true;
        }
    }
}

template<class T>
void GgafElement<T>::resetTree() {
    if (_can_live_flg) {
        if(_was_initialize_flg == false) {
            initialize();       //
            _was_initialize_flg = true;
        }
        if (_is_already_reset == false) {
            onReset();
            _is_already_reset = true;
        }
        callRecursive(&GgafElement<T>::resetTree); //ċA
    }
}

template<class T>
void GgafElement<T>::activate() {
    if (_can_live_flg) {
        activateDelay(1);
    }
}

template<class T>
void GgafElement<T>::activateTree() {
    if (_can_live_flg) {
        activateDelay(1);
        callRecursive(&GgafElement<T>::activateTree); //ċA
    }
}

template<class T>
void GgafElement<T>::activateImmed() {
    if (_can_live_flg) {
        if (!_was_initialize_flg) {
            initialize();       //
            _was_initialize_flg = true;
            reset(); //Zbg
        }
        _is_active_flg = true;
        _will_activate_after_flg = true;
        updateActiveInTheTree();
    }
}

template<class T>
void GgafElement<T>::activateTreeImmed() {
    if (_can_live_flg) {
        activateImmed();
        callRecursive(&GgafElement<T>::activateTreeImmed); //ċA
    }
}

template<class T>
void GgafElement<T>::activateDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwGgafCriticalException("activateDelay(0) ͖ӖłB܂ł activate() ܂IIIBӐ}Ă܂H name="<<GgafNode<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwGgafCriticalException("activateDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł activate() ܂IIIB̐ɂȂ̂ƂHB name="<<GgafNode<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
#ifdef MY_DEBUG
        if (_is_active_flg) {
            _TRACE_("xactivateDelay("<<prm_offset_frames<<") ܂ǁAɊԂłBӐ}Ă܂H name="<<GgafNode<T>::_name<<" this="<<this);
        }
#endif
        //inactivateDelay()sς݂̏ꍇ
        //inactivateDelay()͖B
        //
        //inactivate();
        //activate();
        //̏ɎsƁAactivate() ŏ
        //activate();
        //inactivate();
        //̏ɎsƁAinactivate() 
        _will_inactivate_after_flg = false;

        //activateDelay()sς݂̏ꍇ́AwZt[ŏ㏑i㏟jB
        //(inactivateDelay() ƗD̍lႤߒ)
        _will_activate_after_flg = true;
        _frame_of_life_when_activation = _frame_of_life + prm_offset_frames;
    }
}

template<class T>
void GgafElement<T>::activateWhile(frame prm_frames) {
#ifdef MY_DEBUG
    if (prm_frames == 0) {
        throwGgafCriticalException("activateWhile(0) ͖ӖłB܂ł activate() ܂IIIBӐ}Ă܂H name="<<GgafNode<T>::_name<<" this="<<this);
    }
    if (prm_frames >= 60*60*60) { //PԌ
        throwGgafCriticalException("activateWhile("<<prm_frames<<") Ēx񂿂ႤHB܂ł activate() ܂I̐ɂȂ̂ƂHB name="<<GgafNode<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        _will_activate_after_flg = true;
        _frame_of_life_when_activation = _frame_of_life + 1;
        _will_inactivate_after_flg = true;
        _frame_of_life_when_inactivation = _frame_of_life + prm_frames;
    }
}

template<class T>
void GgafElement<T>::activateTreeDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwGgafCriticalException("activateTreeDelay(0) ͖ӖłB܂ł activate() ܂IIIBӐ}Ă܂H name="<<GgafNode<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwGgafCriticalException("activateTreeDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł activate() ܂I̐ɂȂ̂ƂH name="<<GgafNode<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        activateDelay(prm_offset_frames);
        callRecursive(&GgafElement<T>::activateTreeDelay, prm_offset_frames); //ċA
    }
}

template<class T>
void GgafElement<T>::inactivate() {
    if (_can_live_flg) {
        inactivateDelay(1);
    }
}

template<class T>
void GgafElement<T>::inactivateTree() {
    if (_can_live_flg) {
        inactivateDelay(1);
        callRecursive(&GgafElement<T>::inactivateTree); //ċA
    }
}

template<class T>
void GgafElement<T>::inactivateDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwGgafCriticalException("inactivateDelay(0) ͖ӖłB܂ł inactivate() ܂IIIBӐ}Ă܂H name="<<GgafNode<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwGgafCriticalException("inactivateDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł inactivate() ܂I̐ɂȂ̂ƂH name="<<GgafNode<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        if (_will_activate_after_flg) {
            //activateDelay()sς݂̏ꍇ
            if (_frame_of_life_when_activation >= _frame_of_life + prm_offset_frames) {
                //inactive Ɠt[A܂ inactive \ active \Ȃ΁A
                //(activeɂ͂ȂȂ悤ɂ邽)_will_activate_after_flg 𖳌ɂB
                //
                //activate();
                //inactivate();
                //̏ɎsƁAinactivate() 
                _will_activate_after_flg = false;
            }
        }
        if (_will_inactivate_after_flg) {
            //inactivateDelay()sς݂̏ꍇA葁 inactivate ȂΏ㏑
            if (_frame_of_life_when_inactivation < _frame_of_life + prm_offset_frames) {
                //wZt[̕xꍇ͖B
                return;
            }
        }
        _will_inactivate_after_flg = true;
        _frame_of_life_when_inactivation = _frame_of_life + prm_offset_frames;
    }
}

template<class T>
void GgafElement<T>::inactivateTreeDelay(frame prm_offset_frames) {
#ifdef MY_DEBUG
    if (prm_offset_frames == 0) {
        throwGgafCriticalException("inactivateTreeDelay(0) ͖ӖłB܂ł inactivate() ܂IIIBӐ}Ă܂H name="<<GgafNode<T>::_name<<" this="<<this);
    }
    if (prm_offset_frames >= 60*60*60) { //PԌ
        throwGgafCriticalException("inactivateTreeDelay("<<prm_offset_frames<<") Ēx񂿂ႤHB܂ł inactivate() ܂I̐ɂȂ̂ƂH name="<<GgafNode<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        inactivateDelay(prm_offset_frames);
        callRecursive(&GgafElement<T>::inactivateTreeDelay, prm_offset_frames); //ċA
    }
}

template<class T>
void GgafElement<T>::inactivateImmed() {
#ifdef MY_DEBUG
    if (_frame_of_life == 0) {
        throwGgafCriticalException("inactivateImmed() AN^[シinactivateImmed()邱Ƃ͖ӖłB name="<<GgafNode<T>::_name<<" this="<<this);
    }
#endif
    if (_can_live_flg) {
        _is_active_flg = false;
        _will_inactivate_after_flg = true;
        _frame_of_life_when_inactivation = _frame_of_life;
        updateActiveInTheTree();
    }
}

template<class T>
void GgafElement<T>::inactivateTreeImmed() {
    if (_can_live_flg) {
        inactivateImmed();
        callRecursive(&GgafElement<T>::inactivateTreeImmed); //ċA
    }
}

template<class T>
void GgafElement<T>::pauseTree() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = true;
        callRecursive(&GgafElement<T>::pauseTree); //ċA
    }
}

template<class T>
void GgafElement<T>::pause() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = true;
    }
}

template<class T>
void GgafElement<T>::pauseTreeImmed() {
    if (_can_live_flg) {
        _was_paused_flg = true;
        _was_paused_flg_in_next_frame = true;
        callRecursive(&GgafElement<T>::pauseTreeImmed); //ċA
    }
}

template<class T>
void GgafElement<T>::pauseImmed() {
    if (_can_live_flg) {
        _was_paused_flg = true;
        _was_paused_flg_in_next_frame = true;
    }
}

template<class T>
void GgafElement<T>::unpauseTree() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = false;
        callRecursive(&GgafElement<T>::unpauseTree); //ċA
    }
}

template<class T>
void GgafElement<T>::unpause() {
    if (_can_live_flg) {
        _was_paused_flg_in_next_frame = false;
    }
}

template<class T>
void GgafElement<T>::unpauseTreeImmed() {
    if (_can_live_flg) {
        _was_paused_flg = false;
        _was_paused_flg_in_next_frame = false;
        callRecursive(&GgafElement<T>::unpauseTreeImmed); //ċA
    }
}

template<class T>
void GgafElement<T>::unpauseImmed() {
    if (_can_live_flg) {
        _was_paused_flg = false;
        _was_paused_flg_in_next_frame = false;
    }
}

template<class T>
void GgafElement<T>::end(frame prm_offset_frames) {
    if (_will_end_after_flg) {
        //end()sς݂̏ꍇA葁end()ȂΗLƂ
        if (_frame_of_life_when_end < _frame_of_life + prm_offset_frames + GGAF_END_DELAY) {
            //w̕xt[wł邽ߖB
            return;
        }
    }
    _will_end_after_flg = true;
    _frame_of_life_when_end = _frame_of_life + prm_offset_frames + GGAF_END_DELAY;
    inactivateDelay(prm_offset_frames);
    //wt[ɂ́A܂inactivatesA+GGAF_END_DELAY t[ _can_live_flg = falseɂȂB
    //onEnd() _can_live_flg = false 
    T* pElementTemp = GgafNode<T>::_pSubFirst;
    while (pElementTemp) {
        pElementTemp->end(prm_offset_frames);
        if (pElementTemp->_is_last_flg) {
            break;
        } else {
            pElementTemp = pElementTemp->_pNext;
        }
    }
}

template<class T>
bool GgafElement<T>::isActive() {
    return (_can_live_flg && _is_active_flg) ? true : false;
}
template<class T>
bool GgafElement<T>::isActiveInTheTree() {
    return (_is_active_in_the_tree_flg && _can_live_flg) ? true : false;
}

template<class T>
bool GgafElement<T>::onChangeToActive() {
    return (_can_live_flg && _on_change_to_active_flg) ? true : false;
}

template<class T>
bool GgafElement<T>::onChangeToInactive() {
    return (_can_live_flg && _on_change_to_inactive_flg) ? true : false;
}

template<class T>
bool GgafElement<T>::wasPaused() {
    return _was_paused_flg;
}

template<class T>
bool GgafElement<T>::wasDeclaredEnd() {
    return (_will_end_after_flg || _can_live_flg == false) ? true : false;
}

//template<class T>
//T* GgafElement<T>::extract() {
//    if (_can_live_flg) {
//        return extract();
//    } else {
//        //_TRACE_("[GgafElement<"<<_class_name<<">::extract()] x "<<getName()<<"́Ał܂B");
//        return extract();
//    }
//}

template<class T>
void GgafElement<T>::clean(int prm_num_cleaning) {
    if (GgafNode<T>::_pSubFirst == nullptr) {
        return;
    }

    T* pElementTemp = GgafNode<T>::_pSubFirst->_pPrev;
    T* pWk;

    while (GgafGarbageBox::_cnt_cleaned < prm_num_cleaning) {
        if (pElementTemp->_pSubFirst) {
            //q̎q܂̂Ăꍇɂ
            pElementTemp->clean(prm_num_cleaning);
            if (GgafGarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                break;
            }
        }
        if (pElementTemp->_is_first_flg) { //Ō̈
            if (pElementTemp->_pSubFirst) {
                //q̎q܂̂Ăꍇɂ
                pElementTemp->clean(prm_num_cleaning);
                if (GgafGarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                    break;
                }
            }
            if (pElementTemp->_can_live_flg == false) {
                GGAF_DELETE(pElementTemp);
                GgafGarbageBox::_cnt_cleaned++;
                if (GgafGarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                    break;
                }
            }
            break;
        } else {
            pWk = pElementTemp;
            if (pWk->_pSubFirst) {
                //q̎q܂̂Ăꍇɂ
                pWk->clean(prm_num_cleaning);
                if (GgafGarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                    break;
                }
            }
            pElementTemp = pElementTemp->_pPrev;
            if (pWk->_can_live_flg == false) {
                GGAF_DELETE(pWk);
                GgafGarbageBox::_cnt_cleaned++;
                if (GgafGarbageBox::_cnt_cleaned >= prm_num_cleaning) {
                    break;
                }
            }
        }
    }
}


template<class T>
void GgafElement<T>::executeFuncLowerTree(void (*pFunc)(GgafObject*, void*, void*), void* prm1, void* prm2) {
    if (_can_live_flg && _is_active_flg) {   //TODO:activetOAĂǂȁEEE
        if (_was_initialize_flg) {
            pFunc(this, prm1, prm2);
        } else {

        }
        T* pElementTemp = GgafNode<T>::_pSubFirst;
        while (pElementTemp) {
            pElementTemp->executeFuncLowerTree(pFunc, prm1, prm2);
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }
}

template<class T>
void GgafElement<T>::throwEventLowerTree(hashval prm_no, void* prm_pSource) {
    if (_can_live_flg) {
        onCatchEvent(prm_no, prm_pSource);
        T* pElementTemp = GgafNode<T>::_pSubFirst;
        while (pElementTemp) {
            pElementTemp->throwEventLowerTree(prm_no, prm_pSource);
            if (pElementTemp->_is_last_flg) {
                break;
            } else {
                pElementTemp = pElementTemp->_pNext;
            }
        }
    }
}

template<class T>
void GgafElement<T>::throwEventUpperTree(hashval prm_no, void* prm_pSource) {
    if (_can_live_flg) {
        if (_was_initialize_flg) {
            onCatchEvent(prm_no, prm_pSource);
        }
        if (GgafNode<T>::_pParent) {
            T* pElementTemp = GgafNode<T>::_pParent;
            pElementTemp->throwEventUpperTree(prm_no, prm_pSource);
        } else {
            //Ă؂
        }
    }
}

template<class T>
bool GgafElement<T>::isDisappear() {
    if (_is_active_in_the_tree_flg == false) {
        return true;
    } else {
        return false;
    }
}

template<class T>
GgafElement<T>::~GgafElement() {
    GGAF_DELETE_NULLABLE(_pProg);
}

}
#endif /*GGAFCORE_GGAFELEMENT_H_*/
