#ifndef MYSHIP_H_
#define MYSHIP_H_
#include "jp/ggaf/lib/actor/DefaultD3DXMeshActor.h"

#include "jp/ggaf/lib/util/PxQuantity.h"
#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"

namespace VioletVreath {

#define SH_NOMAL 0;
#define SH_LASER 1;

#define MAX_LEVEL_MOVE_SPEED 5
#define MIN_LEVEL_MOVE_SPEED 0
//Ternary numeral -1,0,1 33i@  zvf̂ߐ10iɕϊ}N
#define TN(X,Y,Z) (((3*3)*((X)+1)) + (3*((Y)+1)) + ((Z)+1))

#define EQ_OPTION 1
#define EQ_MAX_OPTION 0
/** \tgAː */
#define SOFT_RAPIDSHOT_NUM 3
/** \tgAˊԊu */
#define SOFT_RAPIDSHOT_INTERVAL 4

//#define MY_SHIP_VREATH_COST (500)
//ċz 1000000/500/60 = 33.3bŎ

/** t[Vreath */
#define MY_SHIP_VREATH_COST (5)
//ċz 10000/5/60 = 33.3bŎ

/** őMP */
#define MY_SHIP_MAX_MP (1000000)
/** MP */
#define MY_SHIP_START_MP (1000000)
/** @̈ړ~ĂAg[XȏԂێłt[ */
#define TRACE_DELAY_WAIT_FRAME (90)
/**
 * @NX
 * @version 1.00
 * @since 2006/06/22
 * @author Masatoshi Tsuge
 */
class MyShip : public GgafLib::DefaultD3DXMeshActor {
//class MyShip : public GgafLib::DefaultMeshActor {
//class MyShip : public GgafLib::CubeMapMeshActor {
//class MyShip : public GgafLib::DefaultD3DXAniMeshActor {
public:
    enum Switch {
        SW_ADD = 1,
        SW_NOP = 0,
        SW_SUB = -1
    };

    enum MoveWay {
        WAY_ZRIGHT_DOWN_BEHIND = 0,   //0    TN(-1,-1,-1)
        WAY_DOWN_BEHIND,              //1    TN(-1,-1, 0)
        WAY_ZLEFT_DOWN_BEHIND,        //2    TN(-1,-1, 1)
        WAY_ZRIGHT_BEHIND,            //3    TN(-1, 0,-1)
        WAY_BEHIND,                   //4    TN(-1, 0, 0)
        WAY_ZLEFT_BEHIND,             //5    TN(-1, 0, 1)
        WAY_ZRIGHT_UP_BEHIND,         //6    TN(-1, 1,-1)
        WAY_UP_BEHIND,                //7    TN(-1, 1, 0)
        WAY_ZLEFT_UP_BEHIND,          //8    TN(-1, 1, 1)
        WAY_ZRIGHT_DOWN,              //9    TN( 0,-1,-1)
        WAY_DOWN,                     //10   TN( 0,-1, 0)
        WAY_ZLEFT_DOWN,               //11   TN( 0,-1, 1)
        WAY_ZRIGHT,                   //12   TN( 0, 0,-1)
        WAY_NONE,                     //13   TN( 0, 0, 0)
        WAY_ZLEFT,                    //14   TN( 0, 0, 1)
        WAY_ZRIGHT_UP,                //15   TN( 0, 1,-1)
        WAY_UP,                       //16   TN( 0, 1, 0)
        WAY_ZLEFT_UP,                 //17   TN( 0, 1, 1)
        WAY_ZRIGHT_DOWN_FRONT,        //18   TN( 1,-1,-1)
        WAY_DOWN_FRONT,               //19   TN( 1,-1, 0)
        WAY_ZLEFT_DOWN_FRONT,         //20   TN( 1,-1, 1)
        WAY_ZRIGHT_FRONT,             //21   TN( 1, 0,-1)
        WAY_FRONT,                    //22   TN( 1, 0, 0)
        WAY_ZLEFT_FRONT,              //23   TN( 1, 0, 1)
        WAY_ZRIGHT_UP_FRONT,          //24   TN( 1, 1,-1)
        WAY_UP_FRONT,                 //25   TN( 1, 1, 0)
        WAY_ZLEFT_UP_FRONT            //26   TN( 1, 1, 1)
    };

    enum {
        SE_DAMAGED     ,
        SE_EXPLOSION   ,
        SE_TURBO       ,
        SE_FIRE_LASER  ,
        SE_FIRE_SHOT   ,
        SE_FIRE_TORPEDO,
    };

    class MyShipWaySwitch {
    public :
        class SW {
            public:
            int X, Y, Z;
            SW() { X = Y = Z = SW_NOP; }
        };
        bool sw_UP_, sw_LEFT_, sw_RIGHT_, sw_DOWN_;
        SW on_UP_, on_LEFT_, on_RIGHT_, on_DOWN_;

        /** ݂̕ */
        SW way_;
        MyShipWaySwitch() {
            way_.X = way_.Y = way_.Z = SW_NOP;
            sw_UP_ = sw_LEFT_ = sw_RIGHT_ = sw_DOWN_ = false;
        }

        void reset() {
            way_.X = way_.Y = way_.Z = SW_NOP;
            sw_UP_ = sw_LEFT_ = sw_RIGHT_ = sw_DOWN_ = false;
        }
        inline void ON_UP(Switch swX, Switch swY, Switch swZ) {
            if (!sw_UP_) {
                way_.X += swX;
                way_.Y += swY;
                way_.Z += swZ;
                on_UP_.X = swX;
                on_UP_.Y = swY;
                on_UP_.Z = swZ;
                sw_UP_ = true;
            }
        }
        inline void ON_LEFT(Switch swX, Switch swY, Switch swZ) {
            if (!sw_LEFT_) {
                way_.X += swX;
                way_.Y += swY;
                way_.Z += swZ;
                on_LEFT_.X = swX;
                on_LEFT_.Y = swY;
                on_LEFT_.Z = swZ;
                sw_LEFT_ = true;
            }
        }
        inline void ON_RIGHT(Switch swX, Switch swY, Switch swZ) {
            if (!sw_RIGHT_) {
                way_.X += swX;
                way_.Y += swY;
                way_.Z += swZ;
                on_RIGHT_.X = swX;
                on_RIGHT_.Y = swY;
                on_RIGHT_.Z = swZ;
                sw_RIGHT_ = true;
            }
        }
        inline void ON_DOWN(Switch swX, Switch swY, Switch swZ) {
            if (!sw_DOWN_) {
                way_.X += swX;
                way_.Y += swY;
                way_.Z += swZ;
                on_DOWN_.X = swX;
                on_DOWN_.Y = swY;
                on_DOWN_.Z = swZ;
                sw_DOWN_ = true;
            }
        }
        inline void OFF_UP() {
            if (sw_UP_) {
                way_.X -= on_UP_.X;
                way_.Y -= on_UP_.Y;
                way_.Z -= on_UP_.Z;
                sw_UP_ = false;
            }
        }
        inline void OFF_RIGHT() {
            if (sw_RIGHT_) {
                way_.X -= on_RIGHT_.X;
                way_.Y -= on_RIGHT_.Y;
                way_.Z -= on_RIGHT_.Z;
                sw_RIGHT_ = false;
            }
        }
        inline void OFF_LEFT() {
            if (sw_LEFT_) {
                way_.X -= on_LEFT_.X;
                way_.Y -= on_LEFT_.Y;
                way_.Z -= on_LEFT_.Z;
                sw_LEFT_ = false;
            }
        }
        inline void OFF_DOWN() {
            if (sw_DOWN_) {
                way_.X -= on_DOWN_.X;
                way_.Y -= on_DOWN_.Y;
                way_.Z -= on_DOWN_.Z;
                sw_DOWN_ = false;
            }
        }

        inline int getIndex() {
            //3i10iϊ
            //_TRACE_("way_.X, way_.Y, way_.Z="<<way_.X<<","<<way_.Y<<","<< way_.Z);
            return (3*3*(SGN(way_.X)+1)) + (3*(SGN(way_.Y)+1)) + (SGN(way_.Z)+1);
        }

        inline void dump() {
            _TEXT_(way_.X<<way_.Y<<way_.Z<<","<<
                   "["<<sw_UP_<<sw_LEFT_<<sw_RIGHT_<<sw_DOWN_<<"],"<<
                   on_UP_.X<<on_UP_.Y<<on_UP_.Z<<","<<
                   on_LEFT_.X<<on_LEFT_.Y<<on_LEFT_.Z<<","<<
                   on_RIGHT_.X<<on_RIGHT_.Y<<on_RIGHT_.Z<<","<<
                   on_DOWN_.X<<on_DOWN_.Y<<on_DOWN_.Z<<"");
        }

    };
public:
    /** ړYW */
    static coord lim_y_top_;
    /** ړYW */
    static coord lim_y_bottom_;
    /** ړXW */
    static coord lim_x_front_;
    /** ړXW */
    static coord lim_x_behaind_;
    /** ړZW */
    static coord lim_z_left_;
    /** ړZW */
    static coord lim_z_right_;

    /** sړx */
    GgafDxCore::GgafDxAxesMover* pAxsMver_;

    MyShipWaySwitch way_switch_;
    void (MyShip::*paFuncMove[3*3*3])();
    void (MyShip::*paFuncTurbo[3*3*3])();

    /** [r]bNIRg[[ */
    MyLockonController* pLockonCtrler_;
    /** [r]Rg[[ */
    MyTorpedoController* pTorpedoCtrler_;
    /** ͒l */
    int stc_;

    /** ^[{Aړp */
    MoveWay way_;
    MoveWay prev_way_;
    bool is_just_change_way_;
    /** ړXs[hxɑړXs[h */
    int iMoveSpeed_;

    velo veloTurboTop_;
    velo veloTurboBottom_;

    /** TurboړJn̈ړx̏x */
    velo veloBeginMT_; //Move Velo when I Begin To Move with Turbo
    //ZޏꍇA܂̒lvZ悤iZ̈ړx͐ŊǗĂ邽߁j

    /** Turboړ̈ړx̉x */
    acce acce_MT_; //Move Acce while I Move with Turbo
    //A l < 0 ł邱ƁB 悾񂾂xȂ悤ɂ
    //ZޏꍇA܂̒lvZ悤

    /** Turboړ̈ړx̍Œᑬx */
    velo iMvBtmVelo_MT_; //Move Bottom Velo while I Move with Turbo
    //A l < 0 ł邱ƁB
    //ZޏꍇA܂̒lvZ悤

    /** TurboړIƔfړx */
//    velo veloFMT_; //Rotation axisX angle Velo when I Finish Moveing with Turbo
    //A l < 0 ł邱ƁB
    //ZޏꍇA܂̒lvZ悤

    /** (+Z)͎O(-Z)֒ʏړJnX]px̏x */
    angvelo angRxVelo_BeginMZ_; //Rotation axisX angle Velo when I Begin To Move Z
    //̏ꍇ͐AȌꍇ͂ -1 悸

    /** (+Z)͎O(-Z)֒ʏړX]px̊px */
    angacce angRxAcce_MZ_; //Rotation axisX angle Acce while I Move Z
    //̏ꍇ͐AȌꍇ͂ -1 悸

    /** (+Z)͎O(-Z)ֈړX]px̏px */
    angvelo angRxTopVelo_MZ_; //Rotation axisX Top angle Velo while I Move Z
    //px͂ -1 悸

    /** (+Z)͎O(-Z)֒ʏZړX]p̒~px */
    angle angRxStop_MZ_; //Rotation axisX Stop angle while I Move Z


    /** (+Y)͉(-Y)TurboړJnZ]px̏x */
    angvelo angRxVelo_BeginMZT_; //Rotation axisX angle Velo when I Begin To Move Z with Turbo
    //̏ꍇ͐Ȁꍇ͂ -1 悸

    /** VB_OPTION 𗣂uԂ̍W(0,0,0)ƂāȂ΍WiVB_OPTIONĂ鎞͏OĂj */
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxGeoElem>* pRing_MyShipGeoHistory4OptCtrler_;

    /** @̖t[̈ړi΍Wj  */
    GgafCore::GgafLinkedListRing<GgafDxCore::GgafDxGeoElem>* pRing_MyShipGeoHistory2_;
    GgafCore::GgafActorDepository* pDepo_MyShots001_;
    GgafLib::LaserChipDepository* pLaserChipDepo_;

    EffectTurbo001* pEffectTurbo001_;
    MyMagicEnergyCore* pMyMagicEnergyCore_;
//    //debug ---->
//    GgafCore::GgafActorDepository* pDepo_TestGuShot_;
//    GgafCore::GgafActorDepository* pDepo_TestChokiShot_;
//    GgafCore::GgafActorDepository* pDepo_TestPaShot_;
//    GgafCore::GgafActorDepository* pDepo_TestNomalShot_;
//    //<---- debug

    /** \tgAˊJňo߃t[ */
    frame frame_soft_rapidshot_;
    /** \tgA˒ł邩ۂ */
    bool is_being_soft_rapidshot_;
    /** Vbgt[̂ true ɂȂ */
    bool just_shot_;
    /** [U[˒ǂ */
    bool is_shooting_laser_;

    /** [U[ˉ\ǂ */
    bool can_shoot_laser_;

    /** SHOT{^ςȂo߃t[i[U[ˊJn̂߁j */
    frame frame_shot_pressed_;

    /** V[˓ǂ */
    bool is_diving_;

    /**  */
    bool can_control_;

    /** X */
    int blown_veloX_;
    /** Y */
    int blown_veloY_;
    /** Z */
    int blown_veloZ_;

    /** ь */
    double r_blown_velo_attenuate_;

    /** MP */
    int mp_;

    int invincible_frames_;

    /** @[^[ */
    MagicMeter* pMagicMeter_;
    /** IvVg[X@~̍ۂɁAIɃIvV߂܂ł̗P\ɂ~true */
    bool is_trace_waiting_;
    /** is_trace_waiting_̃tO؂ւ邽߂̎ԃJE^ */
    frame trace_delay_count_;

public:
    MyShip(const char* prm_name);

    void onCreateModel() override;

    void initialize() override;

    void onReset() override;

    void onActive() override;
    void onInactive() override;
    void processBehavior() override;

    void processJudgement() override;

    void onHit(GgafCore::GgafActor* prm_pOtherActor) override;

    void setMoveSpeedLv(int lv);

    //ʎOֈړX]

    void doNotingMoveInput();

    static angle wk_dist, wk_angRx;
    void move_WAY_NONE();
    /**
     * ړ
     */
    void move_WAY_UP();
    /**
     * O΂ߏړ
     */
    void move_WAY_UP_FRONT();
    /**
     * ΂ߏړ
     */
    void move_WAY_UP_BEHIND();
    /**
     * Oړ
     */
    void move_WAY_FRONT();
    /**
     * ړ
     */
    void move_WAY_BEHIND();
    /**
     * ړ
     */
    void move_WAY_DOWN();
    /**
     * ΂߉ړ
     */
    void move_WAY_DOWN_BEHIND();
    /**
     * O΂߉ړ
     */
    void move_WAY_DOWN_FRONT();
    /**
     * ړ
     */
    void move_WAY_ZLEFT();
    /**
     * O΂ߍړ
     */
    void move_WAY_ZLEFT_FRONT();
    /**
     * ΂ߍړ
     */
    void move_WAY_ZLEFT_BEHIND();
    /**
     * O΂߉Eړ
     */
    void move_WAY_ZRIGHT_FRONT();
    /**
     * Eړ
     */
    void move_WAY_ZRIGHT();
    /**
     * ΂߉E
     */
    void move_WAY_ZRIGHT_BEHIND();
    /**
     * ΂ߏړ
     */
    void move_WAY_ZLEFT_UP();
    /**
     * ΂߉ړ
     */
    void move_WAY_ZLEFT_DOWN();
    /**
     * E΂ߏړ
     */
    void move_WAY_ZRIGHT_UP();
    /**
     * E΂߉ړ
     */
    void move_WAY_ZRIGHT_DOWN();
    /**
     * O΂ߏړ
     */
    void move_WAY_ZLEFT_UP_FRONT();
    /**
     * ΂ߏړ
     */
    void move_WAY_ZLEFT_UP_BEHIND();
    /**
     * O΂߉ړ
     */
    void move_WAY_ZLEFT_DOWN_FRONT();

    /**
     * ΂߉ړ
     */
    void move_WAY_ZLEFT_DOWN_BEHIND();

    /**
     * OE΂ߏړ
     */
    void move_WAY_ZRIGHT_UP_FRONT();
    /**
     * E΂ߏړ
     */
    void move_WAY_ZRIGHT_UP_BEHIND();
    /**
     * OE΂߉ړ
     */
    void move_WAY_ZRIGHT_DOWN_FRONT();
    /**
     * E΂߉ړ
     */
    void move_WAY_ZRIGHT_DOWN_BEHIND();

    /////////////////TURBO_BEGIN

    void turbo_WAY_NONE();
    /**
     * ^[{Jn
     */
    void turbo_WAY_UP();
    /**
     * O΂ߏ^[{Jn
     */
    void turbo_WAY_UP_FRONT();
    /**
     * ΂ߏ^[{Jn
     */
    void turbo_WAY_UP_BEHIND();
    /**
     * O^[{Jn
     */
    void turbo_WAY_FRONT();
    /**
     * ^[{Jn
     */
    void turbo_WAY_BEHIND();
    /**
     * ^[{Jn
     */
    void turbo_WAY_DOWN();
    /**
     * ΂߉^[{Jn
     */
    void turbo_WAY_DOWN_BEHIND();
    /**
     * O΂߉^[{Jn
     */
    void turbo_WAY_DOWN_FRONT();
    /**
     * ^[{Jn
     */
    void turbo_WAY_ZLEFT();
    /**
     * O΂ߍ^[{Jn
     */
    void turbo_WAY_ZLEFT_FRONT();
    /**
     * ΂ߍ^[{Jn
     */
    void turbo_WAY_ZLEFT_BEHIND();
    /**
     * O΂߉E^[{Jn
     */
    void turbo_WAY_ZRIGHT_FRONT();
    /**
     * E^[{Jn
     */
    void turbo_WAY_ZRIGHT();
    /**
     * ΂߉E
     */
    void turbo_WAY_ZRIGHT_BEHIND();
    /**
     * ΂ߏ^[{Jn
     */
    void turbo_WAY_ZLEFT_UP();
    /**
     * ΂߉^[{Jn
     */
    void turbo_WAY_ZLEFT_DOWN();
    /**
     * E΂ߏ^[{Jn
     */
    void turbo_WAY_ZRIGHT_UP();
    /**
     * E΂߉^[{Jn
     */
    void turbo_WAY_ZRIGHT_DOWN();
    /**
     * O΂ߏ^[{Jn
     */
    void turbo_WAY_ZLEFT_UP_FRONT();
    /**
     * ΂ߏ^[{Jn
     */
    void turbo_WAY_ZLEFT_UP_BEHIND();
    /**
     * O΂߉^[{Jn
     */
    void turbo_WAY_ZLEFT_DOWN_FRONT();
    /**
     * ΂߉^[{Jn
     */
    void turbo_WAY_ZLEFT_DOWN_BEHIND();
    /**
     * OE΂ߏ^[{Jn
     */
    void turbo_WAY_ZRIGHT_UP_FRONT();
    /**
     * E΂ߏ^[{Jn
     */
    void turbo_WAY_ZRIGHT_UP_BEHIND();
    /**
     * OE΂߉^[{Jn
     */
    void turbo_WAY_ZRIGHT_DOWN_FRONT();
    /**
     * E΂߉^[{Jn
     */
    void turbo_WAY_ZRIGHT_DOWN_BEHIND();

    void onChangeWay(MoveWay prev_way, MoveWay new_way) {

        switch(new_way) {
            case 0: {
                break;
            }
            default:
                break;
        }

    }

    void onCatchEvent(hashval prm_no, void* prm_pSource) override;
    /**
     * @ .
     * @param prm_blown_veloX Xёx
     * @param prm_blown_veloY Yёx
     * @param prm_blown_veloZ Zёx
     * @param prm_r_blown_velo_attenuate ь
     */
    void setBlownVelo(velo prm_blown_veloX, velo prm_blown_veloY, velo prm_blown_veloZ, double prm_r_blown_velo_attenuate);
    /**
     * @Gݒ .
     * @param prm_frames G(t[)
     */
    void setInvincibleFrames(int prm_frames);

    virtual ~MyShip();

};

}
#endif /*MYSHIP_H_*/

