#include "stdafx.h"
#include "EnemyRis.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/ggaf/lib/util/spline/SplineKurokoLeader.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EnemyRis::EnemyRis(const char* prm_name)
      : DefaultMeshSetActor(prm_name, "Ris", STATUS(EnemyRis)) {
    _class_name = "EnemyRis";
    iMovePatternNo_ = 0;
    pKurokoLeader_ = nullptr;
    pDepo_Shot_ = nullptr;
    pDepo_ShotEffect_ = nullptr;
    _pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");     //
}

void EnemyRis::onCreateModel() {
    _pModel->_pTexBlinker->setBlinkableRange(0.9, 0.5, 2.0);
    _pModel->_pTexBlinker->setPower(0.5);
    _pModel->_pTexBlinker->beat(60, 3, 1, -1);
}

void EnemyRis::initialize() {
    setHitAble(true);
    _pKuroko->relateFaceWithMvAng(true);
    _pKuroko->setFaceAngVelo(AXIS_X, 5000);
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB(0, -30000, -30000, -30000, 30000, 30000, 30000);
}

void EnemyRis::onActive() {
    _pStatus->reset();
    iMovePatternNo_ = 0; //sp^[Zbg
}

void EnemyRis::processBehavior() {
    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));

    switch (iMovePatternNo_) {
        case 0:  //yp^[OFXvCړJnz
            if (pKurokoLeader_) {
                pKurokoLeader_->start(SplineKurokoLeader::ABSOLUTE_COORD); //XvCړJn
            }
            iMovePatternNo_++; //̍sp^[
            break;

        case 1:  //yp^[PFXvCړI҂z
            if (pKurokoLeader_) {
                //XvCړL
                if (pKurokoLeader_->isFinished()) {
                    iMovePatternNo_++; //XvCړI玟̍sp^[
                }
            } else {
                //XvCړ
                iMovePatternNo_++; //Ɏ̍sp^[
            }
            break;

        case 2:  //yp^[QFˏVbg˂Ǝ@֕]z
            if (pDepo_Shot_) {
                //ˏVbg
                int way = RF_EnemyRis_ShotWay(G_RANK); //VbgWAY
                angle* paAng_way = NEW angle[way];
                UTIL::getRadialAngle2D(0, way, paAng_way);
                GgafDxDrawableActor* pActor_Shot;
                for (int i = 0; i < way; i++) {
                    pActor_Shot = (GgafDxDrawableActor*)pDepo_Shot_->dispatch();
                    if (pActor_Shot) {
                        pActor_Shot->positionAs(this);
                        pActor_Shot->_pKuroko->setRzRyMvAng(paAng_way[i], D90ANG);
                    }
                }
                GGAF_DELETEARR(paAng_way);
                //Vbg˃GtFNg
                if (pDepo_ShotEffect_) {
                    GgafDxDrawableActor* pTestActor_Shot = (GgafDxDrawableActor*)pDepo_ShotEffect_->dispatch();
                    if (pTestActor_Shot) {
                        pTestActor_Shot->positionAs(this);
                    }
                }
            }
            //@֕]
            _pKuroko->turnMvAngTwd(P_MYSHIP,
                                    3000, 0,
                                    TURN_CLOSE_TO, true);
            iMovePatternNo_++; //̍sp^[
            break;

        case 3:  //ysp^[RF@փObƋt]ŕ]Jnz
            if (_z-10000 < P_MYSHIP->_z && P_MYSHIP->_z < _z+10000) {
                //@Zڋ߂ObƋt]ŕ]
                _pKuroko->turnMvAngTwd(MyShip::lim_x_behaind_ - 500000 , _y, _z,
                                        10000, 0,
                                        TURN_CLOSE_TO, true);
                _pKuroko->setMvAcce(100);
                iMovePatternNo_++;
            } else {
                //@Zڋ߂܂ő҂
            }
            break;
        default:
            break;
    }


    if (pKurokoLeader_) {
        pKurokoLeader_->behave(); //XvCړU镑
    }
    _pKuroko->behave();
    //_pSeTx->behave();
}

void EnemyRis::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyRis::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        _pSeTx->play3D(SE_EXPLOSION);
    } else {
        //j
    }
}

void EnemyRis::onInactive() {
    sayonara();
}

EnemyRis::~EnemyRis() {
    GGAF_DELETE_NULLABLE(pKurokoLeader_);
}
