#include "stdafx.h"
#include "EnemyEsperia.h"

#include "jp/ggaf/core/actor/ex/GgafActorDepositoryStore.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxAlphaFader.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxMorpher.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/dxcore/model/supporter/GgafDxTextureBlinker.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/enemy/Esperia/EnemyEsperiaLaserChip001.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

int EnemyEsperia::max_laser_way_ = RF_EnemyEsperia_ShotWay(1.0);
//RF_EnemyEsperia_ShotWayN 1.0ōő悤ɂȂ΂ȂȂ

EnemyEsperia::EnemyEsperia(const char* prm_name) :
        DefaultMorphMeshActor(prm_name, "1/Esperia", STATUS(EnemyEsperia)) {
    pAFader_ = NEW GgafDxAlphaFader(this);
    cnt_laserchip_ = 0;
    laser_length_ = 40;
    now_laser_way_ = 0;
    //؂ꃌ[U[Zbg̃f|Wgێp
    papLaserChipDepo_ = NEW LaserChipDepository*[max_laser_way_];
    for (int i = 0; i < max_laser_way_; i++) {
        papLaserChipDepo_[i] = nullptr;
    }

    pConn_LaserChipDepoStore_ = connect_DepositoryManager("EnemyEsperiaLaserChip001DepoStore");
    pLaserChipDepoStore_ = (GgafActorDepositoryStore*)(pConn_LaserChipDepoStore_->peek());

    paLocalPos_Laser_ = NEW GgafDxGeoElem[max_laser_way_];
    paPos_Target_ = NEW GgafDxGeoElem[max_laser_way_];
    coord dX = PX_C(10); //[U[ˌ̊Ԋu
    for (int i = 0; i < max_laser_way_; i++) {
        paLocalPos_Laser_[i].set(PX_C(-40) + (i*dX),  PX_C(10), 0); //[U[ˌ̃[JW
    }

    _pSeTx->set(SE_EXPLOSION  , "WAVE_EXPLOSION_MIDDLE_001");
    _pSeTx->set(SE_DAMAGED    , "WAVE_ENEMY_DAMAGED_001");
    _pSeTx->set(SE_HATCH_OPEN , "WAVE_HATCH_OPEN_001");
    _pSeTx->set(SE_FIRE       , "WAVE_ENEMY_FIRE_LASER_001");
    _pSeTx->set(SE_HATCH_CLOSE, "WAVE_HATCH_CLOSE_001");
    dX_= dZ_ = 0;
    useProgress(PROG_BANPEI);
}

void EnemyEsperia::onCreateModel() {
    _pModel->_pTexBlinker->setBlinkableRange(0.97, 0.5, 12.0);
    _pModel->_pTexBlinker->setPower(1.0);
    _pModel->_pTexBlinker->beat(60*6, 60*2, 60*2, -1);
}

void EnemyEsperia::initialize() {
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliSphere(0, PX_C(200));
}

void EnemyEsperia::onActive() {
    _pStatus->reset();
    setHitAble(false);
    _pKuroko->setRzRyMvAng(0, D180ANG);
    _pKuroko->setMvVelo(1000);
    dX_= dZ_ = 0;
    //oʒu
    static coord appearances_renge_z = (MyShip::lim_z_left_ - MyShip::lim_z_right_) * 3;
    static coord appearances_renge_y = (MyShip::lim_y_top_ - MyShip::lim_y_bottom_) * 3;
    _x = GgafDxUniverse::_x_gone_right - 1000;
    _y = RND(-(appearances_renge_y/2) , +(appearances_renge_y/2));
    _z = RND(-(appearances_renge_z/2) , +(appearances_renge_z/2));

    _pProg->reset(PROG_ENTRY);
}

void EnemyEsperia::processBehavior() {
    //ZN|Cg
    _pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));
    MyShip* pMyShip = P_MYSHIP;
    switch (_pProg->get()) {
        case PROG_ENTRY: {
            if (_pProg->isJustChanged()) {
                UTIL::activateEntryEffectOf(this);
                pAFader_->setAlpha(0);
                pAFader_->fadeLinerUntil(0.98, 20);
            }
            if (!pAFader_->isFading()) {
                setHitAble(true);
                _pProg->changeNext();
            }
            pAFader_->behave();
            break;
        }
        case PROG_MOVE: {
            if (_pProg->isJustChanged()) {

            }
            if (_pProg->getFrameInProgress() == 100) {
                _pProg->changeNext();
            }
            break;
        }

        case PROG_HATCH_OPEN: {
            if (_pProg->isJustChanged()) {
                _pSeTx->play3D(SE_HATCH_OPEN);
                _pMorpher->morphLinerUntil(1, 1.0, 120);
            }
            if (_pProg->getFrameInProgress() == 120) {
                _pProg->changeNext();
            }
            break;
        }

        case PROG_FIRE: {
            if (_pProg->isJustChanged()) {
                //[U[Zbgi[U[`bṽf|WgŁAP{̃[U[j̃f|WgA
                //[U[Zbg݂̎ؓ
                now_laser_way_ = RF_EnemyEsperia_ShotWay(G_RANK); //񔭎˃[U[{
                coord laser_density = RF_EnemyEsperia_Density(G_RANK); //񃌁[U[ƃ[U[̌
                bool can_fire = false; //ȂƂ{͔˂ł邩ǂ

                for (int i = 0; i < max_laser_way_; i++) {
                    if (now_laser_way_ > i) {
                        LaserChipDepository* pLaserChipDepo = (LaserChipDepository*)(pLaserChipDepoStore_->dispatch());
                        if (pLaserChipDepo) {
                            //[U[Zbgi[U[`bṽf|Wgj؂oB
                            papLaserChipDepo_[i] = pLaserChipDepo;
                            papLaserChipDepo_[i]->config(laser_length_, 1);
                            can_fire = true;
                        } else {
                            //[U[Zbgi[U[`bṽf|Wgj؂oȂB
                            papLaserChipDepo_[i] = nullptr;
                        }
                    } else {
                        papLaserChipDepo_[i] = nullptr;
                    }
                }

                if (can_fire) { //˂Ł[
                    //^[QbgWݒ
                    //                    ^
                    //                    | X
                    //                    |
                    //              (b)   |   (c)
                    //                    |
                    //                    |
                    //                    |
                    //       (a)          |              (d)
                    //  Z                 |
                    //  <--------------- @------------------
                    //                    |
                    //                    |
                    //                    |
                    //                    |
                    //                    |
                    //                    |
                    //               (e)  |    (f)
                    //                    |
                    //                    |
                    //
                    //  (a)(d) ̏ꍇAXẐ
                    //         X̏
                    //                    ^
                    //                    | X
                    //                    |
                    //                    |
                    //  [[[[[[[[[[[[[[[[[[[ [3]
                    //                    |
                    //                    |
                    //  [[[[[[[[[[[[[[[[[[[ [2]
                    //  Z                 |
                    //  <--------------- @------------------
                    //                    |
                    //  [[[[[[[[[[[[[[[[[[[ [1]
                    //                    |
                    //                    |
                    //  [[[[[[[[[[[[[[[[[[[ [0]
                    //                    |
                    //                    |
                    //                    |
                    //ƂB
                    //
                    //
                    //  (b)(c) ̏ꍇAZX̂
                    //  Z     b     b       b     b
                    //  <-----b-----b- @-b-----b------
                    //        b     b       b     b
                    //        b     b       b     b
                    //                         
                    //       [0]     [1]      [2]    [3]  EEE (b)
                    //       [3]     [2]      [1]    [0]  EEE (c)
                    //  Ƃ
                    coord total_laser_effect = laser_density*(now_laser_way_-1)+1; //ꃌ[U[̂ꋗí͈j

                    dX_ = ABS(_x - pMyShip->_x);
                    dZ_ = ABS(_z - pMyShip->_z);
                    if (dX_ < dZ_)  {
                        //(a)(d) ̏ꍇAXZ
                        for (int i = 0, tX = -total_laser_effect/2; i < now_laser_way_; i++, tX+=laser_density) {
                            paPos_Target_[i].set(tX, 0, 0);
                        }
                    } else {
                        if (pMyShip->_x < _x) { //@O
                            //(b)(c)̏ꍇAZX
                            if (pMyShip->_z < _z) {
                                //(b)@OAGXyA
                                for (int i = 0, tZ = total_laser_effect/2; i < now_laser_way_; i++, tZ-=laser_density) {
                                    paPos_Target_[i].set(0, 0, tZ);
                                }
                            } else {
                                //(c)@AGXyAO
                                for (int i = 0, tZ = -total_laser_effect/2; i < now_laser_way_; i++, tZ+=laser_density) {
                                    paPos_Target_[i].set(0, 0, tZ);
                                }
                            }
                        } else { //@ (e)(f)
                            if (pMyShip->_z < _z) {
                                //(e)@OAGXyA
                                for (int i = 0, tZ = -total_laser_effect/2; i < now_laser_way_; i++, tZ+=laser_density) {
                                    paPos_Target_[i].set(0, 0, tZ);
                                }
                            } else {
                                //(f)@AGXyAO
                                for (int i = 0, tZ = total_laser_effect/2; i < now_laser_way_; i++, tZ-=laser_density) {
                                    paPos_Target_[i].set(0, 0, tZ);
                                }
                            }
                        }
                    }

                    _pSeTx->play3D(SE_FIRE); //ˉ
                    effectFlush(2); //tbV
                    cnt_laserchip_ = 0;
                }
            }

            //laser_length_ȓ̊ԁA[U[`bvdispatch()ݑ
            if (cnt_laserchip_ < laser_length_) {
                cnt_laserchip_++;
                EnemyEsperiaLaserChip001* pLaserChip;
                GgafDxGeoElem* p;
                coord turn_dY = getTurnDY(this, pMyShip, (dX_ > dZ_ ? dX_ : dZ_) );
                //turn_dY   EnemyEsperiaLaserChip001::turn_dY_Ɠ鎖
                for (int i = 0; i < max_laser_way_; i++) {
                    if (papLaserChipDepo_[i]) {
                        pLaserChip = (EnemyEsperiaLaserChip001*)papLaserChipDepo_[i]->dispatch();
                        if (pLaserChip) {
                            p = &(paLocalPos_Laser_[i]);
                            //ˌWɐݒ
                            pLaserChip->position(_x+p->x, _y+p->y, _z+p->z);
                            //ŏ̖ڕWn_(܂Ԃn_)ݒ
                            //VobNt߂邽߂YX
                            if (dX_ < dZ_)  {
                                //XZ
                                if (pMyShip->_z < _z) {
                                    //@OAGXyA
                                    pLaserChip->tX1_ = _x + paPos_Target_[i].x;
                                    pLaserChip->tY1_ = _y + paPos_Target_[i].y + turn_dY;
                                    pLaserChip->tZ1_ = _z + paPos_Target_[i].z + PX_C(100);
                                } else {
                                    //@AGXyAO
                                    pLaserChip->tX1_ = _x + paPos_Target_[i].x;
                                    pLaserChip->tY1_ = _y + paPos_Target_[i].y + turn_dY;
                                    pLaserChip->tZ1_ = _z + paPos_Target_[i].z - PX_C(100);
                                }
                            } else {
                                //VobNt߂邽X-100
                                pLaserChip->tX1_ = _x + paPos_Target_[i].x - PX_C(100);
                                pLaserChip->tY1_ = _y + paPos_Target_[i].y + turn_dY;
                                pLaserChip->tZ1_ = _z + paPos_Target_[i].z;
                            }

                            pLaserChip->turn_dY_ = turn_dY;
                            //ŏIڕWn_ݒ
                            pLaserChip->tX2_ = pMyShip->_x + paPos_Target_[i].x;
                            pLaserChip->tY2_ = pMyShip->_y + paPos_Target_[i].y;
                            pLaserChip->tZ2_ = pMyShip->_z + paPos_Target_[i].z;
                            //Ɖx
                            pLaserChip->_pKuroko->setMvVelo(10000); //x
                            pLaserChip->_pKuroko->setMvAcce(150+(max_laser_way_-i)*10); //o悤
                        }
                    }
                }
            } else {
                //[U[ł؂
                _pProg->changeNext();
            }
            break;
        }

        case PROG_HATCH_CLOSE: {
            if (_pProg->isJustChanged()) {
                _pSeTx->play3D(SE_HATCH_CLOSE);
                _pMorpher->morphLinerUntil(1, 0.0, 120);
            }
            if (_pProg->getFrameInProgress() == 120) {
                _pProg->changeNext();
            }
            break;
        }

        case PROG_NOTHING: {
            if (_pProg->getFrameInProgress() == 600) {
                _pProg->change(PROG_MOVE);
            }
            break;
        }
    }
    _pKuroko->behave();
    _pMorpher->behave();
}

void EnemyEsperia::processJudgement() {
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void EnemyEsperia::onHit(GgafActor* prm_pOtherActor) {
    bool was_destroyed = UTIL::proceedEnemyHit(this, (GgafDxGeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j
        _pSeTx->play3D(SE_EXPLOSION);
    } else {
        //j
        _pSeTx->play3D(SE_DAMAGED);
    }
}

void EnemyEsperia::onInactive() {
    //[U[f|Wg͒xĂ߂
    for (int i = 0; i < max_laser_way_; i++) {
        if (papLaserChipDepo_[i]) {
            papLaserChipDepo_[i]->sayonara(60*10);
        }
    }
    sayonara();
}

coord EnemyEsperia::getTurnDY(GgafDxCore::GgafDxGeometricActor* pThis,
                               GgafDxCore::GgafDxGeometricActor* pMyShip,
                               coord DT) {
    //                        ^ Y
    //                        |
    //                        |cccc
    //                      ^|     ^
    //                    ^  |     |
    //                  ^    |     | TurnDYiԂlj
    //                ^      |     |
    //              ^        |     v
    //            ^         Gcccc
    //          ^=5      |
    //    ---@-------------+--------->
    //      ^:               |
    //    ^  :               |
    //  ^    :<------------->|
    //        :     DT()  |
    //
    //DY = DTEtan(5) - (G_y - @_y)
    static double tan5 = tan(5*(PI/180.0)); //Txォł낷
    coord dY = pThis->_y - pMyShip->_y;
    coord TurnDY = DT*tan5 - dY;
    if (TurnDY < PX_C(100)) {
        return PX_C(100);
    } else {
        return TurnDY;
    }
}

EnemyEsperia::~EnemyEsperia() {
    GGAF_DELETE(pAFader_);
    pConn_LaserChipDepoStore_->close();
    GGAF_DELETEARR(paLocalPos_Laser_);
    GGAF_DELETEARR(paPos_Target_);
    GGAF_DELETEARR(papLaserChipDepo_);
}
