#include "stdafx.h"
#include "Shot004Yellow.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/effect/EffectExplosion001.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/CommonScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

Shot004Yellow::Shot004Yellow(const char* prm_name) :
        SingleLaser(prm_name, "Shot004Yellow", STATUS(Shot004)) { //SingleLaser͍ő27Zbgł
        //SingleLaser(prm_name, "27/laser_single") { //SingleLaser͍ő27Zbgł
    _class_name = "Shot004Yellow";
    view_in_ = false;
}

void Shot004Yellow::initialize() {

    setHitAble(false);
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB_Cube(0, PX_C(16));
}
void Shot004Yellow::onReset() {
    setScaleR(3.0);
    setAlpha(0.99); //ɂ邱Ƃŗʃ_O
    _pKuroko->setFaceAngVelo(AXIS_X, D_ANG(3));
    _pKuroko->setMvVelo(40000);             //ړx
    _pKuroko->setMvAcce(1000);             //ړx
    _pKuroko->relateFaceWithMvAng(true);
}

void Shot004Yellow::onActive() {
    setHitAble(true, false);
    view_in_ = false;
}

void Shot004Yellow::processBehavior() {
    //ZN|Cg
    //_pStatus->mul(STAT_AddRankPoint, _pStatus->getDouble(STAT_AddRankPoint_Reduction));
    //eȂ̂ŕsv

    //Wɔf
    _pKuroko->behave();
}

void Shot004Yellow::processJudgement() {
    if (isOutOfView()) {
        if (view_in_) {
            sayonara();
        }
        if (getActiveFrame() > 60) {
            sayonara();
        }
    } else {
        view_in_ = true;
    }
    if (isOutOfUniverse()) {
        sayonara();
    }
}

void Shot004Yellow::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*)prm_pOtherActor;
//    //EEERRɃqbgꂽGtFNg
    if (UTIL::calcEnemyStamina(this, pOther) <= 0) {
        UTIL::activateExplosionEffectOf(this); //GtFNg
        sayonara();
    }
}

Shot004Yellow::~Shot004Yellow() {
}
