#include "stdafx.h"
#include "Horizon001.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"
#include "jp/ggaf/dxcore/util/GgafDxInput.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxChecker.h"
#include "jp/gecchi/VioletVreath/scene/Universe.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


Horizon001::Horizon001(const char* prm_name) :
        DefaultMeshActor(prm_name, "Horizon001", nullptr) {
    _class_name = "Horizon001";
    setHitAble(false);
    setZEnable(true);        //Zobt@͍l
//    setZWriteEnable(false);  //Zobt@͏ݖ
//    setSpecialDrawDepth(DRAW_DEPTH_LEVEL_WORLDBOUND-3);
    drawAnyFar(true);//Ă\
    chip_width_ = PX_C(256);
}

void Horizon001::onCreateModel() {
}

void Horizon001::initialize() {
    setAlpha(0.99);
    position(0, PX_C(-100), 0);
    _pColliChecker->makeCollision(1);
    _pColliChecker->setColliAAB(0, Universe::_x_gone_left  + (chip_width_*2),
                                   0,
                                   Universe::_z_gone_near  + (chip_width_*2),
                                   Universe::_x_gone_right - (chip_width_*2),
                                   Universe::_y_gone_bottom - (chip_width_*2),
                                   Universe::_z_gone_far - (chip_width_*2));
    setBumpMapTexture("bumpstar_nmap.bmp");
}
void Horizon001::processBehavior() {
    _x = _x - PX_C(8);
    if (ABS(_x) >= chip_width_) {
        _x = 0;
    }
}

Horizon001::~Horizon001() {
}

