#include "stdafx.h"
#include "jp/ggaf/lib/util/spline/SplineSource.h"

#include <fstream>
#include "jp/ggaf/dxcore/scene/GgafDxUniverse.h"
#include "jp/ggaf/lib/util/spline/SplineLine.h"
#include "jp/ggaf/lib/GgafLibProperties.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

SplineSource::SplineSource(SplineLine* prm_pSp) : GgafObject() {
    _idstr = "Nothing";
    _pSp = prm_pSp;
    _accuracy = _pSp->_accuracy;
    _is_create_SplineLine = false;
}

SplineSource::SplineSource(char* prm_idstr)  : GgafObject() {
    _idstr = std::string(prm_idstr);
    _accuracy = 1.0;
    std::string data_filename = PROPERTY::DIR_SPLINE + _idstr;// + ".spls";
    std::ifstream ifs(data_filename.c_str());
    if (ifs.fail()) {
        throwGgafCriticalException("SplineSource::SplineSource "<<data_filename<<" J܂");
    }
    double p[MaxSplineSize][3];
    std::string line;
    int n = 0;
    while( getline(ifs,line) ) {
        if (UTIL::trim(line).size() == 0 ) continue;
        if (line.c_str()[0] == '#') continue;

        LOOP_SPLFILE:

        if (line.find("[BASEPOINT]") != std::string::npos) {
            while( getline(ifs,line) ) {
                if (UTIL::trim(line).size() == 0 ) {
                    break;
                }
                if (line.c_str()[0] == '#') continue;
                if (line.c_str()[0] == '[') goto LOOP_SPLFILE;
                std::istringstream iss(line);
                iss >> p[n][0];
                iss >> p[n][1];
                iss >> p[n][2];
                if (iss.fail()) {
                    throwGgafCriticalException("SplineSource::SplineSource [BASEPOINT]sȐlf[^ł line=["<<line<<"]");
                }
                n++;
                if (n >= MaxSplineSize) {
                    throwGgafCriticalException("SplineSource::SplineSource "<<_idstr<<" |Cg"<<MaxSplineSize<<"𒴂܂B");
                }
            }
        }
        if (line.find("[ACCURACY]") != std::string::npos) {
            while( getline(ifs,line) ) {
                if (UTIL::trim(line).size() == 0 ) break;
                if (line.c_str()[0] == '#') continue;
                if (line.c_str()[0] == '[') goto LOOP_SPLFILE;
                std::istringstream iss(line);
                iss >> _accuracy;
                if (iss.fail()) {
                    throwGgafCriticalException("SplineSource::SplineSource [ACCURACY]sȐlf[^ł line=["<<line<<"]");
                }
            }
        }
    }
    if (int(_accuracy*100000000) == 0) {
        throwGgafCriticalException("SplineSource::SplineSource "<<_idstr<<" [ACCURACY] w肳Ă܂B");
    }
    if (n == 0) {
        throwGgafCriticalException("SplineSource::SplineSource "<<_idstr<<" [BASEPOINT] ɍW܂B");
    }
    for (int i = 0; i < n; i++) {
        if (p[i][0] > GgafDxUniverse::_x_gone_right*0.9999) {
            p[i][0] = GgafDxUniverse::_x_gone_right*0.9999;
        }
        if (p[i][0] < GgafDxUniverse::_x_gone_left*0.9999) {
            p[i][0] = GgafDxUniverse::_x_gone_left*0.9999;
        }
        if (p[i][1] > GgafDxUniverse::_y_gone_top*0.9999) {
            p[i][1] = GgafDxUniverse::_y_gone_top*0.9999;
        }
        if (p[i][1] < GgafDxUniverse::_y_gone_bottom*0.9999) {
            p[i][1] = GgafDxUniverse::_y_gone_bottom*0.9999;
        }
        if (p[i][2] > GgafDxUniverse::_z_gone_far*0.9999) {
            p[i][2] = GgafDxUniverse::_z_gone_far*0.9999;
        }
        if (p[i][2] < GgafDxUniverse::_z_gone_near*0.9999) {
            p[i][2] = GgafDxUniverse::_z_gone_near*0.9999;
        }
    }
    _pSp = NEW SplineLine(p, n, _accuracy);
    _is_create_SplineLine = true;
}

//
//RXgN^œǂݍ spl t@C̃tH[}bg
//--------------------------------------------
//[BASEPOINT]
//#       X         Y         Z
//-1.724577  0.000000  0.000000
//-0.964337 -0.088378 -0.344892
//-0.501305 -0.055518 -0.298879
//-0.179336 -0.031628 -0.240141
// 0.123544 -0.016126 -0.165195
// 0.362343  0.000000  0.000000
// 0.545634  0.038709  0.176104
// 0.704048  0.173192  0.372772
// 0.864812  0.444651  0.516556
// 1.055714  0.626849  0.569336
// 1.246407  0.655359  0.547772
// 1.365876  0.590994  0.453279
// 1.388259  0.465998  0.332581
// 1.362117  0.328636  0.211183
// 1.242692  0.226675  0.087900
// 1.064405  0.202917  0.000000
// 0.920421  0.202917  0.000000
//
//[ACCURACY]
//0.2
//--------------------------------------------

//[BASEPOINT]
//XvCȐ̐_ X Y Z ŐݒB
//wł|Cg͍ő1000܂
//@̈ړ͈͂ -1.0 ` 1.0 ƂĐݒ肷B
//AÃXvCẂA΍WƂĈړsL邵A
//n_Ľ_̍WƂA_͑΍WƂĈړLA
//̐ݒ͊eL̃vOɑgݍ܂ĂARRł̎w͕sB
//
//[ACCURACY]
//XvCȐ̐xBBASEPOINTŎw肵_`_̊Ԃɂǂ̂炢̕⊮_ǉāA܂Ȃ߂炩ȋȐɋ߂Â邩ƂB
//1.0  w肷Ɛ_`_̊Ԃɕ⊮_͑}ꂸABASEPOINTwʂ̂܂܂ƂȂB
//0.5  w肷Ɗe_`_ɂāA2_ɕ⊮_vZđ}B(܂⊮_1})
//0.25 w肷Ɗe_`_ɂāA4_ɕ⊮_vZđ}B(܂⊮_3})
//0.1  w肷Ɗe_`_ɂāA10_ɕ⊮_vZđ}B(܂⊮_9})
//0.01 w肷Ɗe_`_ɂāA100_ɕ⊮_vZđ}B(܂⊮_99})
//ƂB
//

SplineSource::~SplineSource() {
    if (_is_create_SplineLine) {
        GGAF_DELETE(_pSp);
    }
}
