#ifndef GGAFLIB_SCENEPROGRESS_H_
#define GGAFLIB_SCENEPROGRESS_H_
#include "jp/ggaf/core/GgafProgress.h"

#include <map>
namespace GgafLib {

typedef std::map<progress, GgafLib::DefaultScene*> ProgSceneMap;

/**
 * ԑJڐiǗ(V[p)NX .
 * GgafProgressNXɁAV[ɂ܂֗ȋ@\ǉ
 * V[p̏ԑJڐiǗNXłB
 * @version 1.00
 * @since 2011/07/15
 * @author Masatoshi Tsuge
 */
class SceneProgress : public GgafCore::GgafProgress {

public:
    /** [r]iǗΏۃV[ */
    DefaultScene* _pScene;
    /** [r]iԍ  TuV[ */
    ProgSceneMap _mapProg2Scene;

    progress _progress_next_promise;
    frame _count_next_promise;

public:
    /**
     * RXgN^ .
     * @param prm_pScene       iǗΏۃV[
     * @param prm_num_progress őiԍ(10ݒ肷 0ԁ`10Ԃ11̐iԂgp\ƂȂ)
     */
    SceneProgress(DefaultScene* prm_pScene, int prm_num_progress);

    /**
     * iԂƃTuV[֘AtA.
     * ̃\bhɂA֘AtsƁAȉ̃\bhgp\iʂjƂȂ܂B<BR>
     * <code>
     * changeWithSceneFlipping(progress)
     * changeWithSceneCrossfading(progress, frame);
     * changeWithSceneOverlapping(progress, frame);
     * </code>
     * @param prm_FirstProgress 擪̐i
     * @param prm_EndProgress ̐i
     * @param prm_FirstSubSceneName 擪̐i(prm_FirstProgress)ɑΉTuV[̖
     */
    void relatSubScene(progress prm_FirstProgress, progress prm_EndProgress, const char* prm_FirstSubSceneName);


    /**
     * iԂƃTuV[֘AtA.
     * ̃\bhɂA֘AtsƁAȉ̃\bhgp\iʂjƂȂ܂B<BR>
     * <code>
     * changeWithSceneFlipping(progress)
     * changeWithSceneCrossfading(progress, frame);
     * changeWithSceneOverlapping(progress, frame);
     * </code>
     * @param prm_FirstProgress 擪̐i
     * @param prm_EndProgress   ̐i
     * @param prm_pFirstSubScene 擪̐i(prm_FirstProgress)ɑΉTuV[
     */
    void relatSubScene(progress prm_FirstProgress, progress prm_EndProgress, DefaultScene* prm_pFirstSubScene);

    /**
     * ViԂ؂ւƓɁA֘AtTuV[Ԃɂ .
     * ݂̐iԂɕRtTuV[͂̂܂܁i񊈓ɂ܂j .
     * {\bȟʂ𓾂ɂ relatSubScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     */
    void changeWithScene(progress prm_progress);

    /**
     * ViԂ؂ւƓɁA֘AtTuV[ɐ؂ւ .
     * ݂̐iԂɕRtTuV[͔񊈓ԂɂA̐iԂɕRtTuV[Ԃɂ܂B
     * {\bȟʂ𓾂ɂ relatSubScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     */
    void changeWithSceneFlipping(progress prm_progress);

    /**
     * ViԂ؂ւƓɁA֘AtTuV[Ԃɐ؂ւA
     * ԃTuV[͔񊈓ԂɂB̍ہAtF[hAEgEtF[hCʂs .
     * {\bȟʂ𓾂ɂ relatSubScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     * @param prm_cross_fade_frames tF[hC & tF[hAEgs
     */
    void changeWithSceneCrossfading(progress prm_progress, frame prm_cross_fade_frames = 300);

    /**
     * iԂɕRtTuV[̓tF[hAEg񊈓ԂɂA
     * ̌㒼Ɏ̐ViԂɕRtTuV[AtF[hCԂɂB .
     * {\bȟʂ𓾂ɂ relatSubScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     * @param prm_fade_out tF[hAEg
     * @param prm_fade_in tF[hC
     */
    void changeWithSceneFadeoutFadein(progress prm_progress, frame prm_fade_out=120, frame prm_fade_in = 120);

    /**
     * ViԂ؂ւƓɁA֘AtTuV[Ԃɐ؂ւA
     * ԃTuV[͔񊈓ԂɂB̍ہAwt[ԁAisiI[o[bsOj .
     * {\bȟʂ𓾂ɂ relatSubScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     * @param prm_overlapping_frames ist[
     */
    void changeWithSceneOverlapping(progress prm_progress, frame prm_overlapping_frames);

    /**
     * ݂̐iԂɊ֘AÂĂV[擾 .
     * 擾łȂꍇ nullptr
     * {\bȟʂ𓾂ɂ relatSubScene() \ߎsAV[֘AtKv܂B
     * @return
     */
    DefaultScene* getGazedScene();

    /**
     * iԂɊ֘AÂĂV[擾 .
     * 擾łȂꍇ nullptr
     * {\bȟʂ𓾂ɂ relatSubScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress i
     * @return
     */
    DefaultScene* getScene(progress prm_progress);

    /**
     * iԍύXAchangeDelay ͖Ƃɂ .
     * AAɂ͔fꂸ update() ɔfB
     * PROGRESS_NOTHING(-1) ͐ݒsB
     * reset(progress) Ǝg邱ƁB
     * @param prm_progress iԍ(0`)
     */
    virtual void change(progress prm_progress) override;

    /**
     * iԍ𖳂 PROGRESS_NOTHING(-1) ɕύXAchangeDelay ͖Ƃɂ .
     * AAɂ͔fꂸ update() ɔfB
     */
    virtual void changeNothing() override;

    /**
     * iԍ+1AchangeDelay ͖Ƃɂ .
     * AAɂ͔fꂸ update() ɔfB
     * change(_progress+1) ƓӖłB
     */
    virtual void changeNext() override;

    /**
     * iԍ̕ύX\B .
     * @param prm_progress \iԍ(0`)
     * @param prm_delay xt[
     */
    virtual void changeDelay(progress prm_progress, frame prm_delay);
    virtual void update() override;

    /**
     * fXgN^ .
     */
    virtual ~SceneProgress();
};

}
#endif /*GGAFLIB_SCENEPROGRESS_H_*/
