#ifndef GGAFDXCORE_GGAFDXSCALER_H_
#define GGAFDXCORE_GGAFDXSCALER_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * gkxNX.
 * GgafDxGeometricActor ̃o<BR>
 * _sx , _sy, _sz  EEE AN^[̃XP[<BR>
 * AȒPɑ삷邽߂ɐ݌vB<BR>
 * gk1.0{iXP[j́A{NXł̃XP[l1000ɑB
 * [{]      [{NX̃XP[l]
 * {          1000
 * 2.5{g     2500
 * ̑傫  500
 * k80%     800
 * {NXł́AXP[ƃXP[OƂP̈ӖŎgpĂӏB
 * XP[EEE݁ĩt[j̊gkԁAXP[l
 * XP[OEEEt[Ԃ̊gkԂ̑J
 * 2009/05/22 GgafDxKuroko 番B
 * TODO:GgafDxScaler,GgafDxMorpher,GgafDxTextureBlinker ʉB
 * @version 1.00
 * @since 2009/05/22
 * @author Masatoshi Tsuge
 */
class GgafDxScaler : public GgafCore::GgafObject {

public: //_sx , _sy, _sz ֘A //////////////////////////////////////////////
    /** [r]ΏۃAN^[ */
    GgafDxGeometricActor* const _pActor;
    /** [r/w]ẽXP[(1000  1{) */
    int _scale[3]; //[0]:XA[1]:YA[2]:ZBȍ~l  [3]EEEXAYAZ̈
    /** [r/w]e̖ڕW̃XP[ */
    int _target_scale[3];
    /** [r/w]ẽXP[ */
    int _top_scale[3];
    /** [r/w]ẽXP[ */
    int _bottom_scale[3];
    /** [r/w]e̖t[̃XP[̑ */
    int _velo_scale[3];
    /** [r/w]e̖t[̃XP[̑̑ */
    int _acce_scale[3];
    /** [r]ẽ[vJEgi2ŊgkZbgA1ȂΊgork̕Гj */
    int _one_way_cnt[3];
    /** [r]ẽXgbv\̃[vJEg */
    int _stop_one_way_num[3];
    /** [r]ẽXP[O@ */
    GgafDxScalingMethod _method[3];
    /** [r]r[gAe̎Opg̔g`ŃXP[ÕA^bNt[ */
    frame _beat_attack_frames[3];
    /** [r]r[gAe̎Opg̔g`ŃXP[ÕXgt[ */
    frame _beat_rest_frames[3];
    /** [r]r[gAẽXP[Oɔ₷t[ */
    frame _beat_target_frames[3];
    /** [r]r[gAẽA^bN牺܂ł̃t[ */
    frame _beat_down_frames[3];
    /** [r]r[gAJE^[ */
    frame _beat_frame_count[3];
    /** [r]r[gAiԍ */
    int _beat_progres[3];

public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  KpΏۂActor
     */
    GgafDxScaler(GgafDxGeometricActor* prm_pActor);

    /**
     * XP[𑊑ΎwiSwj
     * @param prm_scale_diff XP[l
     */
    inline void addScale(int prm_scale_diff) {
        for (int a = 0; a < 3; a++) {
            addScale((axis)a, prm_scale_diff);
        }
    }

    /**
     * XP[𑊑ΎwiPʂŎwj
     * @param prm_axis 
     * @param prm_scale_diff XP[l
     */
    inline void addScale(axis prm_axis, int prm_scale_diff) {
        setScale(prm_axis, _scale[prm_axis] + prm_scale_diff);
    }

    /**
     * XP[ΎwiSwj
     * @param prm_scale XP[l
     */
    inline void setScale(int prm_scale) {
        for (int a = 0; a < 3; a++) {
            setScale((axis)a, prm_scale);
        }
    }

    /**
     * XP[ΎwiPʂŎwj
     * @param prm_axis 
     * @param prm_scale XP[l
     */
    inline void setScale(axis prm_axis, int prm_scale) {
        if (_top_scale[prm_axis] < prm_scale) {
            _scale[prm_axis] = _top_scale[prm_axis];
        } else if (_bottom_scale[prm_axis] > prm_scale) {
            _scale[prm_axis] = _bottom_scale[prm_axis];
        } else {
            _scale[prm_axis] = prm_scale;
        }
    }

    /**
     * XP[̏ݒiSwj .
     * ̑召͋Cɂn(Ŏ)
     * @param prm_scale1 XP[l1
     * @param prm_scale2 XP[l2
     */
    void forceRange(int prm_scale1, int prm_scale2) {
        for (int a = 0; a < 3; a++) {
            forceRange((axis)a, prm_scale1, prm_scale2);
            setScale((axis)a, _scale[a]);
        }
    }

    /**
     * XP[̏ݒiPʂŎwj
     * @param prm_axis 
     * @param prm_scale1 XP[l1
     * @param prm_scale2 XP[l2
     */
    void forceRange(axis prm_axis, int prm_scale1, int prm_scale2) {
        if (prm_scale1 < prm_scale2) {
            _bottom_scale[prm_axis] = prm_scale1;
            _top_scale[prm_axis] = prm_scale2;
        } else {
            _bottom_scale[prm_axis] = prm_scale2;
            _top_scale[prm_axis] = prm_scale1;
        }
    }

    /**
     * XP[Zbg iSwj .
     * {IuWFNg(GgafDxScaler)ɂĕωO
     * ̑傫ɖ߂B
     */
    void setScaleToBottom() {
        for (int a = 0; a < 3; a++) {
            setScaleToBottom((axis)a);
        }
    }

    /**
     * XP[Zbg iPʂŎwj
     * {IuWFNg(GgafDxScaler)ɂĕωO
     * ̑傫ɖ߂B
     * @param prm_axis 
     */
    void setScaleToBottom(axis prm_axis) {
        _scale[prm_axis] = _bottom_scale[prm_axis];
    }

    void setScaleToTop() {
        for (int a = 0; a < 3; a++) {
            setScaleToTop((axis)a);
        }
    }
    void setScaleToTop(axis prm_axis) {
        _scale[prm_axis] = _top_scale[prm_axis];
    }

    /**
     * XP[O~B iSwj .
     */
    void stopImmed();

    /**
     * XP[O~B iPʂŎwj.
     * @param prm_axis
     */
    void stopImmed(axis prm_axis);

    /**
     * ГXP[OiSEt[wj .
     * ڕW̃XP[ֈ葬xŃXP[O
     * @param prm_target_scale ڕWXP[
     * @param prm_spend_frame ₷t[
     */
    void scaleLinerUntil(int prm_target_scale, frame prm_spend_frame);

    /**
     * XP[֕ГXP[OiSEt[wj .
     * @param prm_spend_frame ₷t[
     */
    void scaleLinerTop(frame prm_spend_frame);

    /**
     * XP[֕ГXP[OiSEt[wj .
     * @param prm_spend_frame ₷t[
     */
    void scaleLinerBottom(frame prm_spend_frame);

    /**
     * ГXP[OiPʁEt[wj .
     * ڕW̃XP[ֈ葬xŃXP[OB
     * @param prm_axis 
     * @param prm_target_scale ڕWXP[
     * @param prm_spend_frame ₷t[
     */
    void scaleLinerUntil(axis prm_axis, int prm_target_scale, frame prm_spend_frame);

    /**
     * ГXP[OiSEXP[xwj .
     * ڕW̃XP[ֈ葬xŃXP[O
     * @param prm_target_scale ڕWXP[
     * @param prm_velo_scale t[ZXP[(>0.0)B̃XP[w肷鎖BZZ͎fB
     */
    void scaleLinerStep(int prm_target_scale, int prm_velo_scale);

    /**
     * ГXP[OiPʁEXP[xwj .
     * ڕW̃XP[ֈ葬xŃXP[OiXP[wj .
     * @param prm_axis 
     * @param prm_target_scale ڕWXP[
     * @param prm_velo_scale t[ZXP[(>0.0)B̃XP[w肷鎖BZZ͎fB
     */
    void scaleLinerStep(axis prm_axis, int prm_target_scale, int prm_velo_scale);

    /**
     * ГXP[OiSEXP[xEXP[xwj .
     * ڕW̃XP[։wŃXP[O
     * XP[x0Ɏw肷 scaleLinerStep ƂقړӖɂȂB
     * scaleLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * XP[x̏ꍇAڕWXP[𒴂ƃXP[OIB
     * XP[x̏ꍇAڕWXP[ƃXP[OIB
     * @param prm_target_scale ڕWXP[
     * @param prm_velo_scale XP[x
     * @param prm_acce_scale XP[x
     */
    void scaleAcceStep(int prm_target_scale, int prm_velo_scale, int prm_acce_scale);

    /**
     * ГXP[OiPʁEXP[xEXP[xwj .
     * ڕW̃XP[։wŃXP[OiXP[xAXP[xwj .
     * XP[x0Ɏw肷 scaleLinerStep ƂقړӖɂȂB
     * scaleLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * @param prm_axis 
     * @param prm_target_scale ڕWXP[
     * @param prm_velo_scale XP[x
     * @param prm_acce_scale XP[x
     */
    void scaleAcceStep(axis prm_axis, int prm_target_scale, int prm_velo_scale, int prm_acce_scale);

    /**
     * XP[OiSEt[wj .
     * ڕW̃XP[ֈ葬xŃXP[OA葬xŌɖ߂B[vw肷BiP[ṽt[wj .
     * @param prm_beat_target_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(0.5 PʂŎw\)
     */
    void loopLiner(frame prm_beat_target_frames, float prm_beat_num);

    /**
     * XP[OiPʁEt[wj
     * ڕW̃XP[ֈ葬xŃXP[OA葬xŌɖ߂B
     * [vw肷BiP[ṽt[wj .
     * @param prm_axis 
     * @param prm_beat_target_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(0.5 PʂŎw\)
     */
    void loopLiner(axis prm_axis, frame prm_beat_target_frames, float prm_beat_num);

    /**
     * Opg̔g`ŃXP[OBiSwj.
     * <PRE>
     * C  _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
     *            /_                     /_
     *           /   _                  /   _
     *          /      _               /      _
     *         /         _            /         _
     *        /            _         /            _
     * D  Q/               _QQQ/               _Q
     *
     *       A            B
     *        @ 
     * </PRE>
     * KvȐݒl<BR>
     * @ P[ṽt[<BR>
     * A A^bN܂ł̃t[<BR>
     * B xet[<BR>
     * C XP[(_top_scale[] z񂪕ێ)<BR>
     * D XP[(_bottom_scale[] z񂪕ێ)<BR>
     * @param prm_beat_target_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_rest_frames }ŇB̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    void beat(frame prm_beat_target_frames,
              frame prm_attack_frames,
              frame prm_rest_frames,
              float prm_beat_num);

    /**
     * Opg̔g`ŃXP[OBiwj.
     * @param prm_axis 
     * @param prm_beat_target_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_rest_frames }ŇB̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    void beat(axis prm_axis,
              frame prm_beat_target_frames,
              frame prm_attack_frames,
              frame prm_rest_frames,
              float prm_beat_num);

    /**
     * XP[Oǂׂ .
     * @param prm_axis 
     * @return true/false
     */
    bool isScaling(axis prm_axis);

    /**
     * XP[Oǂׂ .
     * @return true/false
     */
    bool isScaling();

    void reset();

    /**
     * t[̐U镑\bhB<BR>
     * {NX̋@\𗘗pꍇ́Ã\bh<BR>
     * t[s邱ƂKvB
     */
    virtual void behave();

    virtual ~GgafDxScaler();
};

}
#endif /*GGAFDXCORE_GGAFDXSCALER_H_*/

