#ifndef GGAFDXCORE_GGAFDXCOLORIST_H_
#define GGAFDXCORE_GGAFDXCOLORIST_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

#define COLOR_R 0
#define COLOR_G 1
#define COLOR_B 2
#define COLOR_A 3;

/**
 * J[Xg.
 * TODO:ݖgpB쐬B
 * @version 1.00
 * @since 2011/07/28
 * @author Masatoshi Tsuge
 */
class GgafDxColorist : public GgafCore::GgafObject {

public:
    /** ΏۃAN^[ */
    GgafDxDrawableActor* const _pActor;

    /** eFvf̋x(1000  1{) */
    int _color[4]; //[0]:RFvfA[1]:GFvfA[2]:BFvf
    /** eFvf̖ڕW̋x */
    int _target_color[4];
    /** eFvf̋x */
    int _top_color[4];
    /** eFvf̋x */
    int _bottom_color[4];
    /** eFvf̖t[̋x̑ */
    int _velo_color[4];
    /** eFvf̖t[̋x̑̑ */
    int _acce_color[4];
    /** eFvf̃[vJEgi2ŊgkZbgA1ȂΊgork̕Гj */
    int _one_way_cnt[4];
    /** eFvf̃Xgbv\̃[vJEg */
    int _stop_one_way_num[4];
    /** eFvf̃XP[O@ */
    GgafDxColoringMethod _method[4];

    /** r[gAeFvf̎Opg̔g`ŃXP[ÕA^bNt[ */
    frame _beat_attack_frames[4];
    /** r[gAeFvf̎Opg̔g`ŃXP[ÕXgt[ */
    frame _beat_rest_frames[4];
    /** r[gAeFvf̃XP[Oɔ₷t[ */
    frame _beat_target_frames[4];
    /** r[gAeFvf̃A^bN牺܂ł̃t[ */
    frame _beat_down_frames[4];
    /** r[gAJE^[ */
    frame _beat_frame_count[4];
    /** r[gAiԍ */
    int _beat_progres[4];

public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  KpΏۂActor
     */
    GgafDxColorist(GgafDxDrawableActor* prm_pActor);

    /**
     * x𑊑ΎwiSFvfwj
     * @param prm_color_diff xl
     */
    void addColor(int prm_color_diff) {
        for (int c = 0; c < 3; c++) {
            addColor(c, prm_color_diff);
        }
    }
    /**
     * x𑊑ΎwiFvfPʂŎwj
     * @param prm_c Fvf
     * @param prm_color_diff xl
     */
    void addColor(int prm_c, int prm_color_diff) {
        setColor(prm_c, _color[prm_c] + prm_color_diff);
    }

    /**
     * xΎwiSFvfwj
     * @param prm_color xl
     */
    void setColor(int prm_color) {
        for (int c = 0; c < 3; c++) {
            setColor(c, prm_color);
        }
    }

    /**
     * xΎwiFvfPʂŎwj
     * @param prm_c Fvf
     * @param prm_color xl
     */
    void setColor(int prm_c, int prm_color) {
        //_TRACE_("setColor ["<<prm_c<<"]prm_color="<<prm_color);
        //_TRACE_("setColor _bottom_color["<<prm_c<<"]="<<_bottom_color[prm_c]<<"/_top_color["<<prm_c<<"]="<<_top_color[prm_c]<<"");
        if (_top_color[prm_c] < prm_color) {
            _color[prm_c] = _top_color[prm_c];
        } else if (_bottom_color[prm_c] > prm_color) {
            _color[prm_c] = _bottom_color[prm_c];
        } else {
            _color[prm_c] = prm_color;
        }
        //_TRACE_("setColor _color ["<<prm_c<<"] _color[prm_c]="<<prm_color);
    }
    /**
     * x̏ݒiSFvfwj .
     * ̑召͋Cɂn(Ŏ)
     * @param prm_color1 xl1
     * @param prm_color2 xl2
     */
    void forceColorRange(int prm_color1, int prm_color2) {
        for (int c = 0; c < 3; c++) {
            forceColorRange(c, prm_color1, prm_color2);
            setColor(c, _color[c]);
        }
    }
    /**
     * x̏ݒiFvfPʂŎwj
     * @param prm_c Fvf
     * @param prm_color1 xl1
     * @param prm_color2 xl2
     */
    void forceColorRange(int prm_c, int prm_color1, int prm_color2) {
        if (prm_color1 < prm_color2) {
            _bottom_color[prm_c] = prm_color1;
            _top_color[prm_c] = prm_color2;
        } else {
            _bottom_color[prm_c] = prm_color2;
            _top_color[prm_c] = prm_color1;
        }
        //_TRACE_("forceColorRange _bottom_color["<<prm_c<<"]="<<_bottom_color[prm_c]<<"/_top_color["<<prm_c<<"]="<<_top_color[prm_c]<<"");
    }
    /**
     * xZbg iSFvfwj .
     * {IuWFNg(GgafDxColorist)ɂĕωO
     * ̑傫ɖ߂B
     */
    void setColorToBottom() {
        for (int c = 0; c < 3; c++) {
            setColorToBottom(c);
        }
    }
    /**
     * xZbg iFvfPʂŎwj
     * {IuWFNg(GgafDxColorist)ɂĕωO
     * ̑傫ɖ߂B
     * @param prm_c Fvf
     */
    void setColorToBottom(int prm_c) {
        _color[prm_c] = _bottom_color[prm_c];
    }

    void setColorToTop() {
        for (int c = 0; c < 3; c++) {
            setColorToTop(c);
        }
    }
    void setColorToTop(int prm_c) {
        _color[prm_c] = _top_color[prm_c];
    }

    /**
     * XP[O~B iSFvfwj .
     */
    void stopImmed();
    /**
     * XP[O~B iFvfPʂŎwj.
     * @param prm_c
     */
    void stopImmed(int prm_c);

    /**
     * ГXP[OiSFvfEt[wj .
     * ڕW̋xֈ葬xŃXP[O
     * @param prm_target_color ڕWx
     * @param prm_spend_frame ₷t[
     */
    void colorLinerUntil(int prm_target_color, frame prm_spend_frame);

    /**
     * ГXP[OiFvfPʁEt[wj .
     * ڕW̋xֈ葬xŃXP[OB
     * @param prm_c Fvf
     * @param prm_target_color ڕWx
     * @param prm_spend_frame ₷t[
     */
    void colorLinerUntil(int prm_c, int prm_target_color, frame prm_spend_frame);

    /**
     * ГXP[OiSFvfExxwj .
     * ڕW̋xֈ葬xŃXP[O
     * @param prm_target_color ڕWx
     * @param prm_velo_color t[Z鋭x(>0.0)B̋xw肷鎖BZZ͎fB
     */
    void colorLinerStep(int prm_target_color, int prm_velo_color);

    /**
     * ГXP[OiFvfPʁExxwj .
     * ڕW̋xֈ葬xŃXP[Oixwj .
     * @param prm_c Fvf
     * @param prm_target_color ڕWx
     * @param prm_velo_color t[Z鋭x(>0.0)B̋xw肷鎖BZZ͎fB
     */
    void colorLinerStep(int prm_c, int prm_target_color, int prm_velo_color);

    /**
     * ГXP[OiSFvfExxExxwj .
     * ڕW̋x։wŃXP[O
     * xx0Ɏw肷 colorLinerStep ƂقړӖɂȂB
     * colorLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * xx̏ꍇAڕWx𒴂ƃXP[OIB
     * xx̏ꍇAڕWxƃXP[OIB
     * @param prm_target_color ڕWx
     * @param prm_velo_color xx
     * @param prm_acce_color xx
     */
    void colorAcceStep(int prm_target_color, int prm_velo_color, int prm_acce_color);

    /**
     * ГXP[OiFvfPʁExxExxwj .
     * ڕW̋x։wŃXP[OixxAxxwj .
     * xx0Ɏw肷 colorLinerStep ƂقړӖɂȂB
     * colorLinerStep ̑R͐Cɂ邱ƖA{\bh͐̎͂ȂiłȂjB
     * @param prm_c Fvf
     * @param prm_target_color ڕWx
     * @param prm_velo_color xx
     * @param prm_acce_color xx
     */
    void colorAcceStep(int prm_c, int prm_target_color, int prm_velo_color, int prm_acce_color);

    /**
     * XP[OiSFvfEt[wj .
     * ڕW̋xֈ葬xŃXP[OA葬xŌɖ߂B[vw肷BiP[ṽt[wj .
     * @param prm_beat_target_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(0.5 PʂŎw\)
     */
    void loopLiner(frame prm_beat_target_frames, float prm_beat_num);

    /**
     * XP[OiFvfPʁEt[wj
     * ڕW̋xֈ葬xŃXP[OA葬xŌɖ߂B
     * [vw肷BiP[ṽt[wj .
     * @param prm_c Fvf
     * @param prm_beat_target_frames P[v(ωČɖ߂܂)ɔ₷t[
     * @param prm_beat_num [v(0.5 PʂŎw\)
     */
    void loopLiner(int prm_c, frame prm_beat_target_frames, float prm_beat_num);

    /**
     * Opg̔g`ŃXP[OBiSFvfwj.
     * <PRE>
     * C  _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
     *            /_                     /_
     *           /   _                  /   _
     *          /      _               /      _
     *         /         _            /         _
     *        /            _         /            _
     * D  Q/               _QQQ/               _Q
     *
     *       A            B
     *        @ 
     * </PRE>
     * KvȐݒl<BR>
     * @ P[ṽt[<BR>
     * A A^bN܂ł̃t[<BR>
     * B xet[<BR>
     * C x(_top_color[Fvf] z񂪕ێ)<BR>
     * D x(_bottom_color[Fvf] z񂪕ێ)<BR>
     * @param prm_beat_target_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_rest_frames }ŇB̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    void beat(frame prm_beat_target_frames,
              frame prm_attack_frames,
              frame prm_rest_frames,
              float prm_beat_num);
    /**
     * Opg̔g`ŃXP[OBiFvfwj.
     * @param prm_c Fvf
     * @param prm_beat_target_frames }Ň@̃t[
     * @param prm_attack_frames }ŇÃt[
     * @param prm_rest_frames }ŇB̃t[
     * @param prm_beat_num [v(-1Ŗ)
     */
    void beat(int prm_c,
              frame prm_beat_target_frames,
              frame prm_attack_frames,
              frame prm_rest_frames,
              float prm_beat_num);

    /**
     * t[̐U镑\bhB<BR>
     * {NX̋@\𗘗pꍇ́Ã\bh<BR>
     * t[s邱ƂKvB
     */
    virtual void behave();

    virtual ~GgafDxColorist();
};

}
#endif /*GGAFDXCORE_GGAFDXCOLORIST_H_*/

