﻿using System;
using System.Collections.Generic;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using FooEditEngine;

// 基本ページのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234237 を参照してください

namespace FooEditor
{
    /// <summary>
    /// 多くのアプリケーションに共通の特性を指定する基本ページ。
    /// </summary>
    public sealed partial class SettingsFlyout : FooEditor.Common.LayoutAwarePage
    {
        Popup parent;

        public SettingsFlyout()
        {
            this.InitializeComponent();

            List<LineBreakMethod> methodList = new List<LineBreakMethod>();
            methodList.Add(LineBreakMethod.None);
            methodList.Add(LineBreakMethod.CharUnit);
            methodList.Add(LineBreakMethod.PageBound);
            this.LineBreakMethodCollection.ItemsSource = methodList;

            this.FontFamilyCollection.ItemsSource = FontFamillyCollection.GetFonts();
            
            this.FlyoutContent.DataContext = AppSettings.Current;
        }

        /// <summary>
        /// このページには、移動中に渡されるコンテンツを設定します。前のセッションからページを
        /// 再作成する場合は、保存状態も指定されます。
        /// </summary>
        /// <param name="navigationParameter">このページが最初に要求されたときに
        /// <see cref="Frame.Navigate(Type, Object)"/> に渡されたパラメーター値。
        /// </param>
        /// <param name="pageState">前のセッションでこのページによって保存された状態の
        /// ディクショナリ。ページに初めてアクセスするとき、状態は null になります。</param>
        protected override void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
            this.parent = (Popup)navigationParameter;
        }

        /// <summary>
        /// アプリケーションが中断される場合、またはページがナビゲーション キャッシュから破棄される場合、
        /// このページに関連付けられた状態を保存します。値は、
        /// <see cref="SuspensionManager.SessionState"/> のシリアル化の要件に準拠する必要があります。
        /// </summary>
        /// <param name="pageState">シリアル化可能な状態で作成される空のディクショナリ。</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
        }

        protected override void GoBack(object sender, RoutedEventArgs e)
        {
            this.parent.IsOpen = false;
        }
    }
}
