﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Threading.Tasks;
using System.Runtime.Serialization;
using System.IO;
using Windows.Storage;
using FooEditEngine;

namespace FooEditor
{
    public class AppSettings
    {
        static ObservableCollection<FileType> _FileTypeCollection;
        static AppSettings _thisInstance = new AppSettings();
        public static AppSettings Current
        {
            get
            {
                if (ApplicationData.Current.LocalSettings.Values["FontFamily"] == null)
                    ApplicationData.Current.LocalSettings.Values["FontFamily"] = "Calibri";
                if (ApplicationData.Current.LocalSettings.Values["FontSize"] == null)
                    ApplicationData.Current.LocalSettings.Values["FontSize"] = 12.0;
                if (ApplicationData.Current.LocalSettings.Values["TabChar"] == null)
                    ApplicationData.Current.LocalSettings.Values["TabChar"] = 4;
                if (ApplicationData.Current.LocalSettings.Values["IsRTL"] == null)
                    ApplicationData.Current.LocalSettings.Values["IsRTL"] = false;
                if (ApplicationData.Current.LocalSettings.Values["ShowTab"] == null)
                    ApplicationData.Current.LocalSettings.Values["ShowTab"] = true;
                if (ApplicationData.Current.LocalSettings.Values["ShowFullSpace"] == null)
                    ApplicationData.Current.LocalSettings.Values["ShowFullSpace"] = true;
                if (ApplicationData.Current.LocalSettings.Values["ShowRuler"] == null)
                    ApplicationData.Current.LocalSettings.Values["ShowRuler"] = false;
                if (ApplicationData.Current.LocalSettings.Values["ShowLineNumber"] == null)
                    ApplicationData.Current.LocalSettings.Values["ShowLineNumber"] = false;
                if (ApplicationData.Current.LocalSettings.Values["ShowLineMarker"] == null)
                    ApplicationData.Current.LocalSettings.Values["ShowLineMarker"] = true;
                if (ApplicationData.Current.LocalSettings.Values["LineBreakMethod"] == null)
                    ApplicationData.Current.LocalSettings.Values["LineBreakMethod"] = (int)FooEditEngine.LineBreakMethod.None;
                if (ApplicationData.Current.LocalSettings.Values["LineBreakCount"] == null)
                    ApplicationData.Current.LocalSettings.Values["LineBreakCount"] = 80;
                if (_FileTypeCollection == null)
                    LoadFileTypeCollection();
                return _thisInstance;
            }
        }

        private static void LoadFileTypeCollection()
        {
            DataContractSerializer serializer = new DataContractSerializer(typeof(ObservableCollection<FileType>));
            Stream fs = null;
            try
            {
                Task<Stream> task = ApplicationData.Current.LocalFolder.OpenStreamForReadAsync("FileTypes.xml");
                fs = task.Result;
                _FileTypeCollection = (ObservableCollection<FileType>)serializer.ReadObject(fs);
            }
            catch (Exception)
            {
                _FileTypeCollection = new ObservableCollection<FileType>();
                FileType fileType = new FileType("Text", "");
                fileType.ExtensionCollection.Add(".txt");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("C", "clang.xml");
                fileType.ExtensionCollection.Add(".c");
                fileType.ExtensionCollection.Add(".cs");
                fileType.ExtensionCollection.Add(".cpp");
                fileType.ExtensionCollection.Add(".h");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("CSS", "css.xml");
                fileType.ExtensionCollection.Add(".css");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("HTML", "html.xml");
                fileType.ExtensionCollection.Add(".htm");
                fileType.ExtensionCollection.Add(".html");
                fileType.ExtensionCollection.Add(".xhtml");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("Java", "java.xml");
                fileType.ExtensionCollection.Add(".java");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("JavaScript", "javascript.xml");
                fileType.ExtensionCollection.Add(".js");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("Perl", "perl.xml");
                fileType.ExtensionCollection.Add(".pl");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("PHP", "php.xml");
                fileType.ExtensionCollection.Add(".php");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("Python", "python.xml");
                fileType.ExtensionCollection.Add(".py");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("Ruby", "ruby.xml");
                fileType.ExtensionCollection.Add(".rb");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("VisualBasic", "vb.xml");
                fileType.ExtensionCollection.Add(".vb");
                fileType.ExtensionCollection.Add(".vbs");
                _FileTypeCollection.Add(fileType);
                fileType = new FileType("XML", "xml.xml");
                fileType.ExtensionCollection.Add(".xml");
                _FileTypeCollection.Add(fileType);
            }
            finally
            {
                if (fs != null)
                    fs.Dispose();
            }
        }

        public async Task Save()
        {
            DataContractSerializer serializer = new DataContractSerializer(typeof(ObservableCollection<FileType>));
            StorageFile file = await ApplicationData.Current.LocalFolder.CreateFileAsync("FileTypes.xml",CreationCollisionOption.ReplaceExisting);
            using (Stream fs = await file.OpenStreamForWriteAsync())
            {
                serializer.WriteObject(fs, _FileTypeCollection);
            }
        }

        public LineBreakMethod LineBreakMethod
        {
            get
            {
                return (LineBreakMethod)(int)ApplicationData.Current.LocalSettings.Values["LineBreakMethod"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["LineBreakMethod"] = (int)value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public int LineBreakCount
        {
            get
            {
                return (int)ApplicationData.Current.LocalSettings.Values["LineBreakCount"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["LineBreakCount"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public ObservableCollection<FileType> FileTypeCollection
        {
            get
            {
                return _FileTypeCollection;
            }
        }

        public string FontFamily
        {
            get
            {
                return (string)ApplicationData.Current.LocalSettings.Values["FontFamily"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["FontFamily"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public double FontSize
        {
            get
            {
                return (double)ApplicationData.Current.LocalSettings.Values["FontSize"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["FontSize"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public int TabChar
        {
            get
            {
                return (int)ApplicationData.Current.LocalSettings.Values["TabChar"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["TabChar"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool IsRTL
        {
            get
            {
                return (bool)ApplicationData.Current.LocalSettings.Values["IsRTL"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["IsRTL"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool ShowTab
        {
            get
            {
                return (bool)ApplicationData.Current.LocalSettings.Values["ShowTab"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["ShowTab"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool ShowFullSpace
        {
            get
            {
                return (bool)ApplicationData.Current.LocalSettings.Values["ShowFullSpace"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["ShowFullSpace"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool ShowRuler
        {
            get
            {
                return (bool)ApplicationData.Current.LocalSettings.Values["ShowRuler"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["ShowRuler"] = value;
                if(ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool ShowLineNumber
        {
            get
            {
                return (bool)ApplicationData.Current.LocalSettings.Values["ShowLineNumber"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["ShowLineNumber"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public bool ShowLineMarker
        {
            get
            {
                return (bool)ApplicationData.Current.LocalSettings.Values["ShowLineMarker"];
            }
            set
            {
                ApplicationData.Current.LocalSettings.Values["ShowLineMarker"] = value;
                if (ChangedSetting != null)
                    ChangedSetting(this, null);
            }
        }

        public event EventHandler ChangedSetting;
        public event EventHandler OccueredShare;
    }

    [DataContract]
    public class FileType
    {
        [DataMember]
        ObservableCollection<string> _ExtensionCollection;
        [DataMember]
        string _DocumentTypeName,_DocumentType;

        public ObservableCollection<string> ExtensionCollection
        {
            get
            {
                return this._ExtensionCollection;
            }
        }
        
        public string DocumentTypeName
        {
            get
            {
                return _DocumentTypeName;
            }
            set
            {
                _DocumentTypeName = value;
            }
        }
        
        public string DocumentType
        {
            get
            {
                return this._DocumentType;
            }
            set
            {
                this._DocumentType = value;
            }
        }
        public FileType(string name,string doctype)
        {
            this._ExtensionCollection = new ObservableCollection<string>();
            this._DocumentTypeName = name;
            this._DocumentType = doctype;
        }
    }
}
