﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Controls;
using FooEditEngine;
using FooEditor;

namespace Outline
{
    class OutlineAnalyzer
    {
        public static void Analyze(TreeView treeView1, IFoldingStrategy foldingMethod,LineToIndexTable layoutlineCollection,Document doc)
        {
            if (foldingMethod == null)
                return;
            int level = -1;
            List<TreeViewItem> childItems = new List<TreeViewItem>();
            foreach (OutlineItem item in foldingMethod.AnalyzeDocument(doc, 0, doc.Length - 1))
            {
                TreeViewItem newItem = new TreeViewItem();
                if (level == -1 || level < item.Level)
                {
                    level = item.Level;
                }
                else if (level > item.Level)
                {
                    level = item.Level;
                    foreach (TreeViewItem childItem in childItems)
                        newItem.Items.Add(childItem);
                    childItems.Clear();
                }
                int row = layoutlineCollection.GetLineNumberFromIndex(item.Start);
                newItem.Tag = item;
                newItem.Header = layoutlineCollection[row].Trim(new char[] { ' ', '\t', '.', Document.NewLine });
                childItems.Add(newItem);
            }
            foreach (TreeViewItem childItem in childItems)
                treeView1.Items.Add(childItem);
        }

        public static int GetWZTextLevel(string str)
        {
            int level = -1;
            for (int i = 0; i < str.Length; i++)
            {
                if (str[i] == '.')
                    level++;
                else
                    break;
            }
            return level;
        }

    }
}
