#!/bin/busybox sh

for rtld in /lib/ld-linux-armhf.so.* /lib/ld-linux.so.* '' ; do
  [ -x "$rtld" ] && break
done
[ -z "$rtld" ] && exit 1

warn=''
bind_now=''
verbose=''
ld_debug=''
rtldALT=''
ldd1ALT () {
  local h
  if ! [ -s "$1" -a -x "$1" ] ; then
    echo "Not executable: $1" 1>&2
    return 1
  fi
  if "$rtld" --verify "$1" >/dev/null 2>&1 ; then
    echo "${1}:"
    if [ -x "$rtldALT" ] ; then
      LD_WARN=$warn \
        LD_BIND_NOW=$bind_now \
        LD_VERBOSE=$verbose \
        LD_DEBUG=$ld_debug \
        "$rtldALT" --list "$1"
    else
      LD_TRACE_LOADED_OBJECTS=1 \
        LD_WARN=$warn \
        LD_BIND_NOW=$bind_now \
        LD_VERBOSE=$verbose \
        LD_DEBUG=$ld_debug \
        "$1"
    fi
  else
    read h < "$1"
    case "$h" in
    '#!'*)  printf '%s:\n\tshebang\n' "$1" ;;
    '#'*)  printf '%s:\n\tshell script\n' "$1" ;;
    *) printf '%s:\n' "$1"; LD_VERBOSE=1 "$rtld" --list "$1" ;;
    esac
  fi
}

showUsage () {
  cat 1>&2 <<- EOUSAGE
	Usage: ${0#*/} [-b|-d LD_DEBUG|-l path_to_linux.so|-h|-v|-w] FILE...
	  -b  bind_now
	  -d  LD_DEBUG
	  -h  help
	  -v  verbose
	  -w  warn
	EOUSAGE
  printf \\n
  LD_DEBUG=help "$rtld"
  exit 1
}

[ -z "$1" ] && showUsage
for x do
  if [ -z "$rtld" ] ; then
    rtld="$x"
    rtldALT="$x"
    continue
  fi
  if [ "$ld_debug" = _ ] ; then
      ld_debug="$x"
      continue
  fi
  case "$x" in
  -b*) bind_now=1 ;;
  -d*) ld_debug=_ ;;
  -h*) showUsage ;;
  -l*) rtld='' ;;
  -v*) verbose=1 ;;
  -w*) warn=1 ;;
  *) ldd1ALT "$x" ;;
  esac
done

exit
