#!/bin/busybox sh

if [ -d "$FKSH_ONB" ] ; then
  # in the system of fakesh
  defaultPath="$FKSH_ONB/images"
  [ -d "$defaultPath" ] || defaultPath='.'
else
  # without the system of fakesh
  defaultPath='.'
fi

showUsage () {
  cat 1>&2 <<- EOUSG
	Usage: ${0##*/} [ file | file.gz | N | repeatN ]
	  file | file.gz : path to a file to display.
	    default path ${defaultPath}/file[.gz]
	  N : at most 4 digits of wait period (msec).
	  repeatN : at most 4 digits of times of repeatition.
	Usage: ${0##*/} -i file.seq
	  input args from the 1st flds of every line of file.seq .
	    default path ${defaultPath%/*}/file.seq
	EOUSG
  exit
}

[ $# -eq 0 ] && showUsage
pickel='/usr/local/Kobo/pickel showpic 1'

slp=:
rep=0

parseArgs () {
  local p
  case "$1" in
  -*) showUsage ;;
  0 | 00 | 000 | 0000 )
    slp=:
    return
  ;;
  [1-9] | [0-9][0-9] | [0-9][0-9][0-9] | [0-9][0-9][0-9][0-9] )
    slp=${i#00}; slp=${slp#0}
    slp="usleep $((slp*1000))"
  ;;
  rep*[0-9])
    [ $rep -gt 0 ] && return
    rep="${i##*[!0-9]}"; rep=${rep#00}; rep=${rep#0}
    [ -z "$rep" ] && rep=0
  ;;
  /*.gz | ./*.gz )
    if [ -f "$1" -a -r "$1" ] ; then
      $slp ; zcat "$1" | $pickel
    fi
  ;;
  /* | ./* )
    if [ -f "$1" -a -r "$1" ] ; then
      $slp ; $pickel < "$1"
    fi
  ;;
  *.gz)
    p="$defaultPath/$1"
    if [ -f "$p" -a -r "$p" ] ; then
      $slp ; zcat "$p" | $pickel
    fi
  ;;
  *)
    p="$defaultPath/$1"
    if [ -f "$p" -a -r "$p" ] ; then
      $slp ; $pickel < "$p"
    fi
  ;;
  esac </dev/null
}

if [ "x$1" = x-i ] ; then
  seq="$2"
  case "$2" in
  /* | ./* ) seq="$2" ;;
  *) seq="${defaultPath%/*}/$2" ;;
  esac
  [ -f "$seq" ] || exit 1
  while : ; do
    while read -r i dum ; do
      parseArgs "$i"
    done < "$seq"
    rep=$((rep-1))
    [ $rep -le 0 ] && break
  done  
  exit
fi

while : ; do
  for i do
    parseArgs "$i"
  done
  rep=$((rep-1))
  [ $rep -le 0 ] && break
done

exit
################################################################
#
# i forget what i wrote !
# now i remember !
# this enables kobo Touch raw to display on kobo glo, vice versa.
# -- no use -- USE screenShot-jpeg.sh
#

read imglen < /sys/class/graphics/fb0/virtual_size
imglen="${imglen%%,*}"
[ -z "$imglen" ] && imglen=1024
imglen=$((imglen*2))
dipslen=$imglen
output2file=NO

showPic () {
  local ofile
  if [ "$output2file" = YES ]; then
    ofile="${i%.gz}"; ofile="${ofile%.raw}"
    ofile="${ofile##*/}_$((imglen/2)).raw"
    tee "$ofile" | /usr/local/Kobo/pickel showpic 1
    gzip -9 "$ofile"
  else
    /usr/local/Kobo/pickel showpic 1
  fi
}

dispFile () {
  local d n nn
  [ -f "$1" ] || return 0
  if [ $imglen = $dipslen ] ; then
    /usr/local/Kobo/pickel showpic 1 < "$1"
    return 0
  fi
  if [ $imglen -lt $dipslen ] ; then
    nn=$(( $(stat -c %s "$1") / imglen ))
    d=$((dipslen-imglen))
    n=0
    while [ $n -lt $nn ] ; do
      dd "if=$1" bs=$imglen skip=$n count=1
      dd if=/dev/zero bs=$d count=1
      n=$((n+1))
    done 2>/dev/null | showPic
    return 0
  else
    nn=$(( $(stat -c %s "$1") / imglen ))
    n=0
    while [ $n -lt $nn ] ; do
      dd "if=$1" bs=$imglen skip=$n count=1 | dd bs=$dipslen count=1
      n=$((n+1))
    done 2>/dev/null | showPic
  fi
}

dispFileGz () {
  local tmpimg
  [ -f "$1" ] || return 0
  if [ "$imglen" = "$dipslen" ] ; then
    zcat "$1" | /usr/local/Kobo/pickel showpic 1
    return 0
  fi
  tmpimg=`mktemp /tmp/rawimg.XXXXXX`
  zcat "$1" > $tmpimg
  dispFile $tmpimg
  rm -f $tmpimg
}

for i do
  case "$i" in
  -[1-9][0-9][0-9] | -[1-9][0-9][0-9][0-9] )
    imglen=$((${i#-}*2))
    continue
  ;;
  -o) output2file=YES ; continue ;;
  -n) output2file=NO ; continue ;;
  *.gz) dispFileGz "$i" ;;
  *) dispFile "$i" ;;
  esac
done

exit
