#!/usr/bin/perl

# Copyright (c) 2017 dyknon
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

use warnings;
use strict;
use utf8;
use IO::Socket::UNIX;

binmode(STDOUT, ":raw");

$| = 1;

my $sockpath = "/tmp/media_server.sock";

my $con = IO::Socket::UNIX->new(Type=>SOCK_STREAM, Peer=>$sockpath) || die;

my $buf;

#$con->send("i".pack("Q", 0), 0);
#$con->read($buf, 8*4+1);
#my ($curn) = unpack("QQQQC", $buf);
#print STDERR $curn."\n";
$con->send("k", 0);
$con->read($buf, 8);
my $curn = unpack("Q", $buf);

$con->send("h", 0);
$con->read($buf, 8);
my $size = unpack("Q", $buf);
$con->read($buf, $size);
print $buf;

while(1){
    $con->send("w".pack("Q", $curn), 0);
    $con->read($buf, 1);
    $con->send("i".pack("Q", $curn), 0);
    $con->read($buf, 8*4+1);
    my ($cnum, $size, $pos, $cpos, $flags) = unpack("QQQQC", $buf);
    printf(STDERR "\ncluster: at%07.2fsec", $pos/1000);
    if($flags & 1){
        print(STDERR " key");
    }
    print(STDERR "\n");
    $con->send("c".pack("Q", $curn), 0);
    $con->read($buf, 8);
    $size = unpack("Q", $buf);
    $con->read($buf, $size);
    print $buf;
    $curn++;
    $con->close();
    $con = IO::Socket::UNIX->new(Type=>SOCK_STREAM, Peer=>$sockpath) || die;
}
$con->close();
