#include "stdafx.h"
#include "FDKError.h"

namespace FDK {
	namespace General {

// G[eLXg
tstring g_strFDKErrMsg;

LPCTSTR HRMSG( HRESULT hr )
{
	static const int LEN = 1024;
	static TCHAR msg[ LEN ];

#define CASE(h,m)	case(h):lstrcpyn(msg,m,LEN);break;

	switch( hr )
	{
	// FDK̃G[
	CASE( FDKERR_ĂȂ, _T("Ă܂B") );
	CASE( FDKERR_A_v^Ȃ, _T("A_v^܂B") );
	CASE( FDKERR_DirectSoundNULL, _T("DirectSoundNULLłB") );
	CASE( FDKERR_TEhobt@NULL, _T("TEhobt@NULLłB") );
	CASE( FDKERR_SoundType, _T("Sound^CvłB") );
	CASE( FDKERR_TEhobt@̍쐬Ɏs, _T("TEhobt@̍쐬Ɏs܂B") );
	CASE( FDKERR_t@C̓ǂݍݎs, _T("t@C̓ǂݍ݂Ɏs܂B") );
	CASE( FDKERR_DirectDrawNULL, _T("DirectDrawNULLłB") );
	CASE( FDKERR_T[tFCXNULL, _T("T[tFCXNULLłB") );
	CASE( FDKERR_T[tFCX̍쐬Ɏs, _T("T[tFCX̍쐬Ɏs܂B") );
	CASE( FDKERR_DC̎擾Ɏs, _T("DC̎擾Ɏs܂B") );
	CASE( FDKERR_StretchBltɎs, _T("StretchBlt()Ɏs܂B") );
	CASE( FDKERR_BltɎs, _T("Blt()Ɏs܂B") );
	CASE( FDKERR_LockɎs, _T("Lock()Ɏs܂B") );
	CASE( FDKERR_Caps̎擾Ɏs, _T("Caps̎擾Ɏs܂B") );
	CASE( FDKERR_eNX`tH[}bgȂ, _T("eNX`tH[}bg܂B") );
	CASE( FDKERR_BeginSceneĂȂ, _T("BeginScene()sĂ܂B") );
	CASE( FDKERR_3DfoCXNULL, _T("3DfoCXNULLłB") );
	CASE( FDKERR_p[^NULL, _T("p[^NULLłB") );
	CASE( FDKERR_DIB̍쐬Ɏs, _T("DIB̍쐬Ɏs܂B") );
	CASE( FDKERR_eNX`NULL, _T("eNX`NULLłB") );
	CASE( FDKERR_̎擾Ɏs, _T("̎擾Ɏs܂B") );
	CASE( FDKERR_t[̃I[vɎs, _T("t[̃I[vɎs܂B") );
	CASE( FDKERR_DRAWDIB̃I[vɎs, _T("DRAWDIB̃I[vɎs܂B") );
	CASE( FDKERR_eNX`̍쐬Ɏs, _T("eNX`̍쐬Ɏs܂B") );
	CASE( FDKERR_DirectSound̍쐬Ɏs, _T("DirectSound̍쐬Ɏs܂B") );
	CASE( FDKERR_DirectSound̋x̐ݒɎs, _T("DirectSound̋x̐ݒɎs܂B") );

	// DirectX ̃G[
	CASE( D3D_OK, _T("D3D_OK: ɏI܂B") );
	CASE( D3DERR_BADMAJORVERSION, _T("D3DERR_BADMAJORVERSION") );
	CASE( D3DERR_BADMINORVERSION, _T("D3DERR_BADMINORVERSION") );
	CASE( D3DERR_COLORKEYATTACHED, _T("D3DERR_COLORKEYATTACHED") );
	CASE( D3DERR_CONFLICTINGRENDERSTATE, _T("D3DERR_CONFLICTINGRENDERSTATE") );
	CASE( D3DERR_CONFLICTINGTEXTUREFILTER, _T("D3DERR_CONFLICTINGTEXTUREFILTER") );
	CASE( D3DERR_CONFLICTINGTEXTUREPALETTE, _T("D3DERR_CONFLICTINGTEXTUREPALETTE") );
	CASE( D3DERR_DEVICEAGGREGATED, _T("D3DERR_DEVICEAGGREGATED") );
	CASE( D3DERR_EXECUTE_CLIPPED_FAILED, _T("D3DERR_EXECUTE_CLIPPED_FAILED") );
	CASE( D3DERR_EXECUTE_CREATE_FAILED, _T("D3DERR_EXECUTE_CREATE_FAILED") );
	CASE( D3DERR_EXECUTE_DESTROY_FAILED, _T("D3DERR_EXECUTE_DESTROY_FAILED") );
	CASE( D3DERR_EXECUTE_FAILED, _T("D3DERR_EXECUTE_FAILED") );
	CASE( D3DERR_EXECUTE_LOCK_FAILED, _T("D3DERR_EXECUTE_LOCK_FAILED") );
	CASE( D3DERR_EXECUTE_LOCKED, _T("D3DERR_EXECUTE_LOCKED") );
	CASE( D3DERR_EXECUTE_NOT_LOCKED, _T("D3DERR_EXECUTE_NOT_LOCKED") );
	CASE( D3DERR_EXECUTE_UNLOCK_FAILED, _T("D3DERR_EXECUTE_UNLOCK_FAILED") );
	CASE( D3DERR_INBEGIN, _T("D3DERR_INBEGIN") );
	CASE( D3DERR_INBEGINSTATEBLOCK, _T("D3DERR_INBEGINSTATEBLOCK") );
	CASE( D3DERR_INITFAILED, _T("D3DERR_INITFAILED") );
	CASE( D3DERR_INVALID_DEVICE, _T("D3DERR_INVALID_DEVICE") );
	CASE( D3DERR_INVALIDCURRENTVIEWPORT, _T("D3DERR_INVALIDCURRENTVIEWPORT") );
	CASE( D3DERR_INVALIDMATRIX, _T("D3DERR_INVALIDMATRIX") );
	CASE( D3DERR_INVALIDPALETTE, _T("D3DERR_INVALIDPALETTE") );
	CASE( D3DERR_INVALIDPRIMITIVETYPE, _T("D3DERR_INVALIDPRIMITIVETYPE") );
	CASE( D3DERR_INVALIDRAMPTEXTURE, _T("D3DERR_INVALIDRAMPTEXTURE") );
	CASE( D3DERR_INVALIDSTATEBLOCK, _T("D3DERR_INVALIDSTATEBLOCK") );
	CASE( D3DERR_INVALIDVERTEXFORMAT, _T("D3DERR_INVALIDVERTEXFORMAT") );
	CASE( D3DERR_INVALIDVERTEXTYPE, _T("D3DERR_INVALIDVERTEXTYPE") );
	CASE( D3DERR_LIGHT_SET_FAILED, _T("D3DERR_LIGHT_SET_FAILED") );
	CASE( D3DERR_LIGHTHASVIEWPORT, _T("D3DERR_LIGHTHASVIEWPORT") );
	CASE( D3DERR_LIGHTNOTINTHISVIEWPORT, _T("D3DERR_LIGHTNOTINTHISVIEWPORT") );
	CASE( D3DERR_MATERIAL_CREATE_FAILED, _T("D3DERR_MATERIAL_CREATE_FAILED") );
	CASE( D3DERR_MATERIAL_DESTROY_FAILED, _T("D3DERR_MATERIAL_DESTROY_FAILED") );
	CASE( D3DERR_MATERIAL_GETDATA_FAILED, _T("D3DERR_MATERIAL_GETDATA_FAILED") );
	CASE( D3DERR_MATERIAL_SETDATA_FAILED, _T("D3DERR_MATERIAL_SETDATA_FAILED") );
	CASE( D3DERR_MATRIX_CREATE_FAILED, _T("D3DERR_MATRIX_CREATE_FAILED") );
	CASE( D3DERR_MATRIX_DESTROY_FAILED, _T("D3DERR_MATRIX_DESTROY_FAILED") );
	CASE( D3DERR_MATRIX_GETDATA_FAILED, _T("D3DERR_MATRIX_GETDATA_FAILED") );
	CASE( D3DERR_MATRIX_SETDATA_FAILED, _T("D3DERR_MATRIX_SETDATA_FAILED") );
	CASE( D3DERR_NOCURRENTVIEWPORT, _T("D3DERR_NOCURRENTVIEWPORT") );
	CASE( D3DERR_NOTINBEGIN, _T("D3DERR_NOTINBEGIN") );
	CASE( D3DERR_NOTINBEGINSTATEBLOCK, _T("D3DERR_NOTINBEGINSTATEBLOCK") );
	CASE( D3DERR_NOVIEWPORTS, _T("D3DERR_NOVIEWPORTS") );
	CASE( D3DERR_SCENE_BEGIN_FAILED, _T("D3DERR_SCENE_BEGIN_FAILED") );
	CASE( D3DERR_SCENE_END_FAILED, _T("D3DERR_SCENE_END_FAILED") );
	CASE( D3DERR_SCENE_IN_SCENE, _T("D3DERR_SCENE_IN_SCENE") );
	CASE( D3DERR_SCENE_NOT_IN_SCENE, _T("D3DERR_SCENE_NOT_IN_SCENE") );
	CASE( D3DERR_SETVIEWPORTDATA_FAILED, _T("D3DERR_SETVIEWPORTDATA_FAILED") );
	CASE( D3DERR_STENCILBUFFER_NOTPRESENT, _T("D3DERR_STENCILBUFFER_NOTPRESENT") );
	CASE( D3DERR_SURFACENOTINVIDMEM, _T("D3DERR_SURFACENOTINVIDMEM") );
	CASE( D3DERR_TEXTURE_BADSIZE, _T("D3DERR_TEXTURE_BADSIZE") );
	CASE( D3DERR_TEXTURE_CREATE_FAILED, _T("D3DERR_TEXTURE_CREATE_FAILED") );
	CASE( D3DERR_TEXTURE_DESTROY_FAILED, _T("D3DERR_TEXTURE_DESTROY_FAILED") );
	CASE( D3DERR_TEXTURE_GETSURF_FAILED, _T("D3DERR_TEXTURE_GETSURF_FAILED") );
	CASE( D3DERR_TEXTURE_LOAD_FAILED, _T("D3DERR_TEXTURE_LOAD_FAILED") );
	CASE( D3DERR_TEXTURE_LOCK_FAILED, _T("D3DERR_TEXTURE_LOCK_FAILED") );
	CASE( D3DERR_TEXTURE_LOCKED, _T("D3DERR_TEXTURE_LOCKED") );
	CASE( D3DERR_TEXTURE_NO_SUPPORT, _T("D3DERR_TEXTURE_NO_SUPPORT") );
	CASE( D3DERR_TEXTURE_NOT_LOCKED, _T("D3DERR_TEXTURE_NOT_LOCKED") );
	CASE( D3DERR_TEXTURE_SWAP_FAILED, _T("D3DERR_TEXTURE_SWAP_FAILED") );
	CASE( D3DERR_TEXTURE_UNLOCK_FAILED, _T("D3DERR_TEXTURE_UNLOCK_FAILED") );
	CASE( D3DERR_TOOMANYOPERATIONS, _T("D3DERR_TOOMANYOPERATIONS") );
	CASE( D3DERR_TOOMANYPRIMITIVES, _T("D3DERR_TOOMANYPRIMITIVES") );
	CASE( D3DERR_TOOMANYVERTICES, _T("D3DERR_TOOMANYVERTICES") );
	CASE( D3DERR_UNSUPPORTEDALPHAARG, _T("D3DERR_UNSUPPORTEDALPHAARG") );
	CASE( D3DERR_UNSUPPORTEDALPHAOPERATION, _T("D3DERR_UNSUPPORTEDALPHAOPERATION") );
	CASE( D3DERR_UNSUPPORTEDCOLORARG, _T("D3DERR_UNSUPPORTEDCOLORARG") );
	CASE( D3DERR_UNSUPPORTEDCOLOROPERATION, _T("D3DERR_UNSUPPORTEDCOLOROPERATION") );
	CASE( D3DERR_UNSUPPORTEDFACTORVALUE, _T("D3DERR_UNSUPPORTEDFACTORVALUE") );
	CASE( D3DERR_UNSUPPORTEDTEXTUREFILTER, _T("D3DERR_UNSUPPORTEDTEXTUREFILTER") );
	CASE( D3DERR_VBUF_CREATE_FAILED, _T("D3DERR_VBUF_CREATE_FAILED") );
	CASE( D3DERR_VERTEXBUFFERLOCKED, _T("D3DERR_VERTEXBUFFERLOCKED") );
	CASE( D3DERR_VERTEXBUFFEROPTIMIZED, _T("D3DERR_VERTEXBUFFEROPTIMIZED") );
	CASE( D3DERR_VERTEXBUFFERUNLOCKFAILED, _T("D3DERR_VERTEXBUFFERUNLOCKFAILED") );
	CASE( D3DERR_VIEWPORTDATANOTSET, _T("D3DERR_VIEWPORTDATANOTSET") );
	CASE( D3DERR_VIEWPORTHASNODEVICE, _T("D3DERR_VIEWPORTHASNODEVICE") );
	CASE( D3DERR_WRONGTEXTUREFORMAT, _T("D3DERR_WRONGTEXTUREFORMAT") );
	CASE( D3DERR_ZBUFF_NEEDS_SYSTEMMEMORY, _T("D3DERR_ZBUFF_NEEDS_SYSTEMMEMORY") );
	CASE( D3DERR_ZBUFF_NEEDS_VIDEOMEMORY, _T("D3DERR_ZBUFF_NEEDS_VIDEOMEMORY") );
	CASE( D3DERR_ZBUFFER_NOTPRESENT, _T("D3DERR_ZBUFFER_NOTPRESENT") );

	// Win32 ̃G[
	CASE( E_FAIL, _T("E_FAIL: smȃG[łB") );
	CASE( E_INVALIDARG, _T("E_INVALIDARG: sȈn܂B") );
	CASE( E_NOINTERFACE, _T("E_NOINTERFACE: C^[tF[Xpł܂B") );
	CASE( E_NOTIMPL, _T("E_NOTIMPL: Ă܂B") );
	CASE( E_OUTOFMEMORY, _T("E_OUTOFMEMORY: sĂ܂B") );

	// AVICũG[
	CASE( AVIERR_BADFORMAT, _T("AVIERR_BADFORMAT: ΉĂȂAVItH[}bgłB") );
	CASE( AVIERR_MEMORY, _T("AVIERR_MEMORY: sĂ܂B") );
	CASE( AVIERR_FILEREAD, _T("AVIERR_FILEREAD: AVIt@C̓ǂݍ݂Ɏs܂B") );
	CASE( AVIERR_FILEOPEN, _T("AVIERR_FILEOPEN: AVIt@C̃I[vɎs܂B") );
	CASE( AVIERR_NODATA, _T("AVIERR_NODATA: ̃t@Cɂ̓f[^܂܂Ă܂B") );
	CASE( REGDB_E_CLASSNOTREG, _T("REGDB_CLASSNOTREG: @WXgɋLqĂȂt@CłB\n") );

	default:
		_stprintf_s( msg, LEN, _T("%08x"), hr );
		break;
	}
	return msg;
}

LPCTSTR LASTERRMSG()
{
	static TCHAR msg[ 1024 ];

	FormatMessage(
		FORMAT_MESSAGE_IGNORE_INSERTS | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		GetLastError(),
		MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT ),
		msg,
		1024,
		NULL
	);

	return msg;
}

	}//General
}//FDK
