#include "stdafx.h"
#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <crtdbg.h>
#include <locale.h>
#include <direct.h>
#include "Debug.h"

namespace FDK {
	namespace General {

bool	Debug::m_b = false;
int		Debug::m_ns = 0;
bool	Debug::m_bo͒~Out = false;
bool	Debug::m_bo͒~OutConsole = false;
bool	Debug::m_bo͒~Msg = false;
bool	Debug::m_b߂ĂTraceLogo = true;
bool	Debug::m_b߂ĂReportLogo = true;
TCHAR	Debug::m_strTraceLog[ _MAX_PATH ];
TCHAR	Debug::m_strReportLog[ _MAX_PATH ];

void Debug::Init( LPCTSTR strTraceLog, LPCTSTR strReportLog )
{
	// t@C̍쐬
	tstring trace = _T("log\\");
	trace += strTraceLog;
	lstrcpyn( m_strTraceLog, trace.c_str(), _MAX_PATH );

	tstring report = _T("log\\");
	report += strReportLog;
	lstrcpyn( m_strReportLog, report.c_str(), _MAX_PATH );

	// log tH_쐬ȂB
	_tmkdir( _T("log") );

	m_b = true;
}

void Debug::Out( LPCTSTR format, ...)
{
	if( ! m_b )
		return;

	if( ! format )
	{
		OutputDebugString( "No output format string !!\n" );
		return;
	}

	TCHAR strMsg[ MSGLEN ];

	// bZ[W
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// o
	OutWithHeadIndex( strMsg );
}

void Debug::OutFN( LPCTSTR funcname, LPCTSTR format, ...)
{
	if( ! m_b )
		return;

	if( ! format )
	{
		OutputDebugString( "No output format string !!\n" );
		return;
	}

	if( ! funcname )
		funcname = _T("(no function name)");

	// bZ[W
	TCHAR strMsg[ MSGLEN ];
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// ֐
	tstring buf = funcname;
	buf += _T("; ");
	buf += strMsg;

	// o
	OutWithHeadIndex( buf.c_str() );
}

void Debug::OutRaw( LPCTSTR format, ...)
{
	if( ! m_b )
		return;

	if( ! format )
	{
		OutputDebugString( "No output format string !!\n" );
		return;
	}

	TCHAR strMsg[ MSGLEN ];

	// bZ[W
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// o
	OutWithoutHeadIndex( strMsg );
}

void Debug::Msg( LPCTSTR format, ...)
{
	if( ! m_b || m_bo͒~Msg )
		return;

	if( ! format )
	{
		OutputDebugString( "No output format string !!\n" );
		return;
	}

	TCHAR strMsg[ MSGLEN ];

	// bZ[W
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// t@C֏o
	FILE *fp;
	if( _tfopen_s( &fp, m_strReportLog, m_b߂ĂReportLogo ?_T("wt"):_T("at") ) == 0 )
	{
		_ftprintf_s( fp, _T("%s"), strMsg );
		fclose( fp );
	}
	m_b߂ĂReportLogo = false;

	// Outn֏o
	Out( _T("%s"), strMsg );
}

void Debug::MsgFN( LPCTSTR funcname, LPCTSTR format, ...)
{
	if( ! m_b || m_bo͒~Msg )
		return;

	if( ! format )
	{
		OutputDebugString( "No output format string !!\n" );
		return;
	}

	TCHAR strMsg[ MSGLEN ];

	// bZ[W
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// ֐
	tstring buf = funcname;
	buf += _T("; ");
	buf += strMsg;

	// t@C֏o
	FILE *fp;
	if( _tfopen_s( &fp, m_strReportLog, m_b߂ĂReportLogo ?_T("wt"):_T("at") ) == 0 )
	{
		_ftprintf_s( fp, _T("%s"), buf.c_str() );
		fclose( fp );
	}
	m_b߂ĂReportLogo = false;

	// Outn֏o
	Out( _T("%s"), buf.c_str() );
}

void Debug::MsgDialog( HWND hWnd, LPCTSTR title, LPCTSTR format, ... )
{
	if( ! m_b )
		return;

	if( !hWnd || !title || !format )
	{
		OutputDebugString( "MsgDialog parameter error !!\n" );
		return;
	}

	// bZ[W
	TCHAR strMsg[ MSGLEN ];
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// t@C֏o
	FILE *fp;
	if( _tfopen_s( &fp, m_strReportLog, m_b߂ĂReportLogo ?_T("wt"):_T("at") ) == 0 )
	{
		_ftprintf_s( fp, _T("%s"), strMsg );
		fclose( fp );
	}
	m_b߂ĂReportLogo = false;

	// _CAOo
	MessageBox( hWnd, strMsg, title, MB_OK );

	// Outn֏o
	Out( _T("%s: %s"), title, strMsg );
}

void Debug::OutWithHeadIndex( LPCTSTR stro͂镶 )
{
	if( ! m_b || ! stro͂镶 )
		return;

	tstring buf;

	// CfbNXt̍쐬
	time_t o͎;
	TCHAR str[32];

	time( &o͎ );
	_tctime_s( str, 32, &o͎ );

	buf = str;
	buf.erase( 24, 1 );	// sR[h폜
	buf += _T("| ");
	for( int i = 0; i < m_ns; i++ )
		buf += _T("+--");
	if( m_ns > 0 )
		buf += _T(" ");
	buf += stro͂镶;

	// o
	OutWithoutHeadIndex( buf.c_str() );
}

void Debug::OutWithoutHeadIndex( LPCTSTR stro͂镶 )
{
	if( ! m_b || ! stro͂镶 )
		return;

	// fobNR\[ւ̏o
	if( ! m_bo͒~OutConsole )
		OutputDebugString( stro͂镶 );

	// g[Xt@Cւ̏o
	if( bDEBUG && ! m_bo͒~Out )
	{
		FILE *fp;
		if( _tfopen_s( &fp, m_strTraceLog, m_b߂ĂTraceLogo ?_T("wt"):_T("at") ) == 0 )
		{
			_ftprintf_s( fp, _T("%s"), stro͂镶 );
			fclose( fp );
		}
		m_b߂ĂTraceLogo = false;
	}
}

void Debug::IndexUp()
{
	m_ns++;
}

void Debug::IndexDown()
{
	if( m_ns > 0 ) m_ns--;
}

void Debug::METHOD_START( LPCTSTR methodname, LPCSTR format, ...)
{
	// bZ[W
	TCHAR strMsg[ MSGLEN ];
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// óCfbNXUP
	OutFN( methodname, _T("%s"), strMsg );
	IndexUp();
}

void Debug::METHOD_END( LPCTSTR methodname )
{
	IndexDown();
	tstring msg = _T("(");
	msg += methodname;
	msg += _T(")\n");
	Out( msg.c_str() );
}

void Debug::FUNCTION_START( LPCTSTR funcname, LPCSTR format, ...)
{
	// bZ[W
	TCHAR strMsg[ MSGLEN ];
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// óCfbNXUP
	OutFN( funcname, _T("%s"), strMsg );
	IndexUp();
}

void Debug::FUNCTION_END( LPCTSTR funcname )
{
	IndexDown();
	tstring msg = _T("(");
	msg += funcname;
	msg += _T(")\n");
	Out( msg.c_str() );
}

void Debug::WORK_START( LPCTSTR format, ...)
{
	// bZ[W
	TCHAR strMsg[ MSGLEN ];
	va_list	args;
	va_start( args, format );
	_vstprintf_s( strMsg, MSGLEN, format, args );
	va_end( args );

	// óCfbNXUP
	Out( _T("%s"), strMsg );
	IndexUp();
}

void Debug::WORK_END()
{
	IndexDown();
	Out( _T("\n") );
}

	}//General
}//FDK
