#include "stdafx.h"
#include "Debug.h"
#include "DTX.h"
#include "CFileMM.h"
#include "MD5.h"
#include "str2float.h"
#include "CAvi.h"

namespace FDK {
	namespace General {

#ifndef SKIPSP
#define SKIPSP(p)	{while(*p==' '||*p=='\t')p++;}
#endif
#ifndef SKIPSP_BGA
#define SKIPSP_BGA(p)	{while(*p==' '||*p=='\t'||*p==','||*p=='('||*p==')'||*p=='['||*p==']'||*p=='x'||*p=='|')p++;}
#endif
#ifndef SKIPDEC
#define SKIPDEC(p)	{while((*p>='0'&&*p<='9')||*p=='-'||*p=='+')p++;}
#endif
#ifndef SKIPHEX
#define SKIPHEX(p)	{while((*p>='0'&&*p<='9')||(*p>='a'&&*p<='f')||(*p>='A'&&*p<='F')||*p=='-'||*p=='+')p++;}
#endif
#ifndef SKIPZEX
#define SKIPZEX(p)	{while((*p>='0'&&*p<='9')||(*p>='a'&&*p<='z')||(*p>='A'&&*p<='Z')||*p=='-'||*p=='+')p++;}
#endif

static const int s_nChannelToLane[10] = { 1,2,3,4,5,7,6,1,7,0 };		// ChɑΉ郌[ԍ

DTX::DTX()
{
	// Clear() OɏKvȂ̂ŏ
	this->pBPM		= this->pBPMLast	= NULL;
	this->pWave		= this->pWaveLast	= NULL;
	this->pBMP		= this->pBMPLast	= NULL;
	this->pBMPTEX	= this->pBMPTEXLast	= NULL;
	this->pBGA		= this->pBGALast	= NULL;
	this->pBGAPan	= this->pBGAPanLast	= NULL;
	this->pAVI		= this->pAVILast	= NULL;
	this->pAVIPan	= this->pAVIPanLast	= NULL;
	this->pChip		= this->pChipLast	= NULL;

	this->pTimer					= NULL;
	this->bDTXV						= false;
	this->bWAVCache					= true;
	this->bBMPCache					= true;
}

DTX::~DTX()
{
	Clear();
}

// 
void DTX::Clear()
{
	// Ԃ̏ 
	this->strFullPath.clear();
	this->strFolder.clear();
	this->strFileExt[0]			= _T('\0');
	this->scoreType				= SCORETYPE_UNKNOWN;
	this->strTitle.clear();
	this->strArtist.clear();
	this->strComment.clear();
	this->strPanel.clear();
	this->strGenre.clear();
	this->bHiddenLevel = false;
	for( int i = 0; i < 3; i++ )
		this->nLevel[i]			= 0;
	this->dbBPM					= 0.0;
	this->dbBaseBPM				= 0.0;
	this->strStage.clear();
	this->strPresound.clear();
	this->strPreimage.clear();
	this->strPremovie.clear();
	this->strBackground.clear();
	this->strBackgroundGR.clear();
	for( int i = 0; i < 7; i++ ) {
		this->strResultImage[i].clear();
		this->strResultMovie[i].clear();
	}
	this->strMIDI.clear();
	this->bMIDINote				= false;
	this->nMIDILevel			= 0;
	this->bBlackColorKey		= true;
	this->strPathWav.clear();
	this->fSpeed				= 1.0f;
	this->bHeaderOnly			= false;

	for( int i = 0; i < 10; i++)
		this->nTotalChipsD[ i ] = 0;
	this->nTotalChipsG			= 0;
	this->nTotalChipsB			= 0;
	this->bUseDrum				= false;
	this->bUseGuitar			= false;
	this->bUseBass				= false;
	this->bUseHHOpen			= false;
	this->bUseRide				= false;
	this->bUseLeftCymal			= false;
	this->strHash[0]			= _T('\0');
	// BPMXg̉Ə 
	{
		BPM* b = this->pBPM;
		while( b != NULL )
			{
			BPM* n = b->next;
			SAFE_DELETE( b );
			b = n;
		}
		this->pBPM = this->pBPMLast = NULL;
	}
	// WAVXg̉Ə 
	{
		Wave* w = this->pWave;
		while( w != NULL )
		{
			// Wave::sound[][] ̉̓TEh}l[Wōs߁Ał͉ȂB
			Wave* n = w->next;
			SAFE_DELETE( w );
			w = n;
		}
		this->pWave = this->pWaveLast = NULL;
	}
	// BMPXg̉Ə 
	{
		BMP* bm = this->pBMP;
		while( bm != NULL )
		{
			// BMP::pSurface ̉̓T[tFCX}l[Wōs߁Ał͉ȂB
			BMP* n = bm->next;
			SAFE_DELETE( bm );
			bm = n;
		}
		this->pBMP = this->pBMPLast = NULL;
		this->bUseBMP				= false;
		this->dwBMPWidthMax			= 0;
		this->dwBMPHeightMax		= 0;
	}
	// BMPTEXXg̉Ə 
	{
		BMPTEX* bmt = this->pBMPTEX;
		while( bmt != NULL )
		{
			// BMPTEX::pTexture ̉̓eNX`}l[Wōs߁Ał͉ȂB
			BMPTEX* n = bmt->next;
			SAFE_DELETE( bmt );
			bmt = n;
		}
		this->pBMPTEX = this->pBMPTEXLast = NULL;
		this->bUseBMPTEX			= false;
		this->dwBMPTEXWidthMax		= 0;
		this->dwBMPTEXHeightMax		= 0;
	}
	// BGAXg̉Ə 
	{
		BGA* bg = this->pBGA;
		while( bg != NULL )
		{
			BGA* n = bg->next;
			SAFE_DELETE( bg );
			bg = n;
		}
		this->pBGA = this->pBGALast = NULL;
	}
	// BGAPANXg̉Ə 
	{
		BGAPan* bp = this->pBGAPan;
		while( bp != NULL )
		{
			BGAPan* n = bp->next;
			SAFE_DELETE( bp );
			bp = n;
		}
		this->pBGAPan = this->pBGAPanLast = NULL;
	}
	// AVIXg̉Ə 
	{
		this->tAVIXg̉Ə();
	}
	// AVIPANXg̉Ə 
	{
		this->tAVIPANXg̉Ə();
	}
	// CHIPXg̉Ə 
	{
		this->tCHIPXg̉Ə();
	}
	// Cache OFF ̏ꍇ́Af[^łׂĉB 
	if( ! this->bWAVCache ) {
		this->soundManager.tgptONAZ폜();
		this->soundManager.tgpTEh폜();
	}
	if( ! this->bBMPCache ) {
		this->textureManager.ResetCache();
		this->textureManager.RemoveUnusedTextures();
		this->surfaceManager.ResetCache();
		this->surfaceManager.RemoveUnusedSurfaces();
	}
}
void DTX::tAVIXg̉Ə()
{
	AVI* a = this->pAVI;
	while( a != NULL )
	{
		if( a->bUse )
			a->avi.Close();
		AVI* n = a->next;
		SAFE_DELETE( a );
		a = n;
	}
	this->pAVI = this->pAVILast = NULL;
	this->bUseAVI	= false;
}
void DTX::tAVIPANXg̉Ə()
{
	AVIPan* ap = this->pAVIPan;
	while( ap != NULL )
	{
		AVIPan* n = ap->next;
		SAFE_DELETE( ap );
		ap = n;
	}
	this->pAVIPan = this->pAVIPanLast = NULL;
}
void DTX::tCHIPXg̉Ə()
{
	Chip* c = this->pChip;
	while( c != NULL )
	{
		Chip* n = c->next;
		SAFE_DELETE( c );
		c = n;
	}
	this->pChip = this->pChipLast = NULL;
}
// Activity
bool DTX::MyOneTimeSceneInit()
{
	// TEh}l[W̏
	this->soundManager.Init( CD3DApplication::hWnd, DSSCL_PRIORITY );

	// eNX`}l[W̏
	this->textureManager.OneTimeSceneInit();

	// T[tFCX}l[W̏
	this->surfaceManager.OneTimeSceneInit();


	return Activity::MyOneTimeSceneInit();
}

bool DTX::MyActivate()
{
	// ɊĂ牽Ȃ
	if( this->bActivate )
		return true;

	// \[X̉
	this->Clear();

	return Activity::MyActivate();
}

bool DTX::MyUnActivate()
{
	// ĂȂȂ牽Ȃ
	if( ! this->bActivate ) 
		return true;

	this->tAVIXg̉Ə();
	this->tAVIPANXg̉Ə();
	this->tCHIPXg̉Ə();

	return Activity::MyUnActivate();
}

bool DTX::MyFinalCleanup()
{
	this->soundManager.Term();				// TEh}l[W̏I
	this->textureManager.FinalCleanup();	// eNX`}l[W̏I
	this->surfaceManager.FinalCleanup();	// T[tFCX}l[W̏I

	return Activity::MyFinalCleanup();
}

bool DTX::MyInitDeviceObjects()
{
	this->textureManager.InitDeviceObjects();	// eNX`}l[W
	this->surfaceManager.InitDeviceObjects();	// T[tFCX}l[W

	return Activity::MyInitDeviceObjects();
}

bool DTX::MyRestoreDeviceTextures()
{
	// ĂȂȂ疳
	if( ! this->bActivate ) 
		return true;

	// eNX`}l[W̍\z
	this->textureManager.RestoreDeviceObjects();

	return Activity::MyRestoreDeviceTextures();
}

bool DTX::MyRestoreDeviceSurfaces()
{
	// ĂȂȂ疳
	if( ! this->bActivate ) 
		return true;

	// T[tFCX}l[W̍\z
	this->surfaceManager.RestoreDeviceObjects();

	// ߂LȂASBMP̃J[L[ 0xFF000000 ɐݒ肷B
	if( this->bBlackColorKey )
	{
		for( BMP* bmp = this->pBMP; bmp != NULL; bmp = bmp->next )
		{
			if( bmp->pSurface )
				bmp->pSurface->SetColorKey( 0xff000000 );
		}
	}

	return Activity::MyRestoreDeviceSurfaces();
}

bool DTX::MyInvalidateDeviceObjects()
{
	// ĂȂȂ疳
	if( ! this->bActivate ) 
		return true;

	this->textureManager.InvalidateDeviceObjects();		// eNX`}l[W̉
	this->surfaceManager.InvalidateDeviceObjects();		// T[tFCX}l[W̉

	return Activity::MyInvalidateDeviceObjects();
}

bool DTX::MyDeleteDeviceObjects()
{
	this->textureManager.DeleteDeviceObjects();		// eNX`}l[W̔j
	this->surfaceManager.DeleteDeviceObjects();		// T[tFCX}l[W̔j

	return Activity::MyDeleteDeviceObjects();
}

// tt@C̓ǂݍ
bool DTX::Load( LPCTSTR fname, bool bHeaderOnly, double dbPlaySpeed )
{
	// (0) O 
	{
		this->bHeaderOnly = bHeaderOnly;

		if( this->nMIDILevel > 2 )
			this->nMIDILevel = 2;

		// t@CJȂ΂ŏI 
		FILE *fp;
		if( _tfopen_s( &fp, fname, _T("rt") ) != 0 )
			return false;
		fclose( fp );
	}
	// (1) t@CAgqAtH_ۑ  strFullPath, strFolder, strFileExt 
	{
		TCHAR strDrive[ _MAX_DRIVE ];
		TCHAR strDir[_MAX_DIR ];
		if( _tsplitpath_s( fname, strDrive, _MAX_DRIVE, strDir, _MAX_DIR, NULL, 0, NULL, 0 ) != 0 )
			return false;

		// t@C
		this->strFullPath = fname;

		// tH_
		this->strFolder  = strDrive;
		this->strFolder += strDir;

		// gq
		CFileMM::GetExt( this->strFullPath.c_str(), this->strFileExt );
	}
	// (2) gqf[^^Cv  scoreType 
	{
		static struct _dataType {
			LPTSTR			ext;
			ScoreType		type;
			LPTSTR			typeName;
		} s_dataType[] = {
			{ _T("dtx"), SCORETYPE_DTX, _T("DTX") },
			{ _T("bms"), SCORETYPE_BMS, _T("BMS") },
			{ _T("bme"), SCORETYPE_BMS, _T("BMS(BME)") },
			{ _T("gda"), SCORETYPE_GDA, _T("GDA") },
			{ _T("g2d"), SCORETYPE_G2D, _T("G2D") },
			{ _T("mid"), SCORETYPE_MID, _T("MIDI") },
			{ _T("tmp"), SCORETYPE_DTX, _T("DTX") },		// for GDAC2
			{ _T(""), SCORETYPE_UNKNOWN, _T("UNKNOWN") }
		};
		for( int i = 0; i < 99; i++)
		{
			if( s_dataType[i].type == SCORETYPE_UNKNOWN )
			{
				this->scoreType = SCORETYPE_UNKNOWN;		// m
				break;
			}
			else if( lstrcmpi( this->strFileExt, s_dataType[i].ext ) == 0 )
			{
				this->scoreType = s_dataType[i].type;
				break;
			}
		}

		// DTXV ł́ADTX ȊO͓ǂݍ܂Ȃ(2004.01.12)
		if( this->bDTXV && this->scoreType != SCORETYPE_DTX )
			return false;
	}
	// (3) t@Cǂݍ 
	switch( this->scoreType )
	{
	case SCORETYPE_DTX:
	case SCORETYPE_BMS:
	case SCORETYPE_G2D:
	case SCORETYPE_GDA:
		this->LoadDTX();
		break;

	case SCORETYPE_MID:
		this->LoadMID();
		break;
	}
	// (4) ǂݍ݌̏ 
	if( ! this->bHeaderOnly )
	{
		// (4-1) ߐƔ}iMIDIȊOj
		if( this->scoreType != SCORETYPE_MID )
			this->InsertLines();

		// (4-2) `bv̔𐶐iMIDIȊOj
		if( this->scoreType != SCORETYPE_MID )
			CalcChipTime();

		// (4-3) e`bv̔ dbPlaySpeed ɂ킹ĒiDTX, MID ʁj
		AdujstChipTimeByPlaySpeed( dbPlaySpeed );

		// (4-4) `bv𐔂  nTotalChipsD/G/B 
		{
			for( int i = 0; i < 10; i++ )
				this->nTotalChipsD[ i ] = 0;
			this->nTotalChipsG = 0;
			this->nTotalChipsB = 0;
			
			for( Chip* cell = this->pChip; cell != NULL; cell = cell->next )
			{
				if( cell->nChannel >= 0x11 && cell->nChannel <= 0x1A )
					this->nTotalChipsD[ cell->nChannel - 0x11 ] ++;
				else if( cell->nChannel >= 0x20 && cell->nChannel <= 0x27 )
					this->nTotalChipsG ++;
				else if( cell->nChannel >= 0xA0 && cell->nChannel <= 0xA7 ) 
					this->nTotalChipsB ++;
			}
		}
		// (4-5) [ƂɎgpWAVo^iLoadWAV()̑OɍsƁIj
		if( !this->bHeaderOnly )
		{
			// (4-5-1) rbg}XN 
			WORD wWaveToLane[ 36*36 ];	// 00..ZZ = 0`36*36-1
			for( int i = 0; i < 36*36; i++ )
				wWaveToLane[ i ] = 0;

			// (4-5-2) S`bv𑖍Agp郌[̊Yrbg𗧂ĂĂ䂭B 
			for( Chip *cp = this->pChip; cp != NULL; cp = cp->next )
			{
				switch( cp->nChannel )
				{
				case 0x11: case 0x31: case 0xB1: wWaveToLane[ cp->nParam ] |= 0x002; break;		// HH
				case 0x12: case 0x32: case 0xB2: wWaveToLane[ cp->nParam ] |= 0x004; break;		// SD
				case 0x13: case 0x33: case 0xB3: wWaveToLane[ cp->nParam ] |= 0x008; break;		// BD
				case 0x14: case 0x34: case 0xB4: wWaveToLane[ cp->nParam ] |= 0x010; break;		// HT
				case 0x15: case 0x35: case 0xB5: wWaveToLane[ cp->nParam ] |= 0x020; break;		// LT
				case 0x16: case 0x36: case 0xB6: wWaveToLane[ cp->nParam ] |= 0x080; break;		// CY
				case 0x17: case 0x37: case 0xB7: wWaveToLane[ cp->nParam ] |= 0x040; break;		// FT
				case 0x18: case 0x38: case 0xB8: wWaveToLane[ cp->nParam ] |= 0x002; break;		// HH
				case 0x19: case 0x39: case 0xB9: wWaveToLane[ cp->nParam ] |= 0x080; break;		// RD
				case 0x1A: case 0x3A: case 0xBC: wWaveToLane[ cp->nParam ] |= 0x001; break;		// LC
				case 0x20: case 0x21: case 0x22: case 0x23: case 0x24: case 0x25: case 0x26: case 0x27: case 0xBA:
					wWaveToLane[ cp->nParam ] |= 0x100; break;																	// Guitar
				case 0xA0: case 0xA1: case 0xA2: case 0xA3: case 0xA4: case 0xA5: case 0xA6: case 0xA7: case 0xBB:
					wWaveToLane[ cp->nParam ] |= 0x200; break;																	// Bass
				case 0x01: case 0x1F: case 0x2F: case 0xAF:
				case 0x61: case 0x62: case 0x63: case 0x64: case 0x65: case 0x66: case 0x67: case 0x68: case 0x69: case 0x70:
				case 0x71: case 0x72: case 0x73: case 0x74: case 0x75: case 0x76: case 0x77: case 0x78: case 0x79: case 0x80:
				case 0x81: case 0x82: case 0x83: case 0x84: case 0x85: case 0x86: case 0x87: case 0x88: case 0x89: case 0x90:
				case 0x91: case 0x92:
					wWaveToLane[ cp->nParam ] |= 0x400; break;																	// BGM
				}
			}
			// (4-5-3) SWavɂāAgp郌[ true ɂB 
			for( Wave *wp = this->pWave; wp != NULL; wp = wp->next ) {
				for( int i = 0; i < 11; i++ )
					wp->bUseByLane[ i ] = ( wWaveToLane[ wp->vnum ] & (0x001 << i) ) ? true : false;
			}
		}
		// (4-6) WAV ̓o^\z 
		this->LoadWAV();
	}
	// (4-7) ȃf[^nbV̌vZ 
	this->CalcHash();

	return true;
}
void DTX::LoadDTX()
{
	FILE *fp;
	if( _tfopen_s( &fp, this->strFullPath.c_str(), _T("rt") ) != 0 )
		return;		// s

	// (1)  
	{
		// (1-1) ǂݍݍƗpϐ̏ 
		for( int i = 0; i < 36*36; i++ )
		{
			m_nWaveNum[i]	= -i;
			m_nWaveVol[i]	= -i;
			m_nWavePan[i]	= -10000-i;		// pan  -100`100Ȃ̂ŁAobeBOȂ悤l炷B
			m_nBPMNum[i]	= -i;
			m_nBMPNum[i]	= -i;
			m_nBMPTEXNum[i]	= -i;
			m_nBGANum[i]	= -i;
			m_nBGAPanNum[i]	= -i;
		}
		m_nWaveNumCur	= 0;
		m_nBPMNumCur	= 0;
		m_nBMPNumCur	= 0;

		// (1-2) #RESULTIMAGE/MOVIE/SOUND p D揇ʃobt@̏ 
		for( int i = 0; i < 7; i++ )
		{
			m_nResultImagePriority[i] = 0;
			m_nResultMoviePriority[i] = 0;
			m_nResultSoundPriority[i] = 0;
		}
	}
	// (2) ss܂œǂݍ݁ 
	m_nLine = 0;
	m_nRand   = 0;
	m_nSkip   = 0;
	m_bSkip[ m_nSkip ] = false;

	TCHAR* strLine = (TCHAR*) malloc( DTX_LINELEN );		// ǂݍݍs malloc Ŋm
	
	while( _fgetts( strLine, DTX_LINELEN, fp ) != NULL )
	{
		TCHAR* p;
		int zz;

		m_nLine ++;

		// sR[hƃRg폜 
		{
			TCHAR* pLineTop = strLine;
			for( TCHAR* p = strLine; *p != _T('\0'); p++ )
			{
				// a. ';' ȍ~̓RgƂĖ 
				if( *p == _T(';') )
				{
					*p = _T('\0');
			
					// ';' ̒Ő󔒂폜
					if( p != pLineTop )
						p --;
					while( p != pLineTop && ( *p == _T(' ') || *p == _T('\t') ) )
					{
						*p = _T('\0');
						p --;
					}
					break;
				}

				// b. sR[h͍폜
				else if( *p == _T('\n') )
				{
					*p = _T('\0');
					break;
				}
			}
		}

		// s # łȂs̓XLbv 
		p = strLine;
		SKIPSP( p );
		if( *p != _T('#') )
			continue;
		p++;


		// #IF 
		if( IsCommand( &p, _T("IF") ) )
		{
			if( m_nSkip == 255 )
				continue;	// #IF ̓q 255 𒴂   #IF ͖

			if( m_bSkip[ m_nSkip ] )
				m_bSkip[ ++m_nSkip ] = true;			// XLbvɌꂽIF̓XLbv
			else
				m_bSkip[ ++m_nSkip ] = ( _tstoi( p ) == m_nRand ) ? false : true;
			continue;
		}

		// #ENDIF 
		if( IsCommand( &p, _T("ENDIF") ) )
		{
			if( m_nSkip > 0 )	// Ή #IF 
				m_nSkip--;
			continue;
		}

		
		// ȍ~́AXLbvȂ疳B
		if( m_bSkip[ m_nSkip ] ) continue;
		
		// #PATH_WAV 
		if( IsCommand( &p, _T("PATH_WAV") ) )
		{
			this->strPathWav = p;
			continue;
		}
		// #TITLE 
		if( IsCommand( &p, _T("TITLE") ) )
		{
			this->strTitle = p;
			continue;
		}
		// #ARTIST 
		if( IsCommand( &p, _T("ARTIST") ) )
		{
			this->strArtist = p;
			continue;
		}
		// #COMMENT 
		if( IsCommand( &p, _T("COMMENT") ) )
		{
			this->strComment = p;
			continue;
		}
		// #DLEVEL, #PLAYLEVEL 
		if( IsCommand( &p, _T("DLEVEL") ) || IsCommand( &p, _T("PLAYLEVEL") ) )
		{
			this->nLevel[ 0 ] = _ttoi( p );

			//  100 iKƂ݂ȂBi10iKf[^̃T|[g͏II(07.05.27)j
			if( this->nLevel[ 0 ] <   0 ) this->nLevel[ 0 ] =   0;
			if( this->nLevel[ 0 ] > 100 ) this->nLevel[ 0 ] = 100;
			continue;
		}
		// #GLEVEL 
		if( IsCommand( &p, _T("GLEVEL") ) )
		{
			this->nLevel[ 1 ] = _ttoi( p );

			//  100 iKƂ݂ȂBi10iKf[^̃T|[g͏II(07.05.27)j
			if( this->nLevel[ 1 ] <   0 ) this->nLevel[ 1 ] =   0;
			if( this->nLevel[ 1 ] > 100 ) this->nLevel[ 1 ] = 100;
			continue;
		}
		// #BLEVEL 
		if( IsCommand( &p, _T("BLEVEL") ) )
		{
			this->nLevel[ 2 ] = _ttoi( p );

			//  100 iKƂ݂ȂBi10iKf[^̃T|[g͏II(07.05.27)j
			if( this->nLevel[ 2 ] <   0 ) this->nLevel[ 2 ] =   0;
			if( this->nLevel[ 2 ] > 100 ) this->nLevel[ 2 ] = 100;
			continue;
		}
		// #GENRE 
		if( IsCommand( &p, _T("GENRE") ) )
		{
			this->strGenre = p;
			continue;
		}
		// #HIDDENLEVEL 
		if( IsCommand( &p, _T("HIDDENLEVEL") ) )
		{
			this->bHiddenLevel = ((*p==_T('o') || *p==_T('O')) && (*(p+1)==_T('n') || *(p+1)==_T('N'))) ? true : false;
			continue;
		}
		// #STAGEFILE 
		if( IsCommand( &p, _T("STAGEFILE") ) )
		{
			this->strStage = p;
			continue;
		}
		// #PREVIEW 
		if( IsCommand( &p, _T("PREVIEW") ) )
		{
			this->strPresound = p;
			continue;
		}
		// #PREIMAGE 
		if( IsCommand( &p, _T("PREIMAGE") ) )
		{
			this->strPreimage = p;
			continue;
		}
		// #PREMOVIE 
		if( IsCommand( &p, _T("PREMOVIE") ) )
		{
			this->strPremovie = p;
			continue;
		}
		// #BACKGROUND_GR 
		if( IsCommand( &p, _T("BACKGROUND_GR") ) )
		{
			this->strBackgroundGR = p;
			continue;
		}
		// #BACKGROUND, #WALL 
		if( IsCommand( &p, _T("BACKGROUND") ) || IsCommand( &p, _T("WALL") ) )
		{
			this->strBackground = p;
			continue;
		}
		// #RANDOM 
		if( IsCommand( &p, _T("RANDOM") ) )
		{
			m_nRand = (rand() % _ttoi(p)) + 1;
			continue;
		}
		// #BPM 
		if( (zz = GetCommand( &p, _T("BPM") ) ) != 0 )
		{
			// #BPM:  #BPM00: ƌȂB
			if( zz < 0 ) zz = 0;

			// BPMl擾B
			double bpm = str2float( p );
			if( bpm <= 0.0 )
				continue;	// #BPM  0 ȉ̒l܂͕sȕw肵   #BPM 𖳌

			// #BPM: Ȃ\ BPM lƂĕۑ
			if( zz == 0 )
				this->dbBPM = bpm;
			
			// BPM Zǉ
			BPM *bc = new BPM();
			bc->num		= ++ m_nBPMNumCur;
			bc->vnum	= zz;
			bc->bpm		= bpm;
			bc->prev = bc->next = NULL;
			APPENDLIST( this->pBPM, this->pBPMLast, bc );

			// `ΉG
			// #BPMzz `AA#BPMO̍sɃIuWFNgLqAzz gBPM`lȂXVB
			if( m_nBPMNum[ zz ] == -zz )
			{
				for( Chip* cp = this->pChip; cp != NULL; cp=cp->next )
					if( ( GetChipParamType( cp->nChannel ) & DTXCPT_BPM ) && cp->nRealParam == -zz )
						cp->nRealParam = m_nBPMNumCur;	// BPMԍ
			}
			
			// Ō BPMԍXVB
			m_nBPMNum[ zz ] = m_nBPMNumCur;

			continue;
		}

		// bHeaderOnly = true ̎́A牺͖B
		if( this->bHeaderOnly )	continue;

		// #MIDIFILE 
		if( IsCommand( &p, _T("MIDIFILE") ) )
		{
			this->strMIDI = p;
			continue;
		}
		// #PANEL
		TCHAR *q = p;
		if( IsCommand( &p, _T("PANEL") ) )
		{
			int isNotNum = 0;								// #26010 2011.12.23 yyagi: #PAN EL (WAVԍ=EL#PAN)#PANELƌȂ悤A
			for( int i = 0; i < strlen(p); i++) {			// lǂ𔻒f
				if( !_istdigit( p[i] ) && p[i] != '-' && p[i] != '+' )
				{
					isNotNum = 1;
					break;
				}
			}
			if( isNotNum )			// ܂܂ĂȂ#PANEL, l݂̂Ȃ#PAN
			{
				this->strPanel = p;
				continue;
			}
			p = q;
		}
		// #DTXVPLAYSPEED 
		if( IsCommand( &p, _T("DTXVPLAYSPEED") ) && this->bDTXV )
		{
			this->fSpeed = str2float( p );
			continue;
		}
		// #MIDINOTE 
		if( IsCommand( &p, _T("MIDINOTE") ) )
		{
			this->bMIDINote = ((*p==_T('o') || *p==_T('O')) && (*(p+1)==_T('n') || *(p+1)==_T('N'))) ? true : false;
			continue;
		}
		// #BLACKCOLORKEY 
		if( IsCommand( &p, _T("BLACKCOLORKEY") ) )
		{
			this->bBlackColorKey = ((*p==_T('o') || *p==_T('O')) && (*(p+1)==_T('n') || *(p+1)==_T('N'))) ? true : false;
			continue;
		}
		// #RESULTIMAGE_SS 
		if( IsCommand( &p, _T("RESULTIMAGE_SS") ) )	{ SetResultImage( 0, p, m_nResultImagePriority ); continue; }	// SS ȏ

		// #RESULTIMAGE_S 
		if( IsCommand( &p, _T("RESULTIMAGE_S") ) )	{ SetResultImage( 1, p, m_nResultImagePriority ); continue; }	//  S ȏ

		// #RESULTIMAGE_A 
		if( IsCommand( &p, _T("RESULTIMAGE_A") ) )	{ SetResultImage( 2, p, m_nResultImagePriority ); continue; }	//  A ȏ

		// #RESULTIMAGE_B 
		if( IsCommand( &p, _T("RESULTIMAGE_B") ) )	{ SetResultImage( 3, p, m_nResultImagePriority ); continue;	}	//  B ȏ

		// #RESULTIMAGE_C 
		if( IsCommand( &p, _T("RESULTIMAGE_C") ) )	{ SetResultImage( 4, p, m_nResultImagePriority ); continue; }	//  C ȏ

		// #RESULTIMAGE_D 
		if( IsCommand( &p, _T("RESULTIMAGE_D") ) )	{ SetResultImage( 5, p, m_nResultImagePriority ); continue;	}	//  D ȏ

		// #RESULTIMAGE_E 
		if( IsCommand( &p, _T("RESULTIMAGE_E") ) )	{ SetResultImage( 6, p, m_nResultImagePriority ); continue; }	//  E ȏ

		// #RESULTIMAGE 
		if( IsCommand( &p, _T("RESULTIMAGE") ) )
		{
			// SRANKiɎw肳Ăׂ̂͂ď㏑Ȃj
			for( int i = 0; i < 7; i++ )
				if( m_nResultImagePriority[i] == 0 )
					this->strResultImage[i] = p;
			continue;
		}
		// #RESULTMOVIE_SS 
		if( IsCommand( &p, _T("RESULTMOVIE_SS") ) ) { SetResultMovie( 0, p, m_nResultMoviePriority ); continue; }	// SS ȏ

		// #RESULTMOVIE_S 
		if( IsCommand( &p, _T("RESULTMOVIE_S") ) )	{ SetResultMovie( 1, p, m_nResultMoviePriority ); continue; }	//  S ȏ

		// #RESULTMOVIE_A 
		if( IsCommand( &p, _T("RESULTMOVIE_A") ) )	{ SetResultMovie( 2, p, m_nResultMoviePriority ); continue; }	//  A ȏ

		// #RESULTMOVIE_B 
		if( IsCommand( &p, _T("RESULTMOVIE_B") ) )	{ SetResultMovie( 3, p, m_nResultMoviePriority ); continue; }	//  B ȏ

		// #RESULTMOVIE_C 
		if( IsCommand( &p, _T("RESULTMOVIE_C") ) )	{ SetResultMovie( 4, p, m_nResultMoviePriority ); continue; }	//  C ȏ

		// #RESULTMOVIE_D 
		if( IsCommand( &p, _T("RESULTMOVIE_D") ) )	{ SetResultMovie( 5, p, m_nResultMoviePriority ); continue; }	//  D ȏ

		// #RESULTMOVIE_E 
		if( IsCommand( &p, _T("RESULTMOVIE_E") ) )	{ SetResultMovie( 6, p, m_nResultMoviePriority ); continue; }	//  E ȏ

		// #RESULTMOVIE 
		if( IsCommand( &p, _T("RESULTMOVIE") ) )
		{
			// SRANKiɎw肳Ăׂ̂͂ď㏑Ȃj
			for( int i = 0; i < 7; i++ )
				if( m_nResultMoviePriority[i] == 0 )
					this->strResultMovie[i] = p;
			continue;
		}
		// #RESULTSOUND_SS 
		if( IsCommand( &p, _T("RESULTSOUND_SS") ) ) { SetResultSound( 0, p, m_nResultSoundPriority ); continue; }	// SS ȏ

		// #RESULTSOUND_S 
		if( IsCommand( &p, _T("RESULTSOUND_S") ) )	{ SetResultSound( 1, p, m_nResultSoundPriority ); continue; }	//  S ȏ

		// #RESULTSOUND_A 
		if( IsCommand( &p, _T("RESULTSOUND_A") ) )	{ SetResultSound( 2, p, m_nResultSoundPriority ); continue; }	//  A ȏ

		// #RESULTSOUND_B 
		if( IsCommand( &p, _T("RESULTSOUND_B") ) )	{ SetResultSound( 3, p, m_nResultSoundPriority ); continue; }	//  B ȏ

		// #RESULTSOUND_C 
		if( IsCommand( &p, _T("RESULTSOUND_C") ) )	{ SetResultSound( 4, p, m_nResultSoundPriority ); continue; }	//  C ȏ

		// #RESULTSOUND_D 
		if( IsCommand( &p, _T("RESULTSOUND_D") ) )	{ SetResultSound( 5, p, m_nResultSoundPriority ); continue; }	//  D ȏ

		// #RESULTSOUND_E 
		if( IsCommand( &p, _T("RESULTSOUND_E") ) )	{ SetResultSound( 6, p, m_nResultSoundPriority ); continue; }	//  E ȏ

		// #RESULTSOUND 
		if( IsCommand( &p, _T("RESULTSOUND") ) )
		{
			// SRANKiɎw肳Ăׂ̂͂ď㏑Ȃj
			for( int i = 0; i < 7; i++ )
				if( m_nResultSoundPriority[i] == 0 )
					this->strResultSound[i] = p;
			continue;
		}
		// #BASEBPM 
		if( IsCommand( &p, _T("BASEBPM") ) )
		{
			double n = str2float( p );

			if( n < 0.0 )
				continue;	// #BASEBPM ɕ܂͕sȕw肵   #BASEBPM 𖳌

			this->dbBaseBPM = n;
			continue;
		}
		// #VOLUME, #WAVVOL 
		if( ( zz = this->GetCommand( &p, _T("VOLUME") ) ) != 0 || ( zz = this->GetCommand( &p, _T("WAVVOL") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36 )
				continue;	// #VOLUME(WAVVOL)̔ԍ͈͊O

			// ʒl̎擾
			int n = _ttoi( p );
			if( n > 100 ) n = 100;
			if( n <   0 ) n =   0;

			// ΉGߋɒ` #WAV ̂Avolume `̂ɂĊ蓖ĂB
			if( this->m_nWaveVol[ zz ] == -zz )
			{
				for( Wave* wp = this->pWave; wp != NULL; wp = wp->next )
					if( wp->volume == -zz )
						wp->volume = n;
			}

			// ŌɁAWAVVOL X^bNXVB
			this->m_nWaveVol[ zz ] = n;
			continue;
		}
		// #PAN, #WAVPAN 
		if( ( zz = this->GetCommand( &p, _T("PAN") ) ) != 0 || ( zz = this->GetCommand( &p, _T("WAVPAN") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36 )
				continue;	// #WAVPAN(PAN)̔ԍ͈͊O

			// l̎擾
			int n = _ttoi( p );
			if( n >  100 ) n =  100;
			if( n < -100 ) n = -100;

			// ΉGߋɒ` #WAV ̂Apan `̂ɂĊ蓖ĂB
			if( this->m_nWavePan[ zz ] == -10000-zz )
			{
				for( Wave* wp = this->pWave; wp != NULL; wp = wp->next )
					if( wp->pan == -10000-zz )
						wp->pan = n;
			}

			// ŌɁAWAVPAN X^bNXVB
			this->m_nWavePan[ zz ] = n;
			continue;
		}
		// #WAV 
		if( ( zz = this->GetCommand( &p, _T("WAV") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36 )
				continue;	// WAVԍ͈͊O

			// Zǉił͂܂ Wave::sound[][]  NULL j
			Wave *wc		= new Wave();
			wc->num			= ++ m_nWaveNumCur;
			wc->vnum		= zz;
			wc->volume		= this->m_nWaveVol[ zz ];
			wc->pan			= this->m_nWavePan[ zz ];
			wc->bUse		= false;
			wc->strFileName = p;
			for( int i = 0; i < 11; i++ )
			{
				wc->bUseByLane[ i ]	= false;
				wc->nCurSound[ i ]	= -1;
				for( int j = 0; j < DTX_MAX_SOUND; j++ )
				{
					wc->sound[ i ][ j ]			= NULL;
					wc->bPlaying[ i ][ j ]		= false;
					wc->dbStartTime[ i ][ j ]	= 0;
					wc->dbPauseTime[ i ][ j ]	= 0;
				}
			}
			wc->dwBufferSize	= 0;
			wc->dbTotalTime		= 0;
			wc->prev = wc->next = NULL;
			APPENDLIST( this->pWave, this->pWaveLast, wc );	

			// #WAVzz `A
			// #WAVO̍sɃIuWFNgLqAzz gWAV`lȂXVB
			if( this->m_nWaveNum[ zz ] == -zz )
			{
				for( Chip* cp = this->pChip; cp != NULL; cp=cp->next )
					if( ( this->GetChipParamType( cp->nChannel ) & DTXCPT_WAV ) && cp->nRealParam == -zz )
						cp->nRealParam = this->m_nWaveNumCur;	// Waveԍ
			}
				
			// Ō WaveԍXVB
			this->m_nWaveNum[ zz ] = this->m_nWaveNumCur;
			continue;
		}
		// #BMPTEX 
		if( ( zz = this->GetCommand( &p, _T("BMPTEX") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36 )
				continue;	// #BMPTEXԍ͈͊O

			// Zǉił͂܂ BMPTEX::pTexture  NULL  ݒ͌㏈ LoadBMP()  j
			BMPTEX *bm		= new BMPTEX();
			bm->num 		= zz;
			bm->bUse		= false;
			bm->strFileName = p;
			bm->pTexture	= NULL;
			bm->prev = bm->next = NULL;
			APPENDLIST( this->pBMPTEX, this->pBMPTEXLast, bm );

			// BMPTEXgptOON
			this->bUseBMPTEX = true;
			continue;
		}
		// #BMP 
		if( ( zz = this->GetCommand( &p, _T("BMP") ) ) != 0 )
		{
			if( zz >= 36*36 )	// zz ͏ȗiȗAzz==-1j
				continue;		// #BMPԍ͈͊O

			// Zǉił͂܂ BMP::pSurface  NULL  ݒ͌㏈ LoadBMP()  j
			BMP *bm			= new BMP();
			bm->num 		= (zz < 0) ? 0 : zz;		// ԍ2ȗ  #BMP00: (BMP摜) (2006/04/23)
			bm->bUse		= false;
			bm->strFileName = p;
			bm->pSurface	= NULL;
			bm->prev = bm->next = NULL;
			APPENDLIST( this->pBMP, this->pBMPLast, bm );

			// BMPgptOON
			this->bUseBMP = true;
			continue;
		}
		// #BGAPAN 
		if( ( zz = this->GetCommand( &p, _T("BGAPAN") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36 )
				continue;	// #BGAPANԍ͈͊O

			// p[^擾
			int bmp, sw, sh, ew, eh, ssx, ssy, sex, sey, dsx, dsy, dex, dey, len;
			bmp = GetZex(p); SKIPZEX(p); SKIPSP_BGA(p);
			sw  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			sh  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			ew  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			eh  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			ssx = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			ssy = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			sex = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			sey = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dsx = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dsy = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dex = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dey = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			len = GetDec(p);
				
			// BMPԍ̏ȗȂт 00 ̎w͖
			if( bmp <= 0 )
				continue;	// sBMPԍw肳Ă܂B

			// NbsO
			//  BMP̃TCY͎s܂ŔȂ̂ŁANbsO͎sɍsB

			// Zǉ
			BGAPan *bc = new BGAPan();
			bc->num = zz;
			bc->bmp = bmp;
			bc->sw  =  sw;	bc->sh  =  sh;
			bc->ew  =  ew;	bc->eh  =  eh;
			bc->ssx = ssx;	bc->ssy = ssy;
			bc->sex = sex;	bc->sey = sey;
			bc->dsx = dsx;	bc->dsy = dsy;
			bc->dex = dex;	bc->dey = dey;
			bc->len = len;
			bc->prev = bc->next = NULL;
			APPENDLIST( this->pBGAPan, this->pBGAPanLast, bc );
			continue;
		}
		// #BGA 
		if( ( zz = this->GetCommand( &p, _T("BGA") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36 )
				continue;	// #BGAԍ͈͊O

			// p[^擾
			int bmp, x1, y1, x2, y2, ox, oy;
			bmp = GetZex(p); SKIPZEX(p); SKIPSP_BGA(p);
			x1  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			y1  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			x2  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			y2  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			ox  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			oy  = GetDec(p);

			// BMPԍ̏ȗȂт 00 ̎w͖
			if( bmp <= 0 ) 
				continue;	// sBMPԍw肳Ă

			// W
			//  BMP̃TCY͎s܂ŔȂ̂ŁABMP̃NbsO͎sɍŝƂB
			if( x1 > x2  ) {int t=x1; x1=x2; x2=t;}		// K(x1,y1)(x2,y2)̍ɗ悤ɂ
			if( y1 > y2  ) {int t=y1; y1=y2; y2=t;}

			// Zǉ
			BGA *bc  = new BGA();
			bc->num  = zz;
			bc->bmp  = bmp;
			bc->x1   = x1;	bc->y1 = y1;
			bc->x2   = x2;	bc->y2 = y2;
			bc->ox   = ox;	bc->oy = oy;
			bc->prev = bc->next = NULL;
			APPENDLIST( this->pBGA, this->pBGALast, bc);
			continue;	
		}
		// #AVIPAN 
		if( ( zz = this->GetCommand( &p, _T("AVIPAN") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36)
				continue;	// #AVIPANԍ͈͊O

			// p[^擾
			int avi, sw, sh, ew, eh, ssx, ssy, sex, sey, dsx, dsy, dex, dey, len;
			avi = GetZex(p); SKIPZEX(p); SKIPSP_BGA(p);
			sw  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			sh  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			ew  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			eh  = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			ssx = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			ssy = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			sex = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			sey = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dsx = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dsy = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dex = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			dey = GetDec(p); SKIPDEC(p); SKIPSP_BGA(p);
			len = GetDec(p);
				
			// AVIԍ̏ȗȂт 00 ̎w͖B
			if( avi == 0 ) 
				continue;	// sAVIԍw肳Ă

			// NbsOG
			//  AVĨTCY͎s܂ŔȂ̂ŁANbsO͎sɍsB

			// Zǉ
			AVIPan *ac = new AVIPan();
			ac->num = zz;
			ac->avi = avi;
			ac->sw  =  sw;	ac->sh  =  sh;
			ac->ew  =  ew;	ac->eh  =  eh;
			ac->ssx = ssx;	ac->ssy = ssy;
			ac->sex = sex;	ac->sey = sey;
			ac->dsx = dsx;	ac->dsy = dsy;
			ac->dex = dex;	ac->dey = dey;
			ac->len = len;
			ac->prev = ac->next = NULL;
			APPENDLIST( this->pAVIPan, this->pAVIPanLast, ac );
			continue;
		}
		// #AVI, #VIDEO 
		if( ( zz = this->GetCommand( &p, _T("AVI") ) ) != 0 || ( zz = this->GetCommand( &p, _T("VIDEO") ) ) != 0 )
		{
			if( zz < 0 || zz >= 36*36 )
				continue;	// #AVI(VIDEO)ԍ͈͊O

			// Zǉił͂܂ AVI::avi ͏Ȃj
			AVI *ac = new AVI();
			ac->num  = zz;//++ nAVINumCur;	--> #AVIPAN ɂƂȂAB(2006/5/5)
			ac->bUse = false;
			ac->strFileName = p;
			ac->prev = ac->next = NULL;
			APPENDLIST( this->pAVI, this->pAVILast, ac );

			// AVIgptOON
			this->bUseAVI = true;
			continue;
		}

		// ̑F`bvzu 
		{
			// (1) ߔԍ擾  nPart 
			int nPart = GetDec3( p );
			p += 3;
			if( nPart < 0 )
				continue;	// ߔԍs

			nPart ++;	// 1߂炷iȊJn -1 ߂邽߁j

			// (2) `lԍ擾  nCh 
			int nCh = GetChannel( p );
			p += 2;
			if( nCh < 0 )
				continue;	// `lԍs

			// (3) ':' Ƌ󔒂XLbv 
			SKIPSP( p );
			if( *p == _T(':') )
			{
				p++;
				SKIPSP( p );
			}
			// (4) gptOGŶ ON 
			if     ( nCh >= 0x11 && nCh <= 0x1A ) this->bUseDrum		= true;
			else if( nCh >= 0x20 && nCh <= 0x27 ) this->bUseGuitar		= true;
			else if( nCh >= 0xA0 && nCh <= 0xA7 ) this->bUseBass		= true;
			if( nCh == 0x18	)					  this->bUseHHOpen		= true;
			if( nCh == 0x19 )					  this->bUseRide		= true;
			if( nCh == 0x1A )					  this->bUseLeftCymal	= true;

			// (5) p[^擾(ch.02̏ꍇ): w 
			if( nCh == 0x02 )
			{
				double d = str2float( p );
				if( d <= 0.0 )
					continue;

				Chip *cell = new Chip();
				cell->dwPosition	= nPart * DTX_RESOLVE;
				cell->nChannel		= nCh;
				cell->dbParam		= d;
				this->InsertChip( cell );
				continue;
			}
			// (6) p[^擾(ch.02ȊO) 
			{	
				// (6-1) IuWFNg̒𐔂  n 
				int n = 0;
				TCHAR* q = p;
				while( *q != _T('\n') && *q != _T('\0') && *q != _T(' ') && *q != _T('\t') )
				{
					// '_' ͖
					if( *q == _T('_') ) {
						q++;
						continue;
					}
					if( ( *q >= _T('0') && *q <= _T('9') ) || ( *q >= _T('a') && *q <= _T('z') ) || (*q >= _T('A') && *q <= _T('Z') ) ) {
						n++;
						q ++;
						continue;
					}
					else 
					{
						n = -1;
						break;		// IuWFNgzu 0`9,A`Z ȊO̕(%02x)gĂ  ̍s𖳎
					}
				}
				if( ( n % 2 ) != 0 )
					n --;		// ȂAŌ̈ꌅ͖
				if( n <= 0 )
					continue;		// ȂG[Ȃ疳

				// (6-2) IuWFNgQ Chip  
				for( int i = 0; i < n / 2; i++ )
				{
					// (6-2-1) '_' ͖ 
					if( *p == _T('_') )
					{
						p++; i--;
						continue;
					}
					// (6-2-2) '00' Ȃ疳 
					if( *p == _T('0') && *(p+1) == _T('0') ) {
						p += 2;
						continue;
					}

					// (6-2-3) zz l̎擾GCh.03 ̂16iȂ36i 
					int zz = ( nCh == 0x03 ) ? GetHex( p ) : GetZex( p );
					
					// (6-2-4) `bv𐶐 
					Chip *cc = new Chip();
					cc->dwPosition	= ( nPart * DTX_RESOLVE ) + ( DTX_RESOLVE * i) / ( n / 2 );
					cc->nChannel	= nCh;
					cc->nParam		= zz;
					cc->nRealParam	= zz; 
					if( nCh >= 0x11 && nCh <= 0x1A ) cc->nType = 0;		// h`l
					if( nCh >= 0x20 && nCh <= 0x27 ) cc->nType = 1;		// M^[`l
					if( nCh >= 0xA0 && nCh <= 0xA7 ) cc->nType = 2;		// M^[`l
					// (6-2-5) WAVn`lȂ zz  WAVEԍɕϊ 
					if( this->GetChipParamType( cc->nChannel ) & DTXCPT_WAV )
						cc->nRealParam = this->m_nWaveNum[ zz ];
					// (6-2-6) BPMEXn`lȂ zz  BPMԍɕϊ 
					else if( this->GetChipParamType( cc->nChannel ) & DTXCPT_BPMEX )
						cc->nRealParam = this->m_nBPMNum[ zz ];
					// (6-2-7) tBCn`lȂ|WVC 
					else if( nCh == 0x53 )
					{
						if( zz > 0 && zz != 2 )				// tBCJn  |WV 32 Oɂ炷
							cc->dwPosition -= 32;
						else if( zz == 2 )					// tBCI  |WV 32 ɂ炷
							cc->dwPosition += 32;
					}
					// (6-2-8) `bv̒ǉ 
					{
						// InsertChip()  cc->dwPosition Ń\[g邽߁Acc->dwPosition ̏CɌĂяoƁB
						this->InsertChip( cc );
					}

					p += 2;		// ̃IuWFNg	
				}
			}
		}
	}

	SAFE_FREE( strLine );

	// (3) LoadDTX() ̌㏈ 
	{
		// (3-1) JnBPM`bvǉB
		{
			// ChipXg̐擪ɁA#00008:00 ̃`bvǉBi#BPM: Ȃ̓ŗLɂ邽߁j 
			BPM* pb;
			for( pb = this->pBPMLast; pb != NULL; pb = pb->prev )	// #BPM: ꍇ͌uD
				if( pb->vnum == 0 )	break;
		
			// (A) #BPM: ݂Ȃ  #BPM00:120  BPMXg̖ɒǉABPMԍ Chip ǉB 
			if( pb == NULL )
			{
				pb = new BPM();
				pb->num		= ++ m_nBPMNumCur;
				pb->vnum	= 0;
				pb->bpm		= 120.0;
				pb->prev = pb->next = NULL;
				APPENDLIST( this->pBPM, this->pBPMLast, pb );
				
				Chip *cc = new Chip();
				cc->dwPosition	= 0;
				cc->nChannel	= 0x08;
				cc->nParam		= 0;
				cc->nRealParam	= pb->num;	// #BPM00:  BPM ԍ
				this->InsertChip( cc );
			}
			// (B) #BPM: ݂  BPMԍChipǉB 
			else
			{
				Chip *cc = new Chip();
				cc->dwPosition	= 0;
				cc->nChannel	= 0x08;
				cc->nParam		= 0;
				cc->nRealParam	= pb->num;	// #BPM00:  BPM ԍ
				this->InsertChip( cc );
			}
		}
		// (3-2) WAVVOL  WAVPAN ̏ȗĂ Wave ɂăftHglKpB 
		{
			for( Wave* wp = this->pWave; wp != NULL; wp = wp->next )
			{
				if( wp->volume < 0 )
					wp->volume = 100;
				if( wp->pan < -10000 )
					wp->pan = 0;
			}
		}
		// (3-3) łw肪ꍇAŏ̋łw`bvȂ̐擪֕ʂB 
		{
			for( int i = 0xB1; i <= 0xBB; i++ )
			{
				for( Chip* c = this->pChip; c != NULL; c = c->next )
				{
					if( c->nChannel == i ) 
					{
						Chip *cc = new Chip();
						cc->dwPosition	= 0;		// 擪
						cc->nChannel	= c->nChannel;
						cc->nParam		= c->nParam;
						cc->nRealParam	= c->nRealParam;
						this->InsertChip( cc );
						break;
					}
				}
			}
		}
		// (3-4) BMP摜(#BMP00:)ꍇABMP`bvȂ̐擪ɑ}B 
		{
			for( BMP* pBmp = this->pBMPLast; pBmp != NULL; pBmp = pBmp->prev )
			{
				if( pBmp->num == 0 )
				{
					Chip *cc = new Chip();
					cc->dwPosition	= 0;			// 擪
					cc->nChannel	= 0x04;			// ch.04
					cc->nParam		= 0;
					cc->nRealParam	= 0;
					this->InsertChip( cc );
					break;
				}
			}
		}
	}

	fclose( fp );
}
void DTX::InsertChip( Chip *cell )
{
	// \Fʒȕꍇ̃`lԂ̗D揇ʁiقǑOɑ}j 
	static const UCHAR byPriority[ 256 ] = {
		5,5,3,3,5,5,5,5,3,5,5,5,5,5,5,5,	// 0x	ߐύXABPM ͗D
		5,7,7,7,7,7,7,7,7,7,7,5,5,5,5,5,	// 1x	`bv͌ցî̂قǏʕ`j
		7,7,7,7,7,7,7,7,5,5,5,5,5,5,5,5,	// 2x
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// 3x
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// 4x
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// 5x
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// 6x
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// 7x
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// 8x
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// 9x
		7,7,7,7,7,7,7,7,5,5,5,5,5,5,5,5,	// Ax
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// Bx
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// Cx
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// Dx
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,	// Ex
		5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5		// Fx
	};

	// (1) ŏ̃Z̏ꍇ  Xg̐擪ɒǉB 
	if( this->pChipLast == NULL ) {
		this->pChip = this->pChipLast = cell;
		return;
	}
	// (2) K؂ȏꏊXguŌv猟A}B 
	for( Chip *t = this->pChipLast; t != NULL; t = t->prev )
	{
		if( t->dwPosition < cell->dwPosition ||
			( t->dwPosition == cell->dwPosition	&& byPriority[ t->nChannel ] <= byPriority[ cell->nChannel ] ) )
		{
			// t ̒ɑ}
			cell->prev = t;
			cell->next = t->next;
			if( t->next == NULL ) {
				t->next = cell;
				this->pChipLast = cell;
			} else {
				t->next->prev = cell;
				t->next = cell;
			}
			return;	// 
		}
	}
	// (3) 擪܂ŒB  Xg̐擪ɑ}B 
	cell->prev = NULL;
	cell->next = this->pChip;
	if( this->pChip != NULL ) {
		this->pChip->prev = cell;
		this->pChip = cell;
	} else {
		this->pChip = this->pChipLast = cell;
	}
}
void DTX::InsertMIDIChip( Chip *cell )
{
	// (1) ŏ̃Z̏ꍇ  Xg̐擪ɒǉB 
	if( this->pChipLast == NULL )
	{
		this->pChip = this->pChipLast = cell;
		return;
	}
	// (2) K؂ȏꏊXǵuŌv猟A}B 
	for( Chip *t = this->pChipLast; t != NULL; t = t->prev )
	{
		// ʒȕꍇɂ́A0x11`0x1A ͌ɎĂBiŕ`悳遨ɕ`悳j
		if( t->dbTime < cell->dbTime || ( t->dbTime == cell->dbTime && ( cell->nChannel >= 0x11 && cell->nChannel <= 0x1A ) ) )
		{
			// t  cell  ... ̏ɂȂ悤}
			cell->prev	= t;
			cell->next	= t->next;
			if (t->next == NULL) {
				t->next		 = cell;
				this->pChipLast = cell;
			} else {
				t->next->prev = cell;
				t->next		  = cell;
			}
			return; // 
		}
	}
	// (3) 擪܂ŒB  Xg̐擪ɑ}B 
	cell->prev = NULL;
	cell->next = this->pChip;
	if( this->pChip->prev != NULL ) {
		this->pChip->prev = cell;
		this->pChip = cell;
	} else {
		this->pChip = this->pChipLast = cell;
	}
}
void DTX::InsertLines()
{
	if( !this->pChip || !this->pChipLast )
		return;		// `bvȂ

	double	dbBai = 1.0;	// ߒ{
	DWORD	dwLast;			// Ō̃`bv݂鏬߂́A̎̏߂̐擪ʒu
	dwLast  = this->pChipLast->dwPosition;
	dwLast += DTX_RESOLVE - ( dwLast % DTX_RESOLVE );

	// (1) ߐ̑} 
	{
		for( DWORD pos = 0; pos <= dwLast; pos += DTX_RESOLVE )
		{
			Chip *nc = new Chip();
			nc->dwPosition	= pos;
			nc->nChannel	= 0x50;
			nc->nParam		= 36*36-1;		// VXeu nParam = zz
			InsertChip( nc );
		}
	}
	// (2) ̑} 
	{
		Chip *p02 = this->pChip;	// for ch.02iߒ{ύXj
		Chip *pC1 = this->pChip;	// for ch.C1iVtgG02 uƁȀߓɌA甏n܂j
		
		for( DWORD pos = 0; pos < dwLast; pos += DTX_RESOLVE )		// pos ͏ߒPʂő
		{
			// VtgG
			// ̏ߓipos ` pos+DTX_RESOLVE ͈͓̔j ch.C1Z 邩ǂAǂ݂ĊmFB
			// AdwJnʒu ɂ̑Έʒui߃A^}̋[ct]ji[ĂB
			// Ȃ΁AdwJnʒu  0 B
			
			DWORD dwJnʒu = 0;

			while( pC1 && pC1->dwPosition < pos + DTX_RESOLVE )
			{
				if( pC1->nChannel == 0xC1 )
					dwJnʒu = pC1->dwPosition - pos;
				pC1 = pC1->next;
			}

			// ߒ{ύẊ@G BMSł̎RA
			// BMS,BME ł́AP߂Ƃɏߒ{ 1.0 ɖ߂B

			if( this->scoreType == SCORETYPE_BMS )
				dbBai = 1.0;

			// ߒ{ύẊAG Ch.02 ł̕ύXΑΉB
			while( p02 && p02->dwPosition <= pos )	// Ch.02 ͏ߓɂȂi dwPosition K DTX_RESOLVE Ŋ؂j
			{
				if( p02->nChannel == 0x02 )
					dbBai = p02->dbParam;
				p02 = p02->next;
			}

			// ̑}

			for( int nA = 0; nA < 100; nA++ )	// < 100 ͖[vh~̕ی
			{
				DWORD dwʒu = (DWORD)( ( DTX_RESOLVE * nA ) / ( 4.0 * dbBai ) );
				
				// ʒu߂z甲
				if( dwʒu + dwJnʒu >= DTX_RESOLVE )
					break;

				// `bv̍쐬Ƒ}
				if( ( dwʒu + dwJnʒu ) % DTX_RESOLVE != 0 )	// ߐƓꏊɂ͒uȂ
				{
					Chip *nc = new Chip();
					nc->dwPosition	= pos + dwʒu + dwJnʒu;
					nc->nChannel	= 0x51;
					nc->nParam		= 36*36-1;	// VXeu nParam = zz
					InsertChip( nc );
				}
			}
		}
	}
	// (3) Eߐ̔\w(ch.C2)ȂΉB 
	{
		bool b = true;

		// ׂẴ`bvɂ...
		for( Chip* cp = this->pChip; cp != NULL; cp = cp->next )
		{
			//  position ɕ̃`bvꍇ́Ach.C2 DIɓǂށB
			for( Chip* pʒuChip = cp; pʒuChip && pʒuChip->dwPosition == cp->dwPosition; pʒuChip = pʒuChip->next )
			{
				if( pʒuChip->nChannel == 0xC2 && pʒuChip->nParam == 1 ) b = true;
				if( pʒuChip->nChannel == 0xC2 && pʒuChip->nParam == 2 ) b = false;
			}
			
			// ̎ɁAEߐ̉ݒ肷BA[UúinParam!=ZZ ̂́j͉e󂯂ȂB
			if( ( cp->nChannel == 0x50 || cp->nChannel == 0x51 ) && cp->nParam == 36*36-1 )
				cp->bVisible = b;
		}
	}
}
void DTX::CalcChipTime()
{
	// MID `͎ZosviDrumMIDI łłɎvZς݁j
	if( this->scoreType == SCORETYPE_MID )
		return;

	double db݂BPM			= 120.0;	// [/]
	double db݂̏ߒ{	= 1.0;
	DWORD  dwJEgl		= 0;		// db݂̏ߒ{, db݂BPM ̍ŌɕωJEgliP߁ DTX_RESOLVE JEgŌŒj
	double db			= 0;		// @@@@@@@@@@@V@@@@@@@@@@@@[ms]
	DWORD  dwO				= 0;		// ߒύXp

	// ׂẴ`bvɂ...
	for( Chip* cell = this->pChip; cell != NULL; cell = cell->next )
	{
		// (1) ̌vZ  cell->dbTime 
		cell->dbTime = (DWORD)( db + ((240000 / DTX_RESOLVE) * (cell->dwPosition - dwJEgl) * db݂̏ߒ{) / (db݂BPM * this->fSpeed) );

		// (2) ߂ςAߒ 1.0 ɖ߂B(BMŜ) 
		if( this->scoreType == SCORETYPE_BMS && db݂̏ߒ{ != 1.0 && (cell->dwPosition / DTX_RESOLVE) != dwO )
		{
			dwJEgl	= cell->dwPosition;
			db			= cell->dbTime;
			db݂̏ߒ{	= 1.0;
		}
		dwO = cell->dwPosition / DTX_RESOLVE;

		// (3) ȉA`lƂ̌ʏ
		switch( cell->nChannel )
		{
		// (3-1) ߒύX 
		case 0x02: 
			{
				dwJEgl	= cell->dwPosition;
				db			= cell->dbTime;
				db݂̏ߒ{	= cell->dbParam;
			}
			break;

		// (3-2) BPMύX(1)BPM 
		case 0x03: 
			{
				dwJEgl	= cell->dwPosition;
				db			= cell->dbTime;
				db݂BPM			= this->dbBaseBPM + (double)cell->nParam;
			}
			break;

		// (3-3) BPMύX(2)BPM 
		case 0x08: 
			{
				dwJEgl = cell->dwPosition;
				db		 = cell->dbTime;

				for( BPM *bc = this->pBPMLast; bc != NULL; bc = bc->prev )
				{
					if( bc->num == cell->nRealParam )
					{
						db݂BPM = ( ( bc->vnum == 0 ) ? 0 : this->dbBaseBPM ) + bc->bpm;	// bc->vnum = 0 ̂Ƃi#BPM:̂Ƃj BaseBPM ͉ȂI
						break;
					}
				}
			}
			break;

		// (3-4) BGAPAN 
		case 0x04: case 0x07:
		case 0x55: case 0x56: case 0x57: case 0x58: case 0x59: case 0x60:
			{
				for( BGAPan *bp = this->pBGAPanLast; bp != NULL; bp = bp->prev )
				{
					if( bp->num == cell->nParam )
					{
						double st = db + ((240000 / DTX_RESOLVE) * (cell->dwPosition           - dwJEgl) * db݂̏ߒ{) / db݂BPM;
						double et = db + ((240000 / DTX_RESOLVE) * (cell->dwPosition + bp->len - dwJEgl) * db݂̏ߒ{) / db݂BPM;
						cell->dbLong = et - st;
						break;
					}
				}
			}
			break;

		// (3-5) AVIPAN 
		case 0x54:
			{
				for( AVIPan *ap = this->pAVIPanLast; ap != NULL; ap = ap->prev )
				{
					if( ap->num == cell->nParam )
					{
						double st = db + ((240000 / DTX_RESOLVE) * (cell->dwPosition           - dwJEgl) * db݂̏ߒ{) / db݂BPM;
						double et = db + ((240000 / DTX_RESOLVE) * (cell->dwPosition + ap->len - dwJEgl) * db݂̏ߒ{) / db݂BPM;
						cell->dbLong = et - st;
						break;
					}
				}
			}
			break;
		}
	}
}
void DTX::AdujstChipTimeByPlaySpeed( double dbPlaySpeed )
{
	if( dbPlaySpeed <= 0 )
		return;

	// ׂẴ`bv̔C
	for( Chip* p = this->pChip; p != NULL; p = p->next )
		p->dbTime = p->dbTime / dbPlaySpeed;
}
// BMP, AVI, WAV ̓ǂݍ
void DTX::LoadBMP()
{
	this->dwBMPWidthMax		= this->dwBMPHeightMax		= -1;
	this->dwBMPTEXWidthMax	= this->dwBMPTEXHeightMax	= -1;

	// (1) e}l[W̃LbṼtOZbg 
	this->textureManager.ResetCache();
	this->surfaceManager.ResetCache();

	// (2) BMPTEX ̓ǂݍ݁GVRAM D̂߁ABMP ɓǂݍށB 
	{
		int neNX` = 0;

		for( BMPTEX *btc = this->pBMPTEX; btc != NULL; btc = btc->next )
		{
			// #PATH_WAV ̎w肪ꍇ͂AȊO DTX ̂ꏊǂݍށB
			tstring path = ( this->strPathWav.empty() ) ? this->strFolder : this->strPathWav;
			path += btc->strFileName;

			// eNX`̐
			TCHAR name[ 32 ];
			_stprintf_s( name, 32, _T("BMPTEX(%d)摜"), btc->num );
			if( ( btc->pTexture = this->textureManager.GetCachedTexture( name, path.c_str(), 0, 0 ) ) == NULL )
				continue;	// 쐬Ɏs
			btc->bUse = true;

			// ő啝E̍XV
			if( btc->pTexture->dwWidth  > this->dwBMPTEXWidthMax ) this->dwBMPTEXWidthMax  = btc->pTexture->dwWidth;
			if( btc->pTexture->dwHeight > this->dwBMPTEXHeightMax) this->dwBMPTEXHeightMax = btc->pTexture->dwHeight;

			neNX` ++;
		}
	}
	// (3) BMP ̓ǂݍ 
	{
		int nT[tFCX = 0;

		for( BMP *bc = this->pBMP; bc != NULL; bc = bc->next )
		{
			// #PATH_WAV ̎w肪ꍇ͂AȊO DTX ̂ꏊǂݍށB
			tstring path = ( this->strPathWav.empty() ) ? this->strFolder : this->strPathWav;
			path += bc->strFileName;

			// T[tFCX̐
			TCHAR name[ 32 ];
			_stprintf_s( name, 32, _T("BMP(%d)摜"), bc->num );
			if( ( bc->pSurface = this->surfaceManager.GetCachedSurface( name, path.c_str(), 0, 0, LOADTO_VIDEO_OR_SYSTEM ) ) == NULL )
				continue;	// 쐬Ɏs
			bc->bUse = true;

			// ő啝E̍XV
			if( bc->pSurface->dwWidth  > this->dwBMPWidthMax ) this->dwBMPWidthMax  = bc->pSurface->dwWidth;
			if( bc->pSurface->dwHeight > this->dwBMPHeightMax) this->dwBMPHeightMax = bc->pSurface->dwHeight;

			nT[tFCX ++;
		}
	}
	// (4) e}l[W̃LbVsvȃ\[X폜 
	this->surfaceManager.RemoveUnusedSurfaces();
	this->textureManager.RemoveUnusedTextures();

	
	// wb_ǂݍ݂݂̂Ȃ炱ŏI
	if( this->bHeaderOnly ) return;

	// (5) BMP, BMPTEX, BGA, BGAPAN ̎OœK 
	for( Chip *c = this->pChip; c != NULL; c = c->next )
	{
		// (5-1) BGAC`l`bvɁABMP/BMPTEX/BGA/BGAPANւ̃|C^蓖ĂB 
		if( c->nChannel == 0x04 || c->nChannel == 0x07 || ( c->nChannel >= 0x55 && c->nChannel <= 0x59 ) || c->nChannel == 0x60 )
		{
			//  
			c->BGAtype	= BGATYPE_UNKNOWN;
			c->pBMP		= NULL;
			c->pBMPTEX	= NULL;
			c->pBGA		= NULL;
			c->pBGAPan	= NULL;

			// (5-1-1) BGAPAN 猟AΏB 
			for( BGAPan *bgapan = this->pBGAPanLast; bgapan != NULL; bgapan = bgapan->prev )
			{
				if( bgapan->num == c->nParam )
				{
					BMPTEX* bmptex;
					for( bmptex = this->pBMPTEXLast; bmptex != NULL; bmptex = bmptex->prev )
					{
						if( bmptex->num == bgapan->bmp && bmptex->bUse )
						{
							c->BGAtype	= BGATYPE_BGAPAN;
							c->pBMPTEX	= bmptex;
							c->pBGAPan	= bgapan;
							break;
						}
					}
					if( bmptex ) break;
					BMP* bmp;
					for( bmp = this->pBMPLast; bmp != NULL; bmp = bmp->prev )
					{
						if( bmp->num == bgapan->bmp && bmp->bUse )
						{
							c->BGAtype	= BGATYPE_BGAPAN;
							c->pBMP		= bmp;
							c->pBGAPan	= bgapan;
							break;
						}
					}
					if( bmp ) break;
				}
			}
			if( c->BGAtype != BGATYPE_UNKNOWN )
				continue;

			// (5-1-2) BGA 猟AΏB 
			for( BGA *bga = this->pBGALast; bga != NULL; bga = bga->prev ) {
				if( bga->num == c->nParam ) 	{
					BMPTEX* bmptex;
					for( bmptex = this->pBMPTEXLast; bmptex != NULL; bmptex = bmptex->prev ) {
						if( bmptex->num == bga->bmp && bmptex->bUse ) {
							c->BGAtype	= BGATYPE_BGA;
							c->pBMPTEX	= bmptex;
							c->pBGA		= bga;
							break;
						}
					}
					if( bmptex ) break;
					BMP* bmp;
					for( bmp = this->pBMPLast; bmp != NULL; bmp = bmp->prev ) {
						if( bmp->num == bga->bmp && bmp->bUse ) {
							c->BGAtype	= BGATYPE_BGA;
							c->pBMP		= bmp;
							c->pBGA		= bga;
							break;
						}
					}
					if( bmp ) break;
				}
			}
			if( c->BGAtype != BGATYPE_UNKNOWN )
				continue;

			// (5-1-3) BMPTEX 猟AΏB 
			for( BMPTEX* bmptex = this->pBMPTEXLast; bmptex != NULL; bmptex = bmptex->prev ) {
				if( bmptex->num == c->nParam && bmptex->bUse ) {
					c->BGAtype	= BGATYPE_BMPTEX;
					c->pBMPTEX	= bmptex;
					break;
				}
			}
			if( c->BGAtype != BGATYPE_UNKNOWN )
				continue;

			// (5-1-4) BMP 猟AΏB 
			for( BMP* bmp = this->pBMPLast; bmp != NULL; bmp = bmp->prev ) {
				if( bmp->num == c->nParam && bmp->bUse ) {
					c->BGAtype	= BGATYPE_BMP;
					c->pBMP		= bmp;
					break;
				}
			}
		}
		// (5-2) DTX::Chip  BGAXR[v摜ؑփ`lZɁABMP/BMPTEX ւ̃|C^蓖ĂB 
		if( c->nChannel == 0xC4 || c->nChannel == 0xC7 || ( c->nChannel >= 0xD5 && c->nChannel <= 0xD9 ) || c->nChannel == 0xE0 )
		{
			//  
			c->BGAtype	= BGATYPE_UNKNOWN;
			c->pBMP		= NULL;
			c->pBMPTEX	= NULL;
			c->pBGA		= NULL;
			c->pBGAPan	= NULL;

			// (5-2-1) BMPTEX 猟AΏB 
			for( BMPTEX* bmptex = this->pBMPTEXLast; bmptex != NULL; bmptex = bmptex->prev )
			{
				// BGAXR[v摜ؑփ`l̏ꍇAnParam  "BMPԍ" łABGA, BGAPAN ̔ԍ͖֌WłB
				if( bmptex->num == c->nParam && bmptex->bUse )
				{
					c->BGAtype	= BGATYPE_BMPTEX;
					c->pBMPTEX	= bmptex;
					break;
				}
			}
			if( c->BGAtype != BGATYPE_UNKNOWN )
				continue;

			// (5-2-2) BMP 猟AΏB 
			for( BMP* bmp = this->pBMPLast; bmp != NULL; bmp = bmp->prev )
			{
				// BGAXR[v摜ؑփ`l̏ꍇAnParam  "BMPԍ" łABGA, BGAPAN ̔ԍ͖֌WłB
				if( bmp->num == c->nParam && bmp->bUse ) {
					c->BGAtype	= BGATYPE_BMP;
					c->pBMP		= bmp;
					break;
				}
			}
		}
	}
}
void DTX::LoadAVI()
{
	// (1) AVI ̃I[v 
	int nAVII[v = 0;
	for( AVI *ac = this->pAVI; ac != NULL; ac = ac->next )
	{
		// #PATH_WAV ̎w肪ꍇ͂AȊO DTX ̂ꏊǂݍށB
		tstring path = ( this->strPathWav.empty() ) ? this->strFolder : this->strPathWav;
		path += ac->strFileName;

		// AVI I[v
		ac->avi._();
		ac->bUse = ( SUCCEEDED( ac->avi.Open( path ) ) ) ? true : false;		// open ɐ true

		if( ac->bUse )
			nAVII[v ++;
		else
			ac->avi.Close();	// s
	}

	// wb_ǂݍ݂݂̂Ȃ炱ŏI
	if( this->bHeaderOnly ) return;

	// (2) AVIPAN ̎OœK 
	for( Chip *c = this->pChip; c != NULL; c = c->next )
	{
		// AVI`l`bvɁAAVI/AVIPANւ̃|C^蓖ĂB
		if( c->nChannel == 0x54 ) 
		{
			//  
			c->AVItype	= AVITYPE_UNKNOWN;
			c->pAVI		= NULL;
			c->pAVIPan	= NULL;

			// (1) AVIPAN 猟AΏB 
			for( AVIPan *avipan = this->pAVIPanLast; avipan != NULL; avipan = avipan->prev )
			{
				if( avipan->num == c->nParam )
				{
					AVI* avi;
					for( avi = this->pAVILast; avi != NULL; avi = avi->prev )
					{
						if( avi->num == avipan->avi && avi->bUse )
						{
							c->AVItype	= AVITYPE_AVIPAN;
							c->pAVI		= avi;
							c->pAVIPan	= avipan;
							break;
						}
					}
					if( avi ) break;
				}
			}
			if( c->AVItype != AVITYPE_UNKNOWN )
				continue;

			// (2) AVI 猟AΏB 
			for( AVI* avi = this->pAVILast; avi != NULL; avi = avi->prev )
			{
				if( avi->num == c->nParam && avi->bUse )
				{
					c->AVItype	= AVITYPE_AVI;
					c->pAVI		= avi;
					break;
				}
			}
		}
	}
}
void DTX::LoadWAV()
{
	// (1) TEh}l[W̃LbṼZbg 
	this->soundManager.tgptONAZ폜();

	// (2) STEhǂݍ 
	for( Wave *wc = this->pWave; wc != NULL; wc = wc->next )
	{
		// path G#PATH_WAV ̎w肪ꍇ͂AȊO DTX ̂ꏊǂݍށB 
		tstring path = ( this->strPathWav.empty() ) ? this->strFolder : this->strPathWav;
		path += wc->strFileName;

		// TEhgp郌[Ƃɐ
		for( int i = 0; i < 11; i++ )
		{
			if( ! wc->bUseByLane[i] ) continue;		// ̃[ŎgpȂȂXLbv

			// P[ɕtMAX_SOUND ̃obt@쐬
			for( int j = 0; j < DTX_MAX_SOUND; j++ )
			{
				// TEh𐶐
				if( ( wc->sound[i][j] = this->soundManager.pLbVΉTEh쐬ĕԂ( path.c_str() ) ) == NULL )
				{
					wc->bUse = false;	// Płs炱WAV̎gȂ
					break;
				}
				wc->bUse = true;

				// ʂ̏
				wc->sound[i][j]->SetVolume( 100 );

				// t[ms]̌vZ
				wc->dwBufferSize = wc->sound[i][j]->GetDirectSoundBufferSize();
				DWORD dwSize;
				wc->sound[i][j]->GetDirectSoundBuffer()->GetFormat( NULL, 0, &dwSize );
				LPWAVEFORMATEX pWF = (LPWAVEFORMATEX) malloc( dwSize );
				wc->sound[i][j]->GetDirectSoundBuffer()->GetFormat( pWF, dwSize, NULL );
				wc->dbTotalTime = (double)( wc->dwBufferSize / ( pWF->nAvgBytesPerSec * 0.001 ) );
				SAFE_FREE( pWF );
			}
			if( ! wc->bUse )
				break;	// ǂݍ݂ɎŝŔ
		}
	}
	// (3) TEh}l[W̃LbV疢gpTEh폜B 
	this->soundManager.tgpTEh폜();
}
// r̍ĐJn
void DTX::SkipStart( double dbStartTime )
{
	// Wave Ɋ֘At`bv 1, BMP֌W 2B
	// XLbvĐȂƂ 0 ɂĂB
	// łwȂǁAȂWAV֌W͖B
	static const char bTarget[ 256 ] = {
		0,1,0,0,2,0,0,2,0,0,0,0,0,0,0,0,	// 0x	01: BGM / 04,07: BGA
		0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,	// 1x	11`1A: Drums
		1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,	// 2x	20`27: Guitar
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// 3x
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// 4x
		0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,	// 5x	55`59,60: BGA
		2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,	// 6x	61`69,
		1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,	// 7x	70`79,
		1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,	// 8x	80`89,
		1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,	// 9x	90`92: BGM
		1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,	// ax	a0`a7: Bass
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// bx
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// cx
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// dx
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	// ex
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};	// fx

	for( Chip* cell = this->pChip; cell != NULL; cell = cell->next )
	{
		// JnȂÃ`bvŒł؂B
		if( cell->dbTime > dbStartTime ) 
			break;

		// 
		switch( bTarget[ cell->nChannel % 0xff ] )
		{
		case 1:
			SkipStartWave( dbStartTime, cell );		// WAVE ̃XLbvĐ
			break;

		case 2:
			SkipStartBGA( dbStartTime, cell );		// BGA ̃XLbvĐ
			break;
		}
	}
}

void DTX::SkipStartWave( double dbStartTime, Chip* cell )
{
	// (1) [ԍZo  l 
	int ch = cell->nChannel;
	int l;
	if( ch >= 0x11 && ch <= 0x1A )
		l = s_nChannelToLane[ ch - 0x11 ];		// Drums

	else if( ch >= 0x20 && ch <= 0x27 )
		l = 8;	// Guitar

	else if( ch >= 0xA0 && ch <= 0xA7 )
		l = 9;	// Bass

	else if( ch == 0x01 || (ch >= 0x61 && ch <= 0x69) || (ch >= 0x70 && ch <= 0x79) || (ch >= 0x80 && ch <= 0x89) || (ch >= 0x90 && ch <= 0x92) )
		l = 10;	// BGM

	else		
		return;	// ȊOiȂj

	// (2) ΉWave  wc 
	Wave* wc;
	for( wc = this->pWave; wc != NULL; wc = wc->next )
	{
		if( wc->num == cell->nRealParam && wc->bUse )
			break;
	}
	if( wc == NULL )
		return;		// ΉWaveȂ
	if( ! wc->bUseByLane[ l ] )
		return;		// ̃[ł͍ĐȂ
	if( cell->dbTime + ( wc->dbTotalTime / this->fSpeed ) <= dbStartTime )
		return;		// ĐȂ

	// (3) wʒuɈړAɍĐJnB 
	if( ++ wc->nCurSound[ l ] >= DTX_MAX_SOUND )
		wc->nCurSound[ l ] = 0;
	if( wc->sound[l][ wc->nCurSound[l] ] )
	{
		wc->sound[l][ wc->nCurSound[l] ]->SetVolume( (long)((DTX_AUTOVOLUME * wc->volume)/100.0) );
		wc->sound[l][ wc->nCurSound[l] ]->SetPan( wc->pan );
		wc->sound[l][ wc->nCurSound[l] ]->Play();
		wc->sound[l][ wc->nCurSound[l] ]->SetPosition( wc->sound[l][ wc->nCurSound[l] ]->GetPositionFromTime( dbStartTime - cell->dbTime ) );
	}
	wc->dbStartTime[l][ wc->nCurSound[l] ] = cell->dbTime;		// ĐJn
	wc->bPlaying[l][ wc->nCurSound[l] ] = true;
}
void DTX::SkipStartBGA( double dbStartTime, Chip* cell )
{
	//  BGA W[iAvjɈˑ邽߁Ał͉ȂBAvŎ邱ƁB
}
// `bv(WAV)̍ĐA~
void DTX::PlayChip( Chip* pChip, int nLane, long lVol, bool bMIDIMonitor, bool bBad )
{
	// (0) O`FbN 
	if( this->pTimer == NULL ) return;
	if( pChip == NULL ) return;
	if( pChip->nRealParam < 0 ) return;
	if( nLane < 0 || nLane > 10 ) return;

	// (1) Xg̖猟AĐiԍł̏do^ꍇA̐ݒ肪D悳j 
	for( Wave *wc = this->pWaveLast; wc != NULL; wc = wc->prev )
	{
		if( wc->num == pChip->nRealParam && wc->bUse && wc->bUseByLane[ nLane ] )
		{
			// (1-1) TEh[e[V
			if( ++ wc->nCurSound[ nLane ] >= DTX_MAX_SOUND )
				wc->nCurSound[ nLane ] = 0;

			// (1-2) Đ
			int s = wc->nCurSound[ nLane ];
			if( wc->sound[ nLane ][ s ] )
			{
				wc->sound[ nLane ][ s ]->SetVolume( (long)((lVol * wc->volume)/100.0) );
				wc->sound[ nLane ][ s ]->SetPan( wc->pan );

				if( ! bBad )
				{
					wc->sound[ nLane ][ s ]->SetPitch( 1.0f );
					wc->sound[ nLane ][ s ]->Play();
				}
				else
				{
					// BAD ͎gϒ
					wc->sound[ nLane ][ s ]->SetPitch( ( 100+ (((rand()%3)+1)*7) * (1-(rand()%2)*2) )  /100.0f );
					wc->sound[ nLane ][ s ]->Play();
				}
			}
			wc->dbStartTime[ nLane ][ s ] = this->pTimer->dbOReset() + pChip->dbTime;	// ĐJn c ݎł͂ȂAChip::dbTime Ɉv(FPSx̖h~)(2007.6.9)
			wc->bPlaying[ nLane ][ s ] = true;

			// (1-3) pChip->dbTime ƎԂƂ̍𖄂߂邽߁AȂWAVEĐʒuCB
			this->AdjustWave( wc, wc->dbStartTime[ nLane ][ s ], wc->sound[ nLane ][ s ] );

			break;
		}
	}
	// (2) MIDI Note ON ̏ꍇ MIDI m[gƂĂiDTXV ł͖Ή(2004.01.12)j 
	if( ! this->bDTXV )
	{
		DWORD dwMsg = pChip->message.dwMsg;
		if( this->bMIDINote && dwMsg != 0 )
		{
			if( bMIDIMonitor )								// bMonitor = true ̎
				dwMsg = (dwMsg & 0x00FFFF) | 0x7F0000;		// ʂ127ɂ
			midiOutShortMsg( this->hMidiOut, dwMsg );
		}
	}
}
void DTX::StopWave( int nWave, int nLane )
{
	if( nLane < 0 || nLane > 10 ) return;

	for( Wave *wc = this->pWaveLast; wc != NULL; wc = wc->prev )
	{
		if( wc->num == nWave && wc->bUse && wc->bUseByLane[ nLane ] )
		{
			for( int i = 0; i < DTX_MAX_SOUND; i++ ) {
				if( wc->sound[ nLane ][ i ] )
					wc->sound[ nLane ][ i ]->Stop();
				wc->bPlaying[ nLane ][ i ] = false;
			}
			wc->nCurSound[ nLane ] = -1;
			break;
		}
	}
}

void DTX::StopAllWaves()
{
	for( Wave* pw = this->pWave; pw != NULL; pw = pw->next ) {
		for( int i = 0; i < 11; i++ ) {
			for( int j = 0; j < DTX_MAX_SOUND; j++ ) {
				if( pw->bPlaying[i][j] && pw->sound[i][j] )
					pw->sound[i][j]->Stop();
			}
		}
	}
}

void DTX::PauseWaves()
{
	for( Wave *wc = this->pWaveLast; wc != NULL; wc = wc->prev ) {
		if( wc->bUse ) {
			for( int j = 0; j < 11; j++ ) {
				if( wc->bUseByLane[j] ) {
					for( int i = 0; i < DTX_MAX_SOUND; i++ ) {
						if( wc->sound[ j ][ i ] )
							wc->sound[ j ][ i ]->Pause();
						wc->bPlaying[ j ][ i ] = false;
						wc->dbPauseTime[ j ][ i ] = this->pTimer->GetSysTime();	// 
					}
				}
			}
		}
	}
}

void DTX::ContWaves()
{
	for( Wave *wc = this->pWaveLast; wc != NULL; wc = wc->prev ) {
		if( wc->bUse ) {
			for( int j = 0; j < 11; j++ ) {
				if( wc->bUseByLane[j] ) {
					for( int i = 0; i < DTX_MAX_SOUND; i++ ) {
						if( wc->sound[ j ][ i ] ) {
							wc->sound[ j ][ i ]->Cont( wc->dbPauseTime[j][i] - wc->dbStartTime[j][i] );	// Pause() ĂȂꍇ͉eȂ
							wc->dbStartTime[j][i] += this->pTimer->GetSysTime() - wc->dbPauseTime[j][i];
						}
						wc->bPlaying[ j ][ i ] = true;
					}
				}
			}
		}
	}
}

//
void DTX::AdjustWaves()
{
	for( Wave *wc = this->pWave; wc != NULL; wc = wc->next )
	{
		if( wc->bUse )
		{
			for( int j = 0; j < 11; j++ )
			{
				if( ! wc->bUseByLane[j] )
					continue;

				for( int i = 0; i < DTX_MAX_SOUND; i++ )
				{
					if( ! wc->sound[j][i] || ! wc->sound[j][i]->IsPlay() ) {
						wc->bPlaying[j][i] = false;		// ĐȂ
						continue;
					}

					// Đʒu␳
					this->AdjustWave( wc, wc->dbStartTime[j][i], wc->sound[j][i] );
				}
			}
		}
	}
}
void DTX::AdjustWave( DTX::Wave* pWave, double dbStartTime, CSound* pSound )
{
	if( !pWave || dbStartTime < 0.0 || !pSound)
		return;

	// tԂ 5000ms ȏ̉̂ݒ 
	if( pWave->dbTotalTime < 5000.0 )
		return;

	// TEh̍ĐCPUƂ͖֌Wɐił̂ŁA
	//   STEhłP dbNow ȂAPP̃TEhƂ g_Timer.GetSysTime() ĔׂKvB(2007.6.9)
	double dbNow = this->pTimer->GetSysTime();

	if( dbNow > dbStartTime )
	{
		//  this->fSpeed  CSound::GetPositionFromTime() ōl̂łł͂ȂB
		double dbPos = ( dbNow - dbStartTime ) * 1/*this->fSpeed*/;
		pSound->SetPosition( pSound->GetPositionFromTime( dbPos ) );
	}
}
//
void DTX::SetVolume( int nWave, long lVolume, int nLane )
{
	if( nLane < 0 || nLane > 10 ) return;

	for( Wave *wc = this->pWaveLast; wc != NULL; wc = wc->prev )		// Xg̖猟... ԍł̏do^ꍇA̐ݒ肪D悳B
	{
		if( wc->num == nWave && wc->bUse && wc->bUseByLane[ nLane ] )
		{
			int next = wc->nCurSound[ nLane ] + 1;					// ɔׂTEhɂĐݒ
			if( next >= DTX_MAX_SOUND )
				next = 0;
			if( wc->sound[ nLane ][ next ] )
				wc->sound[ nLane ][ next ]->SetVolume( lVolume );
			break;
		}
	}
}

void DTX::SetWAVCache( bool bON )
{
	this->bWAVCache = bON;
}
void DTX::SetBMPCache( bool bON )
{
	this->bBMPCache = bON;
}
void DTX::SetResultImage( int rank, LPCTSTR fname, int arPriority[] )
{
	if( rank < 0 || rank > 6 )
		return;

	for( int i = rank; i >= 0; i-- )
	{
		if( arPriority[i] < 7-rank )
		{
			arPriority[i] = 7-rank;
			this->strResultImage[i] = fname;
		}
	}
}

void DTX::SetResultMovie( int rank, LPCTSTR fname, int arPriority[] )
{
	if( rank < 0 || rank > 6 )
		return;

	for( int i = rank; i >= 0; i-- )
	{
		if( arPriority[i] < 7-rank )
		{
			arPriority[i] = 7-rank;
			this->strResultMovie[i] = fname;
		}
	}
}

void DTX::SetResultSound( int rank, LPCTSTR fname, int arPriority[] )
{
	if( rank < 0 || rank > 6 )
		return;

	for( int i = rank; i >= 0; i-- )
	{
		if( arPriority[i] < 7-rank )
		{
			arPriority[i] = 7-rank;
			this->strResultSound[i] = fname;
		}
	}
}
//
bool DTX::IsCommand( LPTSTR *p, LPCTSTR cmd )
{
	static TCHAR buf[256];
	int len = lstrlen( cmd );
	if( len > 255 ) len = 255;
	TCHAR *q = *p;
	
	int i = 0;
	while( *q != _T(':') && *q != _T('\n') && *q != _T(' ') && *q != _T('\t') && i < len )
		buf[i++] = *q++;
	buf[i] = _T('\0');

	if( i != len || _tcsnicmp( buf, cmd, i ) != 0 )
		return false;

	SKIPSP( q );
	if( *q == _T(':') ) {
		q++;
		SKIPSP( q );
	}
	*p = q;
	return true;
}

int  DTX::GetCommand( LPTSTR *p, LPCTSTR cmd )
{
	static TCHAR buf[256];			// R}h͍ő256
	int len = lstrlen( cmd );
	if( len > 255 ) len = 255;

	TCHAR *q = *p;
	int i;
	for( i = 0; *q != _T(':') && *q != _T('\n') && *q != _T(' ') && *q != _T('\t') && i < len; i++ )	// bufւcmdƓRs[
		buf[i] = *q++;
	buf[i] = _T('\0');

	if( lstrcmpi( buf, cmd ) != 0 ) return 0;

	int zz = GetZex( q );

	if( zz >= 0 )
		while((*q>=_T('0')&&*q<=_T('9'))||(*q>=_T('a')&&*q<=_T('z'))||(*q>=_T('A')&&*q<=_T('Z'))||*q==_T('-')||*q==_T('+')) q++;

	SKIPSP( q );
	if( *q == _T(':') )
	{
		q++;
		SKIPSP( q );
	}
	*p = q;
	return ( zz < 0 ) ? -1 : zz;
}

int  DTX::GetZex( LPCTSTR p )
{
	int num = 0;
	for( int i = 0; i < 2; i++ )
	{
		num *= 36;
		if( *p >= _T('0') && *p <= _T('9') )		num += *p - _T('0');
		else if( *p >= _T('a') && *p <= _T('z') )	num += *p - _T('a') + 10;
		else if( *p >= _T('A') && *p <= _T('Z') )	num += *p - _T('A') + 10;
		else
			return -1;	// 0`9,A`Z ȊO̕gĂ
		p++;
	}
	return num;
}

int  DTX::GetHex( LPCTSTR p )
{
	int num = 0;
	for( int i = 0; i < 2; i++ )
	{
		num *= 16;
		if( *p >= _T('0') && *p <= _T('9') )		num += *p - _T('0');
		else if( *p >= _T('a') && *p <= _T('f') )	num += *p - _T('a') + 10;
		else if( *p >= _T('A') && *p <= _T('F') )	num += *p - _T('A') + 10;
		else 
			return -1;	// 0`9,A`F ȊO̕gĂ
		p++;
	}
	return num;
}

int  DTX::GetDec( LPCTSTR p )
{
	int f = 1;
	if( *p == _T('-') )
	{
		f = -1;
		p++;
	}
	else if( *p == _T('+') )
	{
		f = 1;
		p++;
	}
	int num = 0;
	while( *p >= _T('0') && *p <= _T('9') )
	{
		num = num * 10 + (*p - _T('0'));
		p++;
	}
	return num * f;
}

int  DTX::GetDec3( LPCTSTR p )
{
	int num = 0;
	for( int i = 0; i < 3; i++ )
	{
		num *= 10;
		if( *p >= _T('0') && *p <= _T('9') )				num += *p - _T('0');
		else if( i == 0 && *p >= _T('a') && *p <= _T('z') )	num += *p - _T('a') + 10;
		else if( i == 0 && *p >= _T('A') && *p <= _T('Z') ) num += *p - _T('A') + 10;
		else
			return -1;	// 0`9 ȊO̕gĂ
		p++;
	}
	return num;
}

int  DTX::GetChannel( LPCTSTR p )
{
	// GDA, G2D ȊO16 iQP^
	if( this->scoreType != SCORETYPE_GDA && this->scoreType != SCORETYPE_G2D )
		return GetHex( p );

	// GDA, G2D ͓ꕶ
	#define GDACH	( 5*12+1 )	//̐͂Q--------------------------------
	static const struct ChMap {
		LPCTSTR strCh;
		int nCh;
	} chmap[ GDACH ] = {
		{"TC", 0x03}, {"BL", 0x02}, {"GS", 0x29}, {"DS", 0x30}, {"FI", 0x53},	// 1
		{"HH", 0x11}, {"SD", 0x12}, {"BD", 0x13}, {"HT", 0x14}, {"LT", 0x15},	// 2
		{"CY", 0x16}, {"G1", 0x21}, {"G2", 0x22}, {"G3", 0x23}, {"G4", 0x24},	// 3
		{"G5", 0x25}, {"G6", 0x26}, {"G7", 0x27}, {"GW", 0x28}, {"01", 0x61},	// 4
		{"02", 0x62}, {"03", 0x63}, {"04", 0x64}, {"05", 0x65}, {"06", 0x66},	// 5
		{"07", 0x67}, {"08", 0x68}, {"09", 0x69}, {"0A", 0x70}, {"0B", 0x71},	// 6
		{"0C", 0x72}, {"0D", 0x73}, {"0E", 0x74}, {"0F", 0x75}, {"10", 0x76},	// 7
		{"11", 0x77}, {"12", 0x78}, {"13", 0x79}, {"14", 0x80}, {"15", 0x81},	// 8
		{"16", 0x82}, {"17", 0x83}, {"18", 0x84}, {"19", 0x85}, {"1A", 0x86},	// 9
		{"1B", 0x87}, {"1C", 0x88}, {"1D", 0x89}, {"1E", 0x90}, {"1F", 0x91},	// 10
		{"20", 0x92}, {"B1", 0xA1}, {"B2", 0xA2}, {"B3", 0xA3}, {"B4", 0xA4},	// 11
		{"B5", 0xA5}, {"B6", 0xA6}, {"B7", 0xA7}, {"BW", 0xA8}, {"G0", 0x20},	// 12
		{"B0", 0xA0}															// +1
	};

	if( *p == _T('\0') || *(p+1) == _T('\0') )
		return -1;	// `lԍQP^Ȃ

	TCHAR buf[3];
	buf[0] = *p++;
	buf[1] = *p++;
	buf[2] = _T('\0');
	for( int i = 0; i < GDACH; i++ )
	{
		if( lstrcmpi( chmap[i].strCh, buf ) == 0 )
			return chmap[i].nCh;
	}
	return -1;
}

void DTX::SetSpeed( float fSpeed )
{
	for( Wave *w = this->pWave; w != NULL; w = w->next )
	{
		if( w->bUse )
		{
			for( int i = 0; i < 11; i++ )
			{
				if( w->bUseByLane[ i ] )
				{
					for( int j = 0; j < DTX_MAX_SOUND; j++ )
					{
						if( w->sound[ i ][ j ] != NULL )
							w->sound[ i ][ j ]->SetSpeed( fSpeed );
					}
				}
			}
		}
	}
}

void DTX::CalcHash()
{
	CFileMM file;

	// t@C̓ǂݍ
	if( ! file.Load( this->strFullPath ) )
		return;		// s

	// t@CẽnbVlvZ this->strHash ֊i[
	MD5 md5;
	md5.Init();
	md5.Update( file.GetData(), file.GetSize() );
	md5.Final( this->strHash );

	file.Term();
}

static int s_nChangeRGB[6][8] = {
	{ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07 },		// RGB  RGB
	{ 0x00, 0x02, 0x01, 0x03, 0x04, 0x06, 0x05, 0x07 },		//        RBG
	{ 0x00, 0x01, 0x04, 0x05, 0x02, 0x03, 0x06, 0x07 },		//        GRB
	{ 0x00, 0x02, 0x04, 0x06, 0x01, 0x03, 0x05, 0x07 },		//        GBR
	{ 0x00, 0x04, 0x01, 0x05, 0x02, 0x06, 0x03, 0x07 },		//        BRG
	{ 0x00, 0x04, 0x02, 0x06, 0x01, 0x05, 0x03, 0x07 }		//        BGR
};
void DTX::Random( int nType, bool bSuper )
{
	int nPart    = -10000;	// ߔԍ
	int nPattern = 0;		// ߒPʂ̓ւ@

	int nKp`bv = 0;

	for( Chip* cp = this->pChip; cp != NULL; cp = cp->next )
	{
		// ߂ςւ@ύX
		if( (int)(cp->dwPosition / DTX_RESOLVE) != nPart ) {
			nPart = (int)(cp->dwPosition / DTX_RESOLVE);
			nPattern = rand() % 6;
		}

		// [ւ
		int ch = cp->nChannel;
		if( ( nType == 0 && ch >= 0x20 && ch <= 0x27 ) || ( nType == 1 && ch >= 0xA0 && ch <= 0xA7 ) )
		{
			if( bSuper )
				cp->nChannel = (ch & 0xF0) | ( s_nChangeRGB[ rand() % 6 ][ ch & 0x07 ] );
			else
				cp->nChannel = (ch & 0xF0) | ( s_nChangeRGB[ nPattern   ][ ch & 0x07 ] );

			nKp`bv ++;
		}
	}
}

DWORD DTX::GetChipParamType( int nCh )
{
	switch( nCh )
	{
		// obNR[X
		case 0x01:
			return DTXCPT_WAV;

		// BPMύX
		case 0x03:
			return DTXCPT_BPM;

		// BPMύXigj
		case 0x08:
			return DTXCPT_BPMEX;

		// af`
		case 0x04: case 0x07: case 0x55: case 0x56: case 0x57: case 0x58: case 0x59: case 0x60:
			return DTXCPT_BMP | DTXCPT_BMPTEX | DTXCPT_BGA | DTXCPT_BGAPAN;

		// af`XR[v摜ؑ
		case 0xC4: case 0xC7: case 0xD5: case 0xD6: case 0xD7: case 0xD8: case 0xD9: case 0xE0:
			return DTXCPT_BMP | DTXCPT_BMPTEX;

		// hp[giʏAsA󂤂j
		case 0x11: case 0x12: case 0x13: case 0x14: case 0x15: case 0x16: case 0x17: case 0x18: case 0x19: case 0x1A:
		case 0x31: case 0x32: case 0x33: case 0x34: case 0x35: case 0x36: case 0x37: case 0x38: case 0x39: case 0x3A:
		case 0xB1: case 0xB2: case 0xB3: case 0xB4: case 0xB5: case 0xB6: case 0xB7: case 0xB8: case 0xB9: case 0xBC:
			return DTXCPT_WAV;

		// M^[p[giʏA󂤂j
		case 0x20: case 0x21: case 0x22: case 0x23: case 0x24: case 0x25: case 0x26: case 0x27:
		case 0xBA:
			return DTXCPT_WAV;

		// x[Xp[giʏAłj
		case 0xA0: case 0xA1: case 0xA2: case 0xA3: case 0xA4: case 0xA5: case 0xA6: case 0xA7:
		case 0xBB:
			return DTXCPT_WAV;

		// afl
		case 0x61: case 0x62: case 0x63: case 0x64: case 0x65: case 0x66: case 0x67: case 0x68: case 0x69: case 0x70:
		case 0x71: case 0x72: case 0x73: case 0x74: case 0x75: case 0x76: case 0x77: case 0x78: case 0x79: case 0x80:
		case 0x81: case 0x82: case 0x83: case 0x84: case 0x85: case 0x86: case 0x87: case 0x88: case 0x89: case 0x90:
		case 0x91: case 0x92:
			return DTXCPT_WAV;

		// AVI
		case 0x54:
			return DTXCPT_AVI;

		// 
		case 0x1F: case 0x2F: case 0xAF:
			return DTXCPT_WAV;
	}
	
	return 0;
}

	}//General
}//FDK