#include "stdafx.h"
#include "CSoundStream.h"
#include "FDKError.h"
#include "CFileMM.h"
#include "xadec.h"
#include "vorbis/vorbisfile.h"
#include "COgg.h"

namespace FDK {
	namespace Sound {

CSoundStream::CSoundStream()
{
	this->pDSBuffer = NULL;
}
//
void CSoundStream::Init()
{
	SAFE_RELEASE( this->pDSBuffer );
	this->strFileName.clear();
	this->bŌɏ񂾃obt@ = true;		// 㔼
	this->bĐ = false;
	this->soundType = SOUNDTYPE_UNKNOWN;
	this->l݂̉ = 0;
	this->bLoop = false;
	this->n񃋁[v̖Đ = 0;
	this->fSpeed = 1.0f;
	this->fPitch = 1.0f;
	this->nPause = 0;
	this->dwCurrentPosition = 0;
}
void CSoundStream::Term()
{
	switch( this->soundType )
	{
	case SOUNDTYPE_OGG:
		this->ogg.Term();
		break;
	}
	this->Stop();
	this->file.Term();
	Init();
}
void CSoundStream::Play( bool bLoop )
{
	if( this->pDSBuffer )
	{
		switch( this->soundType )
		{
		case SOUNDTYPE_OGG:
			this->t̃ubNϊăobt@ɃZbg_OGG();
			break;
		}
		this->pDSBuffer->SetVolume( this->l݂̉ );
		this->pDSBuffer->Play( 0, 0, DSBPLAY_LOOPING );
		this->bĐ = true;
		this->bLoop = bLoop;
		this->n񃋁[v̖Đ = 0;
	}
}
void CSoundStream::Stop()
{
	if( this->bĐ && this->pDSBuffer )
	{
		this->pDSBuffer->Stop();
		this->bĐ = false;
	}
}
void CSoundStream::Pause()
{
	// 
}
void CSoundStream::Cont()
{
	// 
}
void CSoundStream::Cont( double dbContTime )
{
	// 
}
void CSoundStream::SetVolume( long lVolume )
{
	if( lVolume == 0 )
		lVolume = 1;		// Vol = 0 ͂Ȃ100%ɂȂĂ܂...

	this->l݂̉ = (long)(( 20.0 * log10( lVolume / 100.0 ) ) * 100.0);

	if( this->bĐ )
		this->pDSBuffer->SetVolume( this->l݂̉ );	// tȂ瑦f
}
void CSoundStream::SetPosition( DWORD dwNewPosition )
{
	// 
}
DWORD CSoundStream::GetPositionFromTime( double dbTime )
{
	// 
	return 0;
}
void CSoundStream::StreamWork()
{
	if( ! this->pDSBuffer || ! this->bĐ ) 
		return;

	DWORD dwtʒu, dw݈ʒu;
	if( FAILED( this->pDSBuffer->GetCurrentPosition( &dwtʒu, &dw݈ʒu ) ) )
		return;

	switch( this->soundType )
	{
	case SOUNDTYPE_OGG:
		if( ( dwtʒu <  this->wfx.nAvgBytesPerSec && ! this->bŌɏ񂾃obt@ )
		 || ( dwtʒu >= this->wfx.nAvgBytesPerSec &&   this->bŌɏ񂾃obt@ ) )
		{
			if( this->ogg.bEOF )
			{
				if( this->bLoop ) {
					this->ogg.RawSeek( 0 );		// ŏ烋[vĐ
					this->ogg.bEOF = false;
					this->t̃ubNϊăobt@ɃZbg_OGG();
				}
				else if( ++ this->n񃋁[v̖Đ >= 2 )		// [vȂƂ́AEOF ɂȂĂQobt@ʉ߂Đ~B
					this->Stop();										// EOF ͂܂tIĂȂA~łȂ߁B
				else
					this->t̃ubNϊăobt@ɃZbg_OGG();
			}
			else
				this->t̃ubNϊăobt@ɃZbg_OGG();
		}
		break;
	}
}
HRESULT	CSoundStream::CreateFromFile( LPDIRECTSOUND8 pDS, LPCTSTR filename )
{
	HRESULT hr = S_OK;
	
	if( ! pDS )
		return FDKERR_DirectSoundNULL;
	
	// t@C̓ǂݍ
	if( ! this->file.Load( filename ) )
	{
		this->file.Term();
		return FDKERR_t@C̓ǂݍݎs;
	}
	
	// t@Cf[^̃TEhobt@쐬
	if( FAILED( hr = CreateFromMemory( pDS, file.GetData(), file.GetSize() ) ) )
	{
		this->file.Term();
		return FDKERR_TEhobt@̍쐬Ɏs;
	}

	this->strFileName = filename;
	return hr;
}
HRESULT	CSoundStream::CreateFromMemory( LPDIRECTSOUND8 pDS, BYTE* pData, DWORD dwSize )
{
	HRESULT hr = S_OK;

	if( ! pData || dwSize == 0 )
		return E_INVALIDARG;

	if( ! pDS )
		return FDKERR_DirectSoundNULL;

	if( this->pDSBuffer )
		Term();	// p  ɏIs

	// TEh̎ʂƃTEhobt@̍쐬
	if( FAILED( hr = this->tTEh̎ʂƃTEhobt@̍쐬_OGG( pDS, pData, dwSize ) ) )
//	if( FAILED( hr = this->tTEh̎ʂƃTEhobt@̍쐬_XA(  pDS, pData, dwSize ) ) )
//	if( FAILED( hr = this->tTEh̎ʂƃTEhobt@̍쐬_WAV( pDS, pData, dwSize ) ) )
//	if( FAILED( hr = this->tTEh̎ʂƃTEhobt@̍쐬_MP3( pDS, pData, dwSize ) ) )
		return FDKERR_TEhobt@̍쐬Ɏs;		// T|[gf[^

	return hr;
}
HRESULT	CSoundStream::tTEh̎ʂƃTEhobt@̍쐬_OGG( LPDIRECTSOUND8 pDS, BYTE* pData, DWORD dwSize )
{
	HRESULT hr = S_OK;

	// `FbN
	if( ! this->ogg.Init( pData, dwSize ) )
		return FDKERR_SoundType;		// Ogg Ȃ

	// WAVEFORMATEX ̎擾
	if( ! this->ogg.GetFormat( &this->wfx ) )
	{
		this->ogg.Term();
		return FDKERR_SoundType;		// 擾s
	}

	// TEhobt@̍쐬
    DSBUFFERDESC dsbd;
    ZeroMemory( &dsbd, sizeof(DSBUFFERDESC) );
	dsbd.dwSize          = sizeof(DSBUFFERDESC);
	dsbd.dwFlags         = DSBCAPS_CTRLVOLUME | DSBCAPS_CTRLPAN | DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS | DSBCAPS_CTRLFREQUENCY;
	dsbd.dwBufferBytes   = this->wfx.nAvgBytesPerSec * 2;		// Qb
	dsbd.guid3DAlgorithm = DS3DALG_DEFAULT;
	dsbd.lpwfxFormat     = &this->wfx;
	if( FAILED( hr = pDS->CreateSoundBuffer( &dsbd, &this->pDSBuffer, NULL ) ) )
		return FDKERR_TEhobt@̍쐬Ɏs;

	this->soundType = SOUNDTYPE_OGG;
	return S_OK;
}
bool	CSoundStream::t̃ubNϊăobt@ɃZbg_OGG()
{
	LPBYTE  pݐ;
	DWORD	dw݃oCg;
	
	if( this->bŌɏ񂾃obt@ )
	{
		// ObN
		if( FAILED( this->pDSBuffer->Lock( 0, this->wfx.nAvgBytesPerSec, (void**)&pݐ, &dw݃oCg, NULL, NULL, 0 ) ) )
			return false;	// bNs
	}
	else
	{
		// 㔼bN
		if( FAILED( this->pDSBuffer->Lock( this->wfx.nAvgBytesPerSec, this->wfx.nAvgBytesPerSec, (void**)&pݐ, &dw݃oCg, NULL, NULL, 0 ) ) )
			return false;	// bNs
	}
	
	this->ogg.ConvertToWav( pݐ, dw݃oCg );
	
	this->pDSBuffer->Unlock( pݐ, dw݃oCg, NULL, 0 );
	this->bŌɏ񂾃obt@ = ! this->bŌɏ񂾃obt@;

	return true;
}
	}//Sound
}//FDK
