
// CSound - TEhNX

#pragma once

namespace FDK {
	namespace Sound {

enum SoundType
{
	SOUNDTYPE_UNKNOWN,
	SOUNDTYPE_WAV,
	SOUNDTYPE_XA,
	SOUNDTYPE_MP3,
	SOUNDTYPE_OGG
};

class CSound
{
public:
	void	Init();														// 
	virtual void	Term();												// I

	void	Play( bool bLoop=false );									// tJn
	void	Stop();														// t~
	void	Pause();													// ꎞ~
	void	Cont();														// ݈ʒuim_dwCurrentPositionj牉tĊJ
	void	Cont( double dbContTime );									// w肵牉tĊJ
	bool	IsPlay();													// ĐȂ true

	void	SetPan( long lPan=0 );										// p|bg̐ݒilPan = -100[]`0[]`100[E]j
	void	SetVolume( long lVolume=100 );								// ʂ̐ݒilVolume = 0`100 [%]j
	void	SetSpeed( float fSpeed=1.0f )	{ this->fSpeed = fSpeed; }	// ĐXs[h̐ݒ
	void	SetPitch( float fPitch=1.0f )	{ this->fPitch = fPitch; }	// sb`ig{j̐ݒ
	DWORD	GetFrequency();												// TEh̎gԂB
	DWORD	SetFrequency( DWORD dwFreq );								// TEh̎gݒ肵AݒO̒lԂB
	double	GetTotalTime();												// t[ms]vZĕԂB
	void	SetPosition( DWORD dwNewPosition );							// wʒu[byte]ֈړB
	DWORD	GetPositionFromTime( double dbTime );						// ʒu擾B

	LPDIRECTSOUNDBUFFER GetDirectSoundBuffer() { return this->pDSBuffer; }
	DWORD				GetDirectSoundBufferSize() { return this->dwDSBufferSize; }

	HRESULT	DuplicateFromSound( LPDIRECTSOUND8 pDS, CSound* srcSound );			// ̐
	HRESULT	CreateFromFile( LPDIRECTSOUND8 pDS, LPCTSTR filename );				// t@CTEh𐶐
	HRESULT	CreateFromMemory( LPDIRECTSOUND8 pDS, BYTE* pData, DWORD dwSize );	// f[^TEh𐶐

public:
	CSound();

public:
	SoundType	m_SoundType;

protected:
	LPDIRECTSOUNDBUFFER	pDSBuffer;
	DWORD				dwDSBufferSize;
	TCHAR				strFileName[_MAX_PATH];
	long				lVolume;
	long				lPan;
	float				fSpeed;
	float				fPitch;
	bool				bLoop;
	int					nPause;
	DWORD				dwCurrentPosition;	// Pause() ̈ʒu

protected:
	// TEhobt@ Lost Ă邩ۂmFALost ĂȂ畜B
	HRESULT	RestoreBuffer( LPDIRECTSOUNDBUFFER pDSB, BOOL* pbWasRestored );

	HRESULT	DecodeFromMP3( LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize );	// MP3 f[^̃fR[h
	HRESULT	DecodeFromXA(  LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize );	// XA f[^̃fR[h
	HRESULT	DecodeFromWAV( LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize );	// WAV f[^̃fR[h
	HRESULT	DecodeFromOgg( LPDIRECTSOUND8 pDS, BYTE* pSrcData, DWORD dwSrcSize );	// Ogg f[^̃fR[h

	// TEhobt@쐬Aփf[^ށB
	HRESULT CreateAndCopyBuffer( LPDIRECTSOUND8 pDS, WAVEFORMATEX* pwfx, BYTE* pData, DWORD dwSize );
};

	}//Sound
}//FDK

using namespace FDK::Sound;
