#include "stdafx.h"
#include "CMIDIOutput.h"

namespace FDK {
	namespace MIDI {

bool CMIDIOutput::Init()
{
	// gpȂIɍs
	if( this->bInit )
		Term();

	// Ԃ̏
	this->bInit = false;
	this->nDevices = 0;
	this->hMidiOut = NULL;

	// foCX̎擾
	if( ( this->nDevices = midiOutGetNumDevs() ) == 0 )
	{
		this->bInit = true;
		return true;	// MIDIo̓foCX͂PołȂ
	}

	// MIDI_MAPPER foCX̃I[v
	MMRESULT mmr;
	if( ( mmr = ::midiOutOpen( &this->hMidiOut, MIDI_MAPPER, (DWORD)NULL, (DWORD)NULL, CALLBACK_NULL ) ) != MMSYSERR_NOERROR )
		return true;	// ftHgMIDIo̓foCX̃I[vɎs

	// foCX̎擾
	MIDIOUTCAPS mocaps;
	::midiOutGetDevCaps( MIDI_MAPPER, &mocaps, sizeof(mocaps) );

	// 
	this->bInit = true;
	return true;
}

void CMIDIOutput::Term()
{
	if (! this->bInit) 
		return;	// ĂȂ

	if( this->hMidiOut )
	{
		::midiOutClose( this->hMidiOut );
		this->hMidiOut = NULL;
	}
	this->bInit = false;
}

void CMIDIOutput::SendMsg( DWORD dwMsg )
{
	if( this->bInit && this->hMidiOut )
		::midiOutShortMsg( this->hMidiOut, dwMsg );
}

void CMIDIOutput::SendMsg( BYTE byState, BYTE byData1, BYTE byData2 )
{
	SendMsg( (DWORD)byState | (((DWORD)byData1) << 8) | ((DWORD)byData2) << 16 );
}

	}//MIDI
}//FDK