#include "stdafx.h"
#include "CAvi.h"
#include "FDKError.h"

namespace FDK {
	namespace Graphics {

int CAvi::nQƐ = 0;

CAvi::CAvi()
{
	this->hFile 		= NULL;
	this->hAvi 			= NULL;
	this->hFrame		= NULL;
	this->hDrawDib		= NULL;
}
CAvi::~CAvi()
{
	_();
}
void	CAvi::_()
{
	this->hFile 		= NULL;
	this->hAvi 			= NULL;
	this->hFrame		= NULL;
	this->hDrawDib		= NULL;
	this->lFrameWidth	= 0;
	this->lFrameHeight	= 0;

	this->bErrorAtDrawFrame = false;

	// ߂Ă̗pȂAVICuB
	if( this->nQƐ++ == 0 )
		::AVIFileInit();
}

void	CAvi::_()
{
	// t@CJꂽ܂܂ȂB
	if( this->hFile )
		this->Close();

	// CAvi 𗘗pCX^XȂȂAVICuIB
	if( --this->nQƐ == 0 )
		::AVIFileExit();
}

HRESULT CAvi::Open( LPCTSTR fname )
{
	HRESULT hr;

	// t@CJꂽ܂܂ȂB
	if( this->hFile )
		this->Close();

	// AVIt@Cǂݎ胂[hŃI[vB
	if(( hr = ::AVIFileOpen( &this->hFile, fname, OF_READ, NULL ) ) != 0 )			//  S_OK ł͂Ȃ 0 ԂBȉB
		return hr;

	// 摜Xg[擾B
	if( (hr = ::AVIFileGetStream( this->hFile, &this->hAvi, streamtypeVIDEO, 0 )) != 0 )
	{
		::AVIFileRelease( this->hFile );
		this->hFile = NULL;
		return hr;
	}

	// 擾B
	AVISTREAMINFO Info;
	if( (hr = ::AVIStreamInfo( this->hAvi, &Info, sizeof(Info) )) != 0 )
	{
		::AVIStreamRelease( this->hAvi );
		::AVIFileRelease( this->hFile );
		this->hAvi = NULL;
		this->hFile = NULL;
		return FDKERR_̎擾Ɏs;
	}
	this->dw[g			= Info.dwRate;
	this->dwXP[		= Info.dwScale;
	this->dwt[	= ::AVIStreamLength( this->hAvi );
	this->lFrameWidth		= Info.rcFrame.right  - Info.rcFrame.left;
	this->lFrameHeight		= Info.rcFrame.bottom - Info.rcFrame.top;

	// t[̃I[v
	if( ( this->hFrame = ::AVIStreamGetFrameOpen( this->hAvi, NULL ) ) == NULL )
	//if( ( m_hFrame = ::AVIStreamGetFrameOpen( m_hAvi, (LPBITMAPINFOHEADER) AVIGETFRAMEF_BESTDISPLAYFMT ) ) == NULL )		// ƏdȂcRADEON9800łc
	{
		::AVIStreamRelease( this->hAvi );
		::AVIFileRelease( this->hFile );
		this->hAvi = NULL;
		this->hFile = NULL;
		return FDKERR_t[̃I[vɎs;
	}

	// DrawDib ̃I[v
	if( (this->hDrawDib = ::DrawDibOpen()) == NULL )
	{
		::AVIStreamGetFrameClose( this->hFrame );
		::AVIStreamRelease( this->hAvi );
		::AVIFileRelease( this->hFile );
		this->hAvi = NULL;
		this->hFile = NULL;
		return FDKERR_DRAWDIB̃I[vɎs;
	}

	return S_OK;
}

void	CAvi::Close()
{
	if( this->hDrawDib )
	{
		::DrawDibEnd( this->hDrawDib );
		::DrawDibClose( this->hDrawDib );
		this->hDrawDib = NULL;
	}
	
	if( this->hFrame )
	{
		::AVIStreamGetFrameClose( this->hFrame );
		this->hFrame = NULL;
	}

	if( this->hAvi )
	{
		::AVIStreamRelease( this->hAvi ); 
		this->hAvi = NULL;
	}

	if( this->hFile )
	{
		::AVIFileRelease( this->hFile );
		this->hFile = NULL;
	}
}

DWORD	CAvi::_t[ԍԂ( double time )
{
	if( !this->hAvi || !this->dwt[ || !this->dw[g || !this->dwXP[ )
		return 0;	// ĂȂ

	// t[̌vZ
	return (DWORD)(time * ((double)(this->dw[g) / (1000.0 * this->dwXP[)));
}

void	CAvi::_t[TCY擾( LONG* plWidth, LONG* plHeight )
{
	if( plWidth  ) *plWidth  = this->lFrameWidth;
	if( plHeight ) *plHeight = this->lFrameHeight;
}

int		CAvi::_w莞̃t[DC֕`悷( HWND hWnd, HDC hDC, double time, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh )
{
	// G[ς݂Ȃ牽ȂŏI
	if( this->bErrorAtDrawFrame )
		return CAVI_ĐI;
	
	// ĂȂ΃G[I
	if( !this->hAvi || !this->dwt[ || !this->dw[g || !this->dwXP[ )
	{
		this->bErrorAtDrawFrame = true;
		return CAVI_G[I;
	}

	// w莞A\ׂt[ԍvZ
	DWORD FrameNo = _t[ԍԂ( time );
	if( this->dwt[ <= FrameNo )
		return CAVI_ĐI;

	// t[̎擾
	BITMAPINFOHEADER *pBmpInfo;		// DIBwb_
	BYTE* pBmpData;					// DIBf[^
	if(( pBmpInfo = (BITMAPINFOHEADER*) ::AVIStreamGetFrame( this->hFrame, FrameNo ) ) == NULL )
	{
		// t[摜̎擾Ɏs
		this->bErrorAtDrawFrame = true;
		return CAVI_G[I;
	}

	// AVIStreamGetFrame ŕԂ BITMAPINFOHEADER ɂ biCompression==BI_BITFIELDS  biColors[] ĂȂ߁A
	// eRs[Ď biColors[] ǉKvB
	struct PACKDIB {
		BITMAPINFOHEADER	header;
		DWORD				r, g, b;
	} static pd;
	pBmpData = (LPBYTE)pBmpInfo + (WORD)(pBmpInfo->biSize);
	::CopyMemory( &(pd.header), pBmpInfo, sizeof(BITMAPINFOHEADER) );
	if( pd.header.biCompression == BI_BITFIELDS )
	{
		if( pd.header.biBitCount == 16 )
		{
			pd.r = 0xf800;	// 5
			pd.g = 0x07e0;	// 6
			pd.b = 0x001f;	// 5
		}
		else
		{
			pd.r = 0xff0000;	// 8
			pd.g = 0x00ff00;	// 8
			pd.b = 0x0000ff;	// 8
		}
	}
	pBmpInfo = &(pd.header);

	// kĂȂWJ
	if( pBmpInfo->biCompression != BI_RGB && pBmpInfo->biCompression != BI_BITFIELDS )
	{
		this->hDrawDib = DrawDibOpen();
		HDC hdc = ::GetDC( hWnd );
		if( ! ::DrawDibDraw( this->hDrawDib, hdc, dx, dy, dw, dh, pBmpInfo, pBmpData, sx, sy, sw, sh, DDF_DONTDRAW ) )	// WĴ݁E`Ȃ
		{
			// kDIB̓WJɎs
			this->bErrorAtDrawFrame = true;
			return CAVI_G[I;
		}
		pBmpData = (LPBYTE) ::DrawDibGetBuffer( this->hDrawDib, pBmpInfo, sizeof(BITMAPINFOHEADER), 0 );
		::ReleaseDC( hWnd, hdc );
	}

	// `
	::DrawDibDraw( this->hDrawDib, hDC, dx, dy, dw, dh, pBmpInfo, pBmpData, sx, sy, sw, sh, 0 );

/*
	if( StretchDIBits( hDC, dx, dy, dw, dh, sx, sy, sw, sh, pBmpData, (BITMAPINFO*)(pBmpInfo), DIB_RGB_COLORS, SRCCOPY ) == GDI_ERROR )
	{
		m_bErrorAtDrawFrame = true;
		if( m_hDrawDib ) {
			DrawDibEnd( m_hDrawDib );
			DrawDibClose( m_hDrawDib );
		}
		return false;
	}
*/
	return 0;
}

	}//Graphics
}//FDK
