﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Drawing;
using FDK;
using SlimDX;

namespace DTXMania
{
	internal class CActConfigKeyAssign : CActivity
	{
		public bool bキー入力待ちの最中である
		{
			get
			{
				return this.bキー入力待ち;
			}
		}

		public void t開始(EPad pad, string strパッド名)
		{
			this.pad = pad;
			this.strパッド名 = strパッド名;
			for (int i = 0; i < CConfigXml.AssignableCodes - 2; i++)
			{
				this.structReset用KeyAssign[i].InputDevice = CDTXMania.Instance.ConfigIni.KeyAssign[pad][i].入力デバイス;
				this.structReset用KeyAssign[i].ID = CDTXMania.Instance.ConfigIni.KeyAssign[pad][i].ID;
				this.structReset用KeyAssign[i].Code = CDTXMania.Instance.ConfigIni.KeyAssign[pad][i].コード;
			}
		}

		public void tEnter押下()
		{
			if (!this.bキー入力待ち)
			{
				CDTXMania.Instance.Skin.sound決定音.t再生する();
				if (ptr == CConfigXml.AssignableCodes - 2)
				{
					for (int i = 0; i < CConfigXml.AssignableCodes - 2; i++)
					{
						CDTXMania.Instance.ConfigIni.KeyAssign[pad][i].CopyFrom(this.structReset用KeyAssign[i]);
					}
					return;
				}
				else if (ptr == CConfigXml.AssignableCodes - 1)
				{

					CDTXMania.Instance.stageコンフィグ.tアサイン完了通知();
					return;
				}
				this.bキー入力待ち = true;
			}
		}

		public void OnNext()
		{
			if (!this.bキー入力待ち)
			{
				CDTXMania.Instance.Skin.soundカーソル移動音.t再生する();
				ptr++;
				ptr %= CConfigXml.AssignableCodes;
			}
		}

		public void OnPrevious()
		{
			if (!this.bキー入力待ち)
			{
				CDTXMania.Instance.Skin.soundカーソル移動音.t再生する();
				--ptr;
				ptr += CConfigXml.AssignableCodes;
				ptr %= CConfigXml.AssignableCodes;
			}
		}

		public override void On活性化()
		{
			if (base.b活性化してない)
			{
				this.pad = EPad.Unknown;
				this.strパッド名 = "";
				this.ptr = 0;
				this.bキー入力待ち = false;
				this.structReset用KeyAssign = new CKeyAssign[CConfigXml.AssignableCodes - 2];
				for (int i = 0; i < this.structReset用KeyAssign.Length; ++i)
				{
					structReset用KeyAssign[i] = new CKeyAssign(EInputDevice.Unknown, 0, 0);
				}

				base.On活性化();
			}
		}

		public override void On非活性化()
		{
			if (base.b活性化してる)
			{
				TextureFactory.tテクスチャの解放(ref this.txカーソル);
				TextureFactory.tテクスチャの解放(ref this.txHitKeyダイアログ);
				base.On非活性化();
			}
		}

		public override void OnManagedリソースの作成()
		{
			if (base.b活性化してる)
			{
				this.prvFont = new CPrivateFastFont(CSkin.Path(@"Graphics\fonts\mplus-1p-heavy.ttf"), (int)(18 * Scale.Y)); // t項目リストの設定 の前に必要
				this.txカーソル = TextureFactory.tテクスチャの生成(CSkin.Path(@"Graphics\ScreenConfig menu cursor.png"), false);
				this.txHitKeyダイアログ = TextureFactory.tテクスチャの生成(CSkin.Path(@"Graphics\ScreenConfig hit key to assign dialog.png"), false);
				base.OnManagedリソースの作成();
			}
		}

		public override void OnManagedリソースの解放()
		{
			if (base.b活性化してる)
			{
				TextureFactory.t安全にDisposeする(ref prvFont);
			}
		}

		public override int On進行描画()
		{
			if (base.b活性化してる)
			{
				if (this.bキー入力待ち)
				{
					if (CDTXMania.Instance.Input管理.Keyboard.bキーが押された((int)SlimDX.DirectInput.Key.Escape))
					{
						CDTXMania.Instance.Skin.sound取消音.t再生する();
						this.bキー入力待ち = false;
						CDTXMania.Instance.Input管理.tポーリング(CDTXMania.Instance.bApplicationActive, false);
					}
					else if ((this.tキーチェックとアサイン_Keyboard() || this.tキーチェックとアサイン_MidiIn()) || (this.tキーチェックとアサイン_Joypad() || this.tキーチェックとアサイン_Mouse()))
					{
						this.bキー入力待ち = false;
						CDTXMania.Instance.Input管理.tポーリング(CDTXMania.Instance.bApplicationActive, false);
					}
				}
				else if (CDTXMania.Instance.Input管理.Keyboard.bキーが押された((int)SlimDX.DirectInput.Key.Delete))
				{
					CDTXMania.Instance.Skin.sound決定音.t再生する();
					CDTXMania.Instance.ConfigIni.KeyAssign[this.pad][ptr].Reset();
				}

				if (this.txカーソル != null)
				{
					int num = 20;
					int num2 = 0x144;
					int num3 = 0x3e + (num * (ptr + 1));
					this.txカーソル.vc拡大縮小倍率 = new Vector3(1f, 0.75f, 1f);
					this.txカーソル.t2D描画(CDTXMania.Instance.Device, num2 * Scale.X, num3 * Scale.Y - 6, new Rectangle(0, 0, (int)(0x10 * Scale.X), (int)(0x20 * Scale.Y)));
					num2 += 0x10;
					Rectangle rectangle = new Rectangle((int)(8 * Scale.X), 0, (int)(0x10 * Scale.X), (int)(0x20 * Scale.Y));
					for (int j = 0; j < 14; j++)
					{
						this.txカーソル.t2D描画(CDTXMania.Instance.Device, num2 * Scale.X, num3 * Scale.Y - 6, rectangle);
						num2 += 0x10;
					}
					this.txカーソル.t2D描画(CDTXMania.Instance.Device, num2 * Scale.X, num3 * Scale.Y - 6, new Rectangle((int)(0x10 * Scale.X), 0, (int)(0x10 * Scale.X), (int)(0x20 * Scale.Y)));
				}

				int num5 = 20;
				int x = 0x134;
				int y = 0x40;
				using (Bitmap bmpStr = prvFont.DrawPrivateFont(this.strパッド名, Color.White, Color.Black))
				{
					CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr);
					txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
					txStr.t2D描画(CDTXMania.Instance.Device, x * Scale.X, y * Scale.Y - 20);
					TextureFactory.tテクスチャの解放(ref txStr);
				}

				y += num5;
				string strParam;
				bool b強調;
				for (int i = 0; i < CConfigXml.AssignableCodes - 2; i++)
				{
					COptionKeyAssign stkeyassignArray = CDTXMania.Instance.ConfigIni.KeyAssign[this.pad][i];
					switch (stkeyassignArray.入力デバイス)
					{
						case EInputDevice.Keyboard:
							this.tアサインコードの描画_Keyboard(i + 1, x + 20, y, stkeyassignArray.ID, stkeyassignArray.コード, ptr == i);
							break;

						case EInputDevice.MIDIIn:
							this.tアサインコードの描画_MidiIn(i + 1, x + 20, y, stkeyassignArray.ID, stkeyassignArray.コード, ptr == i);
							break;

						case EInputDevice.JoyPad:
							this.tアサインコードの描画_Joypad(i + 1, x + 20, y, stkeyassignArray.ID, stkeyassignArray.コード, ptr == i);
							break;

						case EInputDevice.Mouse:
							this.tアサインコードの描画_Mouse(i + 1, x + 20, y, stkeyassignArray.ID, stkeyassignArray.コード, ptr == i);
							break;

						default:
							strParam = string.Format("{0,2}.", i + 1);
							b強調 = (ptr == i);
							using (Bitmap bmpStr = b強調 ?
									prvFont.DrawPrivateFont(strParam, Color.White, Color.Black, Color.Yellow, Color.OrangeRed) :
									prvFont.DrawPrivateFont(strParam, Color.White, Color.Black))
							{
								CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr, false);
								txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
								txStr.t2D描画(CDTXMania.Instance.Device, (x + 20) * Scale.X, y * Scale.Y - 20);
								TextureFactory.tテクスチャの解放(ref txStr);
							}
							break;
					}
					y += num5;
				}

				strParam = "Reset All Assign";
				b強調 = (ptr == CConfigXml.AssignableCodes - 2);
				using (Bitmap bmpStr = b強調 ?
						prvFont.DrawPrivateFont(strParam, Color.White, Color.Black, Color.Yellow, Color.OrangeRed) :
						prvFont.DrawPrivateFont(strParam, Color.White, Color.Black))
				{
					CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr, false);
					txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
					txStr.t2D描画(CDTXMania.Instance.Device, (x + 20) * Scale.X, y * Scale.Y - 20);
					TextureFactory.tテクスチャの解放(ref txStr);
				}

				y += num5;
				strParam = "<< Returnto List";
				b強調 = (ptr == CConfigXml.AssignableCodes - 1);
				using (Bitmap bmpStr = b強調 ?
						prvFont.DrawPrivateFont(strParam, Color.White, Color.Black, Color.Yellow, Color.OrangeRed) :
						prvFont.DrawPrivateFont(strParam, Color.White, Color.Black))
				{
					CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr, false);
					txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
					txStr.t2D描画(CDTXMania.Instance.Device, (x + 20) * Scale.X, y * Scale.Y - 20);
					TextureFactory.tテクスチャの解放(ref txStr);
				}

				if (this.bキー入力待ち && (this.txHitKeyダイアログ != null))
				{
					this.txHitKeyダイアログ.t2D描画(CDTXMania.Instance.Device, 0x185 * Scale.X, 0xd7 * Scale.Y);
				}
			}
			return 0;
		}


		// その他
		[StructLayout(LayoutKind.Sequential)]
		private struct STKEYLABEL
		{
			public int nCode;
			public string strLabel;
			public STKEYLABEL(int nCode, string strLabel)
			{
				this.nCode = nCode;
				this.strLabel = strLabel;
			}
		}

		private bool bキー入力待ち;
		private STKEYLABEL[] KeyLabel = new STKEYLABEL[] {
			new STKEYLABEL(0x35, "[ESC]"), new STKEYLABEL(1, "[ 1 ]"), new STKEYLABEL(2, "[ 2 ]"), new STKEYLABEL(3, "[ 3 ]"), new STKEYLABEL(4, "[ 4 ]"), new STKEYLABEL(5, "[ 5 ]"), new STKEYLABEL(6, "[ 6 ]"), new STKEYLABEL(7, "[ 7 ]"), new STKEYLABEL(8, "[ 8 ]"), new STKEYLABEL(9, "[ 9 ]"), new STKEYLABEL(0, "[ 0 ]"), new STKEYLABEL(0x53, "[ - ]"), new STKEYLABEL(0x34, "[ = ]"), new STKEYLABEL(0x2a, "[BSC]"), new STKEYLABEL(0x81, "[TAB]"), new STKEYLABEL(0x1a, "[ Q ]"),
			new STKEYLABEL(0x20, "[ W ]"), new STKEYLABEL(14, "[ E ]"), new STKEYLABEL(0x1b, "[ R ]"), new STKEYLABEL(0x1d, "[ T ]"), new STKEYLABEL(0x22, "[ Y ]"), new STKEYLABEL(30, "[ U ]"), new STKEYLABEL(0x12, "[ I ]"), new STKEYLABEL(0x18, "[ O ]"), new STKEYLABEL(0x19, "[ P ]"), new STKEYLABEL(0x4a, "[ [ ]"), new STKEYLABEL(0x73, "[ ] ]"), new STKEYLABEL(0x75, "[Enter]"), new STKEYLABEL(0x4b, "[L-Ctrl]"), new STKEYLABEL(10, "[ A ]"), new STKEYLABEL(0x1c, "[ S ]"), new STKEYLABEL(13, "[ D ]"),
			new STKEYLABEL(15, "[ F ]"), new STKEYLABEL(0x10, "[ G ]"), new STKEYLABEL(0x11, "[ H ]"), new STKEYLABEL(0x13, "[ J ]"), new STKEYLABEL(20, "[ K ]"), new STKEYLABEL(0x15, "[ L ]"), new STKEYLABEL(0x7b, "[ ; ]"), new STKEYLABEL(0x26, "[ ' ]"), new STKEYLABEL(0x45, "[ ` ]"), new STKEYLABEL(0x4e, "[L-Shift]"), new STKEYLABEL(0x2b, @"[ \]"), new STKEYLABEL(0x23, "[ Z ]"), new STKEYLABEL(0x21, "[ X ]"), new STKEYLABEL(12, "[ C ]"), new STKEYLABEL(0x1f, "[ V ]"), new STKEYLABEL(11, "[ B ]"),
			new STKEYLABEL(0x17, "[ N ]"), new STKEYLABEL(0x16, "[ M ]"), new STKEYLABEL(0x2f, "[ , ]"), new STKEYLABEL(0x6f, "[ . ]"), new STKEYLABEL(0x7c, "[ / ]"), new STKEYLABEL(120, "[R-Shift]"), new STKEYLABEL(0x6a, "[ * ]"), new STKEYLABEL(0x4d, "[L-Alt]"), new STKEYLABEL(0x7e, "[Space]"), new STKEYLABEL(0x2d, "[CAPS]"), new STKEYLABEL(0x36, "[F1]"), new STKEYLABEL(0x37, "[F2]"), new STKEYLABEL(0x38, "[F3]"), new STKEYLABEL(0x39, "[F4]"), new STKEYLABEL(0x3a, "[F5]"), new STKEYLABEL(0x3b, "[F6]"),
			new STKEYLABEL(60, "[F7]"), new STKEYLABEL(0x3d, "[F8]"), new STKEYLABEL(0x3e, "[F9]"), new STKEYLABEL(0x3f, "[F10]"), new STKEYLABEL(0x58, "[NumLock]"), new STKEYLABEL(0x7a, "[Scroll]"), new STKEYLABEL(0x60, "[NPad7]"), new STKEYLABEL(0x61, "[NPad8]"), new STKEYLABEL(0x62, "[NPad9]"), new STKEYLABEL(0x66, "[NPad-]"), new STKEYLABEL(0x5d, "[NPad4]"), new STKEYLABEL(0x5e, "[NPad5]"), new STKEYLABEL(0x5f, "[NPad6]"), new STKEYLABEL(0x68, "[NPad+]"), new STKEYLABEL(90, "[NPad1]"), new STKEYLABEL(0x5b, "[NPad2]"),
			new STKEYLABEL(0x5c, "[NPad3]"), new STKEYLABEL(0x59, "[NPad0]"), new STKEYLABEL(0x67, "[NPad.]"), new STKEYLABEL(0x40, "[F11]"), new STKEYLABEL(0x41, "[F12]"), new STKEYLABEL(0x42, "[F13]"), new STKEYLABEL(0x43, "[F14]"), new STKEYLABEL(0x44, "[F15]"), new STKEYLABEL(0x48, "[Kana]"), new STKEYLABEL(0x24, "[ ? ]"), new STKEYLABEL(0x30, "[Henkan]"), new STKEYLABEL(0x57, "[MuHenkan]"), new STKEYLABEL(0x8f, @"[ \ ]"), new STKEYLABEL(0x25, "[NPad.]"), new STKEYLABEL(0x65, "[NPad=]"), new STKEYLABEL(0x72, "[ ^ ]"),
			new STKEYLABEL(40, "[ @ ]"), new STKEYLABEL(0x2e, "[ : ]"), new STKEYLABEL(130, "[ _ ]"), new STKEYLABEL(0x49, "[Kanji]"), new STKEYLABEL(0x7f, "[Stop]"), new STKEYLABEL(0x29, "[AX]"), new STKEYLABEL(100, "[NPEnter]"), new STKEYLABEL(0x74, "[R-Ctrl]"), new STKEYLABEL(0x54, "[Mute]"), new STKEYLABEL(0x2c, "[Calc]"), new STKEYLABEL(0x70, "[PlayPause]"), new STKEYLABEL(0x52, "[MediaStop]"), new STKEYLABEL(0x85, "[Volume-]"), new STKEYLABEL(0x86, "[Volume+]"), new STKEYLABEL(0x8b, "[WebHome]"), new STKEYLABEL(0x63, "[NPad,]"),
			new STKEYLABEL(0x69, "[ / ]"), new STKEYLABEL(0x80, "[PrtScn]"), new STKEYLABEL(0x77, "[R-Alt]"), new STKEYLABEL(110, "[Pause]"), new STKEYLABEL(70, "[Home]"), new STKEYLABEL(0x84, "[Up]"), new STKEYLABEL(0x6d, "[PageUp]"), new STKEYLABEL(0x4c, "[Left]"), new STKEYLABEL(0x76, "[Right]"), new STKEYLABEL(0x33, "[End]"), new STKEYLABEL(50, "[Down]"), new STKEYLABEL(0x6c, "[PageDown]"), new STKEYLABEL(0x47, "[Insert]"), new STKEYLABEL(0x31, "[Delete]"), new STKEYLABEL(0x4f, "[L-Win]"), new STKEYLABEL(0x79, "[R-Win]"),
			new STKEYLABEL(0x27, "[APP]"), new STKEYLABEL(0x71, "[Power]"), new STKEYLABEL(0x7d, "[Sleep]"), new STKEYLABEL(0x87, "[Wake]")
		};

		private EPad pad;
		int ptr;
		private CKeyAssign[] structReset用KeyAssign;
		private string strパッド名;
		private CTexture txHitKeyダイアログ;
		private CTexture txカーソル;
		private CPrivateFastFont prvFont;

		private void tアサインコードの描画_Joypad(int line, int x, int y, int nID, int nCode, bool b強調)
		{
			string str = "";
			switch (nCode)
			{
				case 0:
					str = "Left";
					break;

				case 1:
					str = "Right";
					break;

				case 2:
					str = "Up";
					break;

				case 3:
					str = "Down";
					break;

				case 4:
					str = "Forward";
					break;

				case 5:
					str = "Back";
					break;

				default:
					if ((6 <= nCode) && (nCode < 6 + 128))              // other buttons (128 types)
					{
						str = string.Format("Button{0}", nCode - 5);
					}
					else if ((6 + 128 <= nCode) && (nCode < 6 + 128 + 8))       // POV HAT ( 8 types; 45 degrees per HATs)
					{
						str = string.Format("POV {0}", (nCode - 6 - 128) * 45);
					}
					else
					{
						str = string.Format("Code{0}", nCode);
					}
					break;
			}
			using (Bitmap bmpStr = b強調 ?
					prvFont.DrawPrivateFont(str, Color.White, Color.Black, Color.Yellow, Color.OrangeRed) :
					prvFont.DrawPrivateFont(str, Color.White, Color.Black))
			{
				CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr, false);
				txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
				txStr.t2D描画(CDTXMania.Instance.Device, x * Scale.X, y * Scale.Y - 20);
				TextureFactory.tテクスチャの解放(ref txStr);
			}
		}

		private void tアサインコードの描画_Keyboard(int line, int x, int y, int nID, int nCode, bool b強調)
		{
			string str = null;
			foreach (STKEYLABEL stkeylabel in this.KeyLabel)
			{
				if (stkeylabel.nCode == nCode)
				{
					str = string.Format("{0,2}. Key {1}", line, stkeylabel.strLabel);
					break;
				}
			}
			if (str == null)
			{
				str = string.Format("{0,2}. Key 0x{1:X2}", line, nCode);
			}

			using (Bitmap bmpStr = b強調 ?
					prvFont.DrawPrivateFont(str, Color.White, Color.Black, Color.Yellow, Color.OrangeRed) :
					prvFont.DrawPrivateFont(str, Color.White, Color.Black))
			{
				CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr, false);
				txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
				txStr.t2D描画(CDTXMania.Instance.Device, x * Scale.X, y * Scale.Y - 20);
				TextureFactory.tテクスチャの解放(ref txStr);
			}
		}

		private void tアサインコードの描画_MidiIn(int line, int x, int y, int nID, int nCode, bool b強調)
		{
			string str = string.Format("{0,2}. MidiIn #{1} code.{2}", line, nID, nCode);
			using (Bitmap bmpStr = b強調 ?
					prvFont.DrawPrivateFont(str, Color.White, Color.Black, Color.Yellow, Color.OrangeRed) :
					prvFont.DrawPrivateFont(str, Color.White, Color.Black))
			{
				CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr, false);
				txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
				txStr.t2D描画(CDTXMania.Instance.Device, x * Scale.X, y * Scale.Y - 20);
				TextureFactory.tテクスチャの解放(ref txStr);
			}
		}

		private void tアサインコードの描画_Mouse(int line, int x, int y, int nID, int nCode, bool b強調)
		{
			string str = string.Format("{0,2}. Mouse Button{1}", line, nCode);
			using (Bitmap bmpStr = b強調 ?
					prvFont.DrawPrivateFont(str, Color.White, Color.Black, Color.Yellow, Color.OrangeRed) :
					prvFont.DrawPrivateFont(str, Color.White, Color.Black))
			{
				CTexture txStr = TextureFactory.tテクスチャの生成(bmpStr, false);
				txStr.vc拡大縮小倍率 = new Vector3(0.75f, 0.75f, 1f);
				txStr.t2D描画(CDTXMania.Instance.Device, x * Scale.X, y * Scale.Y - 20);
				TextureFactory.tテクスチャの解放(ref txStr);
			}
		}

		private bool tキーチェックとアサイン_Joypad()
		{
			foreach (IInputDevice device in CDTXMania.Instance.Input管理.list入力デバイス)
			{
				if (device.e入力デバイス種別 == E入力デバイス種別.Joystick)
				{
					for (int i = 0; i < 6 + 0x80 + 8; i++)      // +6 for Axis, +8 for HAT
					{
						if (device.bキーが押された(i))
						{
							CDTXMania.Instance.Skin.sound決定音.t再生する();
							CDTXMania.Instance.ConfigIni.t指定した入力が既にアサイン済みである場合はそれを全削除する(EInputDevice.JoyPad, device.ID, i);
							CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].入力デバイス = EInputDevice.JoyPad;
							CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].ID = device.ID;
							CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].コード = i;
							return true;
						}
					}
				}
			}
			return false;
		}

		private bool tキーチェックとアサイン_Keyboard()
		{
			for (int i = 0; i < 0x100; i++)
			{
				if (i != (int)SlimDX.DirectInput.Key.Escape &&
					i != (int)SlimDX.DirectInput.Key.UpArrow &&
					i != (int)SlimDX.DirectInput.Key.DownArrow &&
					i != (int)SlimDX.DirectInput.Key.LeftArrow &&
					i != (int)SlimDX.DirectInput.Key.RightArrow &&
					i != (int)SlimDX.DirectInput.Key.Delete &&
					 CDTXMania.Instance.Input管理.Keyboard.bキーが押された(i))
				{
					CDTXMania.Instance.Skin.sound決定音.t再生する();
					CDTXMania.Instance.ConfigIni.t指定した入力が既にアサイン済みである場合はそれを全削除する(EInputDevice.Keyboard, 0, i);
					CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].入力デバイス = EInputDevice.Keyboard;
					CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].ID = 0;
					CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].コード = i;
					return true;
				}
			}
			return false;
		}

		private bool tキーチェックとアサイン_MidiIn()
		{
			foreach (IInputDevice device in CDTXMania.Instance.Input管理.list入力デバイス)
			{
				if (device.e入力デバイス種別 == E入力デバイス種別.MidiIn)
				{
					for (int i = 0; i < 0x100; i++)
					{
						if (device.bキーが押された(i))
						{
							CDTXMania.Instance.Skin.sound決定音.t再生する();
							CDTXMania.Instance.ConfigIni.t指定した入力が既にアサイン済みである場合はそれを全削除する(EInputDevice.MIDIIn, device.ID, i);
							CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].入力デバイス = EInputDevice.MIDIIn;
							CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].ID = device.ID;
							CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].コード = i;
							return true;
						}
					}
				}
			}
			return false;
		}

		private bool tキーチェックとアサイン_Mouse()
		{
			for (int i = 0; i < 8; i++)
			{
				if (CDTXMania.Instance.Input管理.Mouse.bキーが押された(i))
				{
					CDTXMania.Instance.ConfigIni.t指定した入力が既にアサイン済みである場合はそれを全削除する(EInputDevice.Mouse, 0, i);
					CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].入力デバイス = EInputDevice.Mouse;
					CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].ID = 0;
					CDTXMania.Instance.ConfigIni.KeyAssign[pad][ptr].コード = i;
				}
			}
			return false;
		}
	}
}
