package jp.co.dolinc.composer;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Intbox;
import org.zkoss.zul.Textbox;

public class Main0302Composer extends SelectorComposer<Component> {

	@Wire
	Textbox in01;	//<textbox id="searchBox"
	@Wire
	Intbox in02;
	@Wire
	Intbox in03;
	@Wire
	Decimalbox in04;

	/**
	 * 初期化処理
	 * Composer Implementation
	 */
	public void doAfterCompose(Component comp) throws Exception {
		super.doAfterCompose(comp);

		//初期値
		in01.setValue("入力してください");
		in02.setValue(100);
		in03.setValue(3);
		in04.setValue("1300");

	}

	@Listen("onBlur = #in01")
	public void inoutBlur01(Event event){
		System.out.println("onBlur01");
//		Events.postEvent("onFocus", in03, null);

		in01.setDisabled(true);
		in04.focus();	//フォーカス移動
	}
	@Listen("onBlur = #in02")
	public void inoutBlur02(Event event){
		System.out.println("onBlur02");


	}
//	@Listen("onBlur = #in01, #in02, #in03, #in04 ")
//	public void inoutBlur(){
//		System.out.println("onBlur");
//
//	}
	@Listen("onFocus = #in01, #in02, #in03, #in04 ")
	public void inoutFocus(Event event){
		System.out.println("onFocus:" + event.getTarget().getId());

	}
	@Listen("onChanging = #in01, #in02, #in03, #in04 ")
	public void inoutChanging(Event event){
		System.out.println("onChanging:"  + event.getTarget().getId());

	}



	/**
	 *デフォルトID
	 */
	private static final long serialVersionUID = 1L;
}
