/*
 * JHPdf Free PDF Library : HPdfBase14FontDefData.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.pdfobject.HPdfFont;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfCharData;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;
import net.sf.jhpdf.pdfobject.HPdfXref;

/**
 * Class for load PDF Base 14 fonts data.<br>
 * this class is package private.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
final class HPdfBase14FontDefData {

    private static final Logger logger = LoggerFactory.getLogger(HPdfBase14FontDefData.class);

    // MEMO sorry, all fields are bare package private...
    String fontName;
    HPdfCharData[] widthsTable;
    boolean isFontSpecific;
    int ascent;
    int descent;
    int xHeight;
    int capHeight;
    HPdfRect bBox;
    
    HPdfBase14FontDefData() {
        super();
    }
    
    private final static Map<String, HPdfBase14FontDefData> HPDF_BUILTIN_FONTS = 
            new HashMap<String, HPdfBase14FontDefData>();
    
    private static void loadBuiltinData() {
        logger.trace("HPdfBase14FontDefData.loadBuiltinData");
        // TODO only stub
        // load builtin basefont data from resources.
    }
    
    static HPdfBase14FontDefData findBuiltinData(String fontName) {
        if (HPDF_BUILTIN_FONTS.size() == 0) {
            loadBuiltinData();
        }
        return HPDF_BUILTIN_FONTS.get(fontName);
    }
    
    
}
