/*
 * JHPdf Free PDF Library : HPdfFreeTextAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfString;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.pdfobject.annotation.HPdfLineAnnotation.HPdfLineAnnotEndingStyle;
import net.sf.jhpdf.graphics.HPdfPoint;
import net.sf.jhpdf.graphics.HPdfRect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF FreeText Annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfFreeTextAnnotation extends HPdfMarkupAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfFreeTextAnnotation.class);
    
    public HPdfFreeTextAnnotation(HPdfXref xref, HPdfRect rect, String text, HPdfEncoder encoder) {
        super(xref, rect, text, encoder);
        
        logger.trace("HPdfFreeTextAnnotation#ctor");
        
        this.addName("SubType", "FreeText");
    }
    
    public void setLineEndingStyle(HPdfLineAnnotEndingStyle startStyle, HPdfLineAnnotEndingStyle endStyle) {
        logger.trace("HPdfFreeTextAnnotation#setLineEndingStyle");
        
        HPdfArray lineEndStyles = new HPdfArray();
        
        this.add("LE", lineEndStyles);
        
        lineEndStyles.addName(startStyle.getName());
        lineEndStyles.addName(endStyle.getName());
    }
    
    public void setDefaultStyle(String style) {
        logger.trace("HPdfFreeTextAnnotation#setDefaultStyle");
        
        this.add("DS", new HPdfString(style, null));
    }
    
    /**
     * Callout line will be in default user space
     * @param startPoint
     * @param kneePoint
     * @param endPoint
     */
    public void set3PointCalloutLine(HPdfPoint startPoint, HPdfPoint kneePoint, HPdfPoint endPoint) {
        logger.trace("HPdfFreeTextAnnotation#set3PointCalloutLine");
        
        HPdfArray clPoints = new HPdfArray();
        
        this.add("CL", clPoints);
        
        clPoints.addReal(startPoint.getX());
        clPoints.addReal(startPoint.getY());
        clPoints.addReal(kneePoint.getX());
        clPoints.addReal(kneePoint.getY());
        clPoints.addReal(endPoint.getX());
        clPoints.addReal(endPoint.getY());
    }
    
    /**
     * Callout line will be in default user space
     * @param startPoint
     * @param kneePoint
     * @param endPoint
     */
    public void set2PointCalloutLine(HPdfPoint startPoint, HPdfPoint endPoint) {
        logger.trace("HPdfFreeTextAnnotation#set2PointCalloutLine");
        
        HPdfArray clPoints = new HPdfArray();
        
        this.add("CL", clPoints);
        
        clPoints.addReal(startPoint.getX());
        clPoints.addReal(startPoint.getY());
        clPoints.addReal(endPoint.getX());
        clPoints.addReal(endPoint.getY());
    }
}
