/*
 * JHPdf Free PDF Library : HPdfString.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfConst;
import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.HPdfUtil;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.encoder.HPdfParseText;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.io.HPdfWriteStream;

/**
 * Class represents strings in PDF.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfString extends HPdfObject implements Comparable<HPdfString> {

    private static final Logger logger = LoggerFactory.getLogger(HPdfString.class);
    
    private static final byte[] UNICODE_HEADER = {(byte) 0xFE, (byte) 0xFF};
    
    private String val;
    
    public HPdfString(String val, HPdfEncoder encoder) {
        super();
        logger.trace("HPdfString#ctor");
        setValue(val);
        setEncoder(encoder);
    }
    
    public String getValue() {
        return this.val;
    }
    
    void setValue(String val) {
        this.val = val;
    }
    
    private HPdfEncoder encoder;
    
    public HPdfEncoder getEncoder() {
        return this.encoder;
    }
    
    void setEncoder(HPdfEncoder encoder) {
        this.encoder = encoder;
    }
    
    @Override
    protected void writeValue(HPdfWriteStream stream, HPdfEncrypt e) {
        logger.trace("HPdfString#writeValue");
        
        if (e != null) {
            e.reset();
        }
        
        // MEMO: original code performs byte-to-Unicode converting with HPdfEncoder.
        // Java String is Unicode by nature, so only need is getBytes()
        if (HPdfUtil.isSingleByteOnly(this.getValue())) {
            if (e != null) {
                stream.writeChar('<');
                // MEMO: assumes byte encoding is ISO-8859-1
                byte[] src = this.getBytes(StandardCharsets.ISO_8859_1);
                stream.writeBinary(src, src.length, e);
                stream.writeChar('>');
            } else {
                stream.writeEscapeText(this.getValue());
            }
        } else {
            stream.writeChar('<');
            stream.writeBinary(UNICODE_HEADER, UNICODE_HEADER.length, e);
            
            byte[] src = this.getBytes(StandardCharsets.UTF_16BE);
            stream.writeBinary(src, src.length, e);
            
            stream.writeChar('>');
        }
    }
    
    private byte[] getBytes(Charset c) {
        return this.getValue().getBytes(c);
    }

    @Override
    public int compareTo(HPdfString arg0) {
        return this.getValue().compareTo(arg0.getValue());
    }
}
