/*
 * JHPdf Free PDF Library : HPdfPage.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfCMYKColor;
import net.sf.jhpdf.graphics.HPdfColorSpace;
import net.sf.jhpdf.graphics.HPdfPoint;
import net.sf.jhpdf.graphics.HPdfRGBColor;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfLineCap;
import net.sf.jhpdf.graphics.HPdfLineJoin;
import net.sf.jhpdf.graphics.HPdfTransMatrix;
import net.sf.jhpdf.io.HPdfStream.HPdfFilterFlag;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageDirection;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageSizes;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfTextAlign;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfTextRenderingMode;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfTransitionStyle;
import net.sf.jhpdf.pdfobject.annotation.HPdfLinkAnnotation;
import net.sf.jhpdf.pdfobject.annotation.HPdfTextAnnotation;
import net.sf.jhpdf.pdfobject.annotation.HPdfURILinkAnnotation;

/**
 * Class represents PDF Page.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfPage extends HPdfDict {

    private static final Logger logger = LoggerFactory.getLogger(HPdfPage.class);
    
    public enum HPdfPageSizes {
        LETTER,
        LEGAL,
        A3,
        A4,
        A5,
        B4,
        B5,
        EXECUTIVE,
        US4x6,
        US4x8,
        US5x7,
        COMM10,
    }
    
    public enum HPdfPageDirection {
        PORTRAIT,
        LANDSCAPE,
    }
    
    public enum HPdfTextRenderingMode {
        FILL,
        STROKE,
        FILL_THEN_STROKE,
        INVISIBLE,
        FILL_CLIPPING,
        STROKE_CLIPPING,
        FILL_STROKE_CLIPPING,
        CLIPPING,
    }
    
    public enum HPdfTextAlign {
        LEFT,
        RIGHT,
        CENTER,
        JUSTIFY,
    }
    
    private interface TransitionBehavior {
        void registTo(HPdfDict dict);
    }
    
    public enum HPdfTransitionStyle {
        WIPE_RIGHT(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Wipe");
                dict.addNumber("Di", 0);
            }
        }),
        WIPE_UP(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Wipe");
                dict.addNumber("Di", 90);
            }
        }),
        WIPE_LEFT(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Wipe");
                dict.addNumber("Di", 180);
            }
        }),
        WIPE_DOWN(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Wipe");
                dict.addNumber("Di", 270);
            }
        }),
        BARN_DOORS_HORIZONTAL_OUT(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Split");
                dict.addName("Dm", "H");
                dict.addName("M", "O");
            }
        }),
        BARN_DOORS_HORIZONTAL_IN(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Split");
                dict.addName("Dm", "H");
                dict.addName("M", "I");
            }
        }),
        BARN_DOORS_VERTICAL_OUT(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Split");
                dict.addName("Dm", "V");
                dict.addName("M", "O");
            }
        }),
        BARN_DOORS_VERTICAL_IN(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Split");
                dict.addName("Dm", "V");
                dict.addName("M", "I");
            }
        }),
        BOX_OUT(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Box");
                dict.addName("M", "O");
            }
        }),
        BOX_IN(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Box");
                dict.addName("M", "I");
            }
        }),
        BLINDS_HORIZONTAL(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Blinds");
                dict.addName("Dm", "H");
            }
        }),
        BLINDS_VERTICAL(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Blinds");
                dict.addName("Dm", "V");
            }
        }),
        DISSOLVE(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Dissolve");
            }
        }),
        GLITTER_RIGHT(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Glitter");
                dict.addNumber("Di", 0);
            }
        }),
        GLITTER_DOWN(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Glitter");
                dict.addNumber("Di", 270);
            }
        }),
        GLITTER_TOP_LEFT_TO_BOTTOM_RIGHT(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "Glitter");
                dict.addNumber("Di", 315);
            }
        }),
        REPLACE(new TransitionBehavior() {
            public void registTo(HPdfDict dict) {
                dict.addName("S", "R");
            }
        }),
        ;

        private TransitionBehavior behavior;
       
        HPdfTransitionStyle(TransitionBehavior behavior) {
            this.behavior = behavior;
        }
       
        void registTo(HPdfDict dict) {
            this.behavior.registTo(dict);
        }
    }
    
    private float height;
    private float width;
    
    private float lineWidth;
    
    /**
     * ctor. this is package-private.
     * @param xref 
     */
    HPdfPage(HPdfXref xref) {
        // TODO only stub
        super();
        
        logger.trace("HPdfPage#ctor");
        
        setHeight(0);
        setWidth(0);
        setLineWidth(0);
    }
    
    public float getHeight() {
        return this.height;
    }
    
    public void setHeight(float h) {
        this.height = h;
    }
    
    public float getWidth() {
        return this.width;
    }
    
    public void setWidth(float w) {
        this.width = w;
    }
    
    public void setSize(HPdfPageSizes letter, HPdfPageDirection portrait) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void setRotate(int angle) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void setZoom(float zoom) {
        // TODO ꂽ\bhEX^u
        
    }

    void setFilter(HPdfFilterFlag flateDecode) {
        // TODO ꂽ\bhEX^u
    }

    public HPdfDestination createDestination() {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    // TODO not implemented.
    /*
    public HPdf3DAnnotation create3DAnnot(HPdfRect rect, HPdfU3d u3d) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    */

    public HPdfTextAnnotation createTextAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    // TODO not implemented.
    /*
    public HPdfFreeTextAnnotation createFreeTextAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    */
    
    // TODO not implemented.
    /*
    public HPdfLineAnnotation createLineAnnot(String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    */
    
    public HPdfLinkAnnotation createLinkAnnot(HPdfRect rect, HPdfDestination dst) {
        // TODO ꂽ\bhEX^u
        return null;
    }

    public HPdfURILinkAnnotation createURILinkAnnot(HPdfRect rect, String uri) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    // TODO not implemented.
    /*
    public HPdfMarkupAnnotation createTextMarkupAnnot(HPdfRect rect, String text, HPdfEncoder encoder, Class<? extends HPdfMarkupAnnotation> subType) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfHighlightAnnotation createHighlightAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfUnderlineAnnotation createUnderlineAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfSquigglyAnnotation createSquigglyAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfStrikeOutAnnotation createStrikeOutAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfPopupAnnotation createPopupAnnot(HPdfRect rect, HPdfAnnotation parent) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfStampAnnotation createStampAnnot(HPdfRect rect, HPdfStampAnnotName name, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfProjectionAnnotation createProjectionAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfSquareAnnotation createSquareAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfCircleAnnotation createCircleAnnot(HPdfRect rect, String text, HPdfEncoder encoder) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    */
    
    // TODO not implemented.
    /*
    public HPdf3DMeasure create3DC3DMeasure(HPdfPoint3D firstAnchorPoint, HPdfPoint3D textAnchorPoint) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdf3DMeasure createPD33DMeasure(HPdfPoint3D annotationPlaneNormal, HPdfPoint3D firstAnchorPoint, HPdfPoint3D secondAnchorPoint) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    */
    
    // TODO not implemented.
    /*
    public HPdfExData create3DAnnotExData() {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public HPdfDict create3DView(HPdfU3D u3d, HPdfAnnotaion annot3d, String name) {
        // TODO ꂽ\bhEX^u
        return null;
    }
    */

    public float textWidth(String text) {
        // TODO ꂽ\bhEX^u
        return 0;
    }

    public int measureText(String text, float width, boolean wordwrap, float[] realWidth) {
        // TODO ꂽ\bhEX^u
        return 0;
    }

    public int getGMode() {
        // TODO ꂽ\bhEX^u
        return 0;
    }

    public HPdfPoint getCurrentPos() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    public HPdfPoint getCurrentTextPos() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    public HPdfFont getCurrentFont() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    public float getCurrentFontSize() {
        // TODO ꂽ\bhEX^u
        return 0;
    }
    
    public HPdfTransMatrix getTransMatrix() {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public void setTransMatrix(float a, float b, float c, float d, float x, float y) {
        // TODO only stub
    }
    
    public float getLineWidth() {
        return this.lineWidth;
    }
    
    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }
    
    public HPdfLineCap getLineCap() {
        // TODO only stub.
        return null;
    }

    public void setLineCap(HPdfLineCap lineCap) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public HPdfLineJoin getLineJoin() {
        // TODO only stub.
        return null;
    }

    public void setLineJoin(HPdfLineJoin lineJoin) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public float getMiterLimit() {
        // TODO only stub.
        return 0;
    }
    
    public void setMiterLimit(float miterLimit) {
        // TODO only stub.
    }
    
    // TODO not implemented.
    /*
    public HPdfDashMode getDash() {
        // TODO ꂽ\bhEX^u
        return null;
    }
    */

    public void setDash(int[] dashPtn, int phase) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public float getFlat() {
        // TODO only stub.
        return 0;
    }
    
    public void setFlat(float flatness) {
        // TODO only stub.
    }
    
    public float getCharSpace() {
        // TODO only stub.
        return 0;
    }

    public void setCharSpace(float value) {
        // TODO ꂽ\bhEX^u
        
    }

    public float getWordSpace() {
        // TODO ꂽ\bhEX^u
        return 0;
    }

    public void setWordSpace(float value) {
        // TODO ꂽ\bhEX^u
        
    }

    public float getHorizontalScalling() {
        // TODO ꂽ\bhEX^u
        return 0;
    }

    public void setHorizontalScalling(float value) {
        // TODO ꂽ\bhEX^u
        
    }

    public float getTextLeading() {
        // TODO ꂽ\bhEX^u
        return 0;
    }

    public void setTextLeading(float value) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void setFontAndSize(HPdfFont font, float size) {
        // TODO only stub
    }

    public HPdfTextRenderingMode getTextRenderingMode() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    public void setTextRenderingMode(HPdfTextRenderingMode fill) {
        // TODO ꂽ\bhEX^u
        
    }
    
    /**
     * @deprecated This method is obsolete. Use getTextRise.
     * @see HPdfPage#getTextRise()
     */
    @Deprecated
    public float getTextRaise() {
        return this.getTextRise();
    }
    
    public float getTextRise() {
        // TODO ꂽ\bhEX^u
        return 0;
    }
    
    public float setTextRise(float value) {
        // TODO ꂽ\bhEX^u
        return 0;
    }
    
    /**
     * @deprecated This method is obsolete. Use setTextRise.
     * @see HPdfPage#getTextRise()
     */
    @Deprecated
    public void setTextRaise(float value) {
        this.setTextRise(value);
    }

    public HPdfRGBColor getRGBFill() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    public void setRGBFill(float r, float g, float b) {
        // TODO ꂽ\bhEX^u
        
    }

    public HPdfRGBColor getRGBStroke() {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public void setRGBStroke(float r, float g, float b) {
        // TODO ꂽ\bhEX^u
        
    }

    public HPdfCMYKColor getCMYKFill() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    public void setCMYKFill(float r, float g, float b) {
        // TODO ꂽ\bhEX^u
        
    }

    public HPdfCMYKColor getCMYKStroke() {
        // TODO ꂽ\bhEX^u
        return null;
    }
    
    public void setCMYKStroke(float c, float m, float y, float k) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public float getGrayFill() {
        // TODO only stub
        return 0;
    }
    
    public void setGrayFill(float gray) {
        // TODO only stub
    }
    
    public float getGrayStroke() {
        // TODO only stub
        return 0;
    }
    
    public void setGrayStroke(float gray) {
        // TODO only stub
    }
    
    public HPdfColorSpace getStrokingColorSpace() {
        // TODO only stub
        return null;
    }
    
    public HPdfColorSpace getFillingColorSpace() {
        // TODO only stub
        return null;
    }
    
    public HPdfTransMatrix getTextMatrix() {
        // TODO only stub
        return null;
    }

    public void setTextMatrix(float a, float b, float c, float d, float x, float y) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public int getGStateDepth() {
        // TODO only stub
        return 0;
    }

    public void setExtGState(HPdfExtGState gstate) {
        // TODO ꂽ\bhEX^u
        
    }

    public void gSave() {
        // TODO ꂽ\bhEX^u
        
    }

    public void gRestore() {
        // TODO ꂽ\bhEX^u
        
    }

    public void concat(float a, float b, float c, float d, float x, float y) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void moveTo(float x, float y) {
        // TODO only stub
    }
    
    public void lineTo(float toX, float toY) {
        // TODO only stub
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3,
            float y3) {
        // TODO ꂽ\bhEX^u
        
    }

    public void curveTo2(float x1, float y1, float x2, float y2) {
        // TODO ꂽ\bhEX^u
        
    }

    public void curveTo3(float x1, float y1, float x2, float y2) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void closePath() {
        // TODO only stub
    }

    public void rectangle(float x, float y, float width, float height) {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void stroke() {
        // TODO only stub
    }
    
    public void closePathStroke() {
        // TODO only stub
    }

    public void fill() {
        // TODO ꂽ\bhEX^u
        
    }

    public void eofill() {
        // TODO ꂽ\bhEX^u
        
    }

    public void fillStroke() {
        // TODO ꂽ\bhEX^u
        
    }

    public void eofillStroke() {
        // TODO ꂽ\bhEX^u
        
    }

    public void closePathFillStroke() {
        // TODO ꂽ\bhEX^u
        
    }

    public void closePathEofillStroke() {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void endPath() {
        // TODO only stub.
    }

    public void clip() {
        // TODO ꂽ\bhEX^u
        
    }

    public void eoclip() {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void beginText() {
        // TODO only stub
    }
    
    public void endText() {
        // TODO only stub
    }
    
    public void moveTextPos(float txtX, float txtY) {
        // TODO only stub
    }
    
    public void moveTextPos2(float txtX, float txtY) {
        // TODO only stub
    }

    public void moveToNextLine() {
        // TODO ꂽ\bhEX^u
        
    }
    
    public void showText(String text) {
        // TODO only stub
    }

    public void showTextNextLine(String text) {
        // TODO ꂽ\bhEX^u
        
    }

    public void showTextNextLineEx(float wordSpace, float charSpace, String text) {
        // TODO ꂽ\bhEX^u
        
    }

    public void executeXObject(HPdfXObject obj) {
        // TODO ꂽ\bhEX^u
        
    }

    public void drawImage(HPdfImage image, float x, float y, float width, float height) {
        // TODO ꂽ\bhEX^u
        
    }

    public void circle(float x, float y, float ray) {
        // TODO ꂽ\bhEX^u
        
    }

    public void ellipse(float x, float y, float xray, float yray) {
        // TODO ꂽ\bhEX^u
        
    }

    public void arc(float x, float y, float ray, float ang1, float ang2) {
        // TODO ꂽ\bhEX^u
        
    }

    public void textOut(float xpos, float ypos, String text) {
        // TODO ꂽ\bhEX^u
        
    }

    public void textRect(float left, float top, float right, float bottom, 
                String text, HPdfTextAlign align, int[] len) {
        // TODO ꂽ\bhEX^u
        
    }

    public void setSlideShow(HPdfTransitionStyle style, float dispTime, float transTime) {
        // TODO ꂽ\bhEX^u
        
    }
}
