/*
 * JHPdf Free PDF Library : HPdfInfo.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import java.util.Calendar;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.io.HPdfWriteStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF Info.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfInfo extends HPdfDict {

    private static final Logger logger = LoggerFactory.getLogger(HPdfInfo.class);
    
    protected enum HPdfInfoType {
        /* date-time type parameters */
        CREATION_DATE("CreationDate"),
        MOD_DATE("ModDate"),
        
        /* string type parameters */
        AUTHOR("Author"),
        CREATOR("Creator"),
        PRODUCER("Producer"),
        TITLE("Title"),
        SUBJECT("Subject"),
        KEYWORDS("Keywords"),
        TRAPPED("Trapped"),
        GTS_PDFX("GTS_PDFXVersion"),
        ;
        
        String name;
        HPdfInfoType(String name) {
            this.name = name;
        }
        String getName() {
            return this.name;
        }
    };
    
    /**
     * ctor. this is package-private.
     */
    HPdfInfo() {
        super();
    }
    
    protected String getInfoAttr(HPdfInfoType iType) {
        logger.trace("HPdfInfo#getInfoAttr");
        
        HPdfString s = this.getItem(iType.getName(), HPdfString.class);
        if (s == null) {
            return null;
        } else {
            return s.getValue();
        }
    }
    
    protected void setInfoAttr(HPdfInfoType iType, String value, HPdfEncoder encoder) {
        logger.trace("HPdfInfo#setInfoAttr");
        
        String name = iType.getName();
        
        if (iType.compareTo(HPdfInfoType.MOD_DATE) <= 0) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_PARAMETER, 0);
        }
        
        if (iType == HPdfInfoType.TRAPPED) {
            this.addName(name, value);
            return;
        }
        
        this.add(name, new HPdfString(value, encoder));
    }
    
    protected void setInfoDateAttr(HPdfInfoType iType, HPdfDate value) {
        logger.trace("HPdfInfo#setInfoDateAttr");
        
        if (iType.compareTo(HPdfInfoType.MOD_DATE) > 0) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_PARAMETER, 0);
        }
        
        // if 'value' is invalid, HPdfException is thrown.
        value.validate();
        
        this.add(iType.getName(), new HPdfString(value.toString(), null));
    }
}
