/*
 * JHPdf Free PDF Library : HPdfIOUtil.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.io;

import java.io.Closeable;
import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * I/O utility method class.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
class HPdfIOUtil {
    
    private static final Logger logger = LoggerFactory.getLogger(HPdfIOUtil.class);
    
    private HPdfIOUtil() {
        // prohibits instanciation.
    }
    
    /**
     * close an Closeable instance ignoring Exception.
     * if exception occurred, it would appear on the log.
     * @param s object to be closed
     */
    static void closeQuietly(Closeable s) {
        if (s != null) {
            try {
                s.close();
            } catch (IOException e) {
                logger.error("Error on closing!", e);
            }
        }
    }
}
