/*
 * JHPdf Free PDF Library : HPdfRect.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.graphics;

/**
 * Class represents PDF Rect.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public final class HPdfRect implements Cloneable {
    
    public HPdfRect() {
        this(0, 0, 0, 0);
    }
    
    public HPdfRect(float left, float bottom, float right, float top) {
        super();
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
    }
    
    private float top;
    
    public float getTop() {
        return this.top;
    }
    
    public void setTop(float top) {
        this.top = top;
    }
    
    private float bottom;
    
    public float getBottom() {
        return this.bottom;
    }
    
    public void setBottom(float bottom) {
        this.bottom = bottom;
    }

    private float left;
    
    /**
     * @return left
     */
    public float getLeft() {
        return left;
    }

    /**
     * @param left ݒ肷 left
     */
    public void setLeft(float left) {
        this.left = left;
    }

    private float right;
    
    /**
     * @return right
     */
    public float getRight() {
        return right;
    }

    /**
     * @param right ݒ肷 right
     */
    public void setRight(float right) {
        this.right = right;
    }
    
    /**
     * if top < bottom, swaps them.
     */
    public void reviseVertically() {
        if (this.top < this.bottom) {
            float tmp = this.top;
            this.top = this.bottom;
            this.bottom = tmp;
        }
    }
    
    private void copy(HPdfRect org) {
        this.setTop(org.getTop());
        this.setBottom(org.getBottom());
        this.setLeft(org.getLeft());
        this.setRight(org.getRight());
    }

    @Override
    public HPdfRect clone()  {
        HPdfRect r;
        try {
            r = (HPdfRect) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException("HPdfRect cloning failed", e);
        }
        r.copy(this);
        return r;
    }
    
    
}
