/*
 * JHPdf Free PDF Library : JHPdfVersion.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf;

/**
 * Class for recoding JHPdf version.
 * this class is package-private.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
final class JHPdfVersion {
    
    private JHPdfVersion() {
        // inhibits instanciation.
    }
    
    static final int JHPdfMajorVersion = 0;
    static final int JHPdfMinorVersion = 1;
    static final int JHPdfBugfixVersion = 0;
    static final String JHPdfExtraVersion = "Alpha";
    static final String HPdfCorrespondsVersion = "2.3.0RC2";
    
    static String getJHPdfVersionText() {
        return String.format("%d.%d.%d%s/libHaru %s",
            JHPdfMajorVersion, JHPdfMinorVersion, JHPdfBugfixVersion, JHPdfExtraVersion,
            HPdfCorrespondsVersion);
    }
    
    static int getJHPdfVersionId() {
        return JHPdfMajorVersion * 10000 +
            JHPdfMinorVersion * 100 +
            JHPdfBugfixVersion;
    }
}
