/*
 * JHPdf Free PDF Library : TextDemo2.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * original demo/arc_demo.c in 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

import java.lang.Math;

import net.sf.jhpdf.*;
import net.sf.jhpdf.pdfobject.*;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageDirection;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfPageSizes;
import net.sf.jhpdf.pdfobject.HPdfPage.HPdfTextAlign;
import net.sf.jhpdf.graphics.*;


public class TextDemo2 implements DemoEntry {
    public static void main(String[] args) {
        new TextDemo2().demo(args);
    }
    
    private TextDemo2() {
        super();
        //this.no = 0;
    }
    
    private static final String F_NAME = "TextDemo2.pdf";
    
    @Override
    public void demo(String[] args) {
        
        final String SAMP_TXT = "The quick brown fox jumps over the lazy dog.";
        
        GridSheet grid = new GridSheet();

        HPdfDocument pdf = null;
        try {
            pdf = JHPdf.createDocument();
            
            /* add a new page object. */
            HPdfPage page = pdf.addPage();
            page.setSize(HPdfPageSizes.A5, HPdfPageDirection.PORTRAIT);
            
            grid.printGrid(pdf, page);
            
            //float pageHeight = page.getHeight();
            
            HPdfFont font = pdf.getFont("Helvetica", null);
            page.setTextLeading(20);
            
            /* text_rect method */
            
            HPdfRect rect = new HPdfRect();
            /* HPDF_TALIGN_LEFT */
            rect.setLeft(25);
            rect.setTop(545);
            rect.setRight(200);
            rect.setBottom(rect.getTop() - 40);
            
            page.rectangle(rect.getLeft(), rect.getBottom(), rect.getRight() - rect.getLeft(),
                rect.getTop() - rect.getBottom());
            page.stroke();
            
            page.beginText();
            
            page.setFontAndSize(font, 10);
            page.textOut(rect.getLeft(), rect.getTop() + 3, "HPDF_TALIGN_LEFT");
            page.setFontAndSize(font, 13);
            page.textRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(),
                SAMP_TXT, HPdfTextAlign.LEFT, null);
            
            page.endText();
            
            /* HPDF_TALIGN_RIGTH */
            rect.setLeft(220);
            rect.setRight(395);
            
            page.rectangle(rect.getLeft(), rect.getBottom(), rect.getRight() - rect.getLeft(),
                rect.getTop() - rect.getBottom());
            page.stroke();
            
            page.beginText();
            
            page.setFontAndSize(font, 10);
            page.textOut(rect.getLeft(), rect.getTop() + 3, "HPDF_TALIGN_RIGTH");
            page.setFontAndSize(font, 13);
            page.textRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(),
                SAMP_TXT, HPdfTextAlign.RIGHT, null);
            
            page.endText();
            
            /* HPDF_TALIGN_CENTER */
            rect.setLeft(25);
            rect.setTop(475);
            rect.setRight(200);
            rect.setBottom(rect.getTop() - 40);
            
            page.rectangle(rect.getLeft(), rect.getBottom(), rect.getRight() - rect.getLeft(),
                rect.getTop() - rect.getBottom());
            page.stroke();
            
            page.beginText();
            
            page.setFontAndSize(font, 10);
            page.textOut(rect.getLeft(), rect.getTop() + 3, "HPDF_TALIGN_CENTER");
            page.setFontAndSize(font, 13);
            page.textRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(),
                SAMP_TXT, HPdfTextAlign.CENTER, null);
            
            page.endText();
            
            /* HPDF_TALIGN_JUSTIFY */
            rect.setLeft(220);
            rect.setRight(395);
            
            page.rectangle(rect.getLeft(), rect.getBottom(), rect.getRight() - rect.getLeft(),
                rect.getTop() - rect.getBottom());
            page.stroke();
            
            page.beginText();
            
            page.setFontAndSize(font, 10);
            page.textOut(rect.getLeft(), rect.getTop() + 3, "HPDF_TALIGN_JUSTIFY");
            page.setFontAndSize(font, 13);
            page.textRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(),
                SAMP_TXT, HPdfTextAlign.JUSTIFY, null);
            
            page.endText();
            
            /* Skewed coordinate system */
            page.gSave();
            
            float angle1 = 5;
            float angle2 = 10;
            float rad1 = angle1 / 180 * 3.141592F;
            float rad2 = angle2 / 180 * 3.141592F;
            
            page.concat(1, (float) Math.tan(rad1), (float) Math.tan(rad2), 1, 25, 350);
            rect.setLeft(0);
            rect.setTop(40);
            rect.setRight(175);
            rect.setBottom(0);
            
            page.rectangle(rect.getLeft(), rect.getBottom(), rect.getRight() - rect.getLeft(),
                rect.getTop() - rect.getBottom());
            page.stroke();
            
            page.beginText();
            
            page.setFontAndSize(font, 10);
            page.textOut(rect.getLeft(), rect.getTop() + 3, "Skewed coordinate system");
            
            page.setFontAndSize(font, 13);
            page.textRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(),
                SAMP_TXT, HPdfTextAlign.LEFT, null);
            
            page.endText();
            
            page.gRestore();
            
            /* Rotated coordinate system */
            page.gSave();
            
            angle1 = 5;
            rad1 = angle1 / 180 * 3.141592F;
            
            page.concat((float) Math.cos(rad1), (float) Math.sin(rad1), (float) -Math.sin(rad1), (float) Math.cos(rad1),
                220, 350);
            rect.setLeft(0);
            rect.setTop(40);
            rect.setRight(175);
            rect.setBottom(0);
            
            page.rectangle(rect.getLeft(), rect.getBottom(), rect.getRight() - rect.getLeft(),
                rect.getTop() - rect.getBottom());
            page.stroke();
            
            page.beginText();
            
            page.setFontAndSize(font, 10);
            page.textOut(rect.getLeft(), rect.getTop() + 3, "Rotated coordinate system");
            
            page.setFontAndSize(font, 13);
            page.textRect(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(),
                SAMP_TXT, HPdfTextAlign.LEFT, null);
            
            page.endText();
            
            page.gRestore();
            
            /* text along a circle */
            page.setGrayStroke(0);
            page.circle(210, 190, 145);
            page.circle(210, 190, 113);
            page.stroke();
            
            angle1 = 360 / SAMP_TXT.length();
            angle2 = 180;
            
            page.beginText();
            font = pdf.getFont("Courier-Bold", null);
            page.setFontAndSize(font, 30);
            
            for (final char c : SAMP_TXT.toCharArray()) {
                rad1 = (angle2 - 90) / 180 * 3.141592F;
                rad2 = angle2 / 180 * 3.141592F;
                
                float x = (float) (210 + Math.cos(rad2) * 122);
                float y = (float) (190 + Math.sin(rad2) * 122);
                
                page.setTextMatrix((float) Math.cos(rad1), (float) Math.sin(rad1), (float) -Math.sin(rad1), (float) Math.cos(rad1),
                    x, y);
                
                page.showText(String.valueOf(c));
                angle2 -= angle1;
            }
            
            page.endText();
            
            /* save the document to a file */
            pdf.saveToFile(F_NAME);
            
        } catch (HPdfException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (pdf != null) {
                pdf.freeDocAll();
            }
        }
    }
    
    /*
    private int no;
    
    private void printText(HPdfPage page) {
        HPdfPoint pos = page.getCurrentTextPos();
        
        ++this.no;
        String buf = String.format(".[%d]%0.2f %0.2f", this.no, pos.getX(), pos.getY());
        
        page.showText(buf);
    }
    */
}
