package net.sf.jhpdf.test.matcher

import org.hamcrest.BaseMatcher
import org.hamcrest.Description;

class CloseTo<T extends Number & Comparable<T>> extends BaseMatcher {

    private T expected
    private T delta
    
    public CloseTo(T expected, T delta) {
        super();
        this.expected = expected
        this.delta = delta
    }

    @Override
    public boolean matches(Object item) {
        if (item instanceof T) {
            def expectedLow = expected - delta
            def expectedHigh = expected + delta
            return expectedLow.compareTo(item) <= 0 && expectedHigh.compareTo(item) >= 0
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(
            String.format("expected %f +/- %f", this.expected, this.delta)
            )
    }

}
