/*
 * JHPdf Free PDF Library : HPdfSimSunFontDef.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font.cns;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.pdfobject.font.HPdfCIDFontDef;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;

/**
 * Class represents PDF SimSun Font definition.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfSimSunFontDef extends HPdfCIDFontDef {

    private static final Logger logger = LoggerFactory.getLogger(HPdfSimSunFontDef.class);
    
    // TODO width data loading required.
    private HPdfCIDWidth[] SIMSUN_W_ARRAY;
    
    public HPdfSimSunFontDef() {
        super("SimSun");
    }

    @Override
    public void init() {
        // MEMO: derived from SimSun_Init in hpdf_fontdef_cns.c
        logger.trace("HPdfSimSunFontDef#init");
        
        this.setAscent(859);
        this.setDescent(-140);
        this.setCapHeight(683);
        this.setFontBbox(new HPdfRect(0, -140, 996, 855));
        this.setFlag(HPDF_FONT_SYMBOLIC + HPDF_FONT_FIXED_WIDTH +
            HPDF_FONT_SERIF);
        this.setItalicAngle(0);
        this.setStemv(78);
        this.addWidth(SIMSUN_W_ARRAY);
        
        this.setFontDefType(HPdfFontDefType.CID);
        this.setValid(true);
    }

    @Override
    public void clean() {
        // TODO ꂽ\bhEX^u
        
    }

    @Override
    public void dispose() {
        // TODO ꂽ\bhEX^u
        
    }
}
