/*
 * JHPdf Free PDF Library : HPdfType0Font.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfCMapEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder.HPdfEncoderType;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.io.HPdfWriteStream;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfFont;
import net.sf.jhpdf.pdfobject.HPdfStreamDict;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;

/**
 * Class represents PDF Type0 Font.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfType0Font extends HPdfFontImpl {
    // TODO only stub, needs methods definition.

    private static final Logger logger = LoggerFactory.getLogger(HPdfType0Font.class);
    
    public HPdfType0Font(HPdfCIDFontDef fontDef, HPdfCMapEncoder encoder, HPdfXref xref) {
        super(fontDef, encoder, xref);
        
        logger.trace("HPdfType0Font#ctor");
        
        /* check whether the fontdef object and the encoder object is valid. */
        if (encoder.getType() != HPdfEncoderType.DOUBLE_BYTE) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_ENCODER_TYPE, 0);
        }
        
        if (fontDef.getFontDefType() != HPdfFontDefType.CID &&
                fontDef.getFontDefType() != HPdfFontDefType.TRUETYPE) {
            throw new HPdfException(HPdfErrorCode.HPDF_INVALID_FONTDEF_TYPE, 0);
        }
        
        this.setWritingMode(encoder.getWritingMode());
        
        xref.add(this);
        
        this.addName("Type", "Font");
        this.addName("BaseFont", fontDef.getBaseFont());
        this.addName("Subtype", "Type0");
        
        if (fontDef.getFontDefType() == HPdfFontDefType.CID) {
            this.addName("Encoding", encoder.getName());
        } else {
            this.setCmapStream(createCMap(encoder, xref));
            this.add("Encoding", this.getCmapStream());
        }
        
        HPdfArray descendantFonts = new HPdfArray();
        this.add("DescendantFonts", descendantFonts);
        
        if (fontDef.getFontDefType() == HPdfFontDefType.CID) {
            this.setDescendantFont(new HPdfCIDType0Font(this, xref));
            this.setFontType(HPdfFontType.TYPE0_CID);
        } else {
            this.setDescendantFont(new HPdfCIDType2Font(this, xref));
            this.setFontType(HPdfFontType.TYPE0_TT);
        }
        
        descendantFonts.add(this.getDescendantFont());
    }

    private HPdfStreamDict createCMap(HPdfCMapEncoder encoder, HPdfXref xref) {
        // TODO ꂽ\bhEX^u
        return null;
    }

    @Override
    protected void beforeWrite(HPdfWriteStream stream, HPdfEncrypt e) {
        super.beforeWrite(stream, e);
        logger.trace("HPdfType0Font#beforeWrite");
        HPdfDescendantFont descendantFont = (HPdfDescendantFont) this.getDescendantFont();
        descendantFont.beforeWriteImpl(this);
    }

    @Override
    protected HPdfTextWidth textWidthImpl(String text, int len) {
        // TODO ꂽ\bhEX^u
        return null;
    }

    @Override
    protected int measureTextImpl(String text, int len, float width,
            float fontSize, float charSpace, float wordSpace, boolean wordWrap,
            float[] realWidth) {
        // TODO ꂽ\bhEX^u
        return 0;
    }

    
}
