/*
 * JHPdf Free PDF Library : HPdfCIDType2Font.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfCMapEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder.HPdfEncoderType;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.io.HPdfWriteStream;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfDict;
import net.sf.jhpdf.pdfobject.HPdfFont;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;

/**
 * Class represents PDF CID Font Type2.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfCIDType2Font extends HPdfDescendantFont {
    // TODO only stub, needs methods definition.

    private static final Logger logger = LoggerFactory.getLogger(HPdfCIDType2Font.class);
    
    HPdfCIDType2Font(HPdfType0Font parent, HPdfXref xref) {
        super(parent, xref);
        // TODO only stub
        logger.trace("HPdfCIDType2Font#ctor");
        
        HPdfCIDFontDef fontDef = (HPdfCIDFontDef) parent.getFontDef();
        
        xref.add(this);
        
        this.addName("Type", "Font");
        this.addName("Subtype", "CIDFontType2");
        this.addNumber("DW", fontDef.getMissingWidth());
        
        /* add 'DW2' element */
        HPdfArray array = new HPdfArray();
        this.add("DW2", array);
        HPdfRect bbox = fontDef.getFontBbox();
        array.addNumber((int) bbox.getBottom());
        array.addNumber((int) (bbox.getBottom() - bbox.getTop()));
        
        int[] tmpMap = new int[65535];
        
        
    }

    @Override
    void beforeWriteImpl(HPdfType0Font obj) {
        logger.trace("HPdfCIDType2Font#beforeWrite");
        
        if (obj.getMapStream() != null) {
            obj.getMapStream().setFilterSet(obj.getFilterSet());
        }
        
        if (obj.getCmapStream() != null) {
            obj.getCmapStream().setFilterSet(obj.getFilterSet());
        }
        
        HPdfCIDFontDef fontDef = (HPdfCIDFontDef) obj.getFontDef();
        if (fontDef.getDescriptor() == null) {
            // TODO create descriptor.
        }
        
        obj.addName("BaseFont", fontDef.getBaseFont());
        obj.getDescendantFont().addName("BaseFont", fontDef.getBaseFont());
        obj.getDescendantFont().add("FontDescriptor", fontDef.getDescriptor());
    }

}
