/*
 * JHPdf Free PDF Library : HPdfTextMarkupAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfPoint;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.pdfobject.HPdfArray;
import net.sf.jhpdf.pdfobject.HPdfXref;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Abstract class represents PDF Text Annotations with markup.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
/**
 * @author honbu6
 *
 */
public abstract class HPdfTextMarkupAnnotation extends HPdfMarkupAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfTextMarkupAnnotation.class);
    
    protected HPdfTextMarkupAnnotation(HPdfXref xref, HPdfRect rect, String text, HPdfEncoder encoder) {
        super(xref, rect, text, encoder);
        
        logger.trace("HPdfTextMarkupAnnotation#ctor");
        
        // MEMO: no Subtype definition.
    }
    
    /**
     * @param lb left-bottom point
     * @param rb right-bottom point
     * @param lt left-top point
     * @param rt right-top point
     */
    public final void setQuadPoints(HPdfPoint lb, HPdfPoint rb, HPdfPoint lt, HPdfPoint rt) {
        logger.trace("HPdfTextMarkupAnnotation#setQuadPoints");
        
        HPdfArray quadPoints = new HPdfArray();
        
        this.add("QuadPoints", quadPoints);
        
        quadPoints.addReal(lb.getX());
        quadPoints.addReal(lb.getY());
        quadPoints.addReal(rb.getX());
        quadPoints.addReal(rb.getY());
        quadPoints.addReal(lt.getX());
        quadPoints.addReal(lt.getY());
        quadPoints.addReal(rt.getX());
        quadPoints.addReal(rt.getY());
    }

}
