/*
 * JHPdf Free PDF Library : HPdfCatalog.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.io.HPdfWriteStream;

/**
 * Class represents PDF Catalog.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfCatalog extends HPdfDict {
    
    public enum HPdfPageLayout {
        SINGLE,
        ONE_COLUMN,
        TWO_COLUMN_LEFT,
        TWO_COLUMN_RIGHT,
        TWO_PAGE_LEFT,
        TWO_PAGE_RIGHT,
    }
    
    public enum HPdfPageMode {
        USE_OUTLINE,
        USE_THUMBS,
        FULL_SCREEN,
    }
    
    public enum HPdfViewerPreference {
        HIDE_TOOLBAR(1),
        HIDE_MENUBAR(2),
        HIDE_WINDOW_UI(4),
        FIT_WINDOW(8),
        CENTER_WINDOW(16),
        PRINT_SCALING_NONE(32),
        ;
        
        private int value;
        HPdfViewerPreference(int value) {
            this.value = value;
        }
        public int getValue() {
            return this.value;
        }
    }
    
    /**
     * ctor. this is package-private.
     */
    HPdfCatalog(HPdfXref xref) {
        super();
        xref.add(this);
        
        this.addName("Type", "Catalog");
        this.add("Pages", new HPdfPages(null, xref));
    }
    
    public HPdfPages getRoot() {
        HPdfPages pages = this.getItem("Pages", HPdfPages.class);
        if (pages == null) {
            throw new HPdfException(HPdfErrorCode.HPDF_PAGE_CANNOT_GET_ROOT_PAGES, 0);
        }
        return pages;
    }
}
